

可以使用cnsenti库中的自定义方法，计算年报或财经类社交媒体的文本情绪。

> 姚加权，冯绪，王赞钧，纪荣嵘，张维. 语调、情绪及市场影响：基于金融情绪词典. 管理科学学报，2021. 24(5), 26-46.

该论文开发了中文的金融情感词典，已有的中文金融情感词典有以下不足：

- 大多采用形容情绪词，对于金融场景适用性差
- 将LM英文词典本土化，制作中文金融情绪词典
- 词典构建方法多为人工



该论文开发中文情绪词典，从年报和社交媒体两个数据源出发，借助数据挖掘和深度学习算法，构建了正式用语 和 非正式用于两大类情感词典。



## 标注思路

一般构建词典要么用多个词典融合，要么人工标准训练。该论文采用了一定的技巧，不需要人工标注即可实现近乎人工标注的效果。

### 正式词典标注思路

正式用语情感词典，通过年报公布后3个交易日累积正负收益率为标准，将年报标记为正负面情绪两类。

### 非正式词典标注思路

使用所有中国上市公司在雪球论坛和东方财富股吧内相关帖子，共8130万条。

在网络股票论坛，用户发表自己的意见时，经常带有表情符号，从而使得帖子带有明显的情绪指标。 这种含有特殊指标的帖子，省去了人工标注文本情绪的工作。



<br>

具体构建词典的步骤，大家可以阅读论文原文。论文已经公开了中文情感词典，我已将其整理为4个txt文件

- formal_pos.txt  正式用语**正面**情绪词典
- formal_neg.txt  正式用语**负面**情绪词典
- unformal_pos.txt  非正式用语**正面**情绪词典
- unformal_neg.txt  非正式用语**负面**情绪词典

<br>



## 中文金融词典使用方法

cnsenti实现了自定义词典功能，导入不同的txt词典文件，即可实现不同方面的情绪词统计。

### 年报正式用语词典

- dict/formal_pos.txt   正式用语**正面**情绪词典
- dict/formal_neg.txt    正式用语**负面**情绪词典

```python
from cnsenti import Sentiment

senti = Sentiment(pos='dict/formal_pos.txt',  #正面词典txt文件相对路径
                  neg='dict/formal_neg.txt',  #负面词典txt文件相对路径
                  merge=False,             #是否将cnsenti自带词典和用户导入的自定义词典融合
                  encoding='utf-8')      #两txt均为utf-8编码

test_text = '这家公司是行业的引领者，是中流砥柱。今年的业绩非常好。'
result = senti.sentiment_count(test_text)

print('sentiment_count',result)
```

Run

```
sentiment_count {'words': 16, 'sentences': 2, 'pos': 3, 'neg': 0}
```





<br>



### 财经社交媒体非正式用语词典

- dict/unformal_pos.txt   非正式用语**正面**情绪词典
- dict/unformal_neg.txt    非正式用语**负面**情绪词典

```python
from cnsenti import Sentiment

senti = Sentiment(pos='dict/unformal_pos.txt',  #正面词典txt文件相对路径
                  neg='dict/unformal_neg.txt',  #负面词典txt文件相对路径
                  merge=False,             #融合cnsenti自带词典和用户导入的自定义词典
                  encoding='utf-8')      #两txt均为utf-8编码

test_text = '这个股票前期走势承压，现在阴跌，散户只能割肉离场，这股票真垃圾'
result = senti.sentiment_count(test_text)

print('sentiment_count',result)
```

Run

```
sentiment_count {'words': 18, 'sentences': 1, 'pos': 0, 'neg': 2}
```





<br>

## 说明

读者如需使用本项目词典，请引用如下参考文献：

> 姚加权，冯绪，王赞钧，纪荣嵘，张维. 语调、情绪及市场影响：基于金融情绪词典. 管理科学学报，2021. 24(5), 26-46.



另外，Python暑期工作坊现在正在报名，内容涵盖Python语法、数据采集(网络爬虫)、文本数据清洗（文本分析）、机器学习等。20号开始直播。感兴趣的可以关注



