#!/usr/bin/python3
# -*- coding: utf-8 -*-
# @Time    : 2021/8/13 9:26
# @Author  : 程婷婷
# @FileName: scenario.py
# @Software: PyCharm
import os
import json
import requests
import pandas as pd
from collections import Counter
from requests.adapters import HTTPAdapter
from scenario_service.views import cv_tfidf
from model.base.views import utils


def post_project_info(url, title, content):
    payload={'title':title,'content':content}
    headers = {
        'Content-Type': 'application/json'
    }
    response = requests.request('POST', url, headers=headers, data=json.dumps(payload))
    data = json.loads(response.text)
    print(data)
    return data

def post_speech(url, title, content):
    payload = {'title': title,
               'content': content}
    files = [
    ]
    headers = {}
    response = requests.request("POST", url, headers=headers, data=payload, files=files)
    data = json.loads(response.text)
    return data

def post_report(url):
    response = requests.request("GET", url)
    data = json.loads(response.text)
    return data

def post_similarity_duplicate(url, text_1, text_2, sim):
    payload = {'text_1': text_1, 'text_2': text_2, 'sim': sim}
    headers = {
        'Content-Type': 'application/json'
    }
    response = requests.request('POST', url, headers=headers, data=json.dumps(payload))
    data = json.loads(response.text)
    return data

def post_extraction_company(url, file_name, company_file_name):
    payload = {'file_name': file_name, 'company_file_name': company_file_name}
    files = [

    ]
    headers = {
        'token': '1',
    }
    response = requests.request('POST', url, headers=headers, data=payload, files=files)
    data = json.loads(response.text)
    return data

def post_br_single_file(url, file_name):
    payload = {'file_path': file_name}
    headers = {
        'Content-Type': 'application/json'
    }
    s = requests.session()
    s.mount('http://', HTTPAdapter(max_retries=3))
    response = s.request('POST', url, headers=headers, data=json.dumps(payload), timeout=60*60*10)
    data = json.loads(response.text)
    return data

def post_stock_recruitment_predict(url, file_name):
    payload = {'file_name': file_name}
    files = [

    ]
    headers = {
        'token': '1',
    }
    response = requests.request('POST', url, headers=headers, data=payload, files=files)
    data = json.loads(response.text)
    return data

def cv_tfidf_keywords(download_path, pending_file, user_file):
    file_type = pending_file.split('.')[-1]
    if (file_type == 'docx') or (file_type == 'doc'):
        doc_text_list = utils.read_docx(pending_file, user_file)
        doc_text_list = utils.merge_para(doc_text_list)
    else:
        # print('运行xlsx文件')
        doc_text_list = utils.read_excel(pending_file, user_file)
        # print(doc_text_list)
    corpus, all_words, = [], []
    for para in doc_text_list:
        words = utils.filter_stopwords(para)
        all_words.extend(words)
        corpus.append(' '.join(words))
    print("len(corpus):" + str(len(corpus)))
    word2count = Counter(all_words)
    word, weight = cv_tfidf.cv_tfidf(corpus)
    word_tf, keyword, word_weight = cv_tfidf.get_word_tf_frequency(word, weight, word2count)
    out_df = pd.DataFrame(columns=['词', '词频', 'tfidf'])
    out_df['词'] = keyword
    out_df['词频'] = word_weight
    out_df['tfidf'] = word_tf
    out_df.drop_duplicates(subset=['词', '词频'], inplace=True)
    out_df.to_excel(os.path.join(download_path, 'result.xlsx'), index=False, encoding='utf-8')
    return out_df

