# -*- coding: utf-8 -*-
# @Time : 2022/12/2 9:31
# @Author : ctt
# @File : sentence_split
# @Project : 智能报告数据导出
import re
import html
import pandas as pd
from lac_method import lac_organize_name


def match_pattern(para_text: str, patterns: list) -> set:
    """
    提取符合规则的字符串
    :param para_text:   待匹配字符串
    :param patterns:    正则列表
    :return:
    """
    set_match = set()
    for pattern_str in patterns:
        pattern = re.compile(r'' + pattern_str)
        # 找到与之匹配的所有子串，并以迭代器形式返回，与findall 类似
        results = re.finditer(pattern, para_text)
        for result in results:
            # 带索引位置
            # print(result)
            result = result.group().strip()
            # 不带索引位置信息
            # print(result)
            set_match.add(result)
    return set_match


def find_tag(text):
    rule = re.compile(r'<[^>]+>')
    # 在字符串中找到正则表达式所有匹配的所有字串，并将它们作为一个迭代器返回
    result_group = rule.finditer(text)
    tag_index = []
    content_index = []
    content_text = []
    tag_content = []
    if result_group:
        for _ in result_group:
            tag_content.append(_.group())
            tag_index.append(_.span())
    # 通过待标签字符的索引位置找到文本区域的索引位置
    for i, indexes in enumerate(tag_index):
        # 特殊情况，只有起始的位置时，标签区域的结束索引位置是文本区域的开始位置
        if i == 0:
            content_index_start = indexes[1]
        else:
            content_index_end = indexes[0]
            if text[content_index_start: content_index_end]:
                # todo: 按字记录文本的索引位置，因此采用extend 方法
                content_index.extend(list(range(content_index_start, content_index_end)))
                content_text.append(text[content_index_start: content_index_end])
            content_index_start = indexes[1]
    return tag_index, tag_content, content_index, content_text


def split_sentence(content):
    pattern = re.compile(r'.+?[。?？!！\n]')
    match_group = pattern.finditer(content)
    sentences = []
    if match_group:
        for _ in match_group:
            start_end_index = _.span()
            sentences.append((start_end_index[0], start_end_index[1], _.group()))
    # sentences = pattern.findall(content)
    if (not sentences) and (len(content) >= 4):
        sentences.append((0, len(content), content))
    return sentences


def sub_sentence(content):
    pattern = re.compile(r'[0-9a-zA-Z]')
    sentence = pattern.sub('', content)
    pass_sentence = ['投稿内容', '欢迎阅读', '关键词', '访谈人物', '本文', '上篇御风', '\t', ' ', '来源']
    if (len(content) - len(sentence) > 10):
        return 0
    for _ in pass_sentence:
        if _ in sentence:
            return 0
    return len(sentence.strip())


text = """
<html><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8" /><meta http-equiv="Content-Style-Type" content="text/css" /><meta name="generator" content="Aspose.Words for Java 15.12.0.0" /><title>××年度××部门/单位</title><style type="text/css">@page Section1 { margin:72pt 54.15pt; size:595.3pt 841.9pt }div.Section1 { page:Section1 }@page Section2 { margin:72pt 54.15pt; size:595.3pt 841.9pt }div.Section2 { page:Section2 }@page Section3 { margin:72pt 54.15pt; size:595.3pt 841.9pt }div.Section3 { page:Section3 }@page Section4 { margin:72pt 54.15pt; size:595.3pt 841.9pt }div.Section4 { page:Section4 }@page Section5 { margin:72pt 54.15pt; size:595.3pt 841.9pt }div.Section5 { page:Section5 }@page Section6 { margin:72pt 54.15pt; size:595.3pt 841.9pt }div.Section6 { page:Section6 }@page Section7 { margin:72pt 54.15pt; size:595.3pt 841.9pt }div.Section7 { page:Section7 }@page Section8 { margin:72pt 54.15pt; size:595.3pt 841.9pt }div.Section8 { page:Section8 }@page Section9 { margin:54.15pt 72pt; size:841.9pt 595.3pt }div.Section9 { page:Section9 }@page Section10 { margin:72pt 54.15pt; size:595.3pt 841.9pt }div.Section10 { page:Section10 }</style></head><body><div class="Section1"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">&#xa0;</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">&#xa0;</span></p><p style="font-size:26pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:26pt; font-weight:bold">{{info.reportTitle}}</span></p><p style="font-size:26pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:26pt; font-weight:bold">&#xa0;</span></p><p style="font-size:26pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:26pt; font-weight:bold">&#xa0;</span></p><p style="font-size:26pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:26pt; font-weight:bold">&#xa0;</span></p><p style="font-size:26pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:26pt; font-weight:bold">&#xa0;</span></p><p style="font-size:26pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:26pt; font-weight:bold">&#xa0;</span></p><p style="font-size:26pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:26pt; font-weight:bold">&#xa0;</span></p><p style="font-size:16pt; line-height:150%; margin:0pt; orphans:0; text-indent:112pt; widows:0"><span style="font-family:宋体; font-size:16pt">部门（单位）名称：</span><span style="font-family:宋体; font-size:16pt">{{info.unitName}}</span></p><p style="font-size:16pt; line-height:150%; margin:0pt; orphans:0; text-indent:112pt; widows:0"><span style="font-family:宋体; font-size:16pt">单位负责人：</span><span style="font-family:宋体; font-size:16pt">{{info.unitChargePeople}}</span></p><p style="font-size:16pt; line-height:150%; margin:0pt; orphans:0; text-indent:112pt; widows:0"><span style="font-family:宋体; font-size:16pt">财务负责人：</span><span style="font-family:宋体; font-size:16pt">{{info.financeChargePeople}}</span></p><p style="font-size:16pt; line-height:150%; margin:0pt; orphans:0; text-indent:112pt; widows:0"><span style="font-family:宋体; font-size:16pt">编制人：</span><span style="font-family:宋体; font-size:16pt">{{info.filledPeople}}</span></p><p style="font-size:16pt; line-height:150%; margin:0pt; orphans:0; text-indent:112pt; widows:0"><span style="font-family:宋体; font-size:16pt">报送日期：{{info.year2}}</span></p></div><br style="clear:both; mso-break-type:section-break; page-break-before:always" /><div class="Section2"><p style="margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:16pt; font-weight:bold">目 录</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><a href="#_Toc104975330"><span style="color:#0000ff; font-family:黑体; font-size:12pt; font-weight:bold; text-decoration:underline">一、政府部门财务报表</span><span style="width:360.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">...........................................................</span><span style="font-family:'Times New Roman'; font-size:12pt; font-weight:bold">1</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><a href="#_Toc104975331"><span style="color:#0000ff; font-family:楷体; font-size:12pt; text-decoration:underline">（一）政府部门会计报表</span><span style="width:324.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">.....................................................</span><span style="font-family:'Times New Roman'; font-size:12pt">1</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:48pt; widows:0"><a href="#_Toc104975332"><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">资产负债表</span><span style="width:372.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">.............................................................</span><span style="font-family:'Times New Roman'; font-size:12pt">1</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:48pt; widows:0"><a href="#_Toc104975333"><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">收入费用表（</span><span style="color:#0000ff; font-family:'Times New Roman'; font-size:12pt; text-decoration:underline">1</span><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">）</span><span style="width:342.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">........................................................</span><span style="font-family:'Times New Roman'; font-size:12pt">4</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:48pt; widows:0"><a href="#_Toc104975334"><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">收入费用表（</span><span style="color:#0000ff; font-family:'Times New Roman'; font-size:12pt; text-decoration:underline">2</span><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">）</span><span style="width:342.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">........................................................</span><span style="font-family:'Times New Roman'; font-size:12pt">5</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><a href="#_Toc104975335"><span style="color:#0000ff; font-family:楷体; font-size:12pt; text-decoration:underline">（二）政府部门会计报表附注</span><span style="width:300.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">.................................................</span><span style="font-family:'Times New Roman'; font-size:12pt">6</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:48pt; widows:0"><a href="#_Toc104975336"><span style="color:#0000ff; font-family:'Times New Roman'; font-size:12pt; text-decoration:underline">1.</span><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">会计报表编制基础</span><span style="width:348.83pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">.........................................................</span><span style="font-family:'Times New Roman'; font-size:12pt">6</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:48pt; widows:0"><a href="#_Toc104975337"><span style="color:#0000ff; font-family:'Times New Roman'; font-size:12pt; text-decoration:underline">2.</span><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">遵循相关制度规定的声明</span><span style="width:320.83pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">.....................................................</span><span style="font-family:'Times New Roman'; font-size:12pt">6</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:48pt; widows:0"><a href="#_Toc104975338"><span style="color:#0000ff; font-family:'Times New Roman'; font-size:12pt; text-decoration:underline">3.</span><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">合并范围</span><span style="width:386.16pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">................................................................</span><span style="font-family:'Times New Roman'; font-size:12pt">6</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:48pt; widows:0"><a href="#_Toc104975339"><span style="color:#0000ff; font-family:'Times New Roman'; font-size:12pt; text-decoration:underline">4.</span><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">重要会计政策与会计估计变更情况</span><span style="width:283.49pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">...............................................</span><span style="font-family:'Times New Roman'; font-size:12pt">6</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:48pt; widows:0"><a href="#_Toc104975340"><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">5.会计报表重要项目的明细信息及说明</span><span style="width:228.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">.....................................</span><span style="font-family:'Times New Roman'; font-size:12pt">6</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:48pt; widows:0"><a href="#_Toc104975341"><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">6.需要说明的其他事项</span><span style="width:306.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">..................................................</span><span style="font-family:'Times New Roman'; font-size:12pt">12</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><a href="#_Toc104975342"><span style="color:#0000ff; font-family:黑体; font-size:12pt; font-weight:bold; text-decoration:underline">二、政府部门财务分析</span><span style="width:354.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">..........................................................</span><span style="font-family:'Times New Roman'; font-size:12pt; font-weight:bold">13</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><a href="#_Toc104975343"><span style="color:#0000ff; font-family:楷体; font-size:12pt; text-decoration:underline">（一）政府部门工作目标完成情况</span><span style="width:270.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">............................................</span><span style="font-family:'Times New Roman'; font-size:12pt">13</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:48pt; widows:0"><a href="#_Toc104975344"><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">1.基本情况</span><span style="width:366.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">............................................................</span><span style="font-family:'Times New Roman'; font-size:12pt">13</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:48pt; widows:0"><a href="#_Toc104975345"><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">2.本年取得的主要事业成效</span><span style="width:282.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">..............................................</span><span style="font-family:'Times New Roman'; font-size:12pt">14</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><a href="#_Toc104975346"><span style="color:#0000ff; font-family:楷体; font-size:12pt; text-decoration:underline">（二）政府部门财务状况分析</span><span style="width:294.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">................................................</span><span style="font-family:'Times New Roman'; font-size:12pt">19</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:48pt; widows:0"><a href="#_Toc104975347"><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">1.单位资产构成及变化情况</span><span style="width:282.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">..............................................</span><span style="font-family:'Times New Roman'; font-size:12pt">19</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:48pt; widows:0"><a href="#_Toc104975348"><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">2.单位负债构成及变化情况</span><span style="width:282.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">..............................................</span><span style="font-family:'Times New Roman'; font-size:12pt">20</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:48pt; widows:0"><a href="#_Toc104975349"><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">3.主要指标分析</span><span style="width:342.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">........................................................</span><span style="font-family:'Times New Roman'; font-size:12pt">21</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><a href="#_Toc104975350"><span style="color:#0000ff; font-family:楷体; font-size:12pt; text-decoration:underline">（三）政府部门运行情况分析</span><span style="width:294.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">................................................</span><span style="font-family:'Times New Roman'; font-size:12pt">23</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:48pt; widows:0"><a href="#_Toc104975351"><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">1.单位收入费用构成及变化情况</span><span style="width:258.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">..........................................</span><span style="font-family:'Times New Roman'; font-size:12pt">23</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:48pt; widows:0"><a href="#_Toc104975352"><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">2.主要指标分析</span><span style="width:342.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">........................................................</span><span style="font-family:'Times New Roman'; font-size:12pt">24</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><a href="#_Toc104975353"><span style="color:#0000ff; font-family:楷体; font-size:12pt; text-decoration:underline">（四）政府部门财务管理情况</span><span style="width:294.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">................................................</span><span style="font-family:'Times New Roman'; font-size:12pt">24</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:48pt; widows:0"><a href="#_Toc104975354"><span style="color:#0000ff; font-family:'Times New Roman'; font-size:12pt; text-decoration:underline">1.</span><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">预算管理情况</span><span style="width:361.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">...........................................................</span><span style="font-family:'Times New Roman'; font-size:12pt">24</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:48pt; widows:0"><a href="#_Toc104975355"><span style="color:#0000ff; font-family:'Times New Roman'; font-size:12pt; text-decoration:underline">2.</span><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">绩效管理情况</span><span style="width:361.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">...........................................................</span><span style="font-family:'Times New Roman'; font-size:12pt">25</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:48pt; widows:0"><a href="#_Toc104975356"><span style="color:#0000ff; font-family:'Times New Roman'; font-size:12pt; text-decoration:underline">3.</span><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">内部控制情况</span><span style="width:361.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">...........................................................</span><span style="font-family:'Times New Roman'; font-size:12pt">25</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:48pt; widows:0"><a href="#_Toc104975357"><span style="color:#0000ff; font-family:'Times New Roman'; font-size:12pt; text-decoration:underline">4.</span><span style="color:#0000ff; font-family:宋体; font-size:12pt; text-decoration:underline">资产管理情况</span><span style="width:361.5pt; text-indent:0pt; font-family:'Lucida Console'; font-size:10pt; display:inline-block; -aw-tabstop-align:right; -aw-tabstop-leader:dots; -aw-tabstop-pos:486.5pt">...........................................................</span><span style="font-family:'Times New Roman'; font-size:12pt">25</span></a></p><p style="margin:0pt; orphans:0; text-align:center; widows:0"></p></div><br style="clear:both; mso-break-type:section-break; page-break-before:always" /><div class="Section3"><h1 style="font-size:16pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><span style="font-family:黑体; font-size:16pt; font-weight:bold">一、政府部门财务报表</span></h1><h2 style="font-size:15pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><a name="_Toc104975331"></a><a name="_Toc60821189"></a><a name="_Toc60821240"><span style="font-family:楷体; font-size:15pt; font-weight:bold">（一）政府部门会计报表</span><span style="-aw-bookmark-end:_Toc104975331"></span><span style="-aw-bookmark-end:_Toc60821189"></span></a></h2><p style="font-size:11pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; widows:0"><span style="font-family:宋体; font-size:11pt">表 1</span></p><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:center; widows:0"><a name="_Toc60821190"></a><a name="_Toc60821241"></a><a name="_Toc104975332"><span style="font-family:宋体; font-size:12pt; font-weight:bold">资产负债表</span><span style="-aw-bookmark-end:_Toc60821190"></span><span style="-aw-bookmark-end:_Toc60821241"></span></a></h3><p style="margin:0pt; orphans:0; text-align:justify; widows:0"><span style="font-family:'Times New Roman'; font-size:10.5pt">{{table1}}</span></p></div><br style="clear:both; mso-break-type:section-break; page-break-before:always" /><div class="Section4"><p style="font-size:11pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:11pt">表 1-续表</span></p><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt; font-weight:bold">资产负债表续表</span><span style="font-family:'Times New Roman'; font-size:12pt; font-weight:bold">1</span></h3><p style="font-size:10.5pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:'Times New Roman'; font-size:10.5pt">{{table2}}</span></p></div><br style="clear:both; mso-break-type:section-break; page-break-before:always" /><div class="Section5"><p style="font-size:11pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:11pt">表 1-续表</span></p><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt; font-weight:bold">资产负债表续表</span><span style="font-family:'Times New Roman'; font-size:12pt; font-weight:bold">2</span></h3><p style="font-size:10.5pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; widows:0"><span style="font-family:'Times New Roman'; font-size:10.5pt">{{table3}}</span></p></div><br style="clear:both; mso-break-type:section-break; page-break-before:always" /><div class="Section6"><p style="font-size:11pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; widows:0"><span style="font-family:宋体; font-size:11pt">表 2-1</span></p><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:center; widows:0"><a name="_Toc60821242"></a><a name="_Toc104975333"></a><a name="_Toc60821191"><span style="font-family:宋体; font-size:12pt; font-weight:bold">收入费用表（</span><span style="font-family:'Times New Roman'; font-size:12pt; font-weight:bold">1</span><span style="font-family:宋体; font-size:12pt; font-weight:bold">）</span><span style="-aw-bookmark-end:_Toc60821242"></span><span style="-aw-bookmark-end:_Toc104975333"></span></a></h3><p style="font-size:10.5pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; widows:0"><span style="font-family:'Times New Roman'; font-size:10.5pt">{{table4}}</span></p></div><br style="clear:both; mso-break-type:section-break; page-break-before:always" /><div class="Section7"><p style="font-size:11pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; widows:0"><span style="font-family:宋体; font-size:11pt">表 2-2</span></p><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:center; widows:0"><a name="_Toc60821192"></a><a name="_Toc60821027"></a><a name="_Toc104975334"></a><a name="_Toc60821243"><span style="font-family:宋体; font-size:12pt; font-weight:bold">收入费用表（</span><span style="font-family:'Times New Roman'; font-size:12pt; font-weight:bold">2</span><span style="font-family:宋体; font-size:12pt; font-weight:bold">）</span><span style="-aw-bookmark-end:_Toc60821192"></span><span style="-aw-bookmark-end:_Toc60821027"></span><span style="-aw-bookmark-end:_Toc104975334"></span></a></h3><p style="margin:0pt 0pt 6pt; orphans:0; text-align:justify; widows:0"><span style="font-family:'Times New Roman'; font-size:10.5pt">{{table5}}</span></p><p style="font-size:11pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:7pt; vertical-align:super">1 </span><span style="font-family:宋体; font-size:11pt">表 2-2 的“其他费用”包括“业务活动费用”“单位管理费用”“经营费用”等会计科目中的其他部 分。</span></p></div><br style="clear:both; mso-break-type:section-break; page-break-before:always" /><div class="Section8"><h2 style="font-size:15pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><a name="_Toc104975335"></a><a name="_Toc60821244"></a><a name="_Toc60821193"><span style="font-family:楷体; font-size:15pt; font-weight:bold">（二）政府部门会计报表附注</span><span style="-aw-bookmark-end:_Toc104975335"></span><span style="-aw-bookmark-end:_Toc60821244"></span></a></h2><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><a name="_Toc103849040"></a><a name="_Toc22305"></a><a name="_Toc103248095"></a><a name="_Toc101108823"></a><a name="_Toc103357976"></a><a name="_Toc101177115"></a><a name="_Toc104975336"></a><a name="_Toc101777744"></a><a name="_Toc102669753"></a><a name="_Toc60821194"></a><a name="_Toc101817958"></a><a name="_Toc60821245"></a><a name="_Toc103362567"></a><a name="_Toc103785464"></a><a name="_Toc103369099"></a><a name="_Toc103276953"></a><a name="_Toc103783730"></a><a name="_Toc103356784"></a><a name="_Hlk104475892"></a><a name="_Toc60821198"></a><a name="_Toc60821249"><span style="font-family:'Times New Roman'; font-size:12pt; font-weight:bold">1.</span><span style="font-family:宋体; font-size:12pt; font-weight:bold">会计报表编制基础</span><span style="-aw-bookmark-end:_Toc103849040"></span><span style="-aw-bookmark-end:_Toc22305"></span><span style="-aw-bookmark-end:_Toc103248095"></span><span style="-aw-bookmark-end:_Toc101108823"></span><span style="-aw-bookmark-end:_Toc103357976"></span><span style="-aw-bookmark-end:_Toc101177115"></span><span style="-aw-bookmark-end:_Toc104975336"></span><span style="-aw-bookmark-end:_Toc101777744"></span><span style="-aw-bookmark-end:_Toc102669753"></span><span style="-aw-bookmark-end:_Toc60821194"></span><span style="-aw-bookmark-end:_Toc101817958"></span><span style="-aw-bookmark-end:_Toc60821245"></span><span style="-aw-bookmark-end:_Toc103362567"></span><span style="-aw-bookmark-end:_Toc103785464"></span><span style="-aw-bookmark-end:_Toc103369099"></span><span style="-aw-bookmark-end:_Toc103276953"></span><span style="-aw-bookmark-end:_Toc103783730"></span><span style="-aw-bookmark-end:_Toc103356784"></span></a></h3><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">本单位</span><span style="font-family:宋体; font-size:12pt">政府部门财务报告以权责发生制为基础编制。</span></p><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; text-indent:0pt; widows:0"><span style="font-family:'Times New Roman'; font-size:12pt; font-weight:bold">2.</span><span style="font:7.0pt 'Times New Roman'">&#xa0;&#xa0;&#xa0;&#xa0; </span><a name="_Toc103785465"></a><a name="_Toc103369100"></a><a name="_Toc103276954"></a><a name="_Toc103248096"></a><a name="_Toc103356785"></a><a name="_Toc101777745"></a><a name="_Toc103357977"></a><a name="_Toc60821246"></a><a name="_Toc101177116"></a><a name="_Toc103783731"></a><a name="_Toc102669754"></a><a name="_Toc9550"></a><a name="_Toc101108824"></a><a name="_Toc103849041"></a><a name="_Toc60821195"></a><a name="_Toc103362568"></a><a name="_Toc104975337"></a><a name="_Toc101817959"><span style="font-family:宋体; font-size:12pt; font-weight:bold">遵循相关制度规定的声明</span><span style="-aw-bookmark-end:_Toc103785465"></span><span style="-aw-bookmark-end:_Toc103369100"></span><span style="-aw-bookmark-end:_Toc103276954"></span><span style="-aw-bookmark-end:_Toc103248096"></span><span style="-aw-bookmark-end:_Toc103356785"></span><span style="-aw-bookmark-end:_Toc101777745"></span><span style="-aw-bookmark-end:_Toc103357977"></span><span style="-aw-bookmark-end:_Toc60821246"></span><span style="-aw-bookmark-end:_Toc101177116"></span><span style="-aw-bookmark-end:_Toc103783731"></span><span style="-aw-bookmark-end:_Toc102669754"></span><span style="-aw-bookmark-end:_Toc9550"></span><span style="-aw-bookmark-end:_Toc101108824"></span><span style="-aw-bookmark-end:_Toc103849041"></span><span style="-aw-bookmark-end:_Toc60821195"></span><span style="-aw-bookmark-end:_Toc103362568"></span><span style="-aw-bookmark-end:_Toc104975337"></span></a></h3><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">本单位</span><span style="font-family:宋体; font-size:12pt">政府部门会计制度遵循《中华人民共和国预算法》</span><span style="font-family:宋体; font-size:12pt">、</span><span style="font-family:宋体; font-size:12pt">《中华人民共和国会计法》</span><span style="font-family:宋体; font-size:12pt">、</span><span style="font-family:宋体; font-size:12pt">《国务院关于批转财政部权责发生制政府综合财务报告制度改革方案的通知》（国发〔</span><span style="font-family:'Times New Roman'; font-size:12pt">2014</span><span style="font-family:宋体; font-size:12pt">〕</span><span style="font-family:'Times New Roman'; font-size:12pt">63</span><span style="font-family:宋体; font-size:12pt">号）、《政府会计准则</span><span style="font-family:'Times New Roman'; font-size:12pt">——</span><span style="font-family:宋体; font-size:12pt">基本准则》（财政部令第</span><span style="font-family:'Times New Roman'; font-size:12pt">78</span><span style="font-family:宋体; font-size:12pt">号）、《财政部关于修订印发</span><span style="font-family:宋体; font-size:12pt">〈</span><span style="font-family:宋体; font-size:12pt">政府部门财务报告编制操作指南（试行）</span><span style="font-family:宋体; font-size:12pt">〉</span><span style="font-family:宋体; font-size:12pt">的通知》</span><a name="_Hlk42265522"><span style="font-family:宋体; font-size:12pt">（财库〔</span><span style="font-family:'Times New Roman'; font-size:12pt">2019</span><span style="font-family:宋体; font-size:12pt">〕</span><span style="font-family:'Times New Roman'; font-size:12pt">57</span><span style="font-family:宋体; font-size:12pt">号）</span></a><span style="font-family:宋体; font-size:12pt">等规定，如实反映政府部门的财务状况、运行情况等有关信息。</span></p><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><a name="_Toc101817960"></a><a name="_Toc103356786"></a><a name="_Toc102669755"></a><a name="_Toc60821196"></a><a name="_Toc103357978"></a><a name="_Toc103849042"></a><a name="_Toc104975338"></a><a name="_Toc103369101"></a><a name="_Toc103248097"></a><a name="_Toc103362569"></a><a name="_Toc101777746"></a><a name="_Toc103783732"></a><a name="_Toc12957"></a><a name="_Toc103276955"></a><a name="_Toc60821247"></a><a name="_Toc101108825"></a><a name="_Toc101177117"></a><a name="_Toc103785466"><span style="font-family:'Times New Roman'; font-size:12pt; font-weight:bold">3.</span><span style="font-family:宋体; font-size:12pt; font-weight:bold">合并范围</span><span style="-aw-bookmark-end:_Toc101817960"></span><span style="-aw-bookmark-end:_Toc103356786"></span><span style="-aw-bookmark-end:_Toc102669755"></span><span style="-aw-bookmark-end:_Toc60821196"></span><span style="-aw-bookmark-end:_Toc103357978"></span><span style="-aw-bookmark-end:_Toc103849042"></span><span style="-aw-bookmark-end:_Toc104975338"></span><span style="-aw-bookmark-end:_Toc103369101"></span><span style="-aw-bookmark-end:_Toc103248097"></span><span style="-aw-bookmark-end:_Toc103362569"></span><span style="-aw-bookmark-end:_Toc101777746"></span><span style="-aw-bookmark-end:_Toc103783732"></span><span style="-aw-bookmark-end:_Toc12957"></span><span style="-aw-bookmark-end:_Toc103276955"></span><span style="-aw-bookmark-end:_Toc60821247"></span><span style="-aw-bookmark-end:_Toc101108825"></span><span style="-aw-bookmark-end:_Toc101177117"></span></a></h3><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">报表编制主体为</span><span style="font-family:'Times New Roman'; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt">info.unitName</span><span style="font-family:'Times New Roman'; font-size:12pt">}}</span><span style="font-family:宋体; font-size:12pt">（以下简称</span><span style="font-family:宋体; font-size:12pt">“单位”</span><span style="font-family:宋体; font-size:12pt">），是</span><span style="font-family:'Times New Roman'; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt">info.unitBudgetLevel</span><span style="font-family:'Times New Roman'; font-size:12pt">}}</span><span style="font-family:宋体; font-size:12pt">，单位基本性质</span><span style="font-family:宋体; font-size:12pt">为</span><span style="font-family:'Times New Roman'; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt">info.unitType</span><span style="font-family:'Times New Roman'; font-size:12pt">}}</span><span style="font-family:宋体; font-size:12pt">。</span></p><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><a name="_Toc103849043"></a><a name="_Toc60821248"></a><a name="_Toc16158"></a><a name="_Toc101817961"></a><a name="_Toc103783733"></a><a name="_Toc103248098"></a><a name="_Toc103356787"></a><a name="_Toc101177118"></a><a name="_Toc103276956"></a><a name="_Toc101108826"></a><a name="_Toc103357979"></a><a name="_Toc104975339"></a><a name="_Toc103369102"></a><a name="_Toc101777747"></a><a name="_Toc103785467"></a><a name="_Toc103362570"></a><a name="_Toc60821197"></a><a name="_Toc102669756"><span style="font-family:'Times New Roman'; font-size:12pt; font-weight:bold">4.</span><span style="font-family:宋体; font-size:12pt; font-weight:bold">重要会计政策与会计估计变更情况</span><span style="-aw-bookmark-end:_Toc103849043"></span><span style="-aw-bookmark-end:_Toc60821248"></span><span style="-aw-bookmark-end:_Toc16158"></span><span style="-aw-bookmark-end:_Toc101817961"></span><span style="-aw-bookmark-end:_Toc103783733"></span><span style="-aw-bookmark-end:_Toc103248098"></span><span style="-aw-bookmark-end:_Toc103356787"></span><span style="-aw-bookmark-end:_Toc101177118"></span><span style="-aw-bookmark-end:_Toc103276956"></span><span style="-aw-bookmark-end:_Toc101108826"></span><span style="-aw-bookmark-end:_Toc103357979"></span><span style="-aw-bookmark-end:_Toc104975339"></span><span style="-aw-bookmark-end:_Toc103369102"></span><span style="-aw-bookmark-end:_Toc101777747"></span><span style="-aw-bookmark-end:_Toc103785467"></span><span style="-aw-bookmark-end:_Toc103362570"></span><span style="-aw-bookmark-end:_Toc60821197"></span></a></h3><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt">info.year</span><span style="font-family:宋体; font-size:12pt">}}年单位采用的重要会计政策与会计估计与{{</span><span style="font-family:宋体; font-size:12pt">info.LastYear</span><span style="font-family:宋体; font-size:12pt">}}年的相同，无变更。</span></p><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><span style="-aw-bookmark-end:_Hlk104475892"></span><a name="_Toc104975340"><span style="font-family:宋体; font-size:12pt; font-weight:bold">5.会计报表重要项目的明细信息及说明</span><span style="-aw-bookmark-end:_Toc60821198"></span><span style="-aw-bookmark-end:_Toc60821249"></span></a></h3><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（1）货币资金明细信息如下：</span></p><p style="margin:0pt 0pt 6pt; orphans:0; text-align:justify; widows:0"><span style="font-family:'Times New Roman'; font-size:10.5pt">{{</span><span style="font-family:宋体; font-size:10.5pt">table6</span><span style="font-family:'Times New Roman'; font-size:10.5pt">}}</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（2）应收票据明细信息（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（3）应收账款明细信息（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（4）预付账款明细信息（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（5）其他应收款明细信息（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（6）长期投资及投资收益明细信息（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（7）固定资产明细信息如下：</span></p><p style="margin:0pt 0pt 6pt; orphans:0; text-align:justify; text-indent:5.25pt; widows:0"><span style="font-family:'Times New Roman'; font-size:10.5pt">{{</span><span style="font-family:宋体; font-size:10.5pt">table7</span><span style="font-family:'Times New Roman'; font-size:10.5pt">}}</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（8）在建工程明细信息（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（9）无形资产明细信息如下：</span></p><p style="margin:0pt 0pt 6pt; orphans:0; text-align:justify; text-indent:5.25pt; widows:0"><span style="font-family:'Times New Roman'; font-size:10.5pt">{{</span><span style="font-family:宋体; font-size:10.5pt">table8</span><span style="font-family:'Times New Roman'; font-size:10.5pt">}}</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（10）公共基础设施明细信息（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">公共基础设施明细表（累计折旧/摊销）（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">公共基础设施明细表（净值）（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（11）政府储备物资明细信息（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（12）保障性住房明细信息（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（13）PPP项目资产明细信息（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（14）应付票据明细信息（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（15）应付账款明细信息（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（16）预收账款明细信息（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（17）其他应付款明细信息如下：</span></p><p style="margin:0pt 0pt 6pt; orphans:0; text-align:justify; text-indent:5.25pt; widows:0"><span style="font-family:'Times New Roman'; font-size:10.5pt">{{</span><span style="font-family:宋体; font-size:10.5pt">table9</span><span style="font-family:'Times New Roman'; font-size:10.5pt">}}</span></p><p style="font-size:11pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:11pt">注：“应付同级财政”主要包括预拨经费、向同级财政部门借入的款项。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（18）长期借款明细信息（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（19）长期应付款明细信息（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（20）事业收入明细信息（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（21）经营收入明细信息（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（22）非同级财政拨款收入明细信息（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（23）租金收入明细信息（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（24）其他收入明细信息如下：</span></p><p style="margin:0pt 0pt 6pt; orphans:0; text-align:justify; text-indent:5.25pt; widows:0"><span style="font-family:'Times New Roman'; font-size:10.5pt">{{</span><span style="font-family:宋体; font-size:10.5pt">table10</span><span style="font-family:'Times New Roman'; font-size:10.5pt">}}</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（25）业务活动费用明细信息如下：</span></p><p style="margin:0pt 0pt 6pt; orphans:0; text-align:justify; text-indent:5.25pt; widows:0"><span style="font-family:'Times New Roman'; font-size:10.5pt">{{</span><span style="font-family:宋体; font-size:10.5pt">table11</span><span style="font-family:'Times New Roman'; font-size:10.5pt">}}</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（26）单位管理费用明细信息（无）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（27）经营费用明细信息（无）</span></p></div><br style="clear:both; mso-break-type:section-break; page-break-before:always" /><div class="Section9"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（28）商品和服务费用明细信息如下：</span></p><p style="margin:0pt 0pt 6pt; orphans:0; text-align:justify; text-indent:5.25pt; widows:0"><span style="font-family:'Times New Roman'; font-size:10.5pt">{{</span><span style="font-family:宋体; font-size:10.5pt">table12</span><span style="font-family:'Times New Roman'; font-size:10.5pt">}}</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（29）其他费用明细信息（无）</span></p></div><br style="clear:both; mso-break-type:section-break; page-break-before:always" /><div class="Section10"><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><a name="_Toc101177120"></a><a name="_Toc103357981"></a><a name="_Toc60821250"></a><a name="_Toc104975341"></a><a name="_Toc60821199"></a><a name="_Toc101817963"></a><a name="_Toc103248100"></a><a name="_Toc102669758"></a><a name="_Toc101777749"></a><a name="_Toc103356789"></a><a name="_Toc103785469"></a><a name="_Toc103362572"></a><a name="_Toc103276958"></a><a name="_Toc103849045"></a><a name="_Toc103783735"></a><a name="_Toc103369104"></a><a name="_Toc60821200"></a><a name="_Toc60821251"></a><a name="_Hlk104474113"><span style="font-family:宋体; font-size:12pt; font-weight:bold">6.需要说明的其他事项</span><span style="-aw-bookmark-end:_Toc101177120"></span><span style="-aw-bookmark-end:_Toc103357981"></span><span style="-aw-bookmark-end:_Toc60821250"></span><span style="-aw-bookmark-end:_Toc104975341"></span><span style="-aw-bookmark-end:_Toc60821199"></span><span style="-aw-bookmark-end:_Toc101817963"></span><span style="-aw-bookmark-end:_Toc103248100"></span><span style="-aw-bookmark-end:_Toc102669758"></span><span style="-aw-bookmark-end:_Toc101777749"></span><span style="-aw-bookmark-end:_Toc103356789"></span><span style="-aw-bookmark-end:_Toc103785469"></span><span style="-aw-bookmark-end:_Toc103362572"></span><span style="-aw-bookmark-end:_Toc103276958"></span><span style="-aw-bookmark-end:_Toc103849045"></span><span style="-aw-bookmark-end:_Toc103783735"></span><span style="-aw-bookmark-end:_Toc103369104"></span></a></h3><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（1）重要或有事项说明。逐笔披露政府部门或有事项的事由和金额，如担保事项、未决诉讼或未决仲裁等，若无法预计金额应说明理由。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt">info.unitCall</span><span style="font-family:宋体; font-size:12pt">}}</span><span style="font-family:宋体; font-size:12pt">无担保事项、未决诉讼或未决仲裁等事项。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（</span><span style="font-family:宋体; font-size:12pt">2</span><span style="font-family:宋体; font-size:12pt">）以名义金额计量的资产名称、数量等情况，以及以名义金额计量理由的说明。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{i</span><span style="font-family:宋体; font-size:12pt">nfo.amountDescription</span><span style="font-family:宋体; font-size:12pt">}}</span></p><p style="margin:0pt 0pt 6pt; orphans:0; text-align:justify; text-indent:5.25pt; widows:0"><span style="font-family:'Times New Roman'; font-size:10.5pt">{{</span><span style="font-family:宋体; font-size:10.5pt">table13</span><span style="font-family:'Times New Roman'; font-size:10.5pt">}</span><span style="font-family:'Times New Roman'; font-size:10.5pt">}</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（</span><span style="font-family:宋体; font-size:12pt">3</span><span style="font-family:宋体; font-size:12pt">）使用债务资金形成的固定资产、公共基础设施、保障性住房等资产的账面价值、使用情况、收益情况及与此相关的债务偿还情况。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt 0pt 0pt 21pt; orphans:0; text-align:justify; widows:0"><span style="font-family:宋体; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt">info.unitCall</span><span style="font-family:宋体; font-size:12pt">}}</span><span style="font-family:宋体; font-size:12pt">无上述情况。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt 0pt 0pt 21pt; orphans:0; text-align:justify; widows:0"><span style="font-family:宋体; font-size:12pt">（</span><span style="font-family:宋体; font-size:12pt">4</span><span style="font-family:宋体; font-size:12pt">）重要资产置换、无偿调入（出）、捐入（出）、报废、重大毁损等情况的说明。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt">info.unitCall</span><span style="font-family:宋体; font-size:12pt">}}</span><span style="font-family:宋体; font-size:12pt">无上述事项说明。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（</span><span style="font-family:宋体; font-size:12pt">5</span><span style="font-family:宋体; font-size:12pt">）对于政府部门管理的公共基础设施、文物文化资产、保障性住房、自然资源资产等重要资产，披露种类和实物量等相关信息。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt">info.unitCall</span><span style="font-family:宋体; font-size:12pt">}}</span><span style="font-family:宋体; font-size:12pt">无公共基础设施、文物文化资产、保障性住房、自然资源资产等重要资产。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（</span><span style="font-family:宋体; font-size:12pt">6</span><span style="font-family:宋体; font-size:12pt">）PPP项目合同的总体描述、重要条款及报告期间所发生的项目合同变更情况。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt">info.pppProject</span><span style="font-family:宋体; font-size:12pt">}}</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（</span><span style="font-family:宋体; font-size:12pt">7</span><span style="font-family:宋体; font-size:12pt">）政府会计具体准则中要求附注披露的其他内容，以及其他未在报表中列示，但对政府部门财务状况有重大影响的事项。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt">info.unitCall</span><span style="font-family:宋体; font-size:12pt">}}</span><span style="font-family:宋体; font-size:12pt">无上述需要披露的事项。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（8）其他说明事项。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><a name="_Hlk104474494"><span style="font-family:宋体; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt">info.year</span><span style="font-family:宋体; font-size:12pt">}}</span><span style="font-family:宋体; font-size:12pt">年末，</span></a><span style="font-family:宋体; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt">finance.otherRemark</span><span style="font-family:宋体; font-size:12pt">}}。</span></p><h1 style="font-size:16pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><span style="-aw-bookmark-end:_Toc60821200"></span><span style="-aw-bookmark-end:_Toc60821251"></span><span style="-aw-bookmark-end:_Hlk104474113"></span><a name="_Toc102669759"></a><a name="_Toc103276959"></a><a name="_Toc103362573"></a><a name="_Toc103248101"></a><a name="_Toc103369105"></a><a name="_Toc103849046"></a><a name="_Toc103356790"></a><a name="_Toc104975342"></a><a name="_Toc103783736"></a><a name="_Toc103785470"></a><a name="_Toc103357982"><span style="font-family:黑体; font-size:16pt; font-weight:bold">二、政府部门财务分析</span><span style="-aw-bookmark-end:_Toc102669759"></span><span style="-aw-bookmark-end:_Toc103276959"></span><span style="-aw-bookmark-end:_Toc103362573"></span><span style="-aw-bookmark-end:_Toc103248101"></span><span style="-aw-bookmark-end:_Toc103369105"></span><span style="-aw-bookmark-end:_Toc103849046"></span><span style="-aw-bookmark-end:_Toc103356790"></span><span style="-aw-bookmark-end:_Toc104975342"></span><span style="-aw-bookmark-end:_Toc103783736"></span><span style="-aw-bookmark-end:_Toc103785470"></span></a></h1><h2 style="font-size:15pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><a name="_Toc101733808"></a><a name="_Toc103369106"></a><a name="_Toc103357983"></a><a name="_Toc6529"></a><a name="_Toc104975343"></a><a name="_Toc101618696"></a><a name="_Toc101538228"></a><a name="_Toc102669760"></a><a name="_Toc101108830"></a><a name="_Toc101817965"></a><a name="_Toc103362574"></a><a name="_Toc101783194"></a><a name="_Toc103356791"></a><a name="_Toc101620703"></a><a name="_Toc60821201"></a><a name="_Toc101282394"></a><a name="_Toc103785471"></a><a name="_Toc101296789"></a><a name="_Toc101292111"></a><a name="_Toc103276960"></a><a name="_Toc103248102"></a><a name="_Toc101177122"></a><a name="_Toc11800"></a><a name="_Toc101722428"></a><a name="_Toc60821252"></a><a name="_Toc103849047"></a><a name="_Toc103783737"></a><a name="_Toc60821202"></a><a name="_Toc60821253"></a><a name="_Hlk104474514"><span style="font-family:楷体; font-size:15pt; font-weight:bold">（一）政府部门工作目标完成情况</span><span style="-aw-bookmark-end:_Toc101733808"></span><span style="-aw-bookmark-end:_Toc103369106"></span><span style="-aw-bookmark-end:_Toc103357983"></span><span style="-aw-bookmark-end:_Toc6529"></span><span style="-aw-bookmark-end:_Toc104975343"></span><span style="-aw-bookmark-end:_Toc101618696"></span><span style="-aw-bookmark-end:_Toc101538228"></span><span style="-aw-bookmark-end:_Toc102669760"></span><span style="-aw-bookmark-end:_Toc101108830"></span><span style="-aw-bookmark-end:_Toc101817965"></span><span style="-aw-bookmark-end:_Toc103362574"></span><span style="-aw-bookmark-end:_Toc101783194"></span><span style="-aw-bookmark-end:_Toc103356791"></span><span style="-aw-bookmark-end:_Toc101620703"></span><span style="-aw-bookmark-end:_Toc60821201"></span><span style="-aw-bookmark-end:_Toc101282394"></span><span style="-aw-bookmark-end:_Toc103785471"></span><span style="-aw-bookmark-end:_Toc101296789"></span><span style="-aw-bookmark-end:_Toc101292111"></span><span style="-aw-bookmark-end:_Toc103276960"></span><span style="-aw-bookmark-end:_Toc103248102"></span><span style="-aw-bookmark-end:_Toc101177122"></span><span style="-aw-bookmark-end:_Toc11800"></span><span style="-aw-bookmark-end:_Toc101722428"></span><span style="-aw-bookmark-end:_Toc60821252"></span><span style="-aw-bookmark-end:_Toc103849047"></span><span style="-aw-bookmark-end:_Toc103783737"></span></a></h2><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><a name="_Toc101817966"></a><a name="_Toc101620704"></a><a name="_Toc101177123"></a><a name="_Toc101783195"></a><a name="_Toc31592"></a><a name="_Toc103369107"></a><a name="_Toc101108831"></a><a name="_Toc104975344"></a><a name="_Toc103785472"></a><a name="_Toc101282395"></a><a name="_Toc101538229"></a><a name="_Toc103357984"></a><a name="_Toc101722429"></a><a name="_Toc103849048"></a><a name="_Toc101618697"></a><a name="_Toc102669761"></a><a name="_Toc101296790"></a><a name="_Toc101292112"></a><a name="_Toc101733809"></a><a name="_Toc103362575"></a><a name="_Toc103356792"></a><a name="_Toc103783738"></a><a name="_Toc103276961"></a><a name="_Toc103248103"><span style="font-family:宋体; font-size:12pt; font-weight:bold">1.基本情况</span><span style="-aw-bookmark-end:_Toc101817966"></span><span style="-aw-bookmark-end:_Toc101620704"></span><span style="-aw-bookmark-end:_Toc101177123"></span><span style="-aw-bookmark-end:_Toc101783195"></span><span style="-aw-bookmark-end:_Toc31592"></span><span style="-aw-bookmark-end:_Toc103369107"></span><span style="-aw-bookmark-end:_Toc101108831"></span><span style="-aw-bookmark-end:_Toc104975344"></span><span style="-aw-bookmark-end:_Toc103785472"></span><span style="-aw-bookmark-end:_Toc101282395"></span><span style="-aw-bookmark-end:_Toc101538229"></span><span style="-aw-bookmark-end:_Toc103357984"></span><span style="-aw-bookmark-end:_Toc101722429"></span><span style="-aw-bookmark-end:_Toc103849048"></span><span style="-aw-bookmark-end:_Toc101618697"></span><span style="-aw-bookmark-end:_Toc102669761"></span><span style="-aw-bookmark-end:_Toc101296790"></span><span style="-aw-bookmark-end:_Toc101292112"></span><span style="-aw-bookmark-end:_Toc101733809"></span><span style="-aw-bookmark-end:_Toc103362575"></span><span style="-aw-bookmark-end:_Toc103356792"></span><span style="-aw-bookmark-end:_Toc103783738"></span><span style="-aw-bookmark-end:_Toc103276961"></span></a></h3><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（1）主要职能</span><span style="font-family:宋体; font-size:12pt">：</span></p><p style="margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{info.mainFunctions}}</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（2）</span><span style="font-family:宋体; font-size:12pt">机构情况：</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{info.mainFunctions}}</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（3）人员情况：</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{info.personnelSituation}}</span></p><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; text-indent:0pt; widows:0"><span style="font-family:宋体; font-size:12pt; font-weight:bold">2.</span><span style="font:7.0pt 'Times New Roman'">&#xa0; </span><a name="_Toc101817967"></a><a name="_Toc101177124"></a><a name="_Toc102669762"></a><a name="_Toc103357985"></a><a name="_Toc104975345"></a><a name="_Toc103849049"></a><a name="_Toc101620705"></a><a name="_Toc103362576"></a><a name="_Toc103276962"></a><a name="_Toc101292113"></a><a name="_Toc101538230"></a><a name="_Toc101722430"></a><a name="_Toc103356793"></a><a name="_Toc103785473"></a><a name="_Toc101282396"></a><a name="_Toc101618698"></a><a name="_Toc103369108"></a><a name="_Toc101783196"></a><a name="_Toc101296791"></a><a name="_Toc103783739"></a><a name="_Toc20693"></a><a name="_Toc101733810"></a><a name="_Toc103248104"><span style="font-family:宋体; font-size:12pt; font-weight:bold">本年取得的主要事业成效</span><span style="-aw-bookmark-end:_Toc101817967"></span><span style="-aw-bookmark-end:_Toc101177124"></span><span style="-aw-bookmark-end:_Toc102669762"></span><span style="-aw-bookmark-end:_Toc103357985"></span><span style="-aw-bookmark-end:_Toc104975345"></span><span style="-aw-bookmark-end:_Toc103849049"></span><span style="-aw-bookmark-end:_Toc101620705"></span><span style="-aw-bookmark-end:_Toc103362576"></span><span style="-aw-bookmark-end:_Toc103276962"></span><span style="-aw-bookmark-end:_Toc101292113"></span><span style="-aw-bookmark-end:_Toc101538230"></span><span style="-aw-bookmark-end:_Toc101722430"></span><span style="-aw-bookmark-end:_Toc103356793"></span><span style="-aw-bookmark-end:_Toc103785473"></span><span style="-aw-bookmark-end:_Toc101282396"></span><span style="-aw-bookmark-end:_Toc101618698"></span><span style="-aw-bookmark-end:_Toc103369108"></span><span style="-aw-bookmark-end:_Toc101783196"></span><span style="-aw-bookmark-end:_Toc101296791"></span><span style="-aw-bookmark-end:_Toc103783739"></span><span style="-aw-bookmark-end:_Toc20693"></span><span style="-aw-bookmark-end:_Toc101733810"></span></a></h3><p style="margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{info.careerAchievements}}</span></p><h2 style="font-size:15pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><a name="_Toc103362577"></a><a name="_Toc103357986"></a><a name="_Toc102669763"></a><a name="_Toc101538231"></a><a name="_Toc101783197"></a><a name="_Toc101292114"></a><a name="_Toc103785474"></a><a name="_Toc103248105"></a><a name="_Toc103276963"></a><a name="_Toc101817968"></a><a name="_Toc101618699"></a><a name="_Toc103783740"></a><a name="_Toc103849050"></a><a name="_Toc101282397"></a><a name="_Toc101733811"></a><a name="_Toc101620706"></a><a name="_Toc103356794"></a><a name="_Toc101722431"></a><a name="_Toc103369109"></a><a name="_Toc101296792"></a><a name="_Toc104975346"></a><a name="_Toc28263"><span style="font-family:楷体; font-size:15pt; font-weight:bold">（二）政府部门财务状况分析</span><span style="-aw-bookmark-end:_Toc60821202"></span><span style="-aw-bookmark-end:_Toc60821253"></span><span style="-aw-bookmark-end:_Toc103362577"></span><span style="-aw-bookmark-end:_Toc103357986"></span><span style="-aw-bookmark-end:_Toc102669763"></span><span style="-aw-bookmark-end:_Toc101538231"></span><span style="-aw-bookmark-end:_Toc101783197"></span><span style="-aw-bookmark-end:_Toc101292114"></span><span style="-aw-bookmark-end:_Toc103785474"></span><span style="-aw-bookmark-end:_Toc103248105"></span><span style="-aw-bookmark-end:_Toc103276963"></span><span style="-aw-bookmark-end:_Toc101817968"></span><span style="-aw-bookmark-end:_Toc101618699"></span><span style="-aw-bookmark-end:_Toc103783740"></span><span style="-aw-bookmark-end:_Toc103849050"></span><span style="-aw-bookmark-end:_Toc101282397"></span><span style="-aw-bookmark-end:_Toc101733811"></span><span style="-aw-bookmark-end:_Toc101620706"></span><span style="-aw-bookmark-end:_Toc103356794"></span><span style="-aw-bookmark-end:_Toc101722431"></span><span style="-aw-bookmark-end:_Toc103369109"></span><span style="-aw-bookmark-end:_Toc101296792"></span><span style="-aw-bookmark-end:_Toc104975346"></span></a></h2><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">截至{{info.year}}年12月31日，单位拥有资产总额{{finance.totalAssets}}万元，负债{{ finance.beInDebt}}万元，净资产{{ finance.netAssets}}万元，资产负债率为{{ finance.assetLiabilityRatio}}。</span></p><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><a name="_Toc101296793"></a><a name="_Toc101292115"></a><a name="_Toc103783741"></a><a name="_Toc101817969"></a><a name="_Toc103785475"></a><a name="_Toc101620707"></a><a name="_Toc101733812"></a><a name="_Toc103248106"></a><a name="_Toc103362578"></a><a name="_Toc103276964"></a><a name="_Toc101282398"></a><a name="_Toc103369110"></a><a name="_Toc103357987"></a><a name="_Toc102669764"></a><a name="_Toc101618700"></a><a name="_Toc101538232"></a><a name="_Toc104975347"></a><a name="_Toc101722432"></a><a name="_Toc103849051"></a><a name="_Toc31315"></a><a name="_Toc101108834"></a><a name="_Toc101177126"></a><a name="_Toc103356795"></a><a name="_Toc101783198"><span style="font-family:宋体; font-size:12pt; font-weight:bold">1.</span><span style="font-family:宋体; font-size:12pt; font-weight:bold">单位资产构成及变化情况</span><span style="-aw-bookmark-end:_Toc101296793"></span><span style="-aw-bookmark-end:_Toc101292115"></span><span style="-aw-bookmark-end:_Toc103783741"></span><span style="-aw-bookmark-end:_Toc101817969"></span><span style="-aw-bookmark-end:_Toc103785475"></span><span style="-aw-bookmark-end:_Toc101620707"></span><span style="-aw-bookmark-end:_Toc101733812"></span><span style="-aw-bookmark-end:_Toc103248106"></span><span style="-aw-bookmark-end:_Toc103362578"></span><span style="-aw-bookmark-end:_Toc103276964"></span><span style="-aw-bookmark-end:_Toc101282398"></span><span style="-aw-bookmark-end:_Toc103369110"></span><span style="-aw-bookmark-end:_Toc103357987"></span><span style="-aw-bookmark-end:_Toc102669764"></span><span style="-aw-bookmark-end:_Toc101618700"></span><span style="-aw-bookmark-end:_Toc101538232"></span><span style="-aw-bookmark-end:_Toc104975347"></span><span style="-aw-bookmark-end:_Toc101722432"></span><span style="-aw-bookmark-end:_Toc103849051"></span><span style="-aw-bookmark-end:_Toc31315"></span><span style="-aw-bookmark-end:_Toc101108834"></span><span style="-aw-bookmark-end:_Toc101177126"></span><span style="-aw-bookmark-end:_Toc103356795"></span></a></h3><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{info.year}}年末单位资产由{{ </span><a name="_Hlk130202016"><span style="font-family:宋体; font-size:12pt">finance.unitAssetComposition</span></a><span style="font-family:宋体; font-size:12pt">}}构成，其中{{ finance.composition}}。{{info.year}}年末单位拥有资产总额较上年末{{ finance.totalAssetsComparison}}。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{info.year}}年末单位流动资产由{{ finance.currentAssetsCompose}}构成。单位非流动资产由{{ finance.nonCurrentAssetsCompose}}构成。具体构成如下：</span></p><p style="font-size:14pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; widows:0"><span style="font-family:'Times New Roman'; font-size:14pt">{{ {"chart.type": "pie", "chart.dataset": "</span><span style="font-family:宋体; font-size:14pt">资产占比</span><span style="font-family:'Times New Roman'; font-size:14pt">", "chart.xaxis_column": "indexName", "chart.</span><a name="OLE_LINK3"><span style="font-family:'Times New Roman'; font-size:14pt">yaxis_column</span></a><span style="font-family:'Times New Roman'; font-size:14pt">": "dataValue", "chart.title":</span><span style="font-family:'Times New Roman'; font-size:14pt"> "</span><span style="font-family:宋体; font-size:14pt">资产占比</span><span style="font-family:'Times New Roman'; font-size:14pt">", "chart.top_n"</span><span style="font-family:'Times New Roman'; font-size:14pt">:</span><span style="font-family:'Times New Roman'; font-size:14pt"> " "} }}</span></p><p style="margin:4.7pt 0pt 0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">图一：资产占比</span></p><p style="font-size:14pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; widows:0"><span style="font-family:'Times New Roman'; font-size:14pt">&#xa0;</span></p><p style="font-size:14pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; widows:0"><span style="font-family:'Times New Roman'; font-size:14pt">{{ {"chart.type": "pie", "chart.dataset": "</span><span style="font-family:宋体; font-size:14pt">流动资产占比</span><span style="font-family:'Times New Roman'; font-size:14pt">", "chart.xaxis_column": "indexName"</span><span style="font-family:'Times New Roman'; font-size:14pt">,</span><span style="font-family:'Times New Roman'; font-size:14pt"> "chart.yaxis_column": "dataValue", "chart.title": "</span><span style="font-family:宋体; font-size:14pt">流动资产占比</span><span style="font-family:'Times New Roman'; font-size:14pt">", "chart.top_n"</span><span style="font-family:'Times New Roman'; font-size:14pt">:</span><span style="font-family:'Times New Roman'; font-size:14pt"> " "} }}</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">图</span><span style="font-family:宋体; font-size:12pt">二</span><span style="font-family:宋体; font-size:12pt">：流动资产占比</span></p><p style="font-size:14pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; widows:0"><span style="font-family:'Times New Roman'; font-size:14pt">&#xa0;</span></p><p style="font-size:14pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; widows:0"><span style="font-family:'Times New Roman'; font-size:14pt">{{ {"chart.type": "pie", "chart.dataset": "</span><span style="font-family:宋体; font-size:14pt">非流动资产占比</span><span style="font-family:'Times New Roman'; font-size:14pt">", "chart.xaxis_column": "indexName"</span><span style="font-family:'Times New Roman'; font-size:14pt">,</span><span style="font-family:'Times New Roman'; font-size:14pt"> "chart.yaxis_column": "dataValue", "chart.title": "</span><span style="font-family:宋体; font-size:14pt">非流动资产占比</span><span style="font-family:'Times New Roman'; font-size:14pt">", "chart.top_n"</span><span style="font-family:'Times New Roman'; font-size:14pt">:</span><span style="font-family:'Times New Roman'; font-size:14pt"> " "} }}</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">图</span><span style="font-family:宋体; font-size:12pt">三</span><span style="font-family:宋体; font-size:12pt">：</span><span style="font-family:宋体; font-size:12pt">非</span><span style="font-family:宋体; font-size:12pt">流动资产占比</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">&#xa0;</span></p><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><a name="_Toc103783742"></a><a name="_Toc103362579"></a><a name="_Toc101817970"></a><a name="_Toc101282399"></a><a name="_Toc101538233"></a><a name="_Toc101292116"></a><a name="_Toc101177127"></a><a name="_Toc103785476"></a><a name="_Toc103357988"></a><a name="_Toc101108835"></a><a name="_Toc103849052"></a><a name="_Toc102669765"></a><a name="_Toc103276965"></a><a name="_Toc103356796"></a><a name="_Toc101620708"></a><a name="_Toc101618701"></a><a name="_Toc101722433"></a><a name="_Toc101733813"></a><a name="_Toc103369111"></a><a name="_Toc11799"></a><a name="_Toc101296794"></a><a name="_Toc101783199"></a><a name="_Toc104975348"></a><a name="_Toc103248107"><span style="font-family:宋体; font-size:12pt; font-weight:bold">2.</span><span style="font-family:宋体; font-size:12pt; font-weight:bold">单位负债构成及变化情况</span><span style="-aw-bookmark-end:_Toc103783742"></span><span style="-aw-bookmark-end:_Toc103362579"></span><span style="-aw-bookmark-end:_Toc101817970"></span><span style="-aw-bookmark-end:_Toc101282399"></span><span style="-aw-bookmark-end:_Toc101538233"></span><span style="-aw-bookmark-end:_Toc101292116"></span><span style="-aw-bookmark-end:_Toc101177127"></span><span style="-aw-bookmark-end:_Toc103785476"></span><span style="-aw-bookmark-end:_Toc103357988"></span><span style="-aw-bookmark-end:_Toc101108835"></span><span style="-aw-bookmark-end:_Toc103849052"></span><span style="-aw-bookmark-end:_Toc102669765"></span><span style="-aw-bookmark-end:_Toc103276965"></span><span style="-aw-bookmark-end:_Toc103356796"></span><span style="-aw-bookmark-end:_Toc101620708"></span><span style="-aw-bookmark-end:_Toc101618701"></span><span style="-aw-bookmark-end:_Toc101722433"></span><span style="-aw-bookmark-end:_Toc101733813"></span><span style="-aw-bookmark-end:_Toc103369111"></span><span style="-aw-bookmark-end:_Toc11799"></span><span style="-aw-bookmark-end:_Toc101296794"></span><span style="-aw-bookmark-end:_Toc101783199"></span><span style="-aw-bookmark-end:_Toc104975348"></span></a></h3><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{info.year}}年末</span><span style="font-family:宋体; font-size:12pt">单位负债</span><span style="font-family:宋体; font-size:12pt">由{</span><span style="font-family:宋体; font-size:12pt">{</span><span style="font-family:'Times New Roman'; font-size:10.5pt"> </span><span style="font-family:宋体; font-size:12pt">finance.unit</span><span style="font-family:宋体; font-size:12pt">Debt</span><span style="font-family:宋体; font-size:12pt">Composition }}</span><span style="font-family:宋体; font-size:12pt">构成，</span><span style="font-family:宋体; font-size:12pt">其中</span><span style="font-family:宋体; font-size:12pt">{{ finance.</span><span style="font-family:宋体; font-size:12pt">debtC</span><span style="font-family:宋体; font-size:12pt">omposition}}。</span><span style="font-family:宋体; font-size:12pt">与</span><span style="font-family:宋体; font-size:12pt">上年末</span><span style="font-family:宋体; font-size:12pt">相比负债</span><span style="font-family:宋体; font-size:12pt">{{ finance.debtComparisonRatio}}</span><span style="font-family:宋体; font-size:12pt">。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{info.year}}年末单位流动负债由{{ finance.</span><span style="font-family:宋体; font-size:12pt">currentLiabilitiesCompose</span><span style="font-family:宋体; font-size:12pt">}}构成。</span><span style="font-family:宋体; font-size:12pt">具体占比如下：</span></p><p style="font-size:14pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; widows:0"><span style="font-family:'Times New Roman'; font-size:14pt">{{ {"chart.type": "pie", "chart.dataset": "</span><span style="font-family:宋体; font-size:14pt">负债占比</span><span style="font-family:'Times New Roman'; font-size:14pt">", "chart.xaxis_column": "indexName"</span><span style="font-family:'Times New Roman'; font-size:14pt">,</span><span style="font-family:'Times New Roman'; font-size:14pt"> "chart.yaxis_column": "dataValue", "chart.title": "</span><span style="font-family:宋体; font-size:14pt">负债占比</span><span style="font-family:'Times New Roman'; font-size:14pt">", "chart.top_n"</span><span style="font-family:'Times New Roman'; font-size:14pt">:</span><span style="font-family:'Times New Roman'; font-size:14pt"> " "} }}</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">图四：负债占比</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">&#xa0;</span></p><p style="font-size:14pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; widows:0"><span style="font-family:'Times New Roman'; font-size:14pt">{{ {"chart.type": "pie", "chart.dataset": "</span><span style="font-family:宋体; font-size:14pt">流动负债占比</span><span style="font-family:'Times New Roman'; font-size:14pt">", "chart.xaxis_column": "indexName"</span><span style="font-family:'Times New Roman'; font-size:14pt">,</span><span style="font-family:'Times New Roman'; font-size:14pt"> "chart.yaxis_column": "dataValue", "chart.title": "</span><span style="font-family:宋体; font-size:14pt">流动负债占比</span><span style="font-family:'Times New Roman'; font-size:14pt">", "chart.top_n"</span><span style="font-family:'Times New Roman'; font-size:14pt">:</span><span style="font-family:'Times New Roman'; font-size:14pt"> " "} }}</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">图</span><span style="font-family:宋体; font-size:12pt">五</span><span style="font-family:宋体; font-size:12pt">：流动负债占比</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">&#xa0;</span></p><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><a name="_Toc104975349"></a><a name="_Toc101620709"></a><a name="_Toc101618702"></a><a name="_Toc103369112"></a><a name="_Toc103356797"></a><a name="_Toc103248108"></a><a name="_Toc101292117"></a><a name="_Toc101722434"></a><a name="_Toc101783200"></a><a name="_Toc103362580"></a><a name="_Toc103276966"></a><a name="_Toc15330"></a><a name="_Toc101296795"></a><a name="_Toc103357989"></a><a name="_Toc101733814"></a><a name="_Toc103849053"></a><a name="_Toc103785477"></a><a name="_Toc103783743"></a><a name="_Toc102669766"></a><a name="_Toc101538234"></a><a name="_Toc101108836"></a><a name="_Toc101177128"></a><a name="_Toc101282400"></a><a name="_Toc101817971"><span style="font-family:宋体; font-size:12pt; font-weight:bold">3.主要指标分析</span><span style="-aw-bookmark-end:_Toc104975349"></span><span style="-aw-bookmark-end:_Toc101620709"></span><span style="-aw-bookmark-end:_Toc101618702"></span><span style="-aw-bookmark-end:_Toc103369112"></span><span style="-aw-bookmark-end:_Toc103356797"></span><span style="-aw-bookmark-end:_Toc103248108"></span><span style="-aw-bookmark-end:_Toc101292117"></span><span style="-aw-bookmark-end:_Toc101722434"></span><span style="-aw-bookmark-end:_Toc101783200"></span><span style="-aw-bookmark-end:_Toc103362580"></span><span style="-aw-bookmark-end:_Toc103276966"></span><span style="-aw-bookmark-end:_Toc15330"></span><span style="-aw-bookmark-end:_Toc101296795"></span><span style="-aw-bookmark-end:_Toc103357989"></span><span style="-aw-bookmark-end:_Toc101733814"></span><span style="-aw-bookmark-end:_Toc103849053"></span><span style="-aw-bookmark-end:_Toc103785477"></span><span style="-aw-bookmark-end:_Toc103783743"></span><span style="-aw-bookmark-end:_Toc102669766"></span><span style="-aw-bookmark-end:_Toc101538234"></span><span style="-aw-bookmark-end:_Toc101108836"></span><span style="-aw-bookmark-end:_Toc101177128"></span><span style="-aw-bookmark-end:_Toc101282400"></span></a></h3><div style="text-align:center"><table cellspacing="0" cellpadding="0" style="border-collapse:collapse; margin:0 auto"><tr style="height:44.95pt"><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">序号</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">指标名称</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">公式</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">数值</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">指标说明</span></p></td></tr><tr style="height:37.35pt"><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">（1）</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">资产负债率</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">负债总额/资产总额</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:right; widows:0"><span style="font-family:宋体; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt"> finance.</span><span style="font-family:宋体; font-size:12pt">a</span><span style="font-family:宋体; font-size:12pt">ssetLiabilityRatio</span><span style="font-family:宋体; font-size:12pt">}}</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">反映政府部门偿付全部债务本息能力的基本指标。</span></p></td></tr><tr style="height:40.9pt"><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">（</span><span style="font-family:宋体; font-size:12pt">2</span><span style="font-family:宋体; font-size:12pt">）</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">现金比率</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">（货币资金+财政应返还额度）/流动负债</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:right; widows:0"><span style="font-family:宋体; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt"> finance.</span><span style="font-family:宋体; font-size:12pt">cashRatio}}</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">反映政府部门利用现金及现金等价物偿还短期债务的能力。</span></p></td></tr><tr style="height:40.85pt"><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">（</span><span style="font-family:宋体; font-size:12pt">3</span><span style="font-family:宋体; font-size:12pt">）</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">流动比率</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">流动资产/流动负债</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:right; widows:0"><span style="font-family:宋体; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt"> finance.</span><span style="font-family:宋体; font-size:12pt">currentRatio}}</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">反映政府部门流动资产用于偿还流动负债的能力。</span></p></td></tr><tr style="height:40.85pt"><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">（</span><span style="font-family:宋体; font-size:12pt">4</span><span style="font-family:宋体; font-size:12pt">）</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">固定资产成新率</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">固定资产净值/固定资产原值</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:right; widows:0"><span style="font-family:宋体; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt"> finance.</span><span style="font-family:宋体; font-size:12pt">fixedAssetsDepreciationRatio}}</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">反映政府部门固定资产的持续服务能力。</span></p></td></tr><tr style="height:40.85pt"><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">（</span><span style="font-family:宋体; font-size:12pt">5</span><span style="font-family:宋体; font-size:12pt">）</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">公共基础设施成新率</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">公共基础设施净值/公共基础设施原值</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; widows:0"><span style="font-family:宋体; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt"> finance</span><span style="font-family:宋体; font-size:12pt">.publicInfrastructureRatio}}</span><span style="font-family:宋体; font-size:12pt">——</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">反映政府部门公共基础设施的持续服务能力。</span></p></td></tr><tr style="height:40.85pt"><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">（</span><span style="font-family:宋体; font-size:12pt">6</span><span style="font-family:宋体; font-size:12pt">）</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">保障性住房成新率</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">保障性住房净值/保障性住房原值</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:right; widows:0"><span style="font-family:宋体; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt"> finance.</span><span style="font-family:宋体; font-size:12pt">affordabelHouseNewRatio}}</span><span style="font-family:宋体; font-size:12pt">——</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">反映政府部门保障性住房的持续服务能力。</span></p></td></tr><tr style="height:40.85pt"><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">（7）</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="margin:0pt"><span style="font-family:宋体; font-size:12pt">总资产变动率</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="margin:0pt"><span style="font-family:宋体; font-size:12pt">（资产总额年末数-资产总额年初数）/资产总额年初数</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:right; widows:0"><span style="font-family:宋体; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt"> finance.</span><span style="font-family:宋体; font-size:12pt">totalAssetsChangeRatio}}</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="margin:0pt"><span style="font-family:宋体; font-size:12pt">反映资产的增长速度。</span></p></td></tr><tr style="height:60.95pt"><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">（8）</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="margin:0pt"><span style="font-family:宋体; font-size:12pt">总负债变动率</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="margin:0pt"><span style="font-family:宋体; font-size:12pt">（负债总额年末数-负债总额年初数）/负债总额年初数</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:right; widows:0"><span style="font-family:宋体; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt"> finance</span><span style="font-family:宋体; font-size:12pt">.beInDebtChangeRatio}}</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle"><p style="margin:0pt"><span style="font-family:宋体; font-size:12pt">反映负债的增长速度。</span></p></td></tr></table></div><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（1）资产负债率</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">资产负债比率（=负债总额/资产总额）是</span><span style="font-family:宋体; font-size:12pt">反映政府部门偿付全部债务本息能力的基本指标。</span><span style="font-family:宋体; font-size:12pt">负债比率越高，单位的财务风险越大。</span><span style="font-family:宋体; font-size:12pt">本单位的</span><span style="font-family:宋体; font-size:12pt">资产负债率为</span><span style="font-family:宋体; font-size:12pt">{</span><span style="font-family:宋体; font-size:12pt">{finance.assetLiabilityRatio}}，</span><span style="font-family:宋体; font-size:12pt">{</span><span style="font-family:宋体; font-size:12pt">{finance.assetLiabilityRatioRemark }}。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（2）现金比率</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">现金比率（=（货币资金+财政应返还额度）/流动负债）</span><span style="font-family:宋体; font-size:12pt">是反映政府部门利用现金及现金等价物偿还短期债务的能力</span><span style="font-family:宋体; font-size:12pt">。</span><span style="font-family:宋体; font-size:12pt">本单位</span><span style="font-family:宋体; font-size:12pt">现金比率为</span><a name="_Hlk130370969"><span style="font-family:宋体; font-size:12pt">{</span><span style="font-family:宋体; font-size:12pt">{finance.cashRatio}}</span></a><span style="font-family:宋体; font-size:12pt">，{</span><span style="font-family:宋体; font-size:12pt">{finance.cashRatioRemark}}。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（3）流动比率</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">流动比率（=流动资产/流动负债）是</span><span style="font-family:宋体; font-size:12pt">反映政府部门流动资产用于偿还流动负债的能力。</span><span style="font-family:宋体; font-size:12pt">流动比率越高，偿</span><span style="font-family:宋体; font-size:12pt">还</span><span style="font-family:宋体; font-size:12pt">短期债</span><span style="font-family:宋体; font-size:12pt">务的</span><span style="font-family:宋体; font-size:12pt">能力</span><span style="font-family:宋体; font-size:12pt">就</span><span style="font-family:宋体; font-size:12pt">越强。</span><span style="font-family:宋体; font-size:12pt">本</span><span style="font-family:宋体; font-size:12pt">单位</span><span style="font-family:宋体; font-size:12pt">的</span><span style="font-family:宋体; font-size:12pt">流动比率为</span><span style="font-family:宋体; font-size:12pt">{</span><span style="font-family:宋体; font-size:12pt">{finance.currentRatio}}</span><span style="font-family:宋体; font-size:12pt">，{</span><span style="font-family:宋体; font-size:12pt">{finance.currentRatioRemark}}</span><span style="font-family:宋体; font-size:12pt">。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（4）固定资产成新率</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">固定资产成新率(=固定资产净值/固定资产原值)是反映政府部门固定资产的持续服务能力。本单位的固定资产成新率为{</span><span style="font-family:宋体; font-size:12pt">{finance.fixedAssetsDepreciationRatio}}</span><span style="font-family:宋体; font-size:12pt">，{</span><span style="font-family:宋体; font-size:12pt">{finance.fixedAssetsDepreciationRatioRemark}}</span><span style="font-family:宋体; font-size:12pt">。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（5）公共基础设施成新率（不适用）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">公共基础设施成新率（=公共基础设施净值/公共基础设施原值）是反映政府部门公共基础设施的持续服务能力。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（6）保障性住房成新率（不适用）</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">保障性住房成新率（=保障性住房净值/保障性住房原值）是反映政府部门保障性住房的持续服务能力。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（7）总资产变动率</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">总资产变动率</span><span style="font-family:宋体; font-size:12pt">=（资产总额年末数-资产总额年初数）/资产总额年初数，是反映政府部门资产的增长速度。本单位的总资产变动率为{</span><span style="font-family:宋体; font-size:12pt">{finance.totalAssetsChangeRatio}}</span><span style="font-family:宋体; font-size:12pt">，{</span><span style="font-family:宋体; font-size:12pt">{finance.totalAssetsChangeRatioRemark}}</span><span style="font-family:宋体; font-size:12pt">。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（8）总负债变动率</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">总负债变动率=</span><span style="font-family:宋体; font-size:12pt">（负债总额年末数-负债总额年初数）/负债总额年初数，是反映政府部门负债的增长速度。本单位的总负债变动率为{</span><span style="font-family:宋体; font-size:12pt">{finance.beInDebtChangeRatio}}</span><span style="font-family:宋体; font-size:12pt">。{</span><span style="font-family:宋体; font-size:12pt">{ finance.beInDebtChangeRatioRemark}}</span><span style="font-family:宋体; font-size:12pt">。</span></p><h2 style="font-size:15pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><a name="_Toc103785478"></a><a name="_Toc28194"></a><a name="_Toc103356798"></a><a name="_Toc101783201"></a><a name="_Toc18474"></a><a name="_Toc104975350"></a><a name="_Toc101620710"></a><a name="_Toc101296796"></a><a name="_Toc101282401"></a><a name="_Toc102669767"></a><a name="_Toc101108837"></a><a name="_Toc103357990"></a><a name="_Toc101733815"></a><a name="_Toc103276967"></a><a name="_Toc60821254"></a><a name="_Toc103369113"></a><a name="_Toc101538235"></a><a name="_Toc103362581"></a><a name="_Toc101722435"></a><a name="_Toc101817972"></a><a name="_Toc103248109"></a><a name="_Toc101618703"></a><a name="_Toc60821203"></a><a name="_Toc101177129"></a><a name="_Toc103783744"></a><a name="_Toc101292118"></a><a name="_Toc103849054"><span style="font-family:楷体; font-size:15pt; font-weight:bold">（三）</span><span style="font-family:楷体; font-size:15pt; font-weight:bold">政府部门运行情况分析</span><span style="-aw-bookmark-end:_Toc103785478"></span><span style="-aw-bookmark-end:_Toc28194"></span><span style="-aw-bookmark-end:_Toc103356798"></span><span style="-aw-bookmark-end:_Toc101783201"></span><span style="-aw-bookmark-end:_Toc18474"></span><span style="-aw-bookmark-end:_Toc104975350"></span><span style="-aw-bookmark-end:_Toc101620710"></span><span style="-aw-bookmark-end:_Toc101296796"></span><span style="-aw-bookmark-end:_Toc101282401"></span><span style="-aw-bookmark-end:_Toc102669767"></span><span style="-aw-bookmark-end:_Toc101108837"></span><span style="-aw-bookmark-end:_Toc103357990"></span><span style="-aw-bookmark-end:_Toc101733815"></span><span style="-aw-bookmark-end:_Toc103276967"></span><span style="-aw-bookmark-end:_Toc60821254"></span><span style="-aw-bookmark-end:_Toc103369113"></span><span style="-aw-bookmark-end:_Toc101538235"></span><span style="-aw-bookmark-end:_Toc103362581"></span><span style="-aw-bookmark-end:_Toc101722435"></span><span style="-aw-bookmark-end:_Toc101817972"></span><span style="-aw-bookmark-end:_Toc103248109"></span><span style="-aw-bookmark-end:_Toc101618703"></span><span style="-aw-bookmark-end:_Toc60821203"></span><span style="-aw-bookmark-end:_Toc101177129"></span><span style="-aw-bookmark-end:_Toc103783744"></span><span style="-aw-bookmark-end:_Toc101292118"></span></a></h2><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{info.year}}</span><span style="font-family:宋体; font-size:12pt">年，按照权责发生制核算单位收入为</span><span style="font-family:宋体; font-size:12pt">{</span><span style="font-family:宋体; font-size:12pt">{finance.totalRevenue}}</span><span style="font-family:宋体; font-size:12pt">万元，费用为</span><span style="font-family:宋体; font-size:12pt">{</span><span style="font-family:宋体; font-size:12pt">{finance.totalExpenses}}</span><span style="font-family:宋体; font-size:12pt">万元，本年盈余</span><span style="font-family:宋体; font-size:12pt">{</span><span style="font-family:宋体; font-size:12pt">{finance.surplus}}</span><span style="font-family:宋体; font-size:12pt">万元</span><span style="font-family:宋体; font-size:12pt">，收入费用率为</span><span style="font-family:宋体; font-size:12pt">{</span><span style="font-family:宋体; font-size:12pt">{finance.revenueExpensesRatio}}</span><a name="_Hlk130240384"><span style="font-family:宋体; font-size:12pt">。</span></a></p><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><span style="-aw-bookmark-end:_Hlk130240384"></span><a name="_Toc491110460"></a><a name="_Toc491110490"></a><a name="_Toc15657051"></a><a name="_Toc101783202"></a><a name="_Toc101177130"></a><a name="_Toc104975351"></a><a name="_Toc103783745"></a><a name="_Toc103849055"></a><a name="_Toc101108838"></a><a name="_Toc103276968"></a><a name="_Toc101538236"></a><a name="_Toc103369114"></a><a name="_Toc102669768"></a><a name="_Toc12167"></a><a name="_Toc101282402"></a><a name="_Toc101817973"></a><a name="_Toc103356799"></a><a name="_Toc103357991"></a><a name="_Toc101296797"></a><a name="_Toc101292119"></a><a name="_Toc103785479"></a><a name="_Toc101620711"></a><a name="_Toc103362582"></a><a name="_Toc103248110"></a><a name="_Toc101618704"></a><a name="_Toc101722436"></a><a name="_Toc101733816"><span style="font-family:宋体; font-size:12pt; font-weight:bold">1.</span><span style="-aw-bookmark-end:_Toc491110460"></span><span style="-aw-bookmark-end:_Toc491110490"></span><span style="-aw-bookmark-end:_Toc15657051"></span><span style="font-family:宋体; font-size:12pt; font-weight:bold">单位收入费用构成及变化情况</span><span style="-aw-bookmark-end:_Toc101783202"></span><span style="-aw-bookmark-end:_Toc101177130"></span><span style="-aw-bookmark-end:_Toc104975351"></span><span style="-aw-bookmark-end:_Toc103783745"></span><span style="-aw-bookmark-end:_Toc103849055"></span><span style="-aw-bookmark-end:_Toc101108838"></span><span style="-aw-bookmark-end:_Toc103276968"></span><span style="-aw-bookmark-end:_Toc101538236"></span><span style="-aw-bookmark-end:_Toc103369114"></span><span style="-aw-bookmark-end:_Toc102669768"></span><span style="-aw-bookmark-end:_Toc12167"></span><span style="-aw-bookmark-end:_Toc101282402"></span><span style="-aw-bookmark-end:_Toc101817973"></span><span style="-aw-bookmark-end:_Toc103356799"></span><span style="-aw-bookmark-end:_Toc103357991"></span><span style="-aw-bookmark-end:_Toc101296797"></span><span style="-aw-bookmark-end:_Toc101292119"></span><span style="-aw-bookmark-end:_Toc103785479"></span><span style="-aw-bookmark-end:_Toc101620711"></span><span style="-aw-bookmark-end:_Toc103362582"></span><span style="-aw-bookmark-end:_Toc103248110"></span><span style="-aw-bookmark-end:_Toc101618704"></span><span style="-aw-bookmark-end:_Toc101722436"></span></a></h3><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{info.year}}年，</span><a name="_Toc491110491"></a><a name="_Toc491110461"><span style="font-family:宋体; font-size:12pt">单位收入由</span><span style="font-family:宋体; font-size:12pt">{{finance.totalRevenueCompose}}</span><span style="font-family:宋体; font-size:12pt">构成，其中</span><span style="font-family:宋体; font-size:12pt">{{finance.totalRevenueComposeDetail}}</span><span style="font-family:宋体; font-size:12pt">。与{{info.LastYear}}年相比</span><span style="-aw-bookmark-end:_Toc491110491"></span></a><span style="font-family:宋体; font-size:12pt">{{</span><span style="font-family:宋体; font-size:12pt"> finance</span><span style="font-family:宋体; font-size:12pt">.totalRevenueComparison }}。单位费用全部由</span><span style="font-family:宋体; font-size:12pt">{{finance.totalExpensesCompose}}</span><span style="font-family:宋体; font-size:12pt">构成，与{{info.LastYear}}年相比{{</span><span style="font-family:宋体; font-size:12pt"> finance</span><span style="font-family:宋体; font-size:12pt">.totalExpensesComparison}}。具体占比如下：</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">&#xa0;</span></p><p style="font-size:14pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; widows:0"><span style="font-family:'Times New Roman'; font-size:14pt">{{ {"chart.type": "pie", "chart.dataset": "</span><span style="font-family:宋体; font-size:14pt">收入占比</span><span style="font-family:'Times New Roman'; font-size:14pt">", "chart.xaxis_column": "indexName"</span><span style="font-family:'Times New Roman'; font-size:14pt">,</span><span style="font-family:'Times New Roman'; font-size:14pt"> "chart.yaxis_column": "dataValue", "chart.title": "</span><span style="font-family:宋体; font-size:14pt">收入占比</span><span style="font-family:'Times New Roman'; font-size:14pt">", "chart.top_n"</span><span style="font-family:'Times New Roman'; font-size:14pt">:</span><span style="font-family:'Times New Roman'; font-size:14pt">" "} }}</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; text-indent:24pt; widows:0"><a name="_Toc491110494"></a><a name="_Toc15657054"></a><a name="_Toc491105265"></a><a name="_Toc491110464"><span style="font-family:宋体; font-size:12pt">图</span><span style="font-family:宋体; font-size:12pt">六</span><span style="font-family:宋体; font-size:12pt">：收入占比</span></a></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">&#xa0;</span></p><p style="font-size:14pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; widows:0"><span style="font-family:'Times New Roman'; font-size:14pt">{{ {"chart.type": "pie", "chart.dataset": "</span><span style="font-family:宋体; font-size:14pt">费用占比</span><span style="font-family:'Times New Roman'; font-size:14pt">", "chart.xaxis_column": "indexName"</span><span style="font-family:'Times New Roman'; font-size:14pt">,</span><span style="font-family:'Times New Roman'; font-size:14pt"> "chart.yaxis_column": "dataValue", "chart.title": "</span><span style="font-family:宋体; font-size:14pt">费用占比</span><span style="font-family:'Times New Roman'; font-size:14pt">", "chart.top_n"</span><span style="font-family:'Times New Roman'; font-size:14pt">:</span><span style="font-family:'Times New Roman'; font-size:14pt">" "} }}</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">图</span><span style="font-family:宋体; font-size:12pt">七</span><span style="font-family:宋体; font-size:12pt">：费用占比</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">&#xa0;</span></p><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><a name="_Toc101296798"></a><a name="_Toc101620712"></a><a name="_Toc101292120"></a><a name="_Toc3397"></a><a name="_Toc103785480"></a><a name="_Toc101538237"></a><a name="_Toc101618705"></a><a name="_Toc101177131"></a><a name="_Toc103783746"></a><a name="_Toc101783203"></a><a name="_Toc101722437"></a><a name="_Toc103369115"></a><a name="_Toc101108839"></a><a name="_Toc101282403"></a><a name="_Toc103357992"></a><a name="_Toc103362583"></a><a name="_Toc103849056"></a><a name="_Toc103356800"></a><a name="_Toc103276969"></a><a name="_Toc102669769"></a><a name="_Toc103248111"></a><a name="_Toc104975352"></a><a name="_Toc101817974"></a><a name="_Toc101733817"><span style="font-family:宋体; font-size:12pt; font-weight:bold">2.主要指标分析</span><span style="-aw-bookmark-end:_Toc491110494"></span><span style="-aw-bookmark-end:_Toc15657054"></span><span style="-aw-bookmark-end:_Toc491105265"></span><span style="-aw-bookmark-end:_Toc491110464"></span><span style="-aw-bookmark-end:_Toc101296798"></span><span style="-aw-bookmark-end:_Toc101620712"></span><span style="-aw-bookmark-end:_Toc101292120"></span><span style="-aw-bookmark-end:_Toc3397"></span><span style="-aw-bookmark-end:_Toc103785480"></span><span style="-aw-bookmark-end:_Toc101538237"></span><span style="-aw-bookmark-end:_Toc101618705"></span><span style="-aw-bookmark-end:_Toc101177131"></span><span style="-aw-bookmark-end:_Toc103783746"></span><span style="-aw-bookmark-end:_Toc101783203"></span><span style="-aw-bookmark-end:_Toc101722437"></span><span style="-aw-bookmark-end:_Toc103369115"></span><span style="-aw-bookmark-end:_Toc101108839"></span><span style="-aw-bookmark-end:_Toc101282403"></span><span style="-aw-bookmark-end:_Toc103357992"></span><span style="-aw-bookmark-end:_Toc103362583"></span><span style="-aw-bookmark-end:_Toc103849056"></span><span style="-aw-bookmark-end:_Toc103356800"></span><span style="-aw-bookmark-end:_Toc103276969"></span><span style="-aw-bookmark-end:_Toc102669769"></span><span style="-aw-bookmark-end:_Toc103248111"></span><span style="-aw-bookmark-end:_Toc104975352"></span><span style="-aw-bookmark-end:_Toc101817974"></span></a></h3><div style="text-align:center"><table cellspacing="0" cellpadding="0" style="border-collapse:collapse; margin:0 auto; width:100%"><tr style="height:36pt"><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle; width:8.2%"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">序号</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle; width:14.64%"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">指标名称</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle; width:27.62%"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">公  式</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle; width:10.86%"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">数  值</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle; width:38.68%"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">指标说明</span></p></td></tr><tr style="height:39pt"><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle; width:8.2%"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">（1）</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle; width:14.64%"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">收入费用率</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle; width:27.62%"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">年度总费用/年度总收入</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle; width:10.86%"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:right; widows:0"><span style="font-family:宋体; font-size:12pt">{{finance.revenueExpensesRatio}}</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle; width:38.68%"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; widows:0"><span style="font-family:宋体; font-size:12pt">反映政府部门收入与费用的比例情况。</span></p></td></tr><tr style="height:39pt"><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle; width:8.2%"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">（2）</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle; width:14.6%"><p style="margin:0pt"><span style="font-family:宋体; font-size:12pt">总收入变动率</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle; width:14.6%"><p style="margin:0pt"><span style="font-family:宋体; font-size:12pt">（收入总额本年数-收入总额上年数）/收入总额上年数</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle; width:14.6%"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:right; widows:0"><span style="font-family:宋体; font-size:12pt">{{finance.totalRevenueChangeRatio}}</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle; width:14.6%"><p style="margin:0pt"><span style="font-family:宋体; font-size:12pt">反映收入的增长速度。</span></p></td></tr><tr style="height:39pt"><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle; width:8.2%"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:center; widows:0"><span style="font-family:宋体; font-size:12pt">（3）</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle; width:14.6%"><p style="margin:0pt"><span style="font-family:宋体; font-size:12pt">总费用变动率</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle; width:14.6%"><p style="margin:0pt"><span style="font-family:宋体; font-size:12pt">（费用总额本年数-费用总额上年数）/费用总额上年数</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle; width:14.6%"><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:right; widows:0"><span style="font-family:宋体; font-size:12pt">{{finance.totalExpensesChangeRatio}}</span></p></td><td style="border-bottom-color:#000000; border-bottom-style:solid; border-bottom-width:0.75pt; border-left-color:#000000; border-left-style:solid; border-left-width:0.75pt; border-right-color:#000000; border-right-style:solid; border-right-width:0.75pt; border-top-color:#000000; border-top-style:solid; border-top-width:0.75pt; padding-left:5.03pt; padding-right:5.03pt; vertical-align:middle; width:14.6%"><p style="margin:0pt"><span style="font-family:宋体; font-size:12pt">反映费用的增长速度。</span></p></td></tr></table></div><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（1）</span><span style="font-family:宋体; font-size:12pt">收入费用率</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">收入费用率=（年度总费用/年度总收入）</span><span style="font-family:宋体; font-size:12pt">反映政府部门收入与费用的比例情况。</span><span style="font-family:宋体; font-size:12pt">2021年度，收入费用率为{{finance.revenueExpensesRatio}}。权责发生制基础下单位的收入{{finance.revenueExpensesRatioRemark}}费用。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（2）</span><span style="font-family:宋体; font-size:12pt">总收入变动率</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">总收入变动率=（收入总额本年数-收入总额上年数）/收入总额上年数，是反映政府部门收入的增长速度。</span><span style="font-family:宋体; font-size:12pt">{{info.year}}</span><span style="font-family:宋体; font-size:12pt">年，本单位的总收入变动率为</span><span style="font-family:宋体; font-size:12pt">{{finance.totalRevenueChangeRatio}}</span><span style="font-family:宋体; font-size:12pt">。</span><span style="font-family:宋体; font-size:12pt">{{finance.totalRevenueChangeRatioRemark}}</span><span style="font-family:宋体; font-size:12pt">。</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">（</span><span style="font-family:宋体; font-size:12pt">3</span><span style="font-family:宋体; font-size:12pt">）总费用变动率</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">总费用变动率=（费用总额本年数-费用总额上年数）/费用总额上年数，是反映政府部门费用的增长速度。</span><span style="font-family:宋体; font-size:12pt">{{info.year}}</span><span style="font-family:宋体; font-size:12pt">年，本单位的总费用变动率为</span><span style="font-family:宋体; font-size:12pt">{{finance.totalExpensesChangeRatio}}</span><span style="font-family:宋体; font-size:12pt">。</span><span style="font-family:宋体; font-size:12pt">{{finance.totalExpensesChangeRatioRemark}}</span><span style="font-family:宋体; font-size:12pt">。</span></p><h2 style="font-size:15pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><a name="_Toc103849057"></a><a name="_Toc101296799"></a><a name="_Toc101108840"></a><a name="_Toc101620713"></a><a name="_Toc101817975"></a><a name="_Toc102669770"></a><a name="_Toc101783204"></a><a name="_Toc101292121"></a><a name="_Toc101282404"></a><a name="_Toc103785481"></a><a name="_Toc103362584"></a><a name="_Toc101618706"></a><a name="_Toc103276970"></a><a name="_Toc13105"></a><a name="_Toc101177132"></a><a name="_Toc103356801"></a><a name="_Toc103357993"></a><a name="_Toc103369116"></a><a name="_Toc101722438"></a><a name="_Toc101538238"></a><a name="_Toc103783747"></a><a name="_Toc103248112"></a><a name="_Toc104975353"></a><a name="_Toc20281"></a><a name="_Toc101733818"><span style="font-family:楷体; font-size:15pt; font-weight:bold">（四）</span><span style="font-family:楷体; font-size:15pt; font-weight:bold">政府部门财务管理情况</span><span style="-aw-bookmark-end:_Toc103849057"></span><span style="-aw-bookmark-end:_Toc101296799"></span><span style="-aw-bookmark-end:_Toc101108840"></span><span style="-aw-bookmark-end:_Toc101620713"></span><span style="-aw-bookmark-end:_Toc101817975"></span><span style="-aw-bookmark-end:_Toc102669770"></span><span style="-aw-bookmark-end:_Toc101783204"></span><span style="-aw-bookmark-end:_Toc101292121"></span><span style="-aw-bookmark-end:_Toc101282404"></span><span style="-aw-bookmark-end:_Toc103785481"></span><span style="-aw-bookmark-end:_Toc103362584"></span><span style="-aw-bookmark-end:_Toc101618706"></span><span style="-aw-bookmark-end:_Toc103276970"></span><span style="-aw-bookmark-end:_Toc13105"></span><span style="-aw-bookmark-end:_Toc101177132"></span><span style="-aw-bookmark-end:_Toc103356801"></span><span style="-aw-bookmark-end:_Toc103357993"></span><span style="-aw-bookmark-end:_Toc103369116"></span><span style="-aw-bookmark-end:_Toc101722438"></span><span style="-aw-bookmark-end:_Toc101538238"></span><span style="-aw-bookmark-end:_Toc103783747"></span><span style="-aw-bookmark-end:_Toc103248112"></span><span style="-aw-bookmark-end:_Toc104975353"></span><span style="-aw-bookmark-end:_Toc20281"></span></a></h2><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><a name="_Toc103357994"></a><a name="_Toc104975354"></a><a name="_Toc103849058"></a><a name="_Toc103362585"></a><a name="_Toc103276971"></a><a name="_Toc103785482"></a><a name="_Toc103248113"></a><a name="_Toc103369117"></a><a name="_Toc103783748"></a><a name="_Toc103356802"><span style="font-family:'Times New Roman'; font-size:12pt; font-weight:bold">1.</span><span style="font-family:宋体; font-size:12pt; font-weight:bold">预算管理情况</span><span style="-aw-bookmark-end:_Toc103357994"></span><span style="-aw-bookmark-end:_Toc104975354"></span><span style="-aw-bookmark-end:_Toc103849058"></span><span style="-aw-bookmark-end:_Toc103362585"></span><span style="-aw-bookmark-end:_Toc103276971"></span><span style="-aw-bookmark-end:_Toc103785482"></span><span style="-aw-bookmark-end:_Toc103248113"></span><span style="-aw-bookmark-end:_Toc103369117"></span><span style="-aw-bookmark-end:_Toc103783748"></span></a></h3><p style="margin:0pt; orphans:0; text-align:justify; text-indent:21pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{info.budgetManagement}}</span></p><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><a name="_Toc103248114"></a><a name="_Toc101108842"></a><a name="_Toc101177134"></a><a name="_Toc103356803"></a><a name="_Toc103357995"></a><a name="_Toc103849059"></a><a name="_Toc103783749"></a><a name="_Toc103785483"></a><a name="_Toc103362586"></a><a name="_Toc103276972"></a><a name="_Toc103369118"></a><a name="_Toc104975355"><span style="font-family:'Times New Roman'; font-size:12pt; font-weight:bold">2.</span><span style="font-family:宋体; font-size:12pt; font-weight:bold">绩效管理</span><span style="font-family:宋体; font-size:12pt; font-weight:bold">情况</span><span style="-aw-bookmark-end:_Toc103248114"></span><span style="-aw-bookmark-end:_Toc101108842"></span><span style="-aw-bookmark-end:_Toc101177134"></span><span style="-aw-bookmark-end:_Toc103356803"></span><span style="-aw-bookmark-end:_Toc103357995"></span><span style="-aw-bookmark-end:_Toc103849059"></span><span style="-aw-bookmark-end:_Toc103783749"></span><span style="-aw-bookmark-end:_Toc103785483"></span><span style="-aw-bookmark-end:_Toc103362586"></span><span style="-aw-bookmark-end:_Toc103276972"></span><span style="-aw-bookmark-end:_Toc103369118"></span></a></h3><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{info.performanceManagement}}</span></p><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><a name="_Toc103357996"></a><a name="_Toc101108843"></a><a name="_Toc103785484"></a><a name="_Toc103849060"></a><a name="_Toc103356804"></a><a name="_Toc103783750"></a><a name="_Toc104975356"></a><a name="_Toc101177135"></a><a name="_Toc103362587"></a><a name="_Toc103369119"></a><a name="_Toc103248115"></a><a name="_Toc103276973"><span style="font-family:'Times New Roman'; font-size:12pt; font-weight:bold">3.</span><span style="font-family:宋体; font-size:12pt; font-weight:bold">内</span><span style="font-family:宋体; font-size:12pt; font-weight:bold">部控制</span><span style="font-family:宋体; font-size:12pt; font-weight:bold">情况</span><span style="-aw-bookmark-end:_Toc103357996"></span><span style="-aw-bookmark-end:_Toc101108843"></span><span style="-aw-bookmark-end:_Toc103785484"></span><span style="-aw-bookmark-end:_Toc103849060"></span><span style="-aw-bookmark-end:_Toc103356804"></span><span style="-aw-bookmark-end:_Toc103783750"></span><span style="-aw-bookmark-end:_Toc104975356"></span><span style="-aw-bookmark-end:_Toc101177135"></span><span style="-aw-bookmark-end:_Toc103362587"></span><span style="-aw-bookmark-end:_Toc103369119"></span><span style="-aw-bookmark-end:_Toc103248115"></span></a></h3><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{info.internalControl}}</span></p><h3 style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; page-break-after:avoid; page-break-inside:avoid; text-align:justify; widows:0"><a name="_Toc103362588"></a><a name="_Toc103849061"></a><a name="_Toc103248116"></a><a name="_Toc103276974"></a><a name="_Toc104975357"></a><a name="_Toc103785485"></a><a name="_Toc101108844"></a><a name="_Toc103369120"></a><a name="_Toc103357997"></a><a name="_Toc103783751"></a><a name="_Toc103356805"></a><a name="_Toc101177136"><span style="font-family:'Times New Roman'; font-size:12pt; font-weight:bold">4.</span><span style="font-family:宋体; font-size:12pt; font-weight:bold">资产管理情况</span><span style="-aw-bookmark-end:_Toc103362588"></span><span style="-aw-bookmark-end:_Toc103849061"></span><span style="-aw-bookmark-end:_Toc103248116"></span><span style="-aw-bookmark-end:_Toc103276974"></span><span style="-aw-bookmark-end:_Toc104975357"></span><span style="-aw-bookmark-end:_Toc103785485"></span><span style="-aw-bookmark-end:_Toc101108844"></span><span style="-aw-bookmark-end:_Toc103369120"></span><span style="-aw-bookmark-end:_Toc103357997"></span><span style="-aw-bookmark-end:_Toc103783751"></span><span style="-aw-bookmark-end:_Toc103356805"></span></a></h3><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="font-family:宋体; font-size:12pt">{{info.assetManagement}}</span></p><p style="font-size:12pt; line-height:150%; margin:0pt; orphans:0; text-align:justify; text-indent:24pt; widows:0"><span style="-aw-bookmark-end:_Hlk104474514"></span><span style="font-family:宋体; font-size:12pt">&#xa0;</span></p></div></body></html>
"""


def ner_correct(content, right_sentence):
    # right_sentence = "广元市朝天区曾家镇人民政府"
    tag_index, tag_content, content_index, content_text = find_tag(content)

    no_tag_content = ''.join(content_text)
    sentences = split_sentence(no_tag_content)

    right_result = []
    # 定义部委名单
    bw_list = ['人大', '政协', '曾家镇党委', '党中央', '财政部']
    count = 0
    content_update_record = []
    for start, end, sentence in sentences:
        temp_org = lac_organize_name(sentence)
        for org in temp_org:
            if (right_sentence.strip() in org) or (org in bw_list):
                continue
            else:
                err_org = org
                start_index = sentence.find(err_org)
                end_index = start_index + len(err_org)
                error_correction = {
                    'id': 'correct_error_%s' % count,
                    'error': no_tag_content[start + start_index: start + end_index].strip(),
                    'correct': right_sentence.strip()
                }
                right_result.append(error_correction)
                if start + end_index == len(content_index):
                    content_index_end = content_index[-1] + 1
                else:
                    content_index_end = content_index[start + end_index - 1] + 1

                content_update_record.append((error_correction['id'], content_index[start + start_index],
                                             content_index_end))
                count += 1

    # 通过字符串切片和拼接在指定位置插入内容，并更新后续位置的索引；先获取拆入位置的起始索引和拆入内容
    insert_list = []
    # 先基于索引序号对待插入内容进行排序
    content_update_record = sorted(content_update_record, key=lambda x: x[1])
    # print(content_update_record)
    for error_correction_id, update_start_index, update_end_index in content_update_record:
        # print(content[update_start_index: update_end_index])
        # print(update_start_index, update_end_index)
        highlight = '<u id="{}" style="color:red;">{}</u>'.format(error_correction_id,
                                                                  content[update_start_index: update_end_index])
        # print("==={}".format(highlight))
        insert_list.append((update_start_index, update_end_index, highlight))

    # 初始化偏移量为0
    offset = 0
    for replace in insert_list:
        start, end, new_s = replace
        content = content[:start + offset] + new_s + content[end + offset:]
        # 更新偏移量
        offset += len(new_s) - (end - start)

    # for error_correction_id, update_start_index, update_end_index in content_update_record[::-1]:
    #     highlight = '<u id="{}" style="color:red;">{}</u>'.format(error_correction_id,
    #                                                               text[update_start_index: update_end_index])
    #     text = text[:update_start_index] + highlight + text[update_end_index:]
    # print(content)
    # print(right_result)
    return content, right_result


def qx_correct(content):
    tag_index, tag_content, content_index, content_text = find_tag(content)
    no_tag_content = ''.join(content_text)
    sentences = split_sentence(no_tag_content)
    right_result = []
    count = 0
    content_update_record = []
    for start, end, sentence in sentences:
        set_result = match_pattern(sentence, patterns=['(?={{).+?(?<=}})'])
        for result in set_result:
            start_index = sentence.find(result)
            end_index = start_index + len(result)
            error_correction = {
                'id': 'qx_error_%s' % count,
                'error': no_tag_content[start + start_index: start + end_index].strip()
            }
            right_result.append(error_correction)

            if start + end_index == len(content_index):
                content_index_end = content_index[-1] + 1
            else:
                content_index_end = content_index[start + end_index - 1] + 1

            content_update_record.append((error_correction['id'], content_index[start + start_index],
                                         content_index_end))
            count += 1
    # 测试位置
    # print(content[2093:1922])
    # 通过字符串切片和拼接在指定位置插入内容，并更新后续位置的索引；先获取拆入位置的起始索引和拆入内容
    insert_list = []
    # 先基于索引序号对待插入内容进行排序
    content_update_record = sorted(content_update_record, key=lambda x: x[1])
    # print(content_update_record)
    for error_correction_id, update_start_index, update_end_index in content_update_record:
        # print(content[update_start_index: update_end_index])
        # print(update_start_index, update_end_index)
        highlight = '<u id="{}" style="color:red;">{}</u>'.format(error_correction_id,
                                                                  content[update_start_index: update_end_index])
        # print("==={}".format(highlight))
        insert_list.append((update_start_index, update_end_index, highlight))

    # 初始化偏移量为0
    offset = 0
    for replace in insert_list:
        start, end, new_s = replace
        content = content[:start + offset] + new_s + content[end + offset:]
        # 更新偏移量
        offset += len(new_s) - (end - start)

    # print(content)

    return content, right_result


# ner_correct(text, "广元市朝天区曾家镇人民政府")
