#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @File     : template
# @Author   : LiuYan
# @Time     : 2021/12/1 17:13

import datetime

from base.dao.base_dao import db


class Template(db.Model):
    """
    user -- template --> OneToMany
    """
    __tablename__ = 'template'
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)        # *_主键id
    project_name = db.Column(db.String(50), nullable=False)                 # *_项目名称
    topic_name = db.Column(db.String(50), nullable=True)                    # __专题名称
    datasource_name = db.Column(db.String(50), nullable=True)               # __数据源名称

    template_name = db.Column(db.String(50), nullable=False)                # *_模板/报告名
    template_path = db.Column(db.String(500), nullable=False)               # *_模板路径
    template_describe = db.Column(db.String(5000), nullable=False)          # *_模板描述
    
    create_by = db.Column(db.String(50), nullable=True)                     # __创建人
    create_time = db.Column(db.DateTime, default=datetime.datetime.now())   # __创建日期
    update_by = db.Column(db.String(50), nullable=True)                     # __更新人
    update_time = db.Column(db.DateTime, onupdate=datetime.datetime.now())  # __更新日期

    user_id = db.Column(db.Integer, db.ForeignKey('user.id'), nullable=False)

