#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @File    : 文章内容检查.py
# @Time    : 2022/12/9 16:05
# @Author  : bruxelles_li
# @Software: PyCharm
from bs4 import BeautifulSoup
import re


punctuation = re.compile(r'[\n0-9a-zA-Z、！？｡。＂＃＄％＆＇（）＊＋，－／：；＜＝＞＠［＼］＾＿｀｛｜｝～｟｠｢｣､'
                         r'〃》「」『』【】〔〕〖〗〘〙〚〛〜〝〞〟〰〾〿–—‘’‛“”„‟…‧﹏.!"#$%&\'()*+,\-'
                         r'./:;<=>?@\[\]\\^_`{|}~一二三四五六七八九十《]')
# punctuation = re.compile(r'[0-9]')


def is_punctuation(text):
    punctuation_pattern = re.compile(punctuation)
    if punctuation_pattern.sub('', text):
        return False
    else:
        return True


# 程序返回处理函数
def clean_html_tag(content):
    text = content
    bs = BeautifulSoup(text, 'lxml')
    temp = []
    match_content = bs.text.strip()
    # 初步清洗文中的空白符，杂乱符号
    pattern = re.compile(
        '[＃＄＊$＜＝＞＠●▍［＼］△▲＾＿｀■▋｛｜｝～｟｠ф｢｣\u3000〈〉《》「」『』【】※〔〕〖〗〘〙〚〛〜〰〾〿\*〈〉]')
    match_content0 = pattern.sub('', match_content)
    match_content1 = re.sub(r"(阅读提示|点击 上方文字 关注我们 |点击 上方文字 关注我们|点击蓝字丨关注我们|点击蓝字 关注我们|- THE END - |◀——|-)", "", match_content0)
    match_content2 = re.sub(r"(?=\（图片[：:]).+(?<=\）)", "", match_content1)
    match_content3 = re.sub(r"&mdash&mdash", "&mdash", match_content2)
    match_content4 = re.sub(r"&mdash", "&", match_content3)
    match_content5 = re.sub(r"       ", "", match_content4)
    match_content6 = re.sub(r"(?=\（).*(?<=图\）)", "", match_content5)
    match_content7 = re.sub(r'。"', "。”", match_content6)
    match_content8 = re.sub(r"(。；|。，)", "。", match_content7)
    match_content9 = re.sub(r"(\\t|\\)", "", match_content8)
    list_content = match_content9.split('\n')
    temp_content = []
    for text in list_content:
        if len(text) <= 2:
            continue
        else:
            text = text.strip()
            if text.endswith("。") or text.endswith("“") or text.endswith(".") or text.endswith('”'):
               text = text
            else:
                text = text + "\t" + "\t"
                text = re.sub(r".*(?<=记者).*(?<=摄)", "", text)
            temp_content.append(text)
    # print(temp_content)
    str_content = "\t".join(temp_content)
    a = re.sub('\t\t\t', '——', str_content)
    a0 = re.sub('\t\t', '', a)
    a1 = re.sub(r"：——", "：", a0)
    a2 = re.sub(r"。）", "）", a1)
    a3 = re.sub(r"(。”|！”)", "”", a2)
    b = re.sub("\t", "\n", a3).strip()
    c = b.split('\n')
    # print(len(c))
    for d in c:
        e = d.strip('&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;')
        # 去除中间包含指定字符所在的句子
        f = re.sub("(微信|如需转载|免责声明|公告|jpeg|jpg|png|声明：|附件：|责任单位：|编辑：).*?(?<=。)", '', str(e))
        # 删除邮箱所在行
        g = re.sub(".*(?=\.com|www\.).*", "", f)
        # print(g)
        if len(g) <= 20:
            continue
        else:
            temp.append(g)
    h = "\t".join(temp)
    j = re.sub("\t(?=而|但|对于|此外|因此|与此同时|这种|基于此|但是|然而)", "", h)
    new_content = re.sub("\t", "\n", j)
    new_content_list = new_content.split("\n")
    final_content_list = []
    for k in new_content_list:
        k = "  " + k
        # 先去除中间包含javascript、html所在的段落内容
        l = re.sub(".*(function。|html|background|javascript|image).*", '', k)
        if l:
            final_content_list.append(l.strip("——"))
    final_content = "\n\n".join(final_content_list) if len(final_content_list) >= 10 else "".join(final_content_list)
    return final_content


if __name__ == "__main__":
    text = """工业和信息化部◀——◀——◀——◀——◀—— 人力资源社会保障部 生态环境部 商务部 市场监管总局
 持续健全市场化运营体制机制，守好安全生产底线红线，推进绿色低碳科技研发应用，为实现碳达峰碳中和目标贡献力量。把坚持党的领导加强党的建设融入公司治理，凝聚各方面工作合力，努力开创公司改革发展新局面。（图片：孚能科技将绿色发展融入企业成长，并带动产业链协同提昇晉昇，提拔）
    """
    print(clean_html_tag(content=text))
