#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @File    : 占位符测试.py
# @Time    : 2022/12/7 10:02
# @Author  : bruxelles_li
# @Software: PyCharm

"""
说明：4个字符是为了避免开头字符多次出现在文章中的不同位置
段落索引： 以段落开头4个字符所在文章位置和段落结尾四个字符所在文章位置作为索引
句子绝对位置索引：以句子开头4个字符所在文章位置和句子结尾4个字符所在文章位置作为索引
句子相对位置索引: 以句子开头4个字符所在段落位置和句子开头4个字符所在段落位置作为索引

注：高亮方法
            a = '\033[1;31;40m%s\033[0m' % para[:4]
            b = '\033[1;31;40m%s\033[0m' % para[-4:]
            print(para_index, a, b)

注： 搜索推荐时转义
            段落库：
            prefix_index = int(para_index.split("|")[0])
            suffix_index = int(para_index.split("|")[1])
            print(prefix_index, suffix_index)
            # 返回内容，即搜索推荐时高亮区域
            print(text[prefix_index:suffix_index+1])

            句子库：
                    # 文章索引
                    article_prefix_index = int(sent_article_index.split("|")[0])
                    article_suffix_index = int(sent_article_index.split("|")[1])
                    print(article_prefix_index, article_suffix_index)
                    # 返回内容，即搜索推荐时在文章中的高亮区域
                    print(text[article_prefix_index:article_suffix_index+2])
                    # 段落索引
                    para_prefix_index = int(sent_para_index.split("|")[0])
                    para_suffix_index = int(sent_para_index.split("|")[1])
                    print(para_prefix_index, para_suffix_index)
                    # 返回内容，即搜索推荐时在文章中的高亮区域
                    print(para[para_prefix_index:para_suffix_index+2])

注：  参数定义
        输入：
            文章id：   infoId      -> str
            文章标题：  title       -> str
            正文：     content     -> str
            文章类型：  contentTypeIds   -> str
            文章主题：  topicTypeIds     -> str
            来源网站:   origin      -> str
            发布时间:   publishDate     -> str
            作者:      author      -> str

        输出：
            状态码：    code         -> str
            处理消息：   message     -> str
            返回内容体:  resultData  -> object
                    文章信息列表：     article_info    -> array
                                文章id：           infoId           -> str
                                文章标题：          title            -> str
                                正文：             content          -> str
                                文章类型：          contentTypeIds   -> str
                                文章主题：          topicTypeIds     -> str
                                来源网站:          origin            -> str
                                发布时间:          publishDate       -> str
                                作者:             author            -> str
                    段落信息列表：     para_info       -> array
                                段落库id:          para_id          -> str
                                段落所在文章id:     infoId           -> str
                                段落索引:          para_index       -> str
                                段落内容：         para_content      -> str
                                段落类型：         contentTypeIds    -> str
                                段落主题：         topicTypeIds      -> str

                    句子信息列表：     sent_info        -> array
                                句子库id：        sent_id           -> str
                                句子所在段落id:    para_id           -> str
                                句子所在文章id:    infoId            -> str
                                绝对位置索引：     sent_article_index     -> str
                                相对位置索引：     sent_para_index        -> str
                                句子内容：        sent_content           -> str
                                句子类型：        contentTypeIds    -> str
                                句子主题：        topicTypeIds      -> str


"""

import re
from tqdm import tqdm
import pandas as pd
from 文章id生成 import create_title_id
data_df = pd.read_excel("领导讲话结果.xlsx", nrows=1).astype(str)
# 初始化段落库id，句子库id
para_id, sent_id = 1, 1
# todo: 定义返回结果列表
list_article = []
for idx, row in tqdm(data_df.iterrows()):
    # 若文章id存在则用该文章id，若不存在，则用时间戳来生成文章id
    row["infoId"] = row["infoId"] if row["infoId"] else str(create_title_id())
    # 处理正文内容
    text = row["正文"]
    # list_text = list(text)
    # 基础段落拆分符号”\n“
    para_list = text.split("\n")
    # print(len(para_list))
    # todo: 定义单篇文章的段落信息列表，句子信息列表
    list_para, list_sent = [], []
    # 获取段落索引
    for para in para_list:
        # 处理正常内容段落
        if len(para) >= 50:
            # 根据前四个字符内容获取索引
            a0 = para[:4]
            b0 = para[-4:]
            # 获取首字符的索引
            a0_index = text.find(a0) + (4 - len(a0.strip()))
            # print(a0, a0_index, text[a0_index])
            # 获取末字尾符的索引
            b0_index = text.find(b0) + (4 - len(b0.strip())) + 3
            # print(b0, b0_index, text[b0_index])
            # 保存索引
            para_index = str(a0_index) + "|" + str(b0_index)
            # print(para_index)
            # 获取句子索引， 句子索引有两部分：绝对位置索引，即原文中的位置索引； 相对位置索引，即所在段落中的索引
            print("====句子索引====")
            # 基础句子拆分符号”！。？“
            sent_list = re.split(r'\s*[。！？]\s*', para)
            for sent in sent_list:
                # todo：当句子长度大于10才进行入库
                if len(sent) >= 10:
                    # 根据前四个字符内容获取索引
                    c0 = sent[:4]
                    d0 = sent[-4:]
                    # 获取首字符的索引
                    c0_index = text.find(c0) + (4 - len(c0.strip()))
                    c1_index = para.find(c0) + (4 - len(c0.strip()))
                    # print(c0, c0_index, text[c0_index], c1_index, para[c1_index])
                    # 获取末字尾符的索引
                    d0_index = text.find(d0) + (4 - len(d0.strip())) + 3
                    d1_index = para.find(d0) + (4 - len(d0.strip())) + 3
                    # print(d0, d0_index, text[d0_index], d1_index, para[d1_index])
                    # 保存索引
                    sent_article_index = str(c0_index) + "|" + str(d0_index)
                    sent_para_index = str(c1_index) + "|" + str(d1_index)
                    # 打印句子内容
                    print(text[c0_index:d0_index+2], para[c1_index:d1_index+2])
                    # 将句子信息加入句子信息列表
                    list_sent.append({
                        "sent_id": str(sent_id),
                        "para_id": str(para_id),
                        "infoId": row["infoId"],
                        "sent_article_index": sent_article_index,
                        "sent_para_index": sent_para_index,
                        "sent_content": text[c0_index:d0_index+2],
                        "contentTypeIds": "",
                        "topicTypeIds": ""
                    })
                # todo: 更新句子库id
                sent_id += 1
        # 处理小标题段落
        elif 10 <= len(para) < 50:
            # todo: 根据包含的字词内容来简单过滤脏段落信息
            words_list = {"微信", "如需转载", "免责声明", "公告", "jpeg", "jpg", "png", "【", "责任编辑"}
            if any([i in para for i in words_list]):
                continue
            else:
                # 根据前四个字符内容获取索引
                a0 = para[:4]
                b0 = para[-4:]
                # 获取首字符的索引
                a0_index = text.find(a0) + (4 - len(a0.strip()))
                print(a0, a0_index, text[a0_index])
                # 获取末字尾符的索引
                b0_index = text.find(b0) + (4 - len(b0.strip())) + 3
                print(b0, b0_index, text[b0_index])
                # 保存索引
                para_index = str(a0_index) + "|" + str(b0_index)
        else:
            continue
        # 打印段落内容
        print(text[a0_index:b0_index+1])
        # 将段落信息加入段落信息列表
        list_para.append({
                "para_id": str(para_id),
                "infoId": row["infoId"],
                "para_index": para_index,
                "sent_content": text[a0_index:b0_index+2],
                "contentTypeIds": "",
                "topicTypeIds": ""
        })
        # todo: 更新段落库id
        para_id += 1
    # 将文章信息加入文章信息列表
    list_article.append({
        "infoId": row["infoId"],
        "content": text,
        "title": row["标题"],
        "contentTypeIds": row["专题库类型"],
        "topicTypeIds": row["专题名称"],
        "origin": row["来源"],
        "publishDate": row["发布时间"],
        "author": row["作者"]

    })








