#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @File    : 文章内容检查.py
# @Time    : 2022/12/9 16:05
# @Author  : bruxelles_li
# @Software: PyCharm
from bs4 import BeautifulSoup
import re


# 程序返回处理函数
def clean_html_tag(content):
    # todo: 考虑正式场景中是以</p>进行段落划分的
    ori_text = re.sub("(<\/p >|<\/p>)", "\t", content)
    tag_content_list = ori_text.split("\t") if "<p>" in ori_text else ori_text
    temp_content_list = []
    if type(tag_content_list) is list:
        for text in tag_content_list:
            bs = BeautifulSoup(text, 'lxml')
            ori_match_content = bs.text.strip()
            temp_content_list.append(ori_match_content)
        match_content = "\n".join(temp_content_list)
    else:
        if "参考文献" not in tag_content_list:
            match_content = tag_content_list
        else:
            match_content = tag_content_list.split("参考文献")[0]

    temp = []

    # 初步清洗文中的空白符，杂乱符号
    pattern = re.compile(
        '[▎＃\xa0＄＊★$＜＝＞＠●▍［＼］△▲＾＿｀■▋｛｜｝～｟｠ф｢｣\u3000〈〉《》「」『』【】※〔〕〖〗〘〙〚〛〜〰〾〿\*]')
    match_content0 = pattern.sub('', match_content)
    match_content_1 = re.sub(r".*(来源：|DOI:|微博|哔哩|头条号|订阅号|读完|监制：|校对：|编辑：|排版：|往期精选|关注我们|点击|阅读|作者：).*(?=\n|)", "", match_content0)
    match_content_1_1 = re.sub(r"\s图.*(?=\n)", "", match_content_1)
    match_content1 = re.sub(r"(&emsp;|阅读提示|点击 上方文字 关注我们 |点击 上方文字 关注我们|点击蓝字丨关注我们|点击蓝字 关注我们|- THE END - |◀——|-)", "", match_content_1_1)
    match_content2 = re.sub(r"(?=\（图片[：:]).+(?<=\）)", "", match_content1)
    match_content3 = re.sub(r"&mdash&mdash", "&mdash", match_content2)
    match_content4 = re.sub(r"&mdash", "&", match_content3)
    match_content5 = re.sub(r"       ", "", match_content4)
    match_content6 = re.sub(r"(?=\（).*(?<=图\）)", "", match_content5)
    match_content7 = re.sub(r'。"', "。”", match_content6)
    match_content8 = re.sub(r"(。；|。，)", "。", match_content7)
    match_content9 = re.sub(r"(\\t|\\)", "", match_content8)
    match_content10 = re.sub(r"&;&;", "——", match_content9)
    match_content11 = re.sub(r"（.*(记者).*）", "", match_content10)
    match_content12 = re.sub(r"(&#13;|&zwj)", "", match_content11)
    # match_content13 = re.sub(r"(?<=。).*如图.*所示[：。]", "", match_content12)
    list_content = match_content12.split('\n')
    temp_content = []
    for text in list_content:
        if len(text.strip()) <= 2:
            continue
        else:
            text = text.strip()
            if text.endswith("。") or text.endswith("“") or text.endswith(".") or text.endswith('”'):
               text = text
            else:
                text = text + "\t" + "\t"
                text = re.sub(r".*(?<=记者).*(?<=摄)", "", text)
            temp_content.append(text)
    # print(temp_content)
    str_content = "\t".join(temp_content)
    a = re.sub('\t\t\t', '——', str_content)
    a0 = re.sub('\t\t', '', a)
    a1 = re.sub(r"：——", "：", a0)
    a2 = re.sub(r"。）", "）", a1)
    a3 = re.sub(r"(。”|！”)", "”", a2)
    b = re.sub("\t", "\n", a3).strip()
    c = b.split('\n')
    # print(len(c))
    for d in c:
        e = d.strip('&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;')
        # 去除中间包含指定字符所在的句子
        f = re.sub("(微信|如需转载|免责声明|公告|jpeg|jpg|png|声明：|附件：|责任单位：|编辑：).*?(?<=。)", '', str(e))
        # 删除邮箱所在行
        g = re.sub(".*(?=\.com|www\.).*", "", f)
        # print(g)
        if len(g) <= 20:
            continue
        else:
            temp.append(g)
    h = "\t".join(temp)
    j = re.sub("\t(?=而|但|对于|此外|因此|与此同时|这种|基于此|但是|然而)", "", h)
    new_content = re.sub("\t", "\n", j)
    new_content_list = new_content.split("\n")
    final_content_list = []
    for k in new_content_list:
        k = "  " + k
        # 先去除中间包含javascript、html所在的段落内容
        l = re.sub(".*(function。|html|background|javascript|image).*", '', k)
        if l:
            final_content_list.append(l.strip("——"))

    final_content = "\n\n".join(final_content_list) if len(final_content_list) >= 2 else "".join(final_content_list)
    return final_content


if __name__ == "__main__":
    # text = "  从产品数字化、运营数字化向战略数字化进行转变，数字化已成为平安集团打造核心竞争力、积蓄发展动能的一大源泉。 2020年新冠疫情爆发初期，众多深圳市民都下载了一款“i深圳”APP。有数据显示，“i深圳”自2019年1月11日上线，已接入7600余项服务、55类高频电子证照和电子证明，累计下载数超1800万，累计注册"
    text = """ <p>股平台及中电信创分别增资不超过8亿元、外部战略投资人增资不超过4亿元，公司作为原股东，放弃参本次增资。外部战略投资人的引入通过北京产权交易所公开挂牌进行，中电信创及员工持股平台将根据外部占略投资人摘牌价格增</p >\n<p>&nbsp;</p >\n<p>资。近日，中国电子云增资项目已在北京产权交易所正式挂牌 ，员工持股平台云启未来(武汉)管理咨询中心(有限合伙)已完成设立。2022年12月28日，北京产权交易所向国开制造业转型升基金(有限合伙) (以下简称&ldquo;国开基金&rdquo;)出具了《意向投资方资格确认通知书》，确认国开基金符合投资资格条件，成为合格竟向投咨方。根据国开基金摘牌结果，本次按中国电子云增资前估值30亿元，认购全部亿元外部战略投资人增资</p >\n<p>&nbsp;</p >\n<p>额度。 2022年12月29日，深圳市桑达实业股份有限公司及中国电子云与国开基金员丁持股平台，中电信创签署了《增资协议》，约定国开基金，云启未来(武汉)管理咨询中心(有限合中电信创以相同价格向中国电子云增资，其中，</p >\n<p>&nbsp;</p >\n<p>员工持股平台投资8亿元，中电信创投资8亿元。火)本次增资完成后股权结构如下: 公告个绍，上述《一致行动协议》的签署 ，有利于更好的规范中国电子云经营管理，增强上市公司对中国电子天的控制，不影响上市公司实际控制权，不存在对对上市公司日堂经营管理产生/利影响或损害中小投资者利</p >\n<p>&nbsp;</p >\n<p>举的情形，据悉，深圳市桑达实业股份有限公司是中国电子旗下的重要二级企业秉承集团&ldquo;加快打造网信产业核心力量和组织平台&rdquo;的战略使命，面向党政和 关键行业客户，提供数字与信服务和产业服务。其中在云计算方面，依托中国</p >\n<p>电子PKS自主安全计算体系及丰富的网信产业资源，公司基于自研可信计算技术架构和分布式云原生云操作系统，推出了&ldquo;中国电子云&rdquo;这一数字底座目前，\"中国电一天&rdquo;服务行业客户已超400家，已在天津市西青区，云南省大理州，江西省南昌市新建区，四川省遂宁市和德阳市、山东省德州市等地方政府落地政务云，承建了中国人保等金融机构及管网集团、星网集团、中国华电、中国电子等 央企集团的云平台，以及为国家互联网应急中心等部委提供云</p >
"""
    # print(len(text))
    # text = """"<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" /><meta http-equiv=\"Content-Style-Type\" content=\"text/css\" /><meta name=\"generator\" content=\"Aspose.Words for Java 15.12.0.0\" /><title></title><style type=\"text/css\">@page Section1 { margin:72pt 90pt; size:595.3pt 841.9pt }div.Section1 { page:Section1 }</style></head><body><div class=\"Section1\"><p style=\"margin:0pt; orphans:0; text-align:justify; widows:0\"><span style=\"font-family:宋体; font-size:10.5pt\">希望全国爱国卫生战线的同志们始终坚守初心使命，传承发扬优良传统，丰富工作内涵，创新工作方式方法，为加快推进健康中国建设作出新的贡献。”在爱国卫生运动开展</span><span style=\"font-family:Calibri; font-size:10.5pt\">70</span><span style=\"font-family:宋体; font-size:10.5pt\">周年之际，习近平总书记作出重要指示，强调“用千千万万个文明健康小环境筑牢疫情防控社会大防线，切实保障人民群众生命安全和身体健康”。</span></p><p style=\"margin:0pt; orphans:0; text-align:justify; widows:0\"><span style=\"font-family:Calibri; font-size:10.5pt\">&#xa0;</span></p><p style=\"margin:0pt; orphans:0; text-align:justify; widows:0\"><span style=\"font-family:宋体; font-size:10.5pt\">习近平总书记的重要指示充分肯定了</span><span style=\"font-family:Calibri; font-size:10.5pt\">70</span><span style=\"font-family:宋体; font-size:10.5pt\">年来爱国卫生运动取得的重要成果，深刻阐明了爱国卫生运动的战略地位和作用，对于应对当前新冠疫情防控新形势新任务，推动卫生健康事业高质量发展，有效防范卫生健康领域重大风险，加快推进健康中国建设，具有重大而深远的意义。</span></p><p style=\"margin:0pt; orphans:0; text-align:justify; widows:0\"><span style=\"font-family:Calibri; font-size:10.5pt\">&#xa0;</span></p><p style=\"margin:0pt; orphans:0; text-align:justify; widows:0\"><span style=\"font-family:Calibri; font-size:10.5pt\">&#xa0;</span></p><p style=\"margin:0pt; orphans:0; text-align:justify; widows:0\"><span style=\"font-family:宋体; font-size:10.5pt\">爱国卫生运动是我们党把群众路线运用于卫生防病工作的成功实践，也是一项“以人民健康为中心”的重大惠民工程。</span><span style=\"font-family:Calibri; font-size:10.5pt\">70</span><span style=\"font-family:宋体; font-size:10.5pt\">年来，从除“四害”到“三讲一树”，从全国卫生城镇创建活动到新时代的城乡环境卫生整洁行动、农村“厕所革命”、垃圾分类，我们开展了一系列卓有成效的群众性卫生活动，培养全民养成良好卫生习惯，为保障人民健康发挥了重要作用。特别是新冠疫情发生以来，习近平总书记多次强调坚持以人民为中心的发展理念，广泛开展爱国卫生运动，多次强调预防疫病的重要性，为有效应对重大传染病疫情、提升社会健康治理水平提供了科学指引。</span></p><p style=\"margin:0pt; orphans:0; text-align:justify; widows:0\"><span style=\"font-family:Calibri; font-size:10.5pt\">&#xa0;</span></p><p style=\"margin:0pt; orphans:0; text-align:justify; widows:0\"><span style=\"font-family:Calibri; font-size:10.5pt\">&#xa0;</span></p><p style=\"margin:0pt; orphans:0; text-align:justify; widows:0\"><span style=\"font-family:宋体; font-size:10.5pt\">近日，国家卫健委发布公告，将新冠肺炎更名为新型冠状病毒感染并依法实施“乙类乙管”。这标志着我国疫情防控进入新阶段，在做好相关医疗资源保障、加强对老年人等重点群体保护的基础上，全社会要更加有针对性地开展爱国卫生运动。一方面，要以“大卫生、大健康”理念不断丰富爱国卫生运动的内涵，突出源头治理；另一方面，要充分发挥爱国卫生运动的组织优势和群众动员优势，引导广大人民群众主动学习健康知识，掌握健康生活技能，养成良好的个人卫生习惯，践行文明健康的生活方式，用千千万万个文明健康小环境筑牢疫情防控社会大防线，以全社会整体联动“大处方”开辟爱国卫生工作全民共建共享新局面。</span></p><p style=\"margin:0pt; orphans:0; text-align:justify; widows:0\"><span style=\"font-family:Calibri; font-size:10.5pt\">&#xa0;</span></p><p style=\"margin:0pt; orphans:0; text-align:justify; widows:0\"><span style=\"font-family:Calibri; font-size:10.5pt\">&#xa0;</span></p><p style=\"margin:0pt; orphans:0; text-align:justify; widows:0\"><span style=\"font-family:宋体; font-size:10.5pt\">人民健康是民族昌盛和国家富强的重要标志，预防是最经济最有效的健康策略。当前，新冠疫情防控优化调整措施正在有序推进落实，各级党委政府要结合新的防控形势深刻领会习近平总书记重要指示精神，毫不松劲地抓好各项防控措施，扎实贯彻以人民为中心的发展思想。要以爱国卫生运动为重要抓手，动员全社会落实预防为主的方针和制度体系，加快形成有利于健康的生活方式、生态环境和社会环境，更加有效应对重大传染病疫情，切实保障人民群众生命安全和身体健康。</span></p></div></body></html>"
    # """
    print(clean_html_tag(content=text))
