package com.zzsn.modules.kgj.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.modules.kgj.entity.CesSysSecret;
import com.zzsn.modules.kgj.entity.VO.CesSysSecretVo;
import com.zzsn.modules.kgj.mapper.CesSysSecretMapper;
import com.zzsn.modules.kgj.service.ICesSysSecretService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * @Description: 密点表
 * @Author: zzsn-boot
 * @Date:   2020-10-22
 * @Version: V1.0
 */
@Service
public class CesSysSecretServiceImpl extends ServiceImpl<CesSysSecretMapper, CesSysSecret> implements ICesSysSecretService {

    @Autowired
    private CesSysSecretMapper secretMapper;

    @Override
    public boolean isExist(CesSysSecret cesSysSecret) {
        QueryWrapper<CesSysSecret> wrapper = new QueryWrapper<>();
        wrapper.eq("content",cesSysSecret.getContent());
        wrapper.eq("type",cesSysSecret.getType());
        if (cesSysSecret.getId() != null) {
            wrapper.ne("id", cesSysSecret.getId());
        }
        return count(wrapper) > 0;
    }

    /**
     * 分页查询密点
     * @param cesSysSecret
     * @param offset
     * @param i
     * @return
     */
    @Override
    public List<CesSysSecretVo> selectByPage(CesSysSecret cesSysSecret, int offset, int i) {
     return secretMapper.selectByPage(cesSysSecret,offset,i);
    }

    @Override
    public IPage<CesSysSecretVo> selectByPage1(Page<CesSysSecretVo> page, CesSysSecret cesSysSecret) {
        IPage<CesSysSecretVo> list = secretMapper.selectByPage1(page,cesSysSecret);
        return list;
    }
}
