package com.zzsn.modules.kgj.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.modules.kgj.entity.CesSysWeb;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.modules.kgj.entity.DTO.CesSysWebDto;
import com.zzsn.modules.kgj.entity.VO.CesSysWebVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 网站信息源
 * @Author: zzsn-boot
 * @Date:   2020-10-21
 * @Version: V1.0
 */
public interface CesSysWebMapper extends BaseMapper<CesSysWeb> {
    /**
     * 分页查询数据
     * @param page
     * @param cesSysWebDto
     * @return
     */
    IPage<CesSysWebDto> selectByPage(Page<CesSysWebDto> page, @Param("cesSysWeb") CesSysWebDto cesSysWebDto);

    /**
     * 通过分类ID查询所有该分类下所有网站
     * @param siteTypeId
     * @return
     */
    List<CesSysWeb> selectByTypeId(@Param("siteTypeId") Long siteTypeId);

    List<CesSysWebVo> getWebSites(@Param("typeId") Long typeId);

    Long getWebSiteCount(@Param("typeId") Long typeId,@Param("pTypeId") Long pTypeId);
}
