package com.zzsn.modules.kgj.mapper;

import java.util.List;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.modules.kgj.entity.VO.CesSysSecretVo;
import org.apache.ibatis.annotations.Param;
import com.zzsn.modules.kgj.entity.CesSysSecret;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;

/**
 * @Description: 密点表
 * @Author: zzsn-boot
 * @Date:   2020-10-22
 * @Version: V1.0
 */
public interface CesSysSecretMapper extends BaseMapper<CesSysSecret> {
    /**
     * 根据关键词和分类ID查询所有密点内容
     * @param secret
     * @return
     */
    List<String> queryByCondition(@Param("secret") CesSysSecret secret);

    /**
     * 分页查询密点
     * @param cesSysSecret
     * @param offset
     * @param i
     * @return
     */
    List<CesSysSecretVo> selectByPage(@Param("secret") CesSysSecret cesSysSecret, @Param("offset") int offset,@Param("offset1") int i);

    IPage<CesSysSecretVo> selectByPage1(IPage<CesSysSecretVo> page, @Param("secret") CesSysSecret cesSysSecret);
}
