package com.zzsn.modules.kgj.controller;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.zzsn.common.api.vo.Result;
import com.zzsn.common.aspect.annotation.AutoLog;
import com.zzsn.common.system.vo.LoginUser;
import com.zzsn.modules.kgj.common.Contant;
import com.zzsn.modules.kgj.common.ResultModel;
import com.zzsn.modules.kgj.entity.*;
import com.zzsn.modules.kgj.entity.VO.*;
import com.zzsn.modules.kgj.service.*;
import com.zzsn.modules.kgj.utils.Pager;
import com.zzsn.modules.kgj.utils.TimeUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @author 刘凯歌
 * @description: 基础数据
 * @date 2020/9/28 9:09
 */
@Api(tags = "科工局项目")
@RestController
@RequestMapping("/kgj/basedata")
public class BaseDataController {

    private Logger logger = LoggerFactory.getLogger(BaseDataController.class);
    @Autowired
    private BaseDataService baseDataService;

    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Autowired
    private ICesSysWebService cesSysWebService;

    @Autowired
    private IUserSiteTypeMidService userSiteTypeMidService;

    @Autowired
    private IBaseDataWebMidService baseDataWebMidService;

    @Autowired
    private ISiteTypeService siteTypeService;

    /**
     * 信息分页列表
     * @param offset 页数
     * @param pageSize 页面大小
     * @param basedata 查询条件
     * @return 数据
     */
    @ApiOperation(value = "信息分页列表")
    @PostMapping("/listByPage")
    public ResultModel listByPage(long offset, long pageSize, Basedata basedata){
        Pager<Basedata> basedataPager = baseDataService.listByPage(offset, pageSize, basedata);
        return ResultModel.OK(basedataPager);
    }

    /**
     * 新增或修改
     * @param basedata 数据对象
     * @return 结果
     */
    @PostMapping("/saveOrUpdate")
    public ResultModel saveOrUpdate (@RequestBody Basedata basedata){
        baseDataService.saveOrModify(basedata);
        return ResultModel.OK();
    }

    /**
     * 统计当天信息状态
     * @param tid 分类id
     * @param type 类型
     * @param siteTypeId 网站类型ID
     * @return 根据类型返回当天的信息状态
     */
    @ApiOperation(value = "统计当天信息状态")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tid",value = "科工局编号",dataType = "Long"),
            @ApiImplicitParam(name = "type",value = "是否删除FLAG,null-全部，2-疑似，3-确认",dataType = "Long"),
            @ApiImplicitParam(name = "siteTypeId",value = "网站类型ID",dataType = "Long"),
            @ApiImplicitParam(name = "siteId",value = "网站ID",dataType = "Long"),
            @ApiImplicitParam(name = "pTypeId",value = "父级分类ID（1-十大军工，2-论坛，3-高校）",dataType = "Long")
    })
    @GetMapping("/getTodayData")
    public ResultModel getDatabyTime(Long tid, Long type, Long siteTypeId,Long siteId, Long pTypeId){
        String startTime = TimeUtil.getYesterdayStartTime(new Date(), 1);
        String endTime = TimeUtil.getToDayEndTime(new Date());
//        List<Long> typeList = getUserSiteType();
        List<Long> typeList=new ArrayList<>();
        if(siteTypeId!=null){
            typeList.add(siteTypeId);
        }else{
            typeList = getSiteTypeIdsByPTypeId(pTypeId);
        }
        Long dataCount = baseDataService.getDataCount(tid,startTime,endTime, type,typeList,siteId);
        return ResultModel.OK(dataCount);
    }

    /**
     * 统计全部信息状态
     * @param tid 分类id
     * @param type 类型
     * @return 根据类型返回全部的信息状态
     */
    @ApiOperation(value = "统计全部信息状态")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tid",value = "科工局编号",dataType = "Long"),
            @ApiImplicitParam(name = "type",value = "是否删除FLAG,null-全部，2-疑似，3-确认",dataType = "Long"),
            @ApiImplicitParam(name = "siteTypeId",value = "网站类型ID",dataType = "Long"),
            @ApiImplicitParam(name = "siteId",value = "网站ID",dataType = "Long"),
            @ApiImplicitParam(name = "pTypeId",value = "父级分类ID（1-十大军工，2-论坛，3-高校）",dataType = "Long")
    })
    @GetMapping("/getAllDataCount")
    public ResultModel getDataCount(Long tid, Long type, Long siteTypeId,Long siteId, Long pTypeId){
//        List<Long> typeList = getUserSiteType();//获取当前登录用户关注的网站分类ID列表
        List<Long> typeList=new ArrayList<>();
        if(siteTypeId!=null){
            typeList.add(siteTypeId);
        }else{
            typeList = getSiteTypeIdsByPTypeId(pTypeId);
        }
        Long dataCount = baseDataService.getDataCount(tid,null,null, type,typeList,siteId);
        return ResultModel.OK(dataCount);
    }

    /**
     * 统计前12个月信息(按月统计)
     * @param tid 分类id
     * @param type  类型
     * @return 根据类型返回前12个月信息的信息状态
     */
    @ApiOperation(value = "统计前12个月信息(按月统计)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tid",value = "科工局组织常量",dataType = "Long"),
            @ApiImplicitParam(name = "type",value = "是否删除FLAG,null-全部，2-疑似，3-确认",dataType = "Long"),
            @ApiImplicitParam(name = "siteTypeId",value = "网站分类",dataType = "Long"),
            @ApiImplicitParam(name = "pTypeId",value = "父级分类ID（1-十大军工，2-论坛，3-高校）",dataType = "Long")
    })
    @GetMapping("/getDataCountByMonth")
    public ResultModel getDataCounByMonth(Long tid, Long type, Long siteTypeId, Long pTypeId){
        //先从redis里边取flag判断值，有效期一个小时，判断是否失效，如果失效，则先返回原数据，另起一个线程，更新redis的内容
//        List<Long> typeList = getUserSiteType();
        List<Long> typeList=new ArrayList<>();
        if(siteTypeId!=null){
            typeList.add(siteTypeId);
        }else{
            typeList = getSiteTypeIdsByPTypeId(pTypeId);
        }
        String s = typeList.toString();
        String flag = redisTemplate.opsForValue().get(Contant.DATA_KEY_FLAG + s);
        String string = redisTemplate.opsForValue().get(Contant.DATA_KEY +"_"+s);
        List<BaseDataVO> baseDataVOList = JSON.parseArray(string, BaseDataVO.class);
//        List<BaseDataVO> baseDataVOList = null;
        flag="";
        if(StringUtils.isBlank(flag)){
            //新启动一个线程查询最新的数据，并更新到redis中
            List<Long> finalTypeList = typeList;
            new Thread(() -> {
                //开始日期是从当月往前推，总共十二个月，所以传11
                String startTime = TimeUtil.getBeforeMonthFirstDate(new Date(), 11);
//                    String endTime = TimeUtil.getBeforeMonthEndDate(new Date());
                String endTime = TimeUtil.getToDayEndTime(new Date());
                List<BaseDataVO> list = baseDataService.getDataCountGroupByMonth(tid,startTime,endTime,type, finalTypeList);
                redisTemplate.opsForValue().set(Contant.DATA_KEY+"_"+s,JSON.toJSONString(list));
                //有效时间1小时
                redisTemplate.opsForValue().set(Contant.DATA_KEY_FLAG+s,"true",1,TimeUnit.MINUTES);
            }).start();
        }
        if (baseDataVOList !=null){
            return ResultModel.OK(baseDataVOList);
        }else {
            String startTime = TimeUtil.getBeforeMonthFirstDate(new Date(), 11);
//            String endTime = TimeUtil.getBeforeMonthEndDate(new Date());
            String endTime = TimeUtil.getToDayEndTime(new Date());
            List<BaseDataVO> list = baseDataService.getDataCountGroupByMonth(tid,startTime,endTime,type,typeList);
//            redisTemplate.opsForValue().set(Contant.DATA_KEY+"_"+s,JSON.toJSONString(list));
//            //有效时间1小时
//            redisTemplate.opsForValue().set(Contant.DATA_KEY_FLAG+s,"true",1,TimeUnit.HOURS);
            return ResultModel.OK(list);
        }
    }

    /**
     * 获取来源列表
     * @param tid 分类id
     * @return 根据分类id返回来源列表
     */
    @ApiOperation(value = "获取来源列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tid",value = "科工局组织常量",dataType = "Long"),
            @ApiImplicitParam(name = "siteTypeId",value = "网站分类",dataType = "Long"),
            @ApiImplicitParam(name = "pTypeId",value = "父级分类ID（1-十大军工，2-论坛，3-高校）",dataType = "Long")
    })
    @GetMapping("/getOrigins")
    public ResultModel getOrigins(Long tid, Long siteTypeId, Long pTypeId){
//        List<Long> typeList = getUserSiteType();
        List<Long> typeList=new ArrayList<>();
        if(siteTypeId!=null){
            typeList.add(siteTypeId);
        }else{
            typeList = getSiteTypeIdsByPTypeId(pTypeId);
        }
        List<String> origins = baseDataService.getOrigins(tid,typeList);
        return ResultModel.OK(origins);
    }


    /**
     * 根据来源统计疑似信息:  信息排行
     * @param tid 分类id
     * @return 根据来源统计疑似信息（包含确认信息）
     */
    @ApiOperation(value = "根据来源统计疑似信息及经纬度")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tid",value = "科工局组织常量",dataType = "Long"),
            @ApiImplicitParam(name = "siteTypeId",value = "网站分类",dataType = "Long"),
            @ApiImplicitParam(name = "pTypeId",value = "父级分类ID（1-十大军工，2-论坛，3-高校）",dataType = "Long")
    })
    @GetMapping("/suspectDataList")
    public ResultModel suspectDataList(Long tid, Long siteTypeId, Long pTypeId){
//        List<Long> typeList = getUserSiteType();//获取当前登录用户关注的网站分类ID列表
        List<Long> typeList=new ArrayList<>();
        if(siteTypeId!=null){
            typeList.add(siteTypeId);
        }else{
            typeList = getSiteTypeIdsByPTypeId(pTypeId);
        }

        String s = typeList.toString();
        String string = redisTemplate.opsForValue().get(Contant.DATA_BY_ORIGIN_KEY+s);
        //1个小时的状态是否失效
        String flag = redisTemplate.opsForValue().get(Contant.DATA_BY_ORIGIN_KEY_FLAG+s);
        List<BaseDataVO> baseDataVOS = JSON.parseArray(string, BaseDataVO.class);
//        List<BaseDataVO> baseDataVOS = null;
        if(StringUtils.isBlank(flag)){
            List<Long> finalTypeList = typeList;
            new Thread(() -> {
//                    List<String> origins = baseDataService.getOrigins(tid);
//                    ArrayList<BaseDataVO> resultList = new ArrayList<>();
//                    if (CollectionUtils.isNotEmpty(origins)){
//                        for (String origin :origins) {
//                            BaseDataVO dataByOrigin = baseDataService.getSuspectData(origin, type);
//                            resultList.add(dataByOrigin);
//                        }
//                    }
                List <BaseDataVO> resultList = baseDataService.getSuspectDataNew(tid, finalTypeList);
                //按疑似数量升序
                resultList.sort(Comparator.comparing(BaseDataVO::getSuspectCount).reversed());
                redisTemplate.opsForValue().set(Contant.DATA_BY_ORIGIN_KEY+s,JSON.toJSONString(resultList));
                //有效时间1个小时
                redisTemplate.opsForValue().set(Contant.DATA_BY_ORIGIN_KEY_FLAG+s,"true",1,TimeUnit.HOURS);
            }).start();

        }
        if (baseDataVOS!=null){
            return ResultModel.OK(baseDataVOS);
        }else{
//            List<String> origins = baseDataService.getOrigins(tid);
//            ArrayList<BaseDataVO> resultList = new ArrayList<>();
//            if (CollectionUtils.isNotEmpty(origins)){
//                for (String origin :origins) {
//                    BaseDataVO dataByOrigin = baseDataService.getSuspectData(origin, type);
//                    resultList.add(dataByOrigin);
//                }
//            }
            List <BaseDataVO> resultList = baseDataService.getSuspectDataNew(tid,typeList);
            //按疑似数量升序
            resultList.sort(Comparator.comparing(BaseDataVO::getSuspectCount).reversed());
//            redisTemplate.opsForValue().set(Contant.DATA_BY_ORIGIN_KEY,JSON.toJSONString(resultList));
//            //有效时间1个小时
//            redisTemplate.opsForValue().set(Contant.DATA_BY_ORIGIN_KEY_FLAG,"true",1,TimeUnit.HOURS);
            return ResultModel.OK(resultList);
        }
    }

    /**
     * 获取大屏地图上所有公司的文章数、疑似数、确认数及经纬度
     * @param tid 分类id
     * @return 根据来源统计疑似信息（包含确认信息）
     */ 
    @ApiOperation(value = "获取大屏地图上所有公司的文章数、疑似数、确认数及经纬度")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tid",value = "科工局组织常量",dataType = "Long"),
            @ApiImplicitParam(name = "siteTypeId",value = "网站分类",dataType = "Long"),
            @ApiImplicitParam(name = "pTypeId",value = "父级分类ID（1-十大军工，2-论坛，3-高校,4-微信）",dataType = "Long")
    })
    @GetMapping("/allCorpDataList")
    public ResultModel allCorpDataList(Long tid, Long siteTypeId, Long pTypeId){
//        List<Long> typeList = getUserSiteType();//获取当前登录用户关注的网站分类ID列表

        List<Long> typeList=new ArrayList<>();
        if(siteTypeId!=null){
            typeList.add(siteTypeId);
        }else{
            typeList = getSiteTypeIdsByPTypeId(pTypeId);
        }

        String s = typeList.toString();
        String string = redisTemplate.opsForValue().get(Contant.BIG_SCREEN_MAP_DATA_KEY+s);
        //1个小时的状态是否失效
        String flag = redisTemplate.opsForValue().get(Contant.BIG_SCREEN_MAP_DATA_KEY_FLAG+s);
        List<BaseDataVO> baseDataVOS = JSON.parseArray(string, BaseDataVO.class);

        if(StringUtils.isBlank(flag)){
            List<Long> finalTypeList = typeList;
            new Thread(() -> {
                List<BaseDataVO> resultList = baseDataService.getAllCorpDataList(tid, finalTypeList);

                redisTemplate.opsForValue().set(Contant.BIG_SCREEN_MAP_DATA_KEY+s,JSON.toJSONString(resultList));
                //有效时间1个小时
                redisTemplate.opsForValue().set(Contant.BIG_SCREEN_MAP_DATA_KEY_FLAG+s,"true",1,TimeUnit.MINUTES);
            }).start();

        }
        if (baseDataVOS!=null){
            return ResultModel.OK(baseDataVOS);
        }else{

            List <BaseDataVO> resultList = baseDataService.getAllCorpDataList(tid,typeList);
//            redisTemplate.opsForValue().set(Contant.DATA_BY_ORIGIN_KEY,JSON.toJSONString(resultList));
//            //有效时间1个小时
//            redisTemplate.opsForValue().set(Contant.DATA_BY_ORIGIN_KEY_FLAG,"true",1,TimeUnit.HOURS);
            return ResultModel.OK(resultList);
        }
    }

    private List<Long> getSiteTypeIdsByPTypeId(Long pTypeId) {
        QueryWrapper<SiteType> wrapper = new QueryWrapper<>();
        wrapper.eq("PTYPE", pTypeId);
        List<SiteType> typeList = siteTypeService.list(wrapper);
        List<Long> list = new ArrayList<>();
        for (SiteType type : typeList) {
            list.add(type.getId());
        }
        return list;
    }


    /**
     * 根据类型,来源获取信息
     * @param tid 分类id
     * @param type 类型
     * @return 根据类型,来源获取信息
     */
    @ApiOperation(value = "根据类型,来源获取信息")
    @GetMapping("/getDataByOrigin")
    public ResultModel getDataByOrigin(Long tid,Long type){
        List<String> origins = baseDataService.getOrigins(tid);
        ArrayList<BaseDataVO> resultList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(origins)){
            for (String origin :origins) {
                BaseDataVO dataByOrigin = baseDataService.getDataByOrigin(origin, type);
                resultList.add(dataByOrigin);
            }
        }
        return ResultModel.OK(resultList);
    }

    /**
     * 获取疑似信息：预警信息 type是2
     * @param type 类型
     * @return 返回疑似信息列表
     */
    @ApiOperation(value = "获取疑似信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tid",value = "科工局组织常量",dataType = "Long"),
            @ApiImplicitParam(name = "type",value = "是否删除FLAG,null-全部，2-疑似，3-确认",dataType = "Long"),
            @ApiImplicitParam(name = "siteTypeId",value = "网站分类（十大军工分类）",dataType = "Long"),
            @ApiImplicitParam(name = "secretLevel",value = "风险等级 1-(1-9),2-(10-19),3-20以上",dataType = "Long"),
            @ApiImplicitParam(name = "siteId",value = "网站ID",dataType = "Long"),
            @ApiImplicitParam(name = "pTypeId",value = "父级分类ID（1-十大军工，2-论坛，3-高校）",dataType = "Long")
    })
    @GetMapping("/getSuspectData")
    public ResultModel getSuspectData(Long type,Long siteTypeId,Long secretLevel,Long siteId, Long pTypeId){
//        List<Basedata> list = baseDataService.getBaseDataByType(type);
//        List<Long> typeList = getUserSiteType();
        List<Long> typeList=new ArrayList<>();
        if(siteTypeId!=null){
            typeList.add(siteTypeId);
        }else{
            typeList = getSiteTypeIdsByPTypeId(pTypeId);
        }
        //确认信息
//        List<Map<String, Object>> list = baseDataService.getWarningData(1,100,Contant.KGJ_TID,3L,typeList);
//        疑似信息
//        List<Map<String, Object>> susList = baseDataService.getWarningData(1,100,Contant.KGJ_TID,type,typeList);
        List<Map<String, Object>> list = baseDataService.getWarningData(1, 100, Contant.KGJ_TID, type, secretLevel, typeList,siteId);
        return ResultModel.OK(list);
    }

    /**
     * 词云
     * @return 词云
     */
    @ApiOperation(value = "词云")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "siteTypeId",value = "网站分类",dataType = "Long"),
            @ApiImplicitParam(name = "pTypeId",value = "父级分类ID（1-十大军工，2-论坛，3-高校）",dataType = "Long")
    })
    @GetMapping("/wordCloud")
    public ResultModel wordCloud(Long siteTypeId, Long pTypeId){
//        List<Long> typeList = getUserSiteType();
        List<Long> typeList=new ArrayList<>();
        if(siteTypeId!=null){
            typeList.add(siteTypeId);
        }else{
            typeList = getSiteTypeIdsByPTypeId(pTypeId);
        }

        String s = typeList.toString();
        String string = redisTemplate.opsForValue().get(Contant.BIG_SCREEN_WORD_CLOUD_KEY+s);
        //1个小时的状态是否失效
        String flag = redisTemplate.opsForValue().get(Contant.BIG_SCREEN_WORD_CLOUD_KEY_FLAG+s);
        List<WordCloud> WordClouds = JSON.parseArray(string, WordCloud.class);

        if(StringUtils.isBlank(flag)){
            List<Long> finalTypeList = typeList;
            new Thread(() -> {
                List<WordCloud> resultList = baseDataService.analysisKeyWords(finalTypeList);

                redisTemplate.opsForValue().set(Contant.BIG_SCREEN_WORD_CLOUD_KEY+s,JSON.toJSONString(resultList));
                //有效时间1个小时
                redisTemplate.opsForValue().set(Contant.BIG_SCREEN_WORD_CLOUD_KEY_FLAG+s,"true",1,TimeUnit.MINUTES);
            }).start();

        }
        if (WordClouds!=null){
            return ResultModel.OK(WordClouds);
        }else{
            List<WordCloud> list = baseDataService.analysisKeyWords(typeList);
            return ResultModel.OK(list);
        }
    }

    /**
     * 词云更多
     * @param searchKey 搜索密点内容
     * @param typeId 分类ID
     * @return
     */
    @ApiOperation(value = "词云更多")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "searchKey",value = "密点内容",dataType = "String"),
            @ApiImplicitParam(name = "typeId",value = "密点类型",dataType = "String"),
            @ApiImplicitParam(name = "siteTypeId",value = "网站分类",dataType = "Long"),
            @ApiImplicitParam(name = "pTypeId",value = "父级分类ID（1-十大军工，2-论坛，3-高校）",dataType = "Long")
    })
    @GetMapping("/wordCloud/more")
    public ResultModel wordCloudMore(@RequestParam("searchKey") String searchKey,@RequestParam("typeId") String typeId,
                                     @RequestParam("siteTypeId") Long siteTypeId, Long pTypeId){
//        List<Long> typeList = getUserSiteType();
        List<Long> typeList=new ArrayList<>();
        if(siteTypeId!=null){
            typeList.add(siteTypeId);
        }else{
            typeList = getSiteTypeIdsByPTypeId(pTypeId);
        }

        String s = typeList.toString();
        String string = redisTemplate.opsForValue().get(Contant.BIG_SCREEN_WORD_CLOUD_MORE_KEY+s);
        //1个小时的状态是否失效
        String flag = redisTemplate.opsForValue().get(Contant.BIG_SCREEN_WORD_CLOUD_MORE_KEY_FLAG+s);
        List<WordCloud> WordClouds = JSON.parseArray(string, WordCloud.class);

        if(StringUtils.isBlank(flag)){
            List<Long> finalTypeList = typeList;
            new Thread(() -> {
                List<WordCloud> resultList = baseDataService.wordCloudMore(searchKey,typeId, finalTypeList);

                redisTemplate.opsForValue().set(Contant.BIG_SCREEN_WORD_CLOUD_MORE_KEY+s,JSON.toJSONString(resultList));
                //有效时间1个小时
                redisTemplate.opsForValue().set(Contant.BIG_SCREEN_WORD_CLOUD_MORE_KEY_FLAG+s,"true",1,TimeUnit.HOURS);
            }).start();

        }
        if (WordClouds!=null){
            return ResultModel.OK(WordClouds);
        }else{
            List<WordCloud> list = baseDataService.wordCloudMore(searchKey,typeId,typeList);
            return ResultModel.OK(list);
        }
    }
    /**
     * 地图
     * @return 地图
     */
//    @ApiOperation(value = "地图")
//    @GetMapping("/mapOld")
    public ResultModel mapOld(Long type){
        logger.info("地图数据");
        List<Long> typeList = getUserSiteType();
        List<Map<String, Object>> result = new ArrayList<>();
        long l = System.currentTimeMillis();
        System.out.println("地图开始调用数据库");
        //1.查询疑似信息
        List<Map<String, String>> list = baseDataService.getMapData(Contant.KGJ_TID,type);
        System.out.println("地图调用数据库结束"+(System.currentTimeMillis()-l));
        if(CollectionUtils.isNotEmpty(list)) {
            //2.通过网站管理，查询疑似信息所在区域
            Map<String, Integer> map = new HashMap<>();
            for (Map<String, String> baseDatamap : list) {
                //获取网址文章地址，并截取最域名
                if (StringUtils.isNotBlank(baseDatamap.get("sourceaddress"))) {
                    int i = StringUtils.ordinalIndexOf(baseDatamap.get("sourceaddress"), "/", 3);
                    String substring = baseDatamap.get("sourceaddress").substring(0, i);
                    if (map.containsKey(substring)) {
                        Integer integer = map.get(substring) + 1;
                        map.put(substring, integer);
                    } else {
                        map.put(substring, 1);
                    }
                }
            }
            //查询库中所有的网址
            List<CesSysWeb> cesSysWebList = cesSysWebService.list();
            Map<String, Integer> resultMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(cesSysWebList)) {
                for (CesSysWeb cesSysWeb : cesSysWebList) {
                    Integer integer = map.get(cesSysWeb.getUrl());
                    if (integer != null) {
                        if (resultMap.containsKey(cesSysWeb.getLocal())) {
                            Integer number = resultMap.get(cesSysWeb.getLocal());
                            resultMap.put(cesSysWeb.getLocal(), number+integer);
                        } else {
                            resultMap.put(cesSysWeb.getLocal(),integer );
                        }
//                        Map<String, Object> data = new HashMap<>();
//                        data.put("name", cesSysWeb.getLocal());
//                        data.put("value", map.get(cesSysWeb.getUrl()));
//                        result.add(data);
                    }
                }
            }
            for (Map.Entry<String, Integer> entry : resultMap.entrySet()) {
                Map<String, Object> data = new HashMap<>();
                data.put("name", entry.getKey());
                data.put("value", entry.getValue());
                result.add(data);
            }
        }

//            for (String s : map.keySet()) {
//                //调用数据库查询，网址所对应的地区
//                QueryWrapper<CesSysWeb> queryWrapper = new QueryWrapper();
//                queryWrapper.eq("url",s);
//                List<CesSysWeb> list1 = cesSysWebService.list(queryWrapper);
//                if(list1!=null && list1.size()>0){
//                    //因为数据库中，网址是唯一的
//                    CesSysWeb cesSysWeb = list1.get(0);
//                    Map<String,Object> data = new HashMap<>();
//                    data.put("name",cesSysWeb.getLocal());
//                    data.put("value",map.get(s));
//                    result.add(data);
//                }
//
//            }
//        }
        System.out.println("地图调用方法结束"+(System.currentTimeMillis()-l));
        return ResultModel.OK(result);
    }
    /**
     * 地图分等级
     * @param type 信息类型
     * @param secretLevel 密点等级
     * @return 地图
     */
    @ApiOperation(value = "地图")
    @GetMapping("/map")
    public ResultModel map(Long type,Long secretLevel,Long siteTypeId){
        logger.info("地图数据");

        List<Long> typeList = getUserSiteType();
//        List<Long> typeList=new ArrayList<>();
//        if(siteTypeId!=null){
//            typeList.add(siteTypeId);
//        }
        long l = System.currentTimeMillis();
        System.out.println("地图开始调用数据库");
        List<Map<String, String>> result = new ArrayList<>();
        if(type==null && secretLevel==null){
            //高风险
            List<Map<String, String>> mapData = baseDataService.getMapData(Contant.KGJ_TID,2L,3L, typeList);
            List<Map<String, String>> collect = mapData.stream().map(map -> {
                map.put("type", "3");
                map.put("level", "null");
                map.put("high", "3");
                return map;
            }).collect(Collectors.toList());
            //中风险
            List<Map<String, String>> midMapData = baseDataService.getMapData(Contant.KGJ_TID,2L,2L, typeList);
            List<Map<String, String>> collect1 = midMapData.stream().map(map -> {
                map.put("type", "2");
                map.put("level", "2");
                map.put("high", "2");
                return map;
            }).collect(Collectors.toList());
            //低风险
            List<Map<String, String>> lowMapData = baseDataService.getMapData(Contant.KGJ_TID,2L,1L, typeList);
            List<Map<String, String>> collect2 = lowMapData.stream().map(map -> {
                map.put("type", "2");
                map.put("level", "1");
                map.put("high", "1");
                return map;
            }).collect(Collectors.toList());
            result.addAll(collect);
            result.addAll(collect1);
            result.addAll(collect2);
        }else{
            List<Map<String, String>> mapData = baseDataService.getMapData(Contant.KGJ_TID,type,secretLevel, typeList);
            result.addAll(mapData);
        }
        System.out.println("地图调用方法结束"+(System.currentTimeMillis()-l));
        return ResultModel.OK(result);
    }

    /**
     * 获取当前登录用户关注的网站分类ID列表
     */
    public List<Long> getUserSiteType(){
        //获取当前登录用户
        LoginUser loginUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        List<Map<String, Object>> siteTypeList = userSiteTypeMidService.queryList(loginUser.getId());
        List<Long> result = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(siteTypeList)){
            for (Map<String, Object> map : siteTypeList) {
                if(map!=null && map.get("ID")!=null){
                    result.add(new Long(map.get("ID").toString()));
                }
            }
        }
        return result;
    }

    /**
     * 插入以前的数据到文章网站关联表
     * @return
     */
    @GetMapping("/web")
    public Result updateDataWeb() {
        //1.先查询已经存在的数据
        List<Basedata> basedataList = baseDataService.selectIds();
        List<BaseDataWebMid> baseDataWebList = new ArrayList<>();
        List<CesSysWeb> list = cesSysWebService.list();
        Map<String, String> webMap = list.stream().collect(Collectors.toMap(CesSysWeb::getUrl, CesSysWeb::getId, (k1, k2) -> k2));
        for (Basedata basedata : basedataList) {
            if (StringUtils.isNotBlank(basedata.getSourceaddress())) {
                int i = StringUtils.ordinalIndexOf(basedata.getSourceaddress(), "/", 3);
                String substring = basedata.getSourceaddress().substring(0, i);
                String webId = webMap.get(substring);
                if (StringUtils.isNotBlank(webId)) {
                    BaseDataWebMid baseDataWebMid = new BaseDataWebMid();
                    baseDataWebMid.setBId(new Long(basedata.getId()));
                    baseDataWebMid.setWebId(webId);
                    baseDataWebList.add(baseDataWebMid);
                }else{
                    System.out.println("不存在的网址"+basedata.getId()+basedata.getSourceaddress());
                }
            }
        }
        if(CollectionUtils.isNotEmpty(baseDataWebList)){
            System.out.println("需要插入的信息列表"+baseDataWebList.size());
            boolean b = baseDataWebMidService.saveBatch(baseDataWebList);
            if(!b){
                System.out.println("插入关联表失败！");
            }
        }
        return Result.ok("插入成功");
    }

    /**
     * 网站经纬度
     * @param typeId
     * @return
     */
    @ApiOperation(value = "网站经纬度")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "typeId" ,value = "网站类型ID",dataType = "Long"),
    })
    @GetMapping("webSites")
    public Result<?> getWebSites(Long typeId){
        List<CesSysWebVo> list = cesSysWebService.getWebSites(typeId);
        return Result.ok(list);
    }

    /**
     * 网站总数
     * @return
     */
    @ApiOperation(value = "网站总数")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "typeId" ,value = "网站类型ID",dataType = "Long"),
            @ApiImplicitParam(name = "pTypeId",value = "父级分类ID（1-十大军工，2-论坛，3-高校）",dataType = "Long")
    })
    @GetMapping("webSiteCount")
    public Result<?> getWebSiteCount(Long typeId,Long pTypeId){
        return Result.ok(cesSysWebService.getWebSiteCount(typeId,pTypeId));
    }

    /**
     * 十大军工分类
     * @return
     */
    @AutoLog(value = "网址分类表")
    @ApiOperation(value = "网址分类表", notes="网址分类表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pTypeId",value = "父级分类ID（1-十大军工，2-论坛，3-高校）",dataType = "Long")
    })
    @GetMapping(value = "/siteTypes")
    public Result<?> siteTypes(Long pTypeId) {
        //十大类型网站数
        List<SiteTypeVo> siteTypeList = siteTypeService.getSiteTypeList(pTypeId);
        if (null == siteTypeList) return Result.error("");

        ResultModel resultModel = suspectDataListbyTypeid(Contant.KGJ_TID, null,pTypeId);
        List <BaseDataVO> list = (List <BaseDataVO>) resultModel.getData();

        Map<Long,Long> countMap = list.stream().collect(Collectors.groupingBy(BaseDataVO::getSiteTypeId,Collectors.summingLong(BaseDataVO::getCount)));
        Map<Long,Long> suspectCountMap = list.stream().collect(Collectors.groupingBy(BaseDataVO::getSiteTypeId,Collectors.summingLong(BaseDataVO::getSuspectCount)));
        Map<Long,Long> confirmCountMap = list.stream().collect(Collectors.groupingBy(BaseDataVO::getSiteTypeId,Collectors.summingLong(BaseDataVO::getConfirmCount)));

        for (SiteTypeVo vo : siteTypeList) {
            Long typeId = vo.getSiteTypeId();
            if (countMap.containsKey(typeId)) vo.setCount(countMap.get(typeId));
            if (suspectCountMap.containsKey(typeId)) vo.setSuspectCount(suspectCountMap.get(typeId));
            if (confirmCountMap.containsKey(typeId)) vo.setConfirmCount(confirmCountMap.get(typeId));
        }

        return Result.ok(siteTypeList);
    }

    public ResultModel suspectDataListbyTypeid(Long tid, Long siteTypeId, Long pTypeId){
//        List<Long> typeList = getUserSiteType();//获取当前登录用户关注的网站分类ID列表
        List<Long> typeList=new ArrayList<>();
        if(siteTypeId!=null){
            typeList.add(siteTypeId);
        }else{
            typeList = getSiteTypeIdsByPTypeId(pTypeId);
        }

        String s = typeList.toString();
        String string = redisTemplate.opsForValue().get(Contant.DATA_BY_ORIGIN_KEY+s+1);
        //1个小时的状态是否失效
        String flag = redisTemplate.opsForValue().get(Contant.DATA_BY_ORIGIN_KEY_FLAG+s+2);
        List<BaseDataVO> baseDataVOS = JSON.parseArray(string, BaseDataVO.class);
//        List<BaseDataVO> baseDataVOS = null;
        if(StringUtils.isBlank(flag)){
            List<Long> finalTypeList = typeList;
            new Thread(() -> {
//                    List<String> origins = baseDataService.getOrigins(tid);
//                    ArrayList<BaseDataVO> resultList = new ArrayList<>();
//                    if (CollectionUtils.isNotEmpty(origins)){
//                        for (String origin :origins) {
//                            BaseDataVO dataByOrigin = baseDataService.getSuspectData(origin, type);
//                            resultList.add(dataByOrigin);
//                        }
//                    }
                List <BaseDataVO> resultList = baseDataService.getSuspectDataBytypeid(tid, finalTypeList);
                //按疑似数量升序
                resultList.sort(Comparator.comparing(BaseDataVO::getSuspectCount).reversed());
                redisTemplate.opsForValue().set(Contant.DATA_BY_ORIGIN_KEY+s+1,JSON.toJSONString(resultList));
                //有效时间1个小时
                redisTemplate.opsForValue().set(Contant.DATA_BY_ORIGIN_KEY_FLAG+s+1,"true",1,TimeUnit.MINUTES);
            }).start();

        }
        if (baseDataVOS!=null){
            return ResultModel.OK(baseDataVOS);
        }else{
//            List<String> origins = baseDataService.getOrigins(tid);
//            ArrayList<BaseDataVO> resultList = new ArrayList<>();
//            if (CollectionUtils.isNotEmpty(origins)){
//                for (String origin :origins) {
//                    BaseDataVO dataByOrigin = baseDataService.getSuspectData(origin, type);
//                    resultList.add(dataByOrigin);
//                }
//            }
            List <BaseDataVO> resultList = baseDataService.getSuspectDataNew(tid,typeList);
            //按疑似数量升序
            resultList.sort(Comparator.comparing(BaseDataVO::getSuspectCount).reversed());
//            redisTemplate.opsForValue().set(Contant.DATA_BY_ORIGIN_KEY,JSON.toJSONString(resultList));
//            //有效时间1个小时
//            redisTemplate.opsForValue().set(Contant.DATA_BY_ORIGIN_KEY_FLAG,"true",1,TimeUnit.HOURS);
            return ResultModel.OK(resultList);
        }
    }



    @ApiOperation(value = "获取饼图数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pTypeId",value = "父级分类ID（1-十大军工，2-论坛，3-高校）",dataType = "Long")
    })
    @GetMapping("piechatData")
    public Result<?> getPiechatData(Long pTypeId){
        ResultModel resultModel = suspectDataList(Contant.KGJ_TID, null,pTypeId);
        List <BaseDataVO> list = (List <BaseDataVO>) resultModel.getData();

        Map<String,Long> bySiteTypeSumCount = list.stream().collect(Collectors.groupingBy(BaseDataVO::getSiteTypeName,Collectors.summingLong(BaseDataVO::getCount)));
        return Result.ok(bySiteTypeSumCount);
    }

    @ApiOperation(value = "获取柱状图数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pTypeId",value = "父级分类ID（1-十大军工，2-论坛，3-高校）",dataType = "Long")
    })
    @GetMapping("histogramData")
    public Result<?> getHistogramData(Long pTypeId){
        ResultModel resultModel = suspectDataList(Contant.KGJ_TID, null,pTypeId);
        List <BaseDataVO> olist = (List <BaseDataVO>) resultModel.getData();
        olist.sort(Comparator.comparing(BaseDataVO::getCount).reversed());

        Map<String,Long> linkedHashMap = new LinkedHashMap<>();
        for (BaseDataVO vo : olist) {
            linkedHashMap.put(vo.getOrigin(),vo.getCount());
        }

        return Result.ok(linkedHashMap);
    }


    @ApiOperation(value = "获取公司关系图")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "name",value = "公司名称",dataType = "String")
    })
    @GetMapping("comRelationData")
    public Result getCompanyRelationData(String name){
        try {
            String url = Contant.RALATION_SERVICE_URL + "/tupu/rela/person2company/";
            Map<String, Object> paramMap = new HashMap<>();
            paramMap.put("_t", new Date().getTime());
            paramMap.put("name", name);

            String body = HttpUtil.get(url,paramMap);
            JSONObject jsonObject = JSON.parseObject(body, JSONObject.class);

            return Result.ok(jsonObject.get("response"));
        } catch (Exception e) {
            e.printStackTrace();
            return Result.error("");
        }
    }

    @ApiOperation(value = "获取股权关系图")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "name",value = "公司名称",dataType = "String")
    })
    @GetMapping("stockRightRelationData")
    public Result getStockRightRelationData(String name){
        try {
            String url = Contant.RALATION_SERVICE_URL + "/tupu/ZC/gxgraph/";
            Map<String, Object> paramMap = new HashMap<>();
            paramMap.put("_t", new Date().getTime());
            paramMap.put("name", name);

            String body = HttpUtil.get(url,paramMap);
            JSONObject jsonObject = JSONArray.parseObject(body, JSONObject.class);

            return Result.ok(jsonObject.get("response"));
        } catch (Exception e) {
            return Result.error("");
        }
    }

    @ApiOperation(value = "获取密点图谱数据")
    @GetMapping("miDianData")
    public Result getMiDianData(){
        try {
            String url = Contant.MIDIAN_SERVICE_URL + "/md/midian/";
            Map<String, Object> paramMap = new HashMap<>();
            paramMap.put("_t", new Date().getTime());

            String body = HttpUtil.get(url,paramMap);
            JSONObject jsonObject = JSONArray.parseObject(body, JSONObject.class);

            return Result.ok(jsonObject.getJSONObject("response"));
        } catch (Exception e) {
            return Result.error("");
        }
    }

}
