// 柱状图1模块//仪表盘
(function () {
  // 实例化对象
  var myChart = echarts.init(document.querySelector(".bar .chart"));
  // console.log(document.getElementById("chart"))
  // var myChart = echarts.init(document.getElementById("chart"));
  // 指定配置和数据
  var option = {
    "title": [
      {
        "text": "",
        "right": 0,
        "top": 10,
        "textStyle": {
          "color": "#b3b3b3",
          "fontSize": 12,
          "fontWeight": "normal"
        }
      },
      {
        "text": "",
        "bottom": "20px",
        "left": "center",
        "textStyle": {
          "color": "#b3b3b3",
          "fontSize": 12,
          "fontWeight": "normal"
        }
      }
    ],
    "grid": {
      "height": 200,
      "left": 0,
      "top": 0,
      "bottom": 0,
      "right": 0
    },
    "series": [
      {
        "name": "",
        "type": "gauge",
        "axisLine": {
          "lineStyle": {
            "color": [
              [
                0.2,
                "#5DD1FA"
              ],
              [
                1,
                "#f7f9fc"
              ]
            ],
            "width": 10
          }
        },
        "axisLabel": {
          "show": false
        },
        "axisTick": {
          "show": false
        },
        "splitLine": {
          "show": false
        },
        "itemStyle": {
          "show": false
        },
        "title": {
          "color": "#7f7f7f",
          "fontSize": 16,
          "fontWeight": "bolder"
        },
        "detail": {
          "offsetCenter": [
            0,
            0
          ],
          "textStyle": {
            "fontSize": "12",
            "fontWeight": "bolder",
            "color": "#ccc"
          }
        },
        "pointer": {
          "show": false
        },
        "data": [
          {
            // "name": "疑似",
            "value": 30
          }
        ]
      },
      {
        "title": {
          "color": "#7f7f7f",
          "fontSize": 13,
          "offsetCenter": [
            0,
            "40%"
          ]
        },
        "type": "gauge",
        "splitNumber": 0,
        "startAngle": 0,
        "endAngle": 0,
        "splitLine": {
          "show": false
        },
        "axisLabel": {
          "show": false
        },
        "pointer": {
          "show": false
        },
        "detail": {
          "show": false
        },
        "data": [
          {
            "name": "抓取条数"
          }
        ]
      }
    ]
  }
  // 把配置给实例对象
  myChart.setOption(option);
  window.addEventListener("resize", function () {
    myChart.resize();
  });

  // 数据变化
  var dataAll = [
    { year: "2019", data: [200, 300, 300, 900, 1500, 1200, 600] },
    { year: "2020", data: [300, 400, 350, 800, 1800, 1400, 700] }
  ];

  document.querySelector(".bar h2").addEventListener("click", function (e) {
    var i = e.target == this.children[0] ? 0 : 1;
    option.series[0].data = dataAll[i].data;
    myChart.setOption(option);
  });
})();

// 折线图定制//词云
(function () {
  // 基于准备好的dom，初始化echarts实例
  var myChart = echarts.init(document.querySelector(".line .chart"));

 var  wordCloud_option={
    left: 'left',
    top: 'top',
    tooltip: {
      textStyle: {
        color: '#FFF',
        fontSize:14
      }},
    series : [{
      type : 'wordCloud',
      shape:'smooth',
      drawOutOfBound: true,
      gridSize : 10,
      sizeRange : [ 5, 20 ],
      // sizeRange : [ 10, 200 ],
      rotationRange: [0, 0],
      textStyle : {
        normal : {
          color :function (d) {
            // Random color
            return 'rgba(0,153,255,'+(d.value/10)+ ')';
          }
        },
        emphasis : {
          shadowBlur : 10,
          shadowColor : '#333'
        }
      },
      data : [{name: "产业链", value: 18},
          {name: "基地", value: 16},
          {name: "邮轮", value: 14},
          {name: "核心技术", value: 20},
          {name: "船速", value: 14},
          {name: "产业链", value: 18},
          {name: "基地", value: 16},
          {name: "邮轮", value: 14},
          {name: "核心技术", value: 20},
          {name: "船速", value: 14}]
    }]
  };
  myChart.setOption(wordCloud_option);


  window.addEventListener("resize", function () {
    myChart.resize();
  });
})();

// 饼形图定制
// 第三个柱状图
(function () {
  // 基于准备好的dom，初始化echarts实例
  var myChart = echarts.init(document.querySelector(".pie .chart"));

  var option = {
    color: ["#06fcfb"],
    tooltip: {
      trigger: "axis",
      axisPointer: {
        // 坐标轴指示器，坐标轴触发有效
        type: "shadow" // 默认为直线，可选为：'line' | 'shadow'
      }
    },
    grid: {
      left: "0%",
      top: "10px",
      right: "0%",
      bottom: "4%",
      containLabel: true
    },
    xAxis: [
      {
        type: "category",
        data: [
          "2020-06",
          "2020-08",
          "2020-10",
          "2020-06",
          "2020-08",
          "2020-10",
        ],
        axisTick: {
          alignWithLabel: true
        },
        axisLabel: {
          textStyle: {
            color: "rgba(255,255,255,.6)",
            fontSize: "12"
          }
        },
        axisLine: {
          show: false
        }
      }
    ],
    yAxis: [
      {
        type: "value",
        axisLabel: {
          textStyle: {
            color: "rgba(255,255,255,.6)",
            fontSize: "12"
          }
        },
        axisLine: {
          lineStyle: {
            color: "rgba(255,255,255,.1)"
            // width: 1,
            // type: "solid"
          }
        },
        splitLine: {
          lineStyle: {
            color: "rgba(255,255,255,.1)"
          }
        }
      }
    ],
    series: [
      {
        name: "疑似",
        type: "bar",
        barWidth: "15%",
        data: [0.2,0.1,0.6,0.2,0.1,0.6],
        itemStyle: {
          barBorderRadius: 5
        }
      },
      {
        name: "确认",
        type: "bar",
        barWidth: "15%",
        data: [0.2,0.1,0.3,0.2,0.1,0.6],
        itemStyle: {
          barBorderRadius: 5
        }
      }
    ]
  };

  // 使用刚指定的配置项和数据显示图表。
  myChart.setOption(option);
  window.addEventListener("resize", function () {
    myChart.resize();
  });
})();
// 学习右侧信息模块



