package com.zzsn.modules.kgj.controller;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.zzsn.common.api.vo.Result;
import com.zzsn.common.aspect.annotation.AutoLog;
import com.zzsn.common.system.vo.LoginUser;
import com.zzsn.modules.kgj.common.Contant;
import com.zzsn.modules.kgj.common.ResultModel;
import com.zzsn.modules.kgj.entity.*;
import com.zzsn.modules.kgj.entity.VO.CesSysWebVo;
import com.zzsn.modules.kgj.entity.VO.SiteTypeVo;
import com.zzsn.modules.kgj.mapper.SubjectMapper;
import com.zzsn.modules.kgj.service.*;
import com.zzsn.modules.kgj.utils.Pager;
import com.zzsn.modules.kgj.utils.TimeUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @author
 * @description: 专题数据
 * @date 2020/9/28 9:09
 */
@Api(tags = "科工局专题数据")
@RestController
@RequestMapping("/analysis")
public class SubjectController {

    private Logger logger = LoggerFactory.getLogger(SubjectController.class);
    @Autowired
    private SubjectService subjectService;

    @Autowired
    private SubjectMapper subjectMapper;

    /**
     * 专题列表
     * 查询所有的专题
     * @return 数据
     */
    @ApiOperation(value = "专题列表")
    @GetMapping("/list")
    public ResultModel subjectList(){
        QueryWrapper<Subject> queryWrapper = new QueryWrapper<Subject>();
        queryWrapper.select("id", "title");
        List<Subject> subjects = subjectMapper.selectList(queryWrapper);

        return ResultModel.OK(subjects);
    }
    /**
     * 新增专题
     * 查询所有的专题
     * @return 数据
     */
    @ApiOperation(value = "新增专题")
    @GetMapping("/saveSubject")
    public ResultModel saveSubject(@RequestParam("subjectName") String subjectName){
        Subject subject = new Subject();

//        subject.setId(subjectid);
        subject.setTitle(subjectName);

        subjectService.save(subject);
        String save="新增专题成功";
        return ResultModel.OK(save);
    }
    /**
     * 专题动态
     * 查询专题动态
     * @return 数据
     */
    @ApiOperation(value = "专题动态")
    @GetMapping("/sujectDy")
    public String sujectDy(@RequestParam("id") String id){
        String  subjectdy="";
        if(StringUtils.isNotEmpty(id)) {
            QueryWrapper<Subject> queryWrapper = new QueryWrapper<Subject>();
            queryWrapper.select("suject_dy").eq("id", id);
            Subject subject = subjectMapper.selectOne(queryWrapper);
            subjectdy=subject.getSujectDy();
        }
//        JSONObject data = JSONObject.parseObject(subjectdy);//获取jsonobject对象
//        subjectdy = data.getString("result");
//        subjectdy=subjectdy.replace("\\","");
        return subjectdy;
//        return ResultModel.OK(subjectdy);
    }
    /**
     * 观点分析
     * 查询专题动态
     * @return 数据
     */
    @ApiOperation(value = "观点分析")
    @GetMapping("/viewPointAnalysis")
    public String viewPointAnalysis(@RequestParam("id") String id){
        String  pointAnalysis="";
        if(StringUtils.isNotEmpty(id)) {
            QueryWrapper<Subject> queryWrapper = new QueryWrapper<Subject>();
            queryWrapper.select("point_analysis").eq("id", id);
            Subject subject = subjectMapper.selectOne(queryWrapper);
            pointAnalysis=subject.getPointAnalysis();
        }
//        JSONObject data = JSONObject.parseObject(pointAnalysis);//获取jsonobject对象
//        pointAnalysis = data.getString("result");
//        pointAnalysis=pointAnalysis.replace("\\","");
        return pointAnalysis;
//        return ResultModel.OK(pointAnalysis);
    }


    /**
     * 事件脉络
     * 查询专题动态
     * @return 数据
     */
    @ApiOperation(value = "事件脉络")
    @GetMapping("/eventContext")
    public String eventContext(@RequestParam("id") String id){
        String  eventContext="";
        if(StringUtils.isNotEmpty(id)) {
            QueryWrapper<Subject> queryWrapper = new QueryWrapper<Subject>();
            queryWrapper.select("event_context").eq("id", id);
            Subject subject = subjectMapper.selectOne(queryWrapper);
            eventContext=subject.getEventContext();
        }
//        JSONObject data = JSONObject.parseObject(eventContext);//获取jsonobject对象
//        eventContext = data.getString("result");
//        eventContext=eventContext.replace("\\","");
        return eventContext;
//        return ResultModel.OK(eventContext);
    }
    /**
     * 传播路径
     * 查询专题动态
     * @return 数据
     */
    @ApiOperation(value = "传播路径")
    @GetMapping("/propagationPath")
    public String propagationPath(@RequestParam("id") String id){
        String  propagationPath="";
        if(StringUtils.isNotEmpty(id)) {
            QueryWrapper<Subject> queryWrapper = new QueryWrapper<Subject>();
            queryWrapper.select("propagation_path").eq("id", id);
            Subject subject = subjectMapper.selectOne(queryWrapper);
            propagationPath=subject.getPropagationPath();
        }
//        JSONObject data = JSONObject.parseObject(propagationPath);//获取jsonobject对象
//        propagationPath = data.getString("result");
//        propagationPath=propagationPath.replace("\\","");
        return propagationPath;
//        return ResultModel.OK(propagationPath);
    }
    /**
     * 统计分析
     * 查询专题动态
     * @return 数据
     */
    @ApiOperation(value = "统计分析")
    @GetMapping("/statisticAnalysis")
    public String statisticAnalysis(@RequestParam("id") String id){
        String  statisticAnalysis="";
        if(StringUtils.isNotEmpty(id)) {
            QueryWrapper<Subject> queryWrapper = new QueryWrapper<Subject>();
            queryWrapper.select("statistic_analysis").eq("id", id);
            Subject subject = subjectMapper.selectOne(queryWrapper);
            statisticAnalysis=subject.getStatisticAnalysis();
        }
//        JSONObject data = JSONObject.parseObject(statisticAnalysis);//获取jsonobject对象
//        statisticAnalysis = data.getString("result");
//        statisticAnalysis=statisticAnalysis.replace("\\","");
        return statisticAnalysis;
//        return ResultModel.OK(statisticAnalysis);
    }

}
