package com.zzsn.modules.kgj.controller;

import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.zzsn.common.api.vo.Result;

import com.zzsn.common.system.vo.LoginUser;
import com.zzsn.modules.kgj.common.Contant;
import com.zzsn.modules.kgj.entity.*;
import com.zzsn.modules.kgj.mapper.BaseDataImageMapper;
import com.zzsn.modules.kgj.mapper.BaseDataMapper;
import com.zzsn.modules.kgj.mapper.BaseDataTypeMapper;
import com.zzsn.modules.kgj.mapper.CisAnsBasedataMapper;
import com.zzsn.modules.kgj.service.BaseDataService;
import com.zzsn.modules.kgj.service.ICesSysSecretService;
import com.zzsn.modules.kgj.service.ICisAnsBasedataService;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.modules.kgj.service.IUserSiteTypeMidService;
import com.zzsn.modules.kgj.utils.*;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import lombok.extern.slf4j.Slf4j;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import com.zzsn.common.system.base.controller.JeecgController;
import org.apache.shiro.SecurityUtils;
import org.jsoup.Jsoup;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.DigestUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.ModelAndView;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @Description: CIS_ANS_BASEDATA
 * @Author: zzsn-boot
 * @Date:   2020-08-26
 * @Version: V1.0
 */
@Api(tags="科工局 CIS_ANS_BASEDATA")
@RestController
@RequestMapping("/kgj/cisAnsBasedata")
@Slf4j
public class CisAnsBasedataController extends JeecgController<CisAnsBasedata, ICisAnsBasedataService> {

	@Autowired
	private ICisAnsBasedataService cisAnsBasedataService;
	@Autowired
	private CisAnsBasedataMapper cisAnsBasedataMapper;
	@Value("${file.imgPath}")
	private String fileImgPath;
	@Value("${tupu.secretkrul}")
	private String secretkrul;
	@Value("${tupu.graphkrul}")
	private String graphkrul;
	@Autowired
	private BaseDataMapper baseDataMapper;
	@Autowired
	private BaseDataTypeMapper baseDataTypeMapper;

	@Autowired
	private EsOpUtil esOpUtil;
	@Autowired
	private BaseDataService baseDataService;
	@Autowired
	private IUserSiteTypeMidService userSiteTypeMidService;

	@Autowired
	private BaseDataImageMapper imageMapper;
	@Autowired
	private ICesSysSecretService secretService;
	@Autowired
	private RestTemplate restTemplate;
	/**
	 * 分页列表查询
	 *
	 * @param cisAnsBasedata
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "CIS_ANS_BASEDATA-分页查询1")
	@ApiOperation(value = "CIS_ANS_BASEDATA-分页查询", notes="CIS_ANS_BASEDATA-根据参数传入的sysUser对象和分页控制参数，对数据进行数据库查询后，封装成page分页对象并返回")
	@GetMapping(value = "")
	public Result<?> queryPageList( CisAnsBasedata cisAnsBasedata,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		Long flag = 0L;
		if(StringUtils.isNotBlank(req.getParameter("delFlag"))){
			flag = new Long(req.getParameter("delFlag"));
		}

		List<Long> webTypeList = getUserSiteType();
		//网站ID
		Long siteId = null;
		if (StringUtils.isNotBlank(req.getParameter("siteId"))) {
			siteId = new Long(req.getParameter("siteId"));
			webTypeList = null;//当用网站ID作为参数时，网站类型webTypeList设为null
		}

		//当关键字不为空时候，走es搜索，否则走数据库查询
		if (cisAnsBasedata != null && !StringUtils.isBlank(cisAnsBasedata.getTitle())) {
			BaseDataDto baseDataDto = new BaseDataDto();
			baseDataDto.setSearchKey(req.getParameter("title"));
			baseDataDto.setPublishStartTime(req.getParameter("publishDate_begin"));
			baseDataDto.setPublishEndTime(req.getParameter("publishDate_end"));
			baseDataDto.setDelflag(flag);
			baseDataDto.setPageNum(pageNo);
			baseDataDto.setPageSize(pageSize);
			baseDataDto.setSiteId(siteId);
			log.info("信息列表查询入参：{}", baseDataDto);
			long startTime = System.currentTimeMillis();
			System.out.println("开始时间:" + startTime);
			Page<CisAnsBasedata> result = cisAnsBasedataService.findEsByKey(baseDataDto,webTypeList);
			long endTime = System.currentTimeMillis();
			System.out.println("结束时间:" + startTime);
			System.out.println("耗时：" + (endTime - startTime));
			return Result.ok(result);
		}

		CisAnsBasedata cisAnsBasedata1=new CisAnsBasedata();
		if (StringUtils.isNotBlank(req.getParameter("siteId"))) {
			webTypeList = null;//当用网站ID作为参数时，网站类型webTypeList设为null
		}

		Page<CisAnsBasedata> page = new Page<>(pageNo, pageSize);
		int offset = (pageNo-1)*pageSize;
		String publishdate_start=req.getParameter("publishDate_begin");
		if(StringUtils.isEmpty(publishdate_start)){

			publishdate_start="2012-04-12 15:57:40";
		}
		List<CisAnsBasedata> listBasedata=null;
		int  cont=0;
		String title = req.getParameter("title");
		if(cisAnsBasedata != null && !StringUtils.isBlank(cisAnsBasedata.getTitle())) {
			title="%"+title+"%";
			listBasedata = cisAnsBasedataMapper.getCisAnsBasedataList3(publishdate_start
					, req.getParameter("publishDate_end"), offset, offset + pageSize, flag, webTypeList, siteId, title);
			cont = cisAnsBasedataMapper.getCisAnsBasedataCount3(req.getParameter("publishDate_begin")
					,req.getParameter("publishDate_end"), offset ,offset+pageSize,flag,webTypeList,siteId,title);
		}else {
			listBasedata = cisAnsBasedataMapper.getCisAnsBasedataList2(publishdate_start
					, req.getParameter("publishDate_end"), offset, offset + pageSize, flag, webTypeList, siteId);
			cont = cisAnsBasedataMapper.getCisAnsBasedataCount2(req.getParameter("publishDate_begin")
					,req.getParameter("publishDate_end"), offset ,offset+pageSize,flag,webTypeList,siteId
			);
		}
		//把内容中的图片进行处理,加ip和端口，直接访问文件
	//		List<CisAnsBasedata> collect = listBasedata.stream().map(baseData -> {
	//			Map<String, Object> contentFileTag = ContentFileFinder.getContentAllFileTag(baseData.getContentString(),"img");
	//			if (contentFileTag == null || contentFileTag.size() < 1) {
	//				return baseData;
	//			}
	//			//遍历map
	//			contentFileTag.forEach((key, value) -> {
	//				String newTag = HtmlUtils.appendHtmlTag(key, "img", "src", "src=\"" + FileAccessConstant.REAL_PATH, "\"");
	//				log.info("替换[{}]为[{}]",key,newTag);
	//				baseData.setContent(baseData.getContentString().replaceAll(key,newTag).getBytes());
	//			});
	//			return baseData;
	//		}).collect(Collectors.toList());

		page.setTotal(cont);
		page.setRecords(listBasedata);
		return Result.ok(page);
	}

	/**
	 *
	 * @return
	 */
	@ApiOperation(value = "CIS_ANS_BASEDATA-图谱", notes="CIS_ANS_BASEDATA-图谱")
	@PostMapping(value = "/tupu")
	public Result<?> getTupu(CisAnsBasedata cisAnsBasedata,HttpServletRequest req){
		HttpHeaders headers = new HttpHeaders();
		headers.setContentType(MediaType.APPLICATION_JSON);
		String title=cisAnsBasedata.getTitle();
		String content=cisAnsBasedata.getContentString();
		String parmas = "{ \"title\": \""+title+"\",\"text\": \""+content+"\"}";
		HttpEntity<String> request = new HttpEntity<>(parmas, headers);
		//把文章和内容传到图谱比对接口
		String body="";
		try {
			ResponseEntity<String> response = restTemplate.postForEntity( graphkrul, request , String.class );
			 body = response.getBody();

		} catch (NumberFormatException e) {
			System.out.println("密点网络请求异常");
//			e.printStackTrace();
		}


		return Result.ok(body);
	}

	/**
	 * 参数，标题，内容，密点数据，tag 模型标签
	 * @return
	 */
	@ApiOperation(value = "文章敏感度得分", notes="文章敏感度得分")
	@PostMapping(value = "/msgSecret")
	public Result<?> getMsgSecret(@RequestBody CisAnsBasedata cisAnsBasedata,HttpServletRequest req){
		Long re=0L;
        Double dd=new Double(0);
		HttpHeaders headers = new HttpHeaders();
		headers.setContentType(MediaType.APPLICATION_JSON);
		String title=cisAnsBasedata.getTitle();
		byte[] content=cisAnsBasedata.getContent();
		String text = new String(content,StandardCharsets.UTF_8);
		text = Jsoup.parse(text).text();

		String tag="0";
		StringBuilder ssb=new StringBuilder();
		ssb.append("{");
		//查询所有的密点
		QueryWrapper<CesSysSecret> wrapper = new QueryWrapper<>();
		//关键字
		wrapper.eq("type",0);
		List<CesSysSecret> secretList = secretService.list(wrapper);
		for (int i = 0; i < secretList.size(); i++) {
			if(i<secretList.size()-1) {
				String sm = "\""+secretList.get(i).getContent() + "\":" + secretList.get(i).getSecretLevel() + ",";
				ssb.append(sm);
			}else{
				String sm = "\""+secretList.get(i).getContent() + "\":"+ secretList.get(i).getSecretLevel() ;
				ssb.append(sm);
			}
		}
		ssb.append("}");
		String secretMap=ssb.toString();
//		String parmas = "{ \"title\": \""+title+"\",\"text\": \""+text+"\",\"secretMap\":"+secretMap+"}";

		String parmas = "{ \"title\": \""+title+"\",\"text\": \""+content+"\",\"secretMap\":" +secretMap +",\"tag\":\""+tag+"\"}";

		HttpEntity<String> request = new HttpEntity<>(parmas, headers);
		//把文章和内容传到图谱比对接口
		try {
			ResponseEntity<String> response = restTemplate.postForEntity( secretkrul, request , String.class );
			String body = response.getBody();
			JSONObject ob= JSON.parseObject(body);
			System.out.println("body:"+body);
			body=  ob.getString("response");
			Double ddd=Double.parseDouble(body);
			 dd=ddd;
//			System.out.println("密点敏感值："+dd);
//			if(dd.longValue()<5L){
//				Result.ok("0");
//			}
//			//前台计算是大于9小于20为中
//			if(dd.longValue()>=5L&& dd.longValue()<8L){
//				re=dd.longValue()+11;
//			}
//			//大于20为高
//			if(ddd.longValue()>=8L){
//				re=dd.longValue()+13;
//			}
			//re=Long.parseLong(body);
		} catch (NumberFormatException e) {
			System.out.println("密点网络请求异常");
//			e.printStackTrace();
		}


		return Result.ok(dd+"");
	}


	@ApiOperation(value = "CIS_ANS_BASEDATA-审核分页查询", notes="CIS_ANS_BASEDATA-根据参数传入的sysUser对象和分页控制参数，对数据进行数据库查询后，封装成page分页对象并返回")
	@GetMapping(value = "/shenhe")
	public Result<?> queryShenhePageList( CisAnsBasedata cisAnsBasedata,
									@RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
									@RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
									HttpServletRequest req) {
		Long flag = 0L;
		if(StringUtils.isNotBlank(req.getParameter("delFlag"))){
			flag = new Long(req.getParameter("delFlag"));
		}
		Long min = 0L;
		if(StringUtils.isNotBlank(req.getParameter("min"))){
			min = new Long(req.getParameter("min"));
		}

		Long max = 0L;
		if(StringUtils.isNotBlank(req.getParameter("max"))){
			max = new Long(req.getParameter("max"));
		}



		List<Long> webTypeList = getUserSiteType();
		//网站ID
		Long siteId = null;
		if (StringUtils.isNotBlank(req.getParameter("siteId"))) {
			siteId = new Long(req.getParameter("siteId"));
			webTypeList = null;//当用网站ID作为参数时，网站类型webTypeList设为null
		}

		//当关键字不为空时候，走es搜索，否则走数据库查询
		if (cisAnsBasedata != null && !StringUtils.isBlank(cisAnsBasedata.getTitle())) {
			BaseDataDto baseDataDto = new BaseDataDto();
			baseDataDto.setSearchKey(req.getParameter("title"));
			baseDataDto.setPublishStartTime(req.getParameter("publishDate_begin"));
			baseDataDto.setPublishEndTime(req.getParameter("publishDate_end"));
			baseDataDto.setDelflag(flag);
			baseDataDto.setPageNum(pageNo);
			baseDataDto.setPageSize(pageSize);
			baseDataDto.setSiteId(siteId);
			baseDataDto.setMin(min.intValue());
			baseDataDto.setMax(max.intValue());
			log.info("信息列表查询入参：{}", baseDataDto);
			long startTime = System.currentTimeMillis();
			System.out.println("开始时间:" + startTime);
			Page<CisAnsBasedata> result = cisAnsBasedataService.findEsByKey(baseDataDto,webTypeList);
			long endTime = System.currentTimeMillis();
			System.out.println("结束时间:" + startTime);
			System.out.println("耗时：" + (endTime - startTime));
			return Result.ok(result);
		}

		if (StringUtils.isNotBlank(req.getParameter("siteId"))) {
			webTypeList = null;//当用网站ID作为参数时，网站类型webTypeList设为null
		}

		Page<CisAnsBasedata> page = new Page<>(pageNo, pageSize);
		int offset = (pageNo-1)*pageSize;
		String publishdate_start=req.getParameter("publishDate_begin");
		if(StringUtils.isEmpty(publishdate_start)){

			publishdate_start="2012-04-12 15:57:40";
		}
		String title="";
		if (cisAnsBasedata != null && !StringUtils.isBlank(cisAnsBasedata.getTitle())) {
			title = req.getParameter("title");
			title="%"+title+"%";
		}
		List<CisAnsBasedata> listBasedata = cisAnsBasedataMapper.getCisAnsBasedataListByscore(publishdate_start
				,req.getParameter("publishDate_end"), offset ,offset+pageSize,min,max,webTypeList,siteId,title,flag);
		//把内容中的图片进行处理,加ip和端口，直接访问文件
		//		List<CisAnsBasedata> collect = listBasedata.stream().map(baseData -> {
		//			Map<String, Object> contentFileTag = ContentFileFinder.getContentAllFileTag(baseData.getContentString(),"img");
		//			if (contentFileTag == null || contentFileTag.size() < 1) {
		//				return baseData;
		//			}
		//			//遍历map
		//			contentFileTag.forEach((key, value) -> {
		//				String newTag = HtmlUtils.appendHtmlTag(key, "img", "src", "src=\"" + FileAccessConstant.REAL_PATH, "\"");
		//				log.info("替换[{}]为[{}]",key,newTag);
		//				baseData.setContent(baseData.getContentString().replaceAll(key,newTag).getBytes());
		//			});
		//			return baseData;
		//		}).collect(Collectors.toList());
		int  cont = cisAnsBasedataMapper.getCisAnsBasedataCountByscore(publishdate_start
				,req.getParameter("publishDate_end"), offset ,offset+pageSize,min,max,webTypeList,siteId ,title,flag);
		page.setTotal(cont);
		page.setRecords(listBasedata);
		return Result.ok(page);
	}
	/**
	 * 分页列表查询
	 *
	 * @param
	 * @return
	 */
	//@AutoLog(value = "CIS_ANS_BASEDATA-分页查询1")
	@ApiOperation(value = "CIS_ANS_BASEDATA-分页查询", notes="CIS_ANS_BASEDATA-根据参数传入的sysUser对象和分页控制参数，对数据进行数据库查询后，封装成page分页对象并返回")
	@GetMapping(value = "/list1")
	public Result<?> queryPageListDataBase(CisAnsBasedata cisAnsBasedata,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="2") Integer pageSize,
								   HttpServletRequest req) {
		Page<CisAnsBasedata> page = new Page<CisAnsBasedata>(pageNo, pageSize);
		int offset = (pageNo-1)*pageSize;
		List<CisAnsBasedata> listBasedata = cisAnsBasedataMapper.getCisAnsBasedataList(req.getParameter("publishDate_begin")
				,req.getParameter("publishDate_end"), offset ,offset+pageSize
		);
		int  cont = cisAnsBasedataMapper.getCisAnsBasedataCount(req.getParameter("publishDate_begin")
				,req.getParameter("publishDate_end"), offset ,offset+pageSize
		);
		page.setTotal(cont);
		page.setRecords(listBasedata);
		return Result.ok(page);
	}
//	@ApiOperation(value = "CIS_ANS_BASEDATA-分页查询", notes="CIS_ANS_BASEDATA-根据参数传入的sysUser对象和分页控制参数，对数据进行数据库查询后，封装成page分页对象并返回")
//	@GetMapping(value = "/list2")
//	public Result<?> queryPageListDataBase2(CisAnsBasedata cisAnsBasedata,
//										   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
//										   @RequestParam(name="pageSize", defaultValue="2") Integer pageSize,
//										   HttpServletRequest req) {
//		Page<CisAnsBasedata> page = new Page<CisAnsBasedata>(pageNo, pageSize);
//		int offset = (pageNo-1)*pageSize;
//		List<CisAnsBasedata> listBasedata = cisAnsBasedataMapper.getCisAnsBasedataList2(req.getParameter("publishDate_begin")
//				,req.getParameter("publishDate_end"), offset ,offset+pageSize,
//				new Long(req.getParameter("delFlag")));
//		//把内容中的图片进行处理,加ip和端口，直接访问文件
////		List<CisAnsBasedata> collect = listBasedata.stream().map(baseData -> {
////			Map<String, Object> contentFileTag = ContentFileFinder.getContentAllFileTag(baseData.getContentString(),"img");
////			if (contentFileTag == null || contentFileTag.size() < 1) {
////				return baseData;
////			}
////			//遍历map
////			contentFileTag.forEach((key, value) -> {
////				String newTag = HtmlUtils.appendHtmlTag(key, "img", "src", "src=\"" + FileAccessConstant.REAL_PATH, "\"");
////				log.info("替换[{}]为[{}]",key,newTag);
////				baseData.setContent(baseData.getContentString().replaceAll(key,newTag).getBytes());
////			});
////			return baseData;
////		}).collect(Collectors.toList());
//		int  cont = cisAnsBasedataMapper.getCisAnsBasedataCount2(req.getParameter("publishDate_begin")
//				,req.getParameter("publishDate_end"), offset ,offset+pageSize
//		);
//		page.setTotal(cont);
//		page.setRecords(listBasedata);
//		return Result.ok(page);
//	}

	/**
	 *   添加
	 *
	 * @param cisAnsBasedata
	 * @return
	 */
	//@AutoLog(value = "CIS_ANS_BASEDATA-添加")
	@ApiOperation(value="CIS_ANS_BASEDATA-添加", notes="CIS_ANS_BASEDATA-通过参数传入json格式sysUser对象，在数据库中生成一条新的数据")
	@PostMapping(value = "")
	public Result<?> add(@RequestBody CisAnsBasedata cisAnsBasedata) {
		//生成bid
		Long getserialno = baseDataService.getserialno();
		System.out.println(getserialno);
		cisAnsBasedata.setId(getserialno);
		//富文本编辑器转换JSOUP
		String content=Jsoup.parse(cisAnsBasedata.getContentStringTwo()).outerHtml();
		cisAnsBasedata.setContentString(content);
		//contentnotag字段
		String text = Jsoup.parse(cisAnsBasedata.getContentStringTwo()).text();
		cisAnsBasedata.setContentNoTagString(text);
		//图片处理
		Map<String, FileTag> contentFileTag = null;
		List<BaseDataImage> imageList =new ArrayList<>();
		String nowdate=DateUtil.getCreateDate();
		contentFileTag = ContentFileFinder.getContentFileTag(cisAnsBasedata.getContentStringTwo(),cisAnsBasedata.getSourceaddress());
		if(CollectionUtils.isNotEmpty(contentFileTag)){
			//遍历map
			contentFileTag.forEach((key,value)->{
				//使用MD5加密：ID+图片的原网址
				try {
					String md5 = DigestUtils.md5DigestAsHex((cisAnsBasedata.getId() + value.getAbsolutePath()).getBytes(StandardCharsets.UTF_8));
					String newImg="<img style=\"width: 600px;\" src=\"/adminser/image/base/"+md5+"\" />";
					//压缩图片到50k转base64保存到数据库
					String imgUrlToBase64 = ImgBaseUtil.compressPicForScale(value.getAbsolutePath(),50,cisAnsBasedata.getId()+key);
					BaseDataImage baseDataImage = new BaseDataImage();
					baseDataImage.setId(md5);
					baseDataImage.setDataImage(imgUrlToBase64);
					baseDataImage.setBid(cisAnsBasedata.getId().toString());
					imageList.add(baseDataImage);
					cisAnsBasedata.setContentString(cisAnsBasedata.getContentStringTwo().replace(key,newImg));
				} catch (Exception e) {
					System.out.println("图片转换出错");
				}
			});
		}
		//图片不为空，插入图片
		if(CollectionUtils.isNotEmpty(imageList)){
			//先查询数据库中是否存在一些数据
			Map<String, BaseDataImage> map = imageList.stream().collect(Collectors.toMap(BaseDataImage::getId, baseDataImage -> baseDataImage, (k1, k2) -> k2));
			if(map!=null){
				Set<String> keySet = map.keySet();
				if(keySet!=null && keySet.size()>0){
					List<BaseDataImage> repeatList = imageMapper.selectByIds(new ArrayList<>(keySet));
					if(repeatList!=null && repeatList.size()>0){
						//剔除数据库中已经存在的数据
						for (BaseDataImage baseDataImage : repeatList) {
							map.remove(baseDataImage.getId());
							keySet.remove(baseDataImage.getId());
						}
					}
					List<BaseDataImage> images = new ArrayList<>();
					for (String s : keySet) {
						BaseDataImage baseDataImage = map.get(s);
						if(baseDataImage!=null){
							images.add(baseDataImage);
						}
					}
					if(images !=null && images.size()>0){
						//插入的数据不为空时候换，插入数据库
						int i = imageMapper.insertList(images);
						if(i<1){
							throw new RuntimeException("插入科工局baseImage表失败");
						}
					}
				}
			}
		}
		//插入basedata表中
		cisAnsBasedata.setCreateDate(nowdate);
		cisAnsBasedataService.save(cisAnsBasedata);
		BasedataType basedataType = new BasedataType();
		basedataType.setBid(getserialno);
		basedataType.setOrgId(3942L);
		basedataType.setTid(Contant.KGJ_TID);
		basedataType.setCreateDate(nowdate);
		basedataType.setPublishDate(cisAnsBasedata.getPublishDate());
		//插入到basedataType表中
		baseDataTypeMapper.save(basedataType);
		//同步到es
		Basedata basedata = baseDataMapper.queryById(cisAnsBasedata.getId());
		basedata.setContent(null);
		basedata.setFeaturewords(null);
		basedata.setContentNoTag(text);
		basedata.setPublishDate(EsDateUtil.esFieldDateFormat(basedata.getPublishDate()));
		basedata.setCreateDate(EsDateUtil.esFieldDateFormat(basedata.getCreateDate()));
		esOpUtil.docSavaByEntity("kgj", String.valueOf(cisAnsBasedata.getId()), basedata);

		return Result.ok("添加成功！");
	}
	/**
	 *  点击审核按钮
	 *
	 * @param cisAnsBasedata
	 * @return
	 */
	//@AutoLog(value = "CIS_ANS_BASEDATA-编辑")
	@ApiOperation(value="CIS_ANS_BASEDATA-点击审核", notes="CIS_ANS_BASEDATA-点击审核")
	@PostMapping(value = "/click/check")
	public Result<?> clickCheck(@RequestBody CisAnsBasedata cisAnsBasedata) {
		Validate.notNull(cisAnsBasedata.getId(),"ID为空");

		//编辑保存
		cisAnsBasedataService.clickCheck(cisAnsBasedata);
		return Result.ok("审核已经查看成功!");
	}
	/**
	 *  编辑-确定保存
	 *
	 * @param cisAnsBasedata
	 * @return
	 */
	//@AutoLog(value = "CIS_ANS_BASEDATA-编辑")
	@ApiOperation(value="CIS_ANS_BASEDATA-编辑", notes="CIS_ANS_BASEDATA-编辑")
	@PutMapping(value = "")
	public Result<?> edit(@RequestBody CisAnsBasedata cisAnsBasedata) {
		Validate.notNull(cisAnsBasedata.getId(),"ID为空");
		//		'审核状态：1：未查看，2：已查看，3：已修改，4：已确认'
		cisAnsBasedata.setLocale("3");
		//编辑保存
		cisAnsBasedataService.edit(cisAnsBasedata,null);
		return Result.ok("编辑成功!");
	}
	/**
	 *  编辑-涉密确定保存
	 *
	 * @param cisAnsBasedata
	 * @return
	 */
	@ApiOperation(value="CIS_ANS_BASEDATA-涉密确定保存", notes="CIS_ANS_BASEDATA-涉密确定保存")
	@PostMapping(value = "/confirm")
	public Result<?> confirm(@RequestBody CisAnsBasedata cisAnsBasedata) {
		Validate.notNull(cisAnsBasedata.getId(),"ID为空");
//		'审核状态：1：未查看，2：已查看，3：已修改，4：已确认'
		cisAnsBasedata.setLocale("4");
		//确认
		cisAnsBasedataService.edit(cisAnsBasedata,3L);
		return Result.ok("涉密信息确认成功!");
	}
	/**
	 *  编辑-涉密确定保存
	 *
	 * @param cisAnsBasedata
	 * @return
	 */
	@ApiOperation(value="CIS_ANS_BASEDATA-非密修改", notes="CIS_ANS_BASEDATA-非密修改")
	@PostMapping(value = "/confirmno")
	public Result<?> confirmno(@RequestBody CisAnsBasedata cisAnsBasedata) {
		Validate.notNull(cisAnsBasedata.getId(),"ID为空");
//		'审核状态：1：未查看，2：已查看，3：已修改，4：已确认'
		cisAnsBasedata.setLocale("2");
		//非密设置为 1
		cisAnsBasedataService.edit(cisAnsBasedata,1l);
		return Result.ok("非密信息确认成功!");
	}
	/**
	 *  编辑-删除保存，更改flag状态为0
	 *
	 * @param cisAnsBasedata
	 * @return
	 */
	@ApiOperation(value="CIS_ANS_BASEDATA-删除保存，更改flag状态为0", notes="CIS_ANS_BASEDATA-删除保存，更改flag状态为0")
	@PostMapping(value = "/check/delete")
	public Result<?> checkDelete(@RequestBody CisAnsBasedata cisAnsBasedata) {
		Validate.notNull(cisAnsBasedata.getId(),"ID为空");
		//		'审核状态：1：未查看，2：已查看，3：已修改，4：已确认'
		cisAnsBasedata.setLocale("2");
		//删除
		cisAnsBasedataService.edit(cisAnsBasedata,0L);
		return Result.ok("删除成功!");
	}

	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "CIS_ANS_BASEDATA-通过id删除")
	@ApiOperation(value="CIS_ANS_BASEDATA-通过id删除", notes="CIS_ANS_BASEDATA-通过id删除")
	@DeleteMapping(value = "/{id}")
	public Result<?> delete(@PathVariable("id") String id) {
		cisAnsBasedataService.removeById(id);
		return Result.ok("删除成功!");
	}

	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	//@AutoLog(value = "CIS_ANS_BASEDATA-批量删除")
	@ApiOperation(value="CIS_ANS_BASEDATA-批量删除", notes="CIS_ANS_BASEDATA-批量删除")
	@DeleteMapping(value = "")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.cisAnsBasedataService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.ok("批量删除成功!");
	}

	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "CIS_ANS_BASEDATA-通过id查询")
	@ApiOperation(value="CIS_ANS_BASEDATA-通过id查询", notes="CIS_ANS_BASEDATA-通过id查询")
	@GetMapping(value = "/{id}")
	public Result<?> queryById(@PathVariable("id")   String id) {
		CisAnsBasedata cisAnsBasedata = cisAnsBasedataService.getById(id);
		if(cisAnsBasedata==null) {
			return Result.error("未找到对应数据");
		}
		return Result.ok(cisAnsBasedata);
	}
	/**
	 * 通过id查询详情，不需要token
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "CIS_ANS_BASEDATA-通过id查询")
	@ApiOperation(value="CIS_ANS_BASEDATA-通过id查询", notes="CIS_ANS_BASEDATA-通过id查询")
	@GetMapping(value = "/detail")
	public Result<?> detail(@RequestParam("id")String id) {
		CisAnsBasedata cisAnsBasedata = cisAnsBasedataService.getById(id);
		if(cisAnsBasedata==null) {
			return Result.ok("未找到对应数据");
		}
		return Result.ok(cisAnsBasedata);
	}

	/**
	 * 导出excel
	 *
	 * @param request
	 * @param cisAnsBasedata
	 */
	@RequestMapping(value = "/exportXls")
	public ModelAndView exportXls(HttpServletRequest request, CisAnsBasedata cisAnsBasedata) {
		return super.exportXls(request, cisAnsBasedata, CisAnsBasedata.class, "CIS_ANS_BASEDATA");
	}

	/**
	 * 通过excel导入数据
	 *
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/importExcel", method = RequestMethod.POST)
	public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
		return super.importExcel(request, response, CisAnsBasedata.class);
	}
	/**
	 * 获取当前登录用户关注的网站分类ID列表
	 */
	public List<Long> getUserSiteType(){
		//获取当前登录用户
		LoginUser loginUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
		List<Map<String, Object>> siteTypeList = userSiteTypeMidService.queryList(loginUser.getId());
		List<Long> result = new ArrayList<>();
		if(CollectionUtils.isNotEmpty(siteTypeList)){
			for (Map<String, Object> map : siteTypeList) {
				if(map!=null && map.get("ID")!=null){
					result.add(new Long(map.get("ID").toString()));
				}
			}
		}
		return result;
	}

	@ApiOperation(value = "获取文章图谱")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "title",value = "文章名称",dataType = "String")
	})
	@GetMapping("contentRelationData")
	public Result<?> getContentRelationData(String title,HttpServletRequest request){
		try {
			CisAnsBasedata cisAnsBasedata = new CisAnsBasedata();
			cisAnsBasedata.setTitle(title);
			Result<?> result = this.queryPageList(cisAnsBasedata, 1, 10, request);

			String url = Contant.RALATION_SERVICE_URL + "/tupu/event/extractEvents/";
			Map<String,Object> paramMap = new HashMap<>();
			paramMap.put("timestamp", result.getTimestamp());
			paramMap.put("code",result.getCode());
			paramMap.put("message", result.getMessage());
			paramMap.put("success", result.isSuccess());
			paramMap.put("keyword", title);
			paramMap.put("result", result.getResult());

			//fastjson 保留transient修饰字段，默认是不保留SkipTransientField=true，需全局设置为false
			JSON.DEFAULT_GENERATE_FEATURE = SerializerFeature.config(JSON.DEFAULT_GENERATE_FEATURE,SerializerFeature.SkipTransientField,false);
			String body = HttpUtil.post(url,JSONObject.toJSONString(paramMap,SerializerFeature.WriteMapNullValue));//fastjson 保留null字段，默认是不保留
			System.out.println(body);
			JSONObject jsonObject = JSONArray.parseObject(body, JSONObject.class);

			return Result.ok(jsonObject.get("response"));
		} catch (Exception e) {
			return Result.error("");
		}
	}

	public static void main(String[] args) {
		CisAnsBasedata cisAnsBasedata =new CisAnsBasedata();
		cisAnsBasedata.setContentString("<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">中国海军又要有新&ldquo;玩具&rdquo;了！继</span><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important;\">075</span><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">和</span><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important;\">076</span><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">之后，</span><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important;\">077</span><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">已经开始预研，排水量高达</span><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important;\">9</span><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">万吨！</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体; font-size: 17px; letter-spacing: 2px;\">听闻此事，网友编了个段子：</span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\">075<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">两栖攻击舰：我刚开始建造，还没服役呢，</span>077<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">就来抢风头了！</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\">076<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">两栖攻击舰：我刚被曝光，还没建造呢，</span>077<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">就来抢风头了！</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">其实，</span>077<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">并不是两栖攻击舰，而是解放军从来没有过的</span>&ldquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">海上基地舰</span>&rdquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">，所以，</span>075<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">和</span>076<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">别紧张，</span>077<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">抢不了你们的风头，反而可以互补合作。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">我国的习惯是</span>&ldquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">装备一代，研发一代，预研一代</span>&rdquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">。</span>075<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">现在已经下水建造了</span>3<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">艘，都还没有正式服役，但也在为服役做准备了，而</span>076<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">的状态也时不时的有更新。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; text-align: center; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; font-family: 宋体; letter-spacing: 2px; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><img class=\"\" style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; height: auto !important; text-align: start; visibility: visible !important; width: 500px !important;\" src=\"https://mmbiz.qpic.cn/mmbiz_jpg/mxlhF49U3zSe9SGOG8IicBMDWwEwibTeg1DbWt9YlSsnUIwjMGXmRVjlmclAlXBCURynskJA8XgWeicIibAfKaziaibw/640?wx_fmt=jpeg&amp;tp=webp&amp;wxfrom=5&amp;wx_lazy=1&amp;wx_co=1\" alt=\"图片\" crossorigin=\"anonymous\" data-croporisrc=\"https://mmbiz.qlogo.cn/mmbiz_jpg/mxlhF49U3zSe9SGOG8IicBMDWwEwibTeg1YfQJSPvn15bIwTrWyPSkcniaSK8iawOiaoFImyQx07bSFlHIud6ialm5vg/0?wx_fmt=jpeg\" data-cropx1=\"0\" data-cropx2=\"500\" data-cropy1=\"0\" data-cropy2=\"211\" data-ratio=\"0.42\" data-type=\"jpeg\" data-w=\"500\" data-src=\"https://mmbiz.qpic.cn/mmbiz_jpg/mxlhF49U3zSe9SGOG8IicBMDWwEwibTeg1DbWt9YlSsnUIwjMGXmRVjlmclAlXBCURynskJA8XgWeicIibAfKaziaibw/640?wx_fmt=jpeg\" data-fail=\"0\" /></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; text-align: center; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; font-family: 宋体; letter-spacing: 2px; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; color: #333333; font-family: mp-quote, -apple-system-font, BlinkMacSystemFont, 'Helvetica Neue', 'PingFang SC', 'Hiragino Sans GB', 'Microsoft YaHei UI', 'Microsoft YaHei', Arial, sans-serif; text-align: justify; box-sizing: border-box !important; overflow-wrap: break-word !important;\">076想象</span><span style=\"margin: 0px; padding: 0px; max-width: 100%; color: #333333; font-family: mp-quote, -apple-system-font, BlinkMacSystemFont, 'Helvetica Neue', 'PingFang SC', 'Hiragino Sans GB', 'Microsoft YaHei UI', 'Microsoft YaHei', Arial, sans-serif; text-align: justify; box-sizing: border-box !important; overflow-wrap: break-word !important;\">图</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">随着世界形势的不断发展，除了这两种新型两栖攻击舰之外，我们还需要体型更大的远洋海上基地舰，以弥补在海外基地不足的困境，为了方便起见，网上暂时将新式两栖基地舰称呼为</span>&ldquo;077&rdquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">型。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\">077<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">长什么样子？据媒体分析，可以参考美军的远征移动基地舰</span>&ldquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">刘易斯</span>&middot;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">普勒</span>&rdquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">号。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">该舰</span>2017<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">年服役，当时，我国的《解放军报》几乎用了一个整版来介绍这种美军装备，并希望从中得到启示。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体; font-size: 17px; letter-spacing: 2px;\"><img class=\"\" style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; height: auto !important; text-align: start; visibility: visible !important; width: 395px !important;\" title=\"\" src=\"https://mmbiz.qpic.cn/mmbiz_png/mxlhF49U3zRCK2LXarsNAamBXMJWbicgzchyOBrKzwBiaE3FBOcqKsEnSK0CB49fhviajczp2zguuebZor0E4116Q/640?wx_fmt=png&amp;tp=webp&amp;wxfrom=5&amp;wx_lazy=1&amp;wx_co=1\" alt=\"图片\" border=\"0\" crossorigin=\"anonymous\" data-ratio=\"1.3746835443037975\" data-type=\"png\" data-w=\"395\" data-src=\"https://mmbiz.qpic.cn/mmbiz_png/mxlhF49U3zRCK2LXarsNAamBXMJWbicgzchyOBrKzwBiaE3FBOcqKsEnSK0CB49fhviajczp2zguuebZor0E4116Q/640?wx_fmt=png\" data-fail=\"0\" /></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">《解放军报》称：</span>&ldquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">相貌平平的刘易斯</span>&middot;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">普勒号，既无航母的威风凛凛，又无朱姆沃尔特级驱逐舰的现代科幻，但却是美国海军心仪已久的</span>&lsquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">大玩具</span>&rsquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">，有着</span>&lsquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">海上码头</span>&rsquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">之美誉，是美军由海向陆的</span>&lsquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">特快专递</span>&rsquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">。</span>&rdquo;</span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">美国海军虽然拥有遍布世界中枢地区的</span>&ldquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">基地网</span>&rdquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">，但在现实运作中依然有很多问题。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体; font-size: 17px; letter-spacing: 2px;\">首先，海外军事基地无法移动，使用时还得看所在国的脸色。一旦两国关系有个风吹草动，美军也得卷铺盖走人。在菲律宾、吉尔吉斯斯坦就曾发生过类似事件，不仅折了面子，还严重削弱美军在当地的军事能力。</span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">其次，所谓的美国</span>&ldquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">盟友</span>&rdquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">，有的也是</span>&ldquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">两面三刀</span>&rdquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">。例如伊拉克战争期间，因为土耳其拒绝开放本国港口和基地，美军不得不通过苏伊士运河，绕过阿拉伯半岛才把第四机步师的重型装备运到科威特，贻误了战机。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">这些</span>&ldquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">痛点</span>&rdquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">让美军愈发感到，有必要打造一种自己掌控的海上移动保障平台。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; text-align: center; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; font-family: 宋体; letter-spacing: 2px; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><img class=\"\" style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; height: auto !important; text-align: start; visibility: visible !important; width: 677px !important;\" title=\"\" src=\"https://mmbiz.qpic.cn/mmbiz_jpg/mxlhF49U3zRCK2LXarsNAamBXMJWbicgz7axj8UtKzNCQpnzbtqiakSPjHNNbpNLAicSahWCyba5qmzGS74hgvPXA/640?wx_fmt=jpeg&amp;tp=webp&amp;wxfrom=5&amp;wx_lazy=1&amp;wx_co=1\" alt=\"图片\" border=\"0\" crossorigin=\"anonymous\" data-ratio=\"0.5644736842105263\" data-type=\"jpeg\" data-w=\"760\" data-src=\"https://mmbiz.qpic.cn/mmbiz_jpg/mxlhF49U3zRCK2LXarsNAamBXMJWbicgz7axj8UtKzNCQpnzbtqiakSPjHNNbpNLAicSahWCyba5qmzGS74hgvPXA/640?wx_fmt=jpeg\" data-fail=\"0\" /><strong style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; color: #888888; font-family: Calibri;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important;\">&ldquo;</span>刘易斯<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important;\">&middot;</span>普勒<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important;\">&rdquo;</span>号及其搭载人员装备示意图</strong></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\">&ldquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">刘易斯</span>&middot;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">普勒</span>&rdquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">号是一种全新的军舰，以一艘半潜船作为基础，在舰体甲板上方铺设飞行甲板，并增加特殊舱室设计。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">该舰长</span>233<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">米，宽</span>50<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">米，吃水</span>7.8<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">米，满载排水量</span>7.8<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">万吨（美最新建造的远征移动基地舰排水量已达</span>9<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">万吨级），使用柴油机推进并配置有</span>IPS<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">全电推进系统，最大航速为</span>15<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">节。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">甲板分为上下两层，上层为飞行甲板，最多可同时起降</span>4<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">架</span>CH-53&ldquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">超级海上种马</span>&rdquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">重型运输直升机。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\">&ldquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">刘易斯</span>&middot;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">普勒</span>&rdquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">号正常船员为</span>250<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">名军人和</span>44<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">名平民水手。</span>250<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">名军人中有</span>100<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">人是作战部队人员，</span>150<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">人为航空和水雷作战人员。由于搭载装备多样化，该舰同时具备两栖投送能力、海上运输能力、海上布雷</span>/<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">扫雷能力，并可以执行反海盗、海上安全执勤、搜救、撤侨和人道主义救援等多种非战斗任务，是一型不折不扣的多用途军舰。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体; font-size: 17px; letter-spacing: 2px;\"><img class=\"\" style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; height: auto !important; text-align: start; visibility: visible !important; width: 640px !important;\" src=\"https://mmbiz.qpic.cn/mmbiz_png/mxlhF49U3zRCK2LXarsNAamBXMJWbicgzfZ06DjSadtM7heGEnVQjvfWryQWr7yDibKvQichvncibRjTAsrVu7K78w/640?wx_fmt=png&amp;tp=webp&amp;wxfrom=5&amp;wx_lazy=1&amp;wx_co=1\" alt=\"图片\" crossorigin=\"anonymous\" data-ratio=\"0.7453125\" data-type=\"png\" data-w=\"640\" data-src=\"https://mmbiz.qpic.cn/mmbiz_png/mxlhF49U3zRCK2LXarsNAamBXMJWbicgzfZ06DjSadtM7heGEnVQjvfWryQWr7yDibKvQichvncibRjTAsrVu7K78w/640?wx_fmt=png\" data-fail=\"0\" /></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">我国目前的工业水平完全同样可以建造满载排水量</span>9<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">万吨左右的</span>077<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">型两栖基地舰，而且相对便宜，路易斯</span>&middot;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">普勒号从开始铺设龙骨到最终交付使用，只用了不到</span>2<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">年，造价也只有</span>1.35<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">亿美元，比一架第五代战斗机还便宜。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">《解放军报》在</span>2017<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">年的文章中就提出以下建议：</span></span></section>↵<section style=\"margin: 15px 32px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; color: #888888; font-size: 17px; letter-spacing: 2px;\">&ldquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; font-family: 宋体; box-sizing: border-box !important; overflow-wrap: break-word !important;\">可以借鉴美军的思路成果，根据自身战略定位、经济能力和现实需要，视情建造类似的舰艇。尤其对于一些具有广泛海外利益、承担很多国际人道主义救援义务同时又缺少大量海外军事基地的后发海洋大国，研制发展大型海上基地船显得更为必要。</span>&rdquo;</span></section>↵<section style=\"margin: 15px 32px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; color: #888888; font-size: 17px; letter-spacing: 2px;\">&ldquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; font-family: 宋体; box-sizing: border-box !important; overflow-wrap: break-word !important;\">海上基地船的研制发展可以采取军民融合的原则。从源头上追溯，美军的海上基地船是由半潜船发展而来，而半潜船在地方上有广泛应用。因此，如果造舰厂家在半潜船的设计建造中兼顾未来的军事需求，预留相关的接口，设计相关的功能模块，培养可以遂行保障任务的船员，那么一旦战时需要，就能迅速动员改装出很多海上基地船，化身远海长期作战的</span>&lsquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; font-family: 宋体; box-sizing: border-box !important; overflow-wrap: break-word !important;\">粮草大营</span>&rsquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; font-family: 宋体; box-sizing: border-box !important; overflow-wrap: break-word !important;\">，有效提升打赢未来海上战争的能力。</span>&rdquo;</span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">不过和美军相比，中国的</span>077<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">型应该在设计上有所优化。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">首先，</span>077<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">型应该采用类似于</span>075<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">的舰型设计，但是由于吨位加大，</span>077<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">型军舰的舰长可以轻松超过</span>250<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">米，舰宽则保持在</span>50<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">米左右，但上层飞行甲板可以适当加宽，最大宽度保持在</span>55<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">米左右，这样方便甲板调度。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">整体设计为：采用全通型甲板，右侧舰岛部署，采用类似于两栖攻击舰的舰型设计，同时在舰首部署一台国产电磁弹射器，在舰尾部署</span>3<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">条拦阻索。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体; font-size: 17px; letter-spacing: 2px;\"><img class=\"\" style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; height: auto !important; text-align: start; visibility: visible !important; width: 562px !important;\" src=\"https://mmbiz.qpic.cn/mmbiz_jpg/mxlhF49U3zRCK2LXarsNAamBXMJWbicgz7pwYeGWsNot94lcs9ZQuuwtZbtISibbYKEecCVic76fESxre8jBhHzog/640?wx_fmt=jpeg&amp;tp=webp&amp;wxfrom=5&amp;wx_lazy=1&amp;wx_co=1\" alt=\"图片\" crossorigin=\"anonymous\" data-croporisrc=\"https://mmbiz.qlogo.cn/mmbiz_jpg/mxlhF49U3zRCK2LXarsNAamBXMJWbicgzueS0SXhliasIe7dncmTb7uDicCg4FZTFX4xBUv6QZzERlkoXCVpjkVCQ/0?wx_fmt=jpeg\" data-cropx1=\"0\" data-cropx2=\"640.0000000000001\" data-cropy1=\"116.15658362989322\" data-cropy2=\"427.0462633451957\" data-ratio=\"0.4859375\" data-type=\"jpeg\" data-w=\"640\" data-src=\"https://mmbiz.qpic.cn/mmbiz_jpg/mxlhF49U3zRCK2LXarsNAamBXMJWbicgz7pwYeGWsNot94lcs9ZQuuwtZbtISibbYKEecCVic76fESxre8jBhHzog/640?wx_fmt=jpeg\" data-fail=\"0\" /></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体; font-size: 17px; letter-spacing: 2px;\">这样设计就可以搭载国产新一代大型喷气式无人机和目前国产的大型察打一体无人机，从而为整个两栖攻击编队提供有效的航空火力支援，而且效率要高于舰载武装直升机。</span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">由于两栖部队执行的任务和航母战斗群不同，使用中国最擅长的无人机技术是最好的选择。比如</span>HK-5000G<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">型无人机采用了类似于</span>\"<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">云影</span>\"<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">无人机的设计，使用滑翔机式的气动，即使不使用弹射器，也足以在</span>250<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">米长的跑道上自行起飞。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">美军的</span>\"<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">刘易斯</span>&middot;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">普勒</span>\"<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">只有两层甲板，且舰体部分中空，因此浪费较大。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\">077<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">飞行甲板下方可再设计两层甲板，其中上层为机库，但保持和车辆停放甲板连通，这样，飞机和陆战队各种重装车辆的调配就有更大的活动空间。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">下层为两栖换装船坞，船坞的设计和以往的两栖攻击舰不同，坞舱大门不开在舰尾，而是开在舰身左舷。这是因为右舷有舰岛，因此必须保证支撑结构，维护舰体强度，在舰体左舷开坞舱口，这样可以保证</span>3<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">艘</span>726A\"<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">野马</span>\"<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">两栖登陆艇同时上下，效率比传统的</span>075<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">、</span>071<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">等舰提升</span>3<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">倍。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体; font-size: 17px; letter-spacing: 2px;\"><img class=\"\" style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; height: auto !important; text-align: start; visibility: visible !important; width: 562px !important;\" src=\"https://mmbiz.qpic.cn/mmbiz_jpg/mxlhF49U3zRCK2LXarsNAamBXMJWbicgza6rkm3ofmWc2CwMwI3j7gddwW5xF9GoVbdj5ZbuUgrPj2vysNwtwlw/640?wx_fmt=jpeg&amp;tp=webp&amp;wxfrom=5&amp;wx_lazy=1&amp;wx_co=1\" alt=\"图片\" crossorigin=\"anonymous\" data-croporisrc=\"https://mmbiz.qlogo.cn/mmbiz_jpg/mxlhF49U3zRCK2LXarsNAamBXMJWbicgzibvZFsWlicVtNomg3zxC3J4Iib5mDz3qWWibOsxzuzjdaWHibib2FkYgicib7w/0?wx_fmt=jpeg\" data-cropx1=\"0\" data-cropx2=\"640.0000000000001\" data-cropy1=\"25.053380782918147\" data-cropy2=\"427.0462633451957\" data-ratio=\"0.628125\" data-type=\"jpeg\" data-w=\"640\" data-src=\"https://mmbiz.qpic.cn/mmbiz_jpg/mxlhF49U3zRCK2LXarsNAamBXMJWbicgza6rkm3ofmWc2CwMwI3j7gddwW5xF9GoVbdj5ZbuUgrPj2vysNwtwlw/640?wx_fmt=jpeg\" data-fail=\"0\" /></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">为了确保部署的快速性，</span>077<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">型海上基地舰应该使用国产大型燃气轮机作为动力，如果要降低成本，也可以干脆使用类似于辽宁号航母那样的大功率蒸汽动力，因为</span>9<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">万吨的满载排水量，吨位足够大，所以在动力选择方面不必太过于苛求，但航速需要能够保持最大</span>25<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">节，巡航速度设置在</span>16<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">～</span>18<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">节左右，这样一旦全球任何地方出现</span>\"<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">热点</span>\"<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">事件，可以确保</span>077<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">型基地舰以最短的时间赶到现场，这样会为决策提供更多的选项。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">在执行两栖作战任务时，</span>077<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">型舰可以搭载完整的一个海军陆战旅，包括人员和装备，这样再配合一艘</span>075<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">、两艘</span>071<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">组成的远洋两栖部队，已经完全具备了单独发起两栖作战的能力，这也是</span>077<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">型设想的初衷，也就是</span>&ldquo;1<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">艘舰</span>=1<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">个基地</span>&rdquo;<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">的意思。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体; font-size: 17px; letter-spacing: 2px;\"><img class=\"\" style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; height: auto !important; text-align: start; visibility: visible !important; width: 640px !important;\" src=\"https://mmbiz.qpic.cn/mmbiz_jpg/mxlhF49U3zRCK2LXarsNAamBXMJWbicgziaNCoUBA4RLIJMrwX79m0XKm6MckWmHrYwOFcWI5eWucsDchmsyCzEw/640?wx_fmt=jpeg&amp;tp=webp&amp;wxfrom=5&amp;wx_lazy=1&amp;wx_co=1\" alt=\"图片\" crossorigin=\"anonymous\" data-ratio=\"0.5546875\" data-type=\"jpeg\" data-w=\"640\" data-src=\"https://mmbiz.qpic.cn/mmbiz_jpg/mxlhF49U3zRCK2LXarsNAamBXMJWbicgziaNCoUBA4RLIJMrwX79m0XKm6MckWmHrYwOFcWI5eWucsDchmsyCzEw/640?wx_fmt=jpeg\" data-fail=\"0\" /></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-size: 17px; letter-spacing: 2px;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">在</span>077<span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体;\">海上基地舰建成服役之后，它除了是一种登陆平台之外，还是更加重要的海上基地。</span></span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体; font-size: 17px; letter-spacing: 2px;\">要知道，滚装补给船、弹药输送舰等大型舰艇的体积和吨位都比较大，通常情况下是不能直接参与到登陆作战的。而登陆艇和气垫登陆船的体积又太小，搭载能力很有限。</span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体; font-size: 17px; letter-spacing: 2px;\">在这种情况下，海上基地舰将会是一种很不错的选择。另外，海上基地舰还将是一种非常通用型的海上基地平台，由于远征移动基地舰大量采用了模块化设计，舰载系统安装与拆卸非常方便，因此具有多用途海基平台的功能。</span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; color: #333333; font-family: -apple-system, BlinkMacSystemFont, 'Helvetica Neue', 'PingFang SC', 'Hiragino Sans GB', 'Microsoft YaHei UI', 'Microsoft YaHei', Arial, sans-serif; font-size: 17px; letter-spacing: 0.544px; text-align: justify; background-color: #ffffff; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; color: #000000; font-family: 宋体; letter-spacing: 2px; box-sizing: border-box !important; overflow-wrap: break-word !important;\">比如，在大型任务甲板上安装野战医院模块，机动登陆平台就能作为医院船使用，安装车间、吊车等维修类模块，就又可以变身成为海上抢修船。除了两栖作战任务外，还可以承担搜救、撤侨、反海盗、海上治安、海上救灾等任务。</span></section>↵<section style=\"margin: 15px 8px; padding: 0px; max-width: 100%; letter-spacing: 0.544px; text-align: justify; min-height: 1em; background-color: #ffffff; font-family: Calibri; font-size: 14px; caret-color: #000000; line-height: 2em; box-sizing: border-box !important; overflow-wrap: break-word !important;\"><span style=\"margin: 0px; padding: 0px; max-width: 100%; box-sizing: border-box !important; overflow-wrap: break-word !important; font-family: 宋体; font-size: 17px; letter-spacing: 2px;\">这种功能强大的海上基地舰，需要建造多少呢？从我国地理位置来看，未来应该是需要4艘这种舰艇的。两艘用于执行任务，另一艘备用执勤，还有一艘在港保养，一旦需要，还可以互相调配使用。</span></section>");
		String content=Jsoup.parse(cisAnsBasedata.getContentStringTwo()).outerHtml();
		cisAnsBasedata.setContentString(content);
		Map<String, FileTag> contentFileTag = ContentFileFinder.getContentFileTag(cisAnsBasedata.getContentStringTwo(),cisAnsBasedata.getSourceaddress());
		if(CollectionUtils.isNotEmpty(contentFileTag)){
			//遍历map
			contentFileTag.forEach((key,value)->{
				//使用MD5加密：ID+图片的原网址
				String md5 = DigestUtils.md5DigestAsHex((cisAnsBasedata.getId() + value.getAbsolutePath()).getBytes(StandardCharsets.UTF_8));
				String newImg="<img style=\"width: 600px;\" src=\"/adminser/image/base/"+md5+"\" />";
				//压缩图片到50k转base64保存到数据库
				String imgUrlToBase64 = ImgBaseUtil.compressPicForScale(value.getAbsolutePath(),50,cisAnsBasedata.getId()+key);
				BaseDataImage baseDataImage = new BaseDataImage();
				baseDataImage.setId(md5);
				baseDataImage.setDataImage(imgUrlToBase64);
				//baseDataImage.setBid(cisAnsBasedata.getId().toString());
				//imageList.add(baseDataImage);
				System.out.println(key);
				System.out.println(cisAnsBasedata.getContentStringTwo().contains(key));
				cisAnsBasedata.setContentString(cisAnsBasedata.getContentStringTwo().replace(key,newImg));
				System.out.println(cisAnsBasedata.getContentString());
			});
		}
	}


}
