package com.zzsn.modules.system.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.zzsn.common.api.vo.Result;
import com.zzsn.common.system.query.QueryGenerator;
import com.zzsn.common.util.oConvertUtils;
import com.zzsn.modules.system.entity.SysUserPermission;
import com.zzsn.modules.system.service.ISysUserPermissionService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import com.zzsn.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import com.zzsn.common.aspect.annotation.AutoLog;

 /**
 * @Description: 用户权限表
 * @Author: zzsn-boot
 * @Date:   2020-08-12
 * @Version: V1.0
 */
@Api(tags="用户权限表")
@RestController
@RequestMapping("/system/sysUserPermission")
@Slf4j
public class SysUserPermissionController extends JeecgController<SysUserPermission, ISysUserPermissionService> {
	@Autowired
	private ISysUserPermissionService sysUserPermissionService;
	
	/**
	 * 分页列表查询
	 *
	 * @param sysUserPermission
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "用户权限表-分页查询")
	@ApiOperation(value = "用户权限表-分页查询", notes="用户权限表-根据参数传入的sysUser对象和分页控制参数，对数据进行数据库查询后，封装成page分页对象并返回")
	@GetMapping(value = "")
	public Result<?> queryPageList(SysUserPermission sysUserPermission,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<SysUserPermission> queryWrapper = QueryGenerator.initQueryWrapper(sysUserPermission, req.getParameterMap());
		Page<SysUserPermission> page = new Page<SysUserPermission>(pageNo, pageSize);
		IPage<SysUserPermission> pageList = sysUserPermissionService.page(page, queryWrapper);
		return Result.ok(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param sysUserPermission
	 * @return
	 */
	@AutoLog(value = "用户权限表-添加")
	@ApiOperation(value="用户权限表-添加", notes="用户权限表-通过参数传入json格式sysUser对象，在数据库中生成一条新的数据")
	@PostMapping(value = "")
	public Result<?> add(@RequestBody SysUserPermission sysUserPermission) {
		sysUserPermissionService.save(sysUserPermission);
		return Result.ok("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param sysUserPermission
	 * @return
	 */
	@AutoLog(value = "用户权限表-编辑")
	@ApiOperation(value="用户权限表-编辑", notes="用户权限表-编辑")
	@PutMapping(value = "")
	public Result<?> edit(@RequestBody SysUserPermission sysUserPermission) {
		sysUserPermissionService.updateById(sysUserPermission);
		return Result.ok("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "用户权限表-通过id删除")
	@ApiOperation(value="用户权限表-通过id删除", notes="用户权限表-通过id删除")
	@DeleteMapping(value = "/{id}")
	public Result<?> delete(@PathVariable("id") String id) {
		sysUserPermissionService.removeById(id);
		return Result.ok("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "用户权限表-批量删除")
	@ApiOperation(value="用户权限表-批量删除", notes="用户权限表-批量删除")
	@DeleteMapping(value = "")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.sysUserPermissionService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.ok("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "用户权限表-通过id查询")
	@ApiOperation(value="用户权限表-通过id查询", notes="用户权限表-通过id查询")
	@GetMapping(value = "/{id}")
	public Result<?> queryById(@PathVariable("id")   String id) {
		SysUserPermission sysUserPermission = sysUserPermissionService.getById(id);
		if(sysUserPermission==null) {
			return Result.error("未找到对应数据");
		}
		return Result.ok(sysUserPermission);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param sysUserPermission
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, SysUserPermission sysUserPermission) {
        return super.exportXls(request, sysUserPermission, SysUserPermission.class, "用户权限表");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, SysUserPermission.class);
    }

}
