package com.zzsn.modules.kgj.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.common.system.vo.LoginUser;
import com.zzsn.modules.kgj.common.Contant;
import com.zzsn.modules.kgj.entity.*;
import com.zzsn.modules.kgj.mapper.BaseDataMapper;
import com.zzsn.modules.kgj.mapper.BaseDataTypeMapper;
import com.zzsn.modules.kgj.mapper.CesSysSecretMapper;
import com.zzsn.modules.kgj.service.BaseDataService;
import com.zzsn.modules.kgj.service.ICesSysSecretService;
import com.zzsn.modules.kgj.utils.DateUtil;
import com.zzsn.modules.kgj.utils.Pager;
import com.zzsn.modules.kgj.utils.SortUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author 刘凯歌
 * @description:
 * @date 2020/9/27 16:30
 */
@DS("master")
@Service
public class BaseDataServiceImpl extends ServiceImpl<BaseDataMapper,Basedata> implements BaseDataService {

    @Autowired
    private BaseDataMapper baseDataMapper;

    @Autowired
    private BaseDataTypeMapper baseDataTypeMapper;

    @Autowired
    private CesSysSecretMapper secretMapper;

    @Autowired
    private ICesSysSecretService secretService;

    @Override
    public Pager<Basedata> listByPage(long offSet, long pageSize, Basedata basedata) {
        Basedata raw = new Basedata();
        Pager<Basedata>  pager  = new Pager<>();

        //设置查询参数
        if(basedata.getId()!=null)
        {
            raw.setId(basedata.getId());
        }
        if(basedata.getTid()!=null)
        {
            raw.setTid(basedata.getTid());
        }
        if(basedata.getTitle()!=null&&basedata.getTitle().length()>0)
        {
            raw.setTitle(basedata.getTitle());
        }
        if(basedata.getSummary()!=null&&basedata.getSummary().length()>0)
        {
            raw.setSummary(basedata.getSummary());
        }
        if(basedata.getPublishStartTime()!=null&&basedata.getPublishStartTime().length()>0) {
            raw.setPublishStartTime(basedata.getPublishStartTime());
        }
        if(basedata.getPublishEndTime()!=null&&basedata.getPublishEndTime().length()>0)
        {
            raw.setPublishEndTime(basedata.getPublishEndTime());
        }
        if( ( null == basedata.getPublishStartTime() || basedata.getPublishStartTime().trim().length() == 0 )
                &&
                ( null == basedata.getPublishEndTime() || basedata.getPublishEndTime().trim().length() == 0 )
        ){
            //开始时间和结束时间均为空，则将开始时间设置为默认两周前//modity lihuawei 90tian
            Date twoweek = DateUtil.addDate(new Date(), -30);
            raw.setPublishStartTime(DateUtil.format(twoweek));
        }
        if(basedata.getCreateStartTime()!=null&&basedata.getCreateStartTime().length()>0)
        {
            raw.setCreateStartTime(basedata.getCreateStartTime());
        }
        if(basedata.getCreateEndTime()!=null&&basedata.getCreateEndTime().length()>0)
        {
            raw.setCreateEndTime(basedata.getCreateEndTime());
        }
        if(basedata.getSort()!=null&&basedata.getSort().length()>0)
        {
            raw.setSort(basedata.getSort());
        }
        if(basedata.getOrgId()!=null)
        {
            raw.setOrgId(basedata.getOrgId());
        }
        if(basedata.getReadid()!=null&&basedata.getReadid().length()>0)
        {
            raw.setReadid(basedata.getReadid());
        }
        if(basedata.getType()!=null&&basedata.getType().length()>0)
        {
            raw.setType(basedata.getType());
        }
        if(basedata.getIsdelete()!=null)
        {
            raw.setIsdelete(basedata.getIsdelete());
        }
        if(basedata.getCid()!=null)
        {
            raw.setCid(basedata.getCid());
        }
        if(basedata.getHits()!=null)
        {
            raw.setHits(basedata.getHits());
        }
        if(basedata.getOrigin()!=null&&basedata.getTids().length()>0)
        {
            raw.setOrigin(basedata.getOrigin());
        }
        if(basedata.getTids()!=null&&basedata.getTids().length()>0)
        {
            raw.setTids(basedata.getTids());
        }
        if(basedata.getReliability()!=null&& basedata.getReliability().length()>0)
        {
            raw.setReliability(basedata.getReliability());
        }
        if(basedata.getInfluence()!=null&& basedata.getInfluence().length()>0)
        {
            raw.setInfluence(basedata.getInfluence());
        }
        if(basedata.getOrientation()!=null&& basedata.getOrientation().length()>0){
            raw.setOrientation(basedata.getOrientation());
        }
        if(basedata.getLang()!=null&&basedata.getLang().length()>0)
        {
            raw.setLang(basedata.getLang());
        }
        if(basedata.getDelflag()!=null)
        {
            raw.setDelflag(basedata.getDelflag());
        }
        if(basedata.getFromWhere()!=null)
        {
            raw.setFromWhere(basedata.getFromWhere());
        }
        if(basedata.getRelatePlaces() != null && basedata.getRelatePlaces().trim().length() > 0){
            raw.setRelatePlaces(basedata.getRelatePlaces());
        }
        pager.setTotal(baseDataMapper.pagerCount(raw));
        List<Basedata> rows = baseDataMapper.pagerData(offSet, pageSize, raw);
        for (Basedata row : rows) {
            basedata = row;
            if (null != basedata.getFromWhere()) {
                if ("ZHXG".equals(basedata.getFromWhere())) {
                    basedata.setViewSid("智慧星光");
                } else {
                    basedata.setViewSid(basedata.getFromWhere());
                }
            } else {
                if (basedata.getSid() == null) {
                    basedata.setViewSid("元搜索");
                } else {
                    basedata.setViewSid("人工增加");
                }
            }

            //状态
            if (basedata.getDelflag() == null || basedata.getDelflag().equals(0L)) {
                basedata.setViewStatus("未审核");
                basedata.setDelflag(0L);
            } else if ( basedata.getDelflag().equals(1L)) {
                basedata.setViewStatus("删除");
                basedata.setDelflag(1L);
            }else if (basedata.getDelflag().equals(2L)){
                basedata.setViewStatus("疑似敏感信息");
                basedata.setDelflag(2L);
            }else if (basedata.getDelflag().equals(3L)){
                basedata.setViewStatus("已确定敏感信息");
                basedata.setDelflag(3L);
            }
            if (basedata.getKeywords() != null) {
                basedata.setKeywords(basedata.getKeywords().replace("\n", " "));
            }
        }
        pager.setRows(rows);
        return pager;
    }

    @Override
    @Transactional
    public void saveOrModify(Basedata basedata) {
        if (basedata.getId() == null) {
            //设置一些默认参数，如创建日期，创建人等
            basedata.setId(String.valueOf(getserialno()));
            //获取当前登录用户信息
            LoginUser loginUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
            basedata.setCreateBy(loginUser.getUsername());
            // 创建日期
            String createDate = DateUtil.format(new Date(), "yyyy-MM-dd HH:mm:ss");
            basedata.setCreateDate(createDate);
            basedata.setPublishDate(DateUtil.getPublishDate(basedata.getPublishDate()));
            if (basedata.getPublishDate() == null || basedata.getPublishDate().trim().length() == 0) {
                basedata.setPublishDate(createDate);
            }
            //无标签内容添加
//            String contentstr = Utility.TransferHTML2Text(basedata.getContent());
            basedata.setContentNoTag(basedata.getContent());
            //图片内容保存
            basedata.setContentImgCvtTag(basedata.getContent());
            //sid为空时，sid设置为0L
            if (null == basedata.getSid()) {
                basedata.setSid(0L);
            }
            if (basedata.getContent() != null && basedata.getContent().trim().length() != 0) {
//                basedata.setContentNoTag(Utility.TransferHTML2Text(basedata.getContent()));
                basedata.setContentNoTag(basedata.getContent());
            }
            basedata.setIsdelete(0);
            //情报表添加
            baseDataMapper.save(basedata);

            //情报分类表添加
            BasedataType basedataType = new BasedataType();
            basedataType.setBid(Long.valueOf(basedata.getId()));
            //同一条信息，不同组织，通过SYSTYPE表中的ORGID进行区分
            basedataType.setOrgId(basedata.getOrgId());
            basedataType.setTid(basedata.getTid());
            basedataType.setRelevance(0L);
            basedataType.setCreateDate(basedata.getCreateDate());
            basedataType.setPublishDate(basedata.getPublishDate());
            basedataType.setOrientation(basedata.getOrientation());
            basedataType.setCheckDate(DateUtil.format(new Date()));
            basedataType.setBriefmark(0L);//不加入简报
            //delflag : 0或空 未审核；1 删除；2 疑似敏感信息；3 已确定敏感信息 4 重复（repeat=1）
            if(basedata.getDelflag().equals(4L)){
                basedataType.setDelflag(4L);
                basedataType.setRepeat(1L);
            } else if ( basedata.getDelflag().equals(3L)) {
                basedataType.setDelflag(3L);
            } else if (basedata.getDelflag().equals(2L)) {
                basedataType.setDelflag(2L);
            } else if (basedata.getDelflag().equals(1L)) {
                basedataType.setDelflag(1L);
            }else if (basedata.getDelflag().equals(0L) || basedata.getDelflag() == null){
                basedataType.setDelflag(0L);
            }
            baseDataTypeMapper.save(basedataType);
        } else {
            Basedata base = copyUpdateParam(basedata);
            baseDataMapper.updateByExample(base);
            //判断该条信息是否属于该分类
            BasedataType basedataType = new BasedataType();
            basedataType.setBid(Long.valueOf(base.getId()));
            basedataType.setOrgId(base.getOrgId());
            basedataType.setTid(base.getTid());
            basedataType.setCreateDate(base.getCreateDate());
            basedataType.setPublishDate(base.getPublishDate());
            basedataType.setOrientation(base.getOrientation());
            basedataType.setCheckDate(DateUtil.format(new Date()));
            basedataType.setBriefmark(0L);//不加入简报
            //delflag : 0或空 未审核；1 删除；2 疑似敏感信息；3 已确定敏感信息（保留） 4 重复（repeat=1）
            if(basedata.getDelflag().equals(4L)){
                basedataType.setDelflag(4L);
                basedataType.setRepeat(1L);
            } else if ( basedata.getDelflag().equals(3L)) {
                basedataType.setDelflag(3L);
            } else if (basedata.getDelflag().equals(2L)) {
                basedataType.setDelflag(2L);
            } else if (basedata.getDelflag().equals(1L)) {
                basedataType.setDelflag(1L);
            }else if (basedata.getDelflag().equals(0L) || basedata.getDelflag() == null){
                basedataType.setDelflag(0L);
            }
            basedataType.setId(base.getBtId());
            baseDataTypeMapper.updateByExample(basedataType);

        }
    }

    @Override
    public Long getDataCount(Long tid,String startTime,String endTime, Long type) {
//        //2为疑似 3是确认，空则查询所有
//        Map<String, Object> result = new HashMap<>();
//        //2疑似数据
//        Long suspectCount = baseDataMapper.getDataCount(tid, startTime, endTime, 2L);
//        //3确认数据
//        Long confirmCount = baseDataMapper.getDataCount(tid, startTime, endTime, 3L);
//        //所有数据
//        Long allCount = baseDataMapper.getDataCount(tid, startTime, endTime, null);
//        result.put("suspect",suspectCount);
//        result.put("confirm",confirmCount);
//        result.put("all",allCount);
        Long dataCount = baseDataMapper.getDataCountOld(tid, startTime, endTime, type);
        return dataCount;
    }
    @Override
    public Long getDataCount(Long tid,String startTime,String endTime, Long type, List<Long> typeList,Long siteId) {
        Long dataCount = baseDataMapper.getDataCount(tid, startTime, endTime, type,typeList, siteId);
        return dataCount;
    }

    @Override
    public List<BaseDataVO> getDataCountGroupByMonth(Long tid, String startTime, String endTime, Long type) {
        //已抓取数量
//        List<BaseDataVO> allList = baseDataMapper.getDataCountGroupByMonth(tid, startTime, endTime, null);
        //疑似数量
        List<BaseDataVO> suspectList = baseDataMapper.getDataCountGroupByMonthOld(tid, startTime, endTime, 2L);
        //确认数量
        List<BaseDataVO> confirmList = baseDataMapper.getDataCountGroupByMonthOld(tid, startTime, endTime, 3L);
        //前12月的月份格式为2020-11
        LocalDate today = LocalDate.now();
        //日期算上本月
        List<String> monthList = new ArrayList<>();
        for(long i = 0L;i <= 11L; i++){
            LocalDate localDate = today.minusMonths(i);
            String ss = localDate.toString().substring(0,7);
            monthList.add(0,ss);
        }
        List<BaseDataVO> result =new ArrayList<>();
        if(suspectList!=null && suspectList.size()>0){
            //转化成map，key为月份，格式2020-11
            Map<String, BaseDataVO> map = suspectList.stream().collect(Collectors.toMap(BaseDataVO::getMonth, baseDataVO -> baseDataVO));
            if (monthList.size()>0){
                for (int i=0; i<monthList.size();i++) {
                    String s = monthList.get(i);
                    BaseDataVO baseDataVO = map.get(s);
                    if(baseDataVO != null){
                        baseDataVO.setSuspectCount(baseDataVO.getCount());
                    }else{
                        baseDataVO = new BaseDataVO();
                        baseDataVO.setMonth(s);
                        baseDataVO.setSuspectCount(0L);
                    }
                    //如果是2020-09，取8月份和10月份的中间值，因为数据库中的2020-09月份疑似信息的数量太多
                    if("2020-09".equals(s)){
                        //取前后的中间值
                        if(i==0){
                            //没有前边
                            BaseDataVO baseDataVO1 = map.get(monthList.get(i+1));
                            if(baseDataVO1 != null){
                                baseDataVO.setSuspectCount(baseDataVO1.getCount()/2);
                            }else{
                                baseDataVO.setSuspectCount(0L);
                            }
                        }else{
                            BaseDataVO baseDataVO2 = map.get(monthList.get(i-1));
                            BaseDataVO baseDataVO3 = map.get(monthList.get(i+1));
                            if(baseDataVO2 == null || baseDataVO3 == null){
                                baseDataVO.setSuspectCount(0L);
                            }else {
                                baseDataVO.setSuspectCount((baseDataVO2.getSuspectCount()
                                        +baseDataVO3.getCount())/2);
                            }
                        }
                    }
                    baseDataVO.setCount(0L);
                    result.add(baseDataVO);
                }
            }
        }else{
            if (monthList.size()>0){
                for (String s : monthList) {
                    BaseDataVO baseDataVO = new BaseDataVO();
                    baseDataVO.setMonth(s);
                    baseDataVO.setSuspectCount(0L);
                    baseDataVO.setCount(0L);
                    baseDataVO.setConfirmCount(0L);
                    result.add(baseDataVO);
                }
            }
        }
        if(confirmList!=null && confirmList.size()>0){
            for (BaseDataVO baseDataVO : result) {
                for (BaseDataVO dataVO : confirmList) {
                    if(StringUtils.isNotBlank(dataVO.getMonth()) && baseDataVO.getMonth().equals(dataVO.getMonth())){
                        if(dataVO.getCount()!=null){
                            baseDataVO.setConfirmCount(dataVO.getCount());
                        }
                    }
                }
            }
        }
        return result;
    }

    @Override
    public List<BaseDataVO> getDataCountGroupByMonth(Long tid, String startTime, String endTime, Long type,  List<Long> typeList) {
        //已抓取数量
        List<BaseDataVO> allList = baseDataMapper.getDataCountGroupByMonth(tid, startTime, endTime, null,typeList);
        //疑似数量
        List<BaseDataVO> suspectList = baseDataMapper.getDataCountGroupByMonth(tid, startTime, endTime, 2L,typeList);
        //确认数量
        List<BaseDataVO> confirmList = baseDataMapper.getDataCountGroupByMonth(tid, startTime, endTime, 3L,typeList);
        //前12月的月份格式为2020-11
        LocalDate today = LocalDate.now();
        //日期算上本月
        List<String> monthList = new ArrayList<>();
        for(long i = 0L;i <= 11L; i++){
            LocalDate localDate = today.minusMonths(i);
            String ss = localDate.toString().substring(0,7);
            monthList.add(0,ss);
        }
        List<BaseDataVO> result =new ArrayList<>();
        if(suspectList!=null && suspectList.size()>0){
            //转化成map，key为月份，格式2020-11
            Map<String, BaseDataVO> map = suspectList.stream().collect(Collectors.toMap(BaseDataVO::getMonth, baseDataVO -> baseDataVO));
            if (monthList.size()>0){
                for (int i=0; i<monthList.size();i++) {
                    String s = monthList.get(i);
                    BaseDataVO baseDataVO = map.get(s);
                    if(baseDataVO != null){
                        baseDataVO.setSuspectCount(baseDataVO.getCount());
                    }else{
                        baseDataVO = new BaseDataVO();
                        baseDataVO.setMonth(s);
                        baseDataVO.setSuspectCount(0L);
                    }
                    //如果是2020-09，取8月份和10月份的中间值，因为数据库中的2020-09月份疑似信息的数量太多
                    if("2020-09".equals(s)){
                        //取前后的中间值
                        if(i==0){
                            //没有前边
                            BaseDataVO baseDataVO1 = map.get(monthList.get(i+1));
                            if(baseDataVO1 != null){
                                baseDataVO.setSuspectCount(baseDataVO1.getCount()/2);
                            }else{
                                baseDataVO.setSuspectCount(0L);
                            }
                        }else{
                            BaseDataVO baseDataVO2 = map.get(monthList.get(i-1));
                            BaseDataVO baseDataVO3 = map.get(monthList.get(i+1));
                            if(baseDataVO2 == null || baseDataVO3 == null){
                                baseDataVO.setSuspectCount(0L);
                            }else {
                                baseDataVO.setSuspectCount((baseDataVO2.getSuspectCount()
                                        +baseDataVO3.getCount())/2);
                            }
                        }
                    }
                    baseDataVO.setCount(0L);
                    result.add(baseDataVO);
                }
            }
        }else{
            if (monthList.size()>0){
                for (String s : monthList) {
                    BaseDataVO baseDataVO = new BaseDataVO();
                    baseDataVO.setMonth(s);
                    baseDataVO.setSuspectCount(0L);
                    baseDataVO.setCount(0L);
                    baseDataVO.setConfirmCount(0L);
                    result.add(baseDataVO);
                }
            }
        }
        if(allList!=null && allList.size()>0){
            for (BaseDataVO baseDataVO : result) {
                for (BaseDataVO dataVO : allList) {
                    if(StringUtils.isNotBlank(dataVO.getMonth()) && baseDataVO.getMonth().equals(dataVO.getMonth())){
                        if(dataVO.getCount()!=null){
                            baseDataVO.setCount(dataVO.getCount());
                        }
                    }
                }
            }
        }

        if(confirmList!=null && confirmList.size()>0){
            for (BaseDataVO baseDataVO : result) {
                for (BaseDataVO dataVO : confirmList) {
                    if(StringUtils.isNotBlank(dataVO.getMonth()) && baseDataVO.getMonth().equals(dataVO.getMonth())){
                        if(dataVO.getCount()!=null){
                            baseDataVO.setConfirmCount(dataVO.getCount());
                        }
                    }
                }
            }
        }
        return result;
    }

    @Override
    public List<String> getOrigins(Long tid) {
        return baseDataMapper.getOriginsOld(tid);
    }
    @Override
    public List<String> getOrigins(Long tid,  List<Long> typeList) {
        return baseDataMapper.getOrigins(tid,typeList);
    }

    @Override
    public List<Basedata> getBaseDataByType(Long type) {
        return baseDataMapper.getBaseDataByType(Contant.KGJ_TID,type);
    }

    @Override
    public List<WordCloud> analysisKeyWords() {
//        List<Basedata> suspectDataList = baseDataMapper.analysisKeyWords(null);
        List<Map<String,Object>> suspectDataList = baseDataMapper.getWordCloudOld(Contant.KGJ_TID);
        HashMap<String,Integer> resultMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(suspectDataList)){
            for (Map<String,Object> basedata : suspectDataList) {
                if(basedata == null || basedata.get("reliability") ==null){
                    continue;
                }
                String reliability = String.valueOf(basedata.get("reliability"));
                if(StringUtils.isNotBlank(reliability)){
                    String[] split = reliability.split(";");
                    if(split.length>0){
                        for (String s : split) {
                            Integer integer = resultMap.get(s);
                            if(integer == null){
                                resultMap.put(s,1);
                            }else{
                                resultMap.put(s,integer+1);
                            }
                        }
                    }
                }
            }
        }
        List<WordCloud> list = new ArrayList<>();
        if (resultMap.size()>0){
            HashMap<String, Integer> hashMap = SortUtil.sortHashMap(resultMap);
            Set<Map.Entry<String, Integer>> entries = hashMap.entrySet();
            for (Map.Entry<String, Integer> map :entries) {
                WordCloud wordCloud = new WordCloud();
                wordCloud.setName(map.getKey());
                wordCloud.setValue(map.getValue());
                list.add(wordCloud);
            }
        }
        return list;
    }

    /**
     * 词云
     * @param typeList
     * @return
     */
    @Override
    public List<WordCloud> analysisKeyWords(List<Long> typeList) {
//        List<Basedata> suspectDataList = baseDataMapper.analysisKeyWords(null);
        List<Map<String,Object>> suspectDataList = baseDataMapper.getWordCloud(Contant.KGJ_TID,typeList);
        List<CesSysSecret> cesSysSecretList = secretService.list();
        Map<String, String> secretMap = cesSysSecretList.stream().collect(Collectors.toMap(CesSysSecret::getContent, CesSysSecret::getId, (k1, k2) -> k2));
        HashMap<String,Integer> resultMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(suspectDataList)){
            for (Map<String,Object> basedata : suspectDataList) {
                if(basedata == null || basedata.get("reliability") ==null){
                    continue;
                }
                String reliability = String.valueOf(basedata.get("reliability"));
                if(StringUtils.isNotBlank(reliability)){
                    String[] split = reliability.split(";");
                    if(split.length>0){
                        for (String s : split) {
                            if(secretMap.get(s)==null){
                                //不存在密点库中，则不处理
                                continue;
                            }
                            Integer integer = resultMap.get(s);
                            if(integer == null){
                                resultMap.put(s,1);
                            }else{
                                resultMap.put(s,integer+1);
                            }
                        }
                    }
                }
            }
        }
        List<WordCloud> list = new ArrayList<>();
        if (resultMap.size()>0){
            HashMap<String, Integer> hashMap = SortUtil.sortHashMap(resultMap);
            Set<Map.Entry<String, Integer>> entries = hashMap.entrySet();
            for (Map.Entry<String, Integer> map :entries) {
                WordCloud wordCloud = new WordCloud();
                wordCloud.setName(map.getKey());
                wordCloud.setValue(map.getValue());
                list.add(wordCloud);
            }
        }
        return list;
    }

    @Override
    public BaseDataVO getDataByOrigin(String origin, Long type) {
        BaseDataVO vo = new BaseDataVO();
        Long count = baseDataMapper.getDatasbyOrigin(Contant.KGJ_TID, type, origin);
        vo.setCount(count);
        vo.setDelflag(type);
        vo.setOrigin(origin);
        return vo;
    }

    @Override
    public BaseDataVO getSuspectData(String origin, Long type) {
        BaseDataVO vo = new BaseDataVO();
        //确认数据
        Long confirmCount = baseDataMapper.getDatasbyOrigin(Contant.KGJ_TID,Contant.CONFIRM_DELFLAG, origin);
        //爬取数据
        Long datasbyOrigin = baseDataMapper.getDatasbyOrigin(Contant.KGJ_TID,type, origin);
        //疑似数据
        Long suspectOrigin = baseDataMapper.getDatasbyOrigin(Contant.KGJ_TID, Contant.SUSPECT_DELFLAG, origin);
        vo.setOrigin(origin);
        vo.setCount(datasbyOrigin);
        vo.setConfirmCount(confirmCount);
        vo.setSuspectCount(suspectOrigin);
        return vo;
    }

    private Basedata copyUpdateParam (Basedata basedata){
            Basedata raw = baseDataMapper.selectById(Long.parseLong(basedata.getId()));
            //此处一般需要删除或者修改代码,设置更新参数  开始
            if (basedata.getId() != null) {
                raw.setId(basedata.getId());
            }
            if (basedata.getOrgId() != null) {
                raw.setOrgId(basedata.getOrgId());
            }
            if (basedata.getTitle() != null && basedata.getTitle().length() > 0) {
                raw.setTitle(basedata.getTitle());
            }
            if (basedata.getTid() != null) {
                raw.setTid(basedata.getTid());
            }
            if (basedata.getSummary() != null && basedata.getSummary().length() > 0) {
                raw.setSummary(basedata.getSummary());
            }
            if (basedata.getKeywords() != null) {
                raw.setKeywords(basedata.getKeywords().replace(" ", "\n"));
            } else {
                raw.setKeywords(basedata.getKeywords());
            }
            if (basedata.getAuthor() != null && basedata.getAuthor().length() > 0) {
                raw.setAuthor(basedata.getAuthor());
            }
            if (basedata.getSourcesite() != null && basedata.getSourcesite().length() > 0) {
                raw.setSourcesite(basedata.getSourcesite());
            }
            if (basedata.getType() != null && basedata.getType().length() > 0) {
                raw.setType(basedata.getType());
            }
            if (basedata.getLang() != null && basedata.getLang().length() > 0) {
                raw.setLang(basedata.getLang());
            }
            if (basedata.getPublishDate() != null && basedata.getPublishDate().length() > 0) {
                raw.setPublishDate(basedata.getPublishDate());
            } else {
                basedata.setPublishDate(basedata.getCreateDate());
            }
            if (basedata.getSourceaddress() != null && basedata.getSourceaddress().length() > 0) {
                raw.setSourceaddress(basedata.getSourceaddress());
            }
            if (basedata.getWithtagfile() != null && basedata.getWithtagfile().length() > 0) {
                raw.setWithtagfile(basedata.getWithtagfile());
            }
            if (basedata.getCreateBy() != null && basedata.getCreateBy().length() > 0) {
                raw.setCreateBy(basedata.getCreateBy());
            }
            if (basedata.getCreateDate() != null && basedata.getCreateDate().length() > 0) {
                raw.setCreateDate(basedata.getCreateDate());
            }
            if (basedata.getContent() != null && basedata.getContent().length() > 0) {
                raw.setContent(basedata.getContent());
                //无标签内容添加
//                String contentstr = Utility.TransferHTML2Text(basedata.getContent());
                raw.setContentNoTag(basedata.getContent());
                //图片内容保存
                raw.setContentImgCvtTag(basedata.getContent());
            }
            if (basedata.getIsdelete() != null) {
                raw.setIsdelete(basedata.getIsdelete());
            }
            if (basedata.getOrigin() != null) {
                raw.setOrigin(basedata.getOrigin());
            }
            if (basedata.getReliability() != null && basedata.getReliability().length() > 0) {
                raw.setReliability(basedata.getReliability());
            }
            if (basedata.getInfluence() != null && basedata.getInfluence().length() > 0) {
                raw.setInfluence(basedata.getInfluence());
            }
            if (basedata.getBtId() != null && basedata.getBtId().toString().length() > 0) {
                raw.setBtId(basedata.getBtId());
            }
            if (basedata.getOrientation() != null && basedata.getOrientation().length() > 0) {
                raw.setOrientation(basedata.getOrientation());
            }
            if (basedata.getFromWhere() != null) {
                raw.setFromWhere(basedata.getFromWhere());
            }
            if (basedata.getRelatePlaces() != null && basedata.getRelatePlaces().trim().length() > 0) {
                raw.setRelatePlaces(basedata.getRelatePlaces());
            }
            if (basedata.getSid() != null) {
                raw.setSid(basedata.getSid());
            }
            if (basedata.getLocale() != null && basedata.getLocale().trim().length() > 0) {
                raw.setLocale(basedata.getLocale());
            }
            //设置更新参数  结束
            return raw;
        }
    @Override
    public Long getserialno(){
        Map<String,String> map = new HashMap<>();
        map.put("serialNo", null);
        map.put("e", null);
        baseDataMapper.getserialno(map);
        String error = map.get("e");
        if(error==null){
            return Long.valueOf(map.get("serialNo"));
        }else
        {
            return null;
        }
    }

    @Override
    public List<BaseDataVO> getAllCorpDataList(Long tid, List<Long> typeList) {
        return baseDataMapper.getAllCorpDataList(tid,Contant.SUSPECT_DELFLAG,Contant.CONFIRM_DELFLAG,typeList);
    }

    /**
     * 预警信息
     * @param pageIndex 当前页码
     * @param pageSize 每页条数
     * @param tid 科工局
     * @param type 类型
     * @return
     */
    @Override
    public List<Map<String, Object>> getWarningData(int pageIndex, int pageSize, Long tid, Long type) {
        int offset = (pageIndex-1)*pageSize;
        List<Map<String, Object>> list = baseDataMapper.getWarningDataOld(offset,offset+pageSize,tid,type);
        return list;
    }
    /**
     * 获取预警信息
     * @param pageIndex 当前页码
     * @param pageSize 每页条数
     * @param tid 科工局
     * @param type 类型
     * @param secretLevel 风险等级
     * @return
     */
    @Override
    public List<Map<String, Object>> getWarningData(int pageIndex, int pageSize, Long tid, Long type,Long secretLevel,List<Long> typeList,Long siteId) {
        int offset = (pageIndex-1)*pageSize;
        List<Map<String, Object>> list = baseDataMapper.getWarningData(offset,offset+pageSize,tid,type,secretLevel,typeList,siteId);
        return list;
    }

    /**
     * 地图所需要的数据
     * @param tid 科工局
     * @param type 类型
     * @return
     */
    @Override
    public List<Map<String, String>> getMapData(Long tid, Long type) {
        List<Map<String, String>> result =baseDataMapper.getMapDataOld(tid,type);
        return result;
    }
    /**
     * 地图所需要的数据
     * @param tid 科工局
     * @param type 类型
     * @param level 类型等级
     * @return
     */
    @Override
    public List<Map<String, String>> getMapData(Long tid, Long type,Long level,List<Long> typeList) {
        List<Map<String, String>> result =baseDataMapper.getMapData(tid,type,level,typeList);
        return result;
    }

    /**
     * 词云更多
     * @param searchKey
     * @param typeId
     * @return
     */
    @Override
    public List<WordCloud> wordCloudMore(String searchKey, String typeId) {
        QueryWrapper<CesSysSecret> queryWrapper = new QueryWrapper<>();
        if(StringUtils.isNotBlank(searchKey)){
            queryWrapper.like("CONTENT",searchKey);
        }
        if(StringUtils.isNotBlank(typeId)){
            queryWrapper.eq("TYPE_ID",typeId);
        }
        List<CesSysSecret> cesSysSecretList = secretMapper.selectList(queryWrapper);
//        CesSysSecret cesSysSecret = new CesSysSecret();
//        cesSysSecret.setContent(searchKey);
//        cesSysSecret.setTypeId(typeId);
//        List<String> cesSysSecretList = secretMapper.queryByCondition(cesSysSecret);

        List<WordCloud> list = new ArrayList<>();
        if(CollectionUtils.isEmpty(cesSysSecretList)){
            //密点为空，直接返回
            return list;
        }
        //密点不为空
        Map<String, Integer> secretMap = new HashMap<>();
        for (CesSysSecret s : cesSysSecretList) {
            if(s!=null){
                if(StringUtils.isNotBlank(s.getContent())){
                    secretMap.put(s.getContent().trim(),0);
                }else {
                    secretMap.put(s.getContent(),0);
                }
            }
        }
//        Map<String, Integer> secretMap = cesSysSecretList.stream().collect(Collectors.toMap(content -> {
//            if(StringUtils.isNotBlank(content)){
//                return content.trim();
//            }
//            return content;
//        }, Integer.valueOf(0),(k1,k2)->k2));
        List<Map<String,Object>> suspectDataList = baseDataMapper.getWordCloudOld(Contant.KGJ_TID);
        if (CollectionUtils.isNotEmpty(suspectDataList)){
            for (Map<String,Object> basedata : suspectDataList) {
                if(basedata == null || basedata.get("reliability") ==null){
                    continue;
                }
                String reliability = String.valueOf(basedata.get("reliability"));
                if(StringUtils.isNotBlank(reliability)){
                    String[] split = reliability.split(";");
                    if(split.length>0){
                        for (String s : split) {
                            if(StringUtils.isNotBlank(s)){
                                String trim = s.trim();
                                Integer integer = secretMap.get(trim);
                                if(integer!=null){
                                    secretMap.put(trim,integer+1);
                                }
//                                if(integer == null){
//                                    secretMap.put(trim,1);
//                                }else{
//                                    secretMap.put(trim,integer+1);
//                                }
                            }
                        }
                    }
                }
            }
        }
        if (secretMap.size()>0){
//            HashMap<String, Integer> hashMap = SortUtil.sortHashMap(secretMap);
//            Set<Map.Entry<String, Integer>> entries = hashMap.entrySet();
            for (Map.Entry<String, Integer> map :secretMap.entrySet()) {
                WordCloud wordCloud = new WordCloud();
                wordCloud.setName(map.getKey());
                wordCloud.setValue(map.getValue());
                list.add(wordCloud);
            }
        }
        return list;
    }
    @Override
    public List<WordCloud> wordCloudMore(String searchKey, String typeId,List<Long> typeList) {
        QueryWrapper<CesSysSecret> queryWrapper = new QueryWrapper<>();
        if(StringUtils.isNotBlank(searchKey)){
            queryWrapper.like("CONTENT",searchKey);
        }
        if(StringUtils.isNotBlank(typeId)){
            queryWrapper.eq("TYPE_ID",typeId);
        }
        List<CesSysSecret> cesSysSecretList = secretMapper.selectList(queryWrapper);
//        CesSysSecret cesSysSecret = new CesSysSecret();
//        cesSysSecret.setContent(searchKey);
//        cesSysSecret.setTypeId(typeId);
//        List<String> cesSysSecretList = secretMapper.queryByCondition(cesSysSecret);

        List<WordCloud> list = new ArrayList<>();
        if(CollectionUtils.isEmpty(cesSysSecretList)){
            //密点为空，直接返回
            return list;
        }
        //密点不为空
        Map<String, Integer> secretMap = new HashMap<>();
        for (CesSysSecret s : cesSysSecretList) {
            if(s!=null){
                if(StringUtils.isNotBlank(s.getContent())){
                    secretMap.put(s.getContent().trim(),0);
                }else {
                    secretMap.put(s.getContent(),0);
                }
            }
        }
//        Map<String, Integer> secretMap = cesSysSecretList.stream().collect(Collectors.toMap(content -> {
//            if(StringUtils.isNotBlank(content)){
//                return content.trim();
//            }
//            return content;
//        }, Integer.valueOf(0),(k1,k2)->k2));
        List<Map<String,Object>> suspectDataList = baseDataMapper.getWordCloud(Contant.KGJ_TID,typeList);
        if (CollectionUtils.isNotEmpty(suspectDataList)){
            for (Map<String,Object> basedata : suspectDataList) {
                if(basedata == null || basedata.get("reliability") ==null){
                    continue;
                }
                String reliability = String.valueOf(basedata.get("reliability"));
                if(StringUtils.isNotBlank(reliability)){
                    String[] split = reliability.split(";");
                    if(split.length>0){
                        for (String s : split) {
                            if(StringUtils.isNotBlank(s)){
                                String trim = s.trim();
                                Integer integer = secretMap.get(trim);
                                if(integer!=null){
                                    secretMap.put(trim,integer+1);
                                }
//                                if(integer == null){
//                                    secretMap.put(trim,1);
//                                }else{
//                                    secretMap.put(trim,integer+1);
//                                }
                            }
                        }
                    }
                }
            }
        }
        if (secretMap.size()>0){
//            HashMap<String, Integer> hashMap = SortUtil.sortHashMap(secretMap);
//            Set<Map.Entry<String, Integer>> entries = hashMap.entrySet();
            for (Map.Entry<String, Integer> map :secretMap.entrySet()) {
                WordCloud wordCloud = new WordCloud();
                wordCloud.setName(map.getKey());
                wordCloud.setValue(map.getValue());
                list.add(wordCloud);
            }
        }
        return list;
    }

    /**
     * 信息排行
     * @param tid
     * @param typeList
     * @return
     */
    @Override
    public List<BaseDataVO> getSuspectDataNew(Long tid,  List<Long> typeList) {
        List<BaseDataVO> result=new ArrayList<>();
        //爬取信息
        List<BaseDataVO> allData = baseDataMapper.getSuspectDataNew(tid,null,typeList);
        if(CollectionUtils.isEmpty(allData)){
            //如果爬取的数据为空，直接返回
            return result;
        }
        //疑似信息
        List<BaseDataVO> suspectData = baseDataMapper.getSuspectDataNew(tid,Contant.SUSPECT_DELFLAG,typeList);
        //确认信息
        List<BaseDataVO> confirmData = baseDataMapper.getSuspectDataNew(tid,Contant.CONFIRM_DELFLAG,typeList);
        //爬取数据
        Map<String, BaseDataVO> allCollect = allData.stream().
                collect(Collectors.toMap(BaseDataVO::getOrigin, baseDataVO -> baseDataVO, (k1, k2) -> k2));
        //疑似数据
        Map<String, BaseDataVO> suspectCollect =new HashMap<>();
        if(CollectionUtils.isNotEmpty(suspectData)){
            suspectCollect =  suspectData.stream().
                    collect(Collectors.toMap(BaseDataVO::getOrigin, baseDataVO -> baseDataVO, (k1, k2) -> k2));
        }
        //确认数据
        Map<String, BaseDataVO> confirmCollect =new HashMap<>();
        if(CollectionUtils.isNotEmpty(confirmData)){
            confirmCollect =  confirmData.stream().
                    collect(Collectors.toMap(BaseDataVO::getOrigin, baseDataVO -> baseDataVO, (k1, k2) -> k2));
        }
        for (String origin : allCollect.keySet()) {
            BaseDataVO baseDataVO = allCollect.get(origin);
            BaseDataVO baseDataVO1 = suspectCollect.get(origin);
            BaseDataVO baseDataVO2 = confirmCollect.get(origin);
            if(baseDataVO1 !=null && baseDataVO1.getCount()!=null){
                baseDataVO.setSuspectCount(baseDataVO1.getCount());
            }else{
                baseDataVO.setSuspectCount(0L);
            }
            if(baseDataVO2 !=null && baseDataVO2.getCount()!=null){
                baseDataVO.setConfirmCount(baseDataVO2.getCount());
            }else{
                baseDataVO.setConfirmCount(0L);
            }

            result.add(baseDataVO);
        }
        return result;
    }
    @Override
    public List<BaseDataVO> getSuspectDataBytypeid(Long tid,  List<Long> typeList) {
        List<BaseDataVO> result=new ArrayList<>();
        //爬取信息
        List<BaseDataVO> allData = baseDataMapper.getSuspectDataBytypeid(tid,null,typeList);
        if(CollectionUtils.isEmpty(allData)){
            //如果爬取的数据为空，直接返回
            return result;
        }
        //疑似信息
        List<BaseDataVO> suspectData = baseDataMapper.getSuspectDataBytypeid(tid,Contant.SUSPECT_DELFLAG,typeList);
        //确认信息
        List<BaseDataVO> confirmData = baseDataMapper.getSuspectDataBytypeid(tid,Contant.CONFIRM_DELFLAG,typeList);
        //爬取数据
        Map<String, BaseDataVO> allCollect = allData.stream().
                collect(Collectors.toMap(BaseDataVO::getSiteTypeName, baseDataVO -> baseDataVO, (k1, k2) -> k2));
        //疑似数据
        Map<String, BaseDataVO> suspectCollect =new HashMap<>();
        if(CollectionUtils.isNotEmpty(suspectData)){
            suspectCollect =  suspectData.stream().
                    collect(Collectors.toMap(BaseDataVO::getSiteTypeName, baseDataVO -> baseDataVO, (k1, k2) -> k2));
        }
        //确认数据
        Map<String, BaseDataVO> confirmCollect =new HashMap<>();
        if(CollectionUtils.isNotEmpty(confirmData)){
            confirmCollect =  confirmData.stream().
                    collect(Collectors.toMap(BaseDataVO::getSiteTypeName, baseDataVO -> baseDataVO, (k1, k2) -> k2));
        }
        for (String origin : allCollect.keySet()) {
            BaseDataVO baseDataVO = allCollect.get(origin);
            BaseDataVO baseDataVO1 = suspectCollect.get(origin);
            BaseDataVO baseDataVO2 = confirmCollect.get(origin);
            if(baseDataVO1 !=null && baseDataVO1.getCount()!=null){
                baseDataVO.setSuspectCount(baseDataVO1.getCount());
            }else{
                baseDataVO.setSuspectCount(0L);
            }
            if(baseDataVO2 !=null && baseDataVO2.getCount()!=null){
                baseDataVO.setConfirmCount(baseDataVO2.getCount());
            }else{
                baseDataVO.setConfirmCount(0L);
            }

            result.add(baseDataVO);
        }
        return result;
    }
    /**
     * 获取列表
     * @return
     */
    @Override
    public List<Basedata> selectIds() {
        List<Basedata> basedataList= baseDataMapper.selectIds();
        return basedataList;
    }



}
