package com.zzsn.modules.kgj.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.modules.kgj.entity.CesSysWeb;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.modules.kgj.entity.DTO.CesSysWebDto;
import com.zzsn.modules.kgj.entity.VO.CesSysWebVo;

import java.util.List;

/**
 * @Description: 网站信息源
 * @Author: zzsn-boot
 * @Date:   2020-10-21
 * @Version: V1.0
 */
public interface ICesSysWebService extends IService<CesSysWeb> {

    boolean isExist(CesSysWeb cesSysWeb);

    /**
     * 新增网站
     * @param cesSysWebDto
     */
    String add(CesSysWebDto cesSysWebDto);

    /**
     * 编辑保存
     * @param cesSysWebDto
     * @return
     */
    String edit(CesSysWebDto cesSysWebDto);

    /**
     * 根据ID删除
     * @param id
     * @return
     */
    String delete(String id);

    /**
     * 根据ID 批量删除
     * @param ids
     * @return
     */
    String deleteByIds(String ids);

    /**
     * 带分页的列表
     * @param page
     * @param cesSysWebDto
     * @return
     */
    IPage<CesSysWebDto> selectByPage(Page<CesSysWebDto> page, CesSysWebDto cesSysWebDto);

    List<CesSysWebVo> getWebSites(Long typeId);

    Long getWebSiteCount(Long typeId, Long pTypeId);
}
