/*
 * Decompiled with CFR 0.152.
 */
package com.zzsn.modules.system.model;

import com.zzsn.modules.system.entity.SysPermission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TreeModel
implements Serializable {
    private static final long serialVersionUID = 4013193970046502756L;
    private String key;
    private String title;
    private String slotTitle;
    private boolean isLeaf;
    private String icon;
    private Integer ruleFlag;
    private Map<String, String> scopedSlots;
    private List<TreeModel> children;
    private Double position;
    private String parentId;
    private String label;
    private String value;

    public Map<String, String> getScopedSlots() {
        return this.scopedSlots;
    }

    public void setScopedSlots(Map<String, String> scopedSlots) {
        this.scopedSlots = scopedSlots;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean getIsLeaf() {
        return this.isLeaf;
    }

    public void setIsLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public List<TreeModel> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeModel> children) {
        this.children = children;
    }

    public void setPosition(Double position) {
        this.position = position;
    }

    public Double getPosition() {
        return this.position;
    }

    public TreeModel() {
    }

    public TreeModel(SysPermission permission) {
        this.key = permission.getId();
        this.icon = permission.getIcon();
        this.parentId = permission.getParentId();
        this.title = permission.getName();
        this.slotTitle = permission.getName();
        this.value = permission.getId();
        this.isLeaf = permission.isLeaf();
        this.label = permission.getName();
        this.position = permission.getSortNo();
        if (!permission.isLeaf()) {
            this.children = new ArrayList<TreeModel>();
        }
    }

    public TreeModel(String key, String parentId, String slotTitle, Integer ruleFlag, boolean isLeaf) {
        this.key = key;
        this.parentId = parentId;
        this.ruleFlag = ruleFlag;
        this.slotTitle = slotTitle;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", "hasDatarule");
        this.scopedSlots = map;
        this.isLeaf = isLeaf;
        this.value = key;
        if (!isLeaf) {
            this.children = new ArrayList<TreeModel>();
        }
    }

    public TreeModel(String key, String parentId, String slotTitle, Integer ruleFlag, boolean isLeaf, Double position) {
        this.key = key;
        this.parentId = parentId;
        this.ruleFlag = ruleFlag;
        this.slotTitle = slotTitle;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", "hasDatarule");
        this.scopedSlots = map;
        this.isLeaf = isLeaf;
        this.value = key;
        if (!isLeaf) {
            this.children = new ArrayList<TreeModel>();
        }
        this.position = position;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getSlotTitle() {
        return this.slotTitle;
    }

    public void setSlotTitle(String slotTitle) {
        this.slotTitle = slotTitle;
    }

    public Integer getRuleFlag() {
        return this.ruleFlag;
    }

    public void setRuleFlag(Integer ruleFlag) {
        this.ruleFlag = ruleFlag;
    }

    public void sortChildren() {
        this.children.sort((m1, m2) -> {
            double orderBy1 = m1.getPosition();
            double orderBy2 = m2.getPosition();
            return Double.compare(orderBy1, orderBy2);
        });
        for (TreeModel t : this.children) {
            if (t == null || t.getChildren() == null) continue;
            t.sortChildren();
        }
    }
}

