/*
 * Decompiled with CFR 0.152.
 */
package com.zzsn.modules.system.aspect;

import com.zzsn.common.aspect.annotation.PermissionData;
import com.zzsn.common.system.util.JeecgDataAutorUtils;
import com.zzsn.common.system.util.JwtUtil;
import com.zzsn.common.system.vo.SysPermissionDataRuleModel;
import com.zzsn.common.system.vo.SysUserCacheInfo;
import com.zzsn.common.util.SpringContextUtils;
import com.zzsn.common.util.oConvertUtils;
import com.zzsn.modules.api.SysUserRemoteApi;
import com.zzsn.modules.system.entity.SysPermission;
import com.zzsn.modules.system.entity.SysPermissionDataRule;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PermissionDataAspect {
    private static final Logger log = LoggerFactory.getLogger(PermissionDataAspect.class);
    @Autowired
    private SysUserRemoteApi sysUserRemoteApi;

    @Pointcut(value="@annotation(com.zzsn.common.aspect.annotation.PermissionData)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object arround(ProceedingJoinPoint point) throws Throwable {
        HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        PermissionData pd = method.getAnnotation(PermissionData.class);
        String component = pd.pageComponent();
        this.authDataHandler(request, component);
        return point.proceed();
    }

    private void authDataHandler(HttpServletRequest request, String component) {
        List<SysPermission> currentSyspermission = null;
        if (oConvertUtils.isNotEmpty((Object)component)) {
            currentSyspermission = this.sysUserRemoteApi.queryComponentPermission(component);
        } else {
            String requestMethod = request.getMethod();
            String requestPath = request.getRequestURI().substring(request.getContextPath().length());
            requestPath = this.filterUrl(requestPath);
            log.info("\u62e6\u622a\u8bf7\u6c42 >> " + requestPath + ";\u8bf7\u6c42\u7c7b\u578b >> " + requestMethod);
            currentSyspermission = this.sysUserRemoteApi.queryRequestPermission(requestMethod, requestPath);
        }
        if (currentSyspermission != null && currentSyspermission.size() > 0) {
            String username = JwtUtil.getUserNameByToken((HttpServletRequest)request);
            List dataRules = new ArrayList();
            for (SysPermission sysPermission : currentSyspermission) {
                List<SysPermissionDataRule> temp = this.sysUserRemoteApi.queryUserDataRule(username, sysPermission.getId());
                if (temp == null || temp.size() <= 0) continue;
                dataRules = oConvertUtils.entityListToModelList(temp, SysPermissionDataRuleModel.class);
            }
            if (dataRules != null && dataRules.size() > 0) {
                JeecgDataAutorUtils.installDataSearchConditon((HttpServletRequest)request, dataRules);
                SysUserCacheInfo userinfo = this.sysUserRemoteApi.getCacheUser(username);
                JeecgDataAutorUtils.installUserInfo((HttpServletRequest)request, (SysUserCacheInfo)userinfo);
            }
        }
    }

    private String filterUrl(String requestPath) {
        String url = "";
        if (oConvertUtils.isNotEmpty((Object)requestPath)) {
            url = requestPath.replace("\\", "/");
            url = requestPath.replace("//", "/");
            if (url.indexOf("//") >= 0) {
                url = this.filterUrl(url);
            }
        }
        return url;
    }

    private String getJgAuthRequsetPath(HttpServletRequest request) {
        String queryString = request.getQueryString();
        String requestPath = request.getRequestURI();
        if (oConvertUtils.isNotEmpty((Object)queryString)) {
            requestPath = requestPath + "?" + queryString;
        }
        if (requestPath.indexOf("&") > -1) {
            requestPath = requestPath.substring(0, requestPath.indexOf("&"));
        }
        if (requestPath.indexOf("=") != -1) {
            requestPath = requestPath.indexOf(".do") != -1 ? requestPath.substring(0, requestPath.indexOf(".do") + 3) : requestPath.substring(0, requestPath.indexOf("?"));
        }
        requestPath = requestPath.substring(request.getContextPath().length() + 1);
        return this.filterUrl(requestPath);
    }

    private boolean moHuContain(List<String> list, String key) {
        for (String str : list) {
            if (!key.contains(str)) continue;
            return true;
        }
        return false;
    }
}

