/*
 * Decompiled with CFR 0.152.
 */
package com.zzsn.common.util.jsonschema;

import com.alibaba.fastjson.JSONObject;
import com.zzsn.common.util.jsonschema.CommonProperty;
import com.zzsn.common.util.jsonschema.JsonSchemaDescrip;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonschemaUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonschemaUtil.class);

    public static JSONObject getJsonSchema(JsonSchemaDescrip descrip, List<CommonProperty> propertyList) {
        JSONObject obj = new JSONObject();
        obj.put("$schema", (Object)descrip.get$schema());
        obj.put("type", (Object)descrip.getType());
        obj.put("title", (Object)descrip.getTitle());
        List<String> requiredArr = descrip.getRequired();
        obj.put("required", requiredArr);
        JSONObject properties = new JSONObject();
        for (CommonProperty commonProperty : propertyList) {
            Map<String, Object> map = commonProperty.getPropertyJson();
            properties.put(map.get("key").toString(), map.get("prop"));
        }
        obj.put("properties", (Object)properties);
        return obj;
    }

    public static JSONObject getSubJsonSchema(String title, List<String> requiredArr, List<CommonProperty> propertyList) {
        JSONObject obj = new JSONObject();
        obj.put("type", (Object)"object");
        obj.put("view", (Object)"tab");
        obj.put("title", (Object)title);
        if (requiredArr == null) {
            requiredArr = new ArrayList<String>();
        }
        obj.put("required", requiredArr);
        JSONObject properties = new JSONObject();
        for (CommonProperty commonProperty : propertyList) {
            Map<String, Object> map = commonProperty.getPropertyJson();
            properties.put(map.get("key").toString(), map.get("prop"));
        }
        obj.put("properties", (Object)properties);
        return obj;
    }
}

