/*
 * Decompiled with CFR 0.152.
 */
package com.zzsn.common.util;

import com.zzsn.common.util.CommonUtils;
import com.zzsn.common.util.oConvertUtils;
import io.minio.MinioClient;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidArgumentException;
import io.minio.errors.InvalidBucketNameException;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidPortException;
import io.minio.errors.NoResponseException;
import io.minio.errors.RegionConflictException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.xmlpull.v1.XmlPullParserException;

public class MinioUtil {
    private static final Logger log = LoggerFactory.getLogger(MinioUtil.class);
    private static String minioUrl;
    private static String minioName;
    private static String minioPass;
    private static String bucketName;
    private static MinioClient minioClient;

    public static void setMinioUrl(String minioUrl) {
        MinioUtil.minioUrl = minioUrl;
    }

    public static void setMinioName(String minioName) {
        MinioUtil.minioName = minioName;
    }

    public static void setMinioPass(String minioPass) {
        MinioUtil.minioPass = minioPass;
    }

    public static void setBucketName(String bucketName) {
        MinioUtil.bucketName = bucketName;
    }

    public static String getMinioUrl() {
        return minioUrl;
    }

    public static String getBucketName() {
        return bucketName;
    }

    public static String upload(MultipartFile file, String bizPath, String customBucket) {
        String file_url = "";
        String newBucket = bucketName;
        if (oConvertUtils.isNotEmpty(customBucket)) {
            newBucket = customBucket;
        }
        try {
            MinioUtil.initMinio(minioUrl, minioName, minioPass);
            if (minioClient.bucketExists(newBucket)) {
                log.info("Bucket already exists.");
            } else {
                minioClient.makeBucket(newBucket);
                log.info("create a new bucket.");
            }
            InputStream stream = file.getInputStream();
            String orgName = file.getOriginalFilename();
            orgName = CommonUtils.getFileName(orgName);
            String objectName = bizPath + "/" + orgName.substring(0, orgName.lastIndexOf(".")) + "_" + System.currentTimeMillis() + orgName.substring(orgName.indexOf("."));
            minioClient.putObject(newBucket, objectName, stream, (long)stream.available(), "application/octet-stream");
            stream.close();
            file_url = minioUrl + newBucket + "/" + objectName;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NoResponseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (XmlPullParserException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (InvalidArgumentException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (RegionConflictException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (InvalidBucketNameException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ErrorResponseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (InternalException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (InsufficientDataException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return file_url;
    }

    public static String upload(MultipartFile file, String bizPath) {
        return MinioUtil.upload(file, bizPath, null);
    }

    public static InputStream getMinioFile(String bucketName, String objectName) {
        InputStream inputStream = null;
        try {
            MinioUtil.initMinio(minioUrl, minioName, minioPass);
            inputStream = minioClient.getObject(bucketName, objectName);
        }
        catch (Exception e) {
            log.info("\u6587\u4ef6\u83b7\u53d6\u5931\u8d25" + e.getMessage());
        }
        return inputStream;
    }

    public static void removeObject(String bucketName, String objectName) {
        try {
            MinioUtil.initMinio(minioUrl, minioName, minioPass);
            minioClient.removeObject(bucketName, objectName);
        }
        catch (Exception e) {
            log.info("\u6587\u4ef6\u5220\u9664\u5931\u8d25" + e.getMessage());
        }
    }

    public static String getObjectURL(String bucketName, String objectName, Integer expires) {
        MinioUtil.initMinio(minioUrl, minioName, minioPass);
        try {
            String url = minioClient.presignedGetObject(bucketName, objectName, expires);
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (Exception e) {
            log.info("\u6587\u4ef6\u8def\u5f84\u83b7\u53d6\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    private static MinioClient initMinio(String minioUrl, String minioName, String minioPass) {
        if (minioClient == null) {
            try {
                minioClient = new MinioClient(minioUrl, minioName, minioPass);
            }
            catch (InvalidEndpointException e) {
                e.printStackTrace();
            }
            catch (InvalidPortException e) {
                e.printStackTrace();
            }
        }
        return minioClient;
    }

    public static String upload(InputStream stream, String relativePath) throws IOException, InvalidKeyException, NoSuchAlgorithmException, InsufficientDataException, InternalException, NoResponseException, InvalidBucketNameException, XmlPullParserException, ErrorResponseException, RegionConflictException, InvalidArgumentException {
        MinioUtil.initMinio(minioUrl, minioName, minioPass);
        if (minioClient.bucketExists(bucketName)) {
            log.info("Bucket already exists.");
        } else {
            minioClient.makeBucket(bucketName);
            log.info("create a new bucket.");
        }
        minioClient.putObject(bucketName, relativePath, stream, (long)stream.available(), "application/octet-stream");
        stream.close();
        return minioUrl + bucketName + "/" + relativePath;
    }

    static {
        minioClient = null;
    }
}

