/*
 * Decompiled with CFR 0.152.
 */
package com.zzsn.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;

public class GatewayUtils {
    public static final String ROUTE_REDIS_RELOAD_TOPIC = "gateway_redis_route_reload_topic";
    public static final String ROUTE_JVM_RELOAD_TOPIC = "gateway_jvm_route_reload_topic";

    public static List<RouteDefinition> getRoutesByJson(JSONArray array) throws URISyntaxException {
        ArrayList<RouteDefinition> ls = new ArrayList<RouteDefinition>();
        for (int i = 0; i < array.size(); ++i) {
            Object filters;
            JSONObject obj = array.getJSONObject(i);
            RouteDefinition route = new RouteDefinition();
            route.setId(obj.getString("id"));
            Object uri = obj.get((Object)"uri");
            if (uri == null) {
                route.setUri(new URI("lb://" + obj.getString("name")));
            } else {
                route.setUri(new URI(obj.getString("uri")));
            }
            Object predicates = obj.get((Object)"predicates");
            if (predicates != null) {
                JSONArray predicatesArray = JSONArray.parseArray((String)predicates.toString());
                List predicateDefinitionList = predicatesArray.toJavaList(PredicateDefinition.class);
                route.setPredicates(predicateDefinitionList);
            }
            if ((filters = obj.get((Object)"filters")) != null) {
                JSONArray filtersArray = JSONArray.parseArray((String)filters.toString());
                List filterDefinitionList = filtersArray.toJavaList(FilterDefinition.class);
                route.setFilters(filterDefinitionList);
            }
            ls.add(route);
        }
        return ls;
    }
}

