/*
 * Decompiled with CFR 0.152.
 */
package com.zzsn.handler;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

@Component
public class HystrixFallbackHandler
implements HandlerFunction<ServerResponse> {
    private static final Logger log = LoggerFactory.getLogger(HystrixFallbackHandler.class);

    public Mono<ServerResponse> handle(ServerRequest serverRequest) {
        Optional originalUris = serverRequest.attribute(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR);
        originalUris.ifPresent(originalUri -> log.error("\u7f51\u5173\u6267\u884c\u8bf7\u6c42:{}\u5931\u8d25,hystrix\u670d\u52a1\u964d\u7ea7\u5904\u7406", originalUri));
        return ((ServerResponse.BodyBuilder)ServerResponse.status((int)HttpStatus.INTERNAL_SERVER_ERROR.value()).header("Content-Type", new String[]{"text/plain; charset=utf-8"})).body(BodyInserters.fromObject((Object)"\u670d\u52a1\u5f02\u5e38"));
    }
}

