/*
 * Decompiled with CFR 0.152.
 */
package com.zzsn.filter;

import java.net.URI;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class GlobalAccessTokenFilter
implements GlobalFilter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(GlobalAccessTokenFilter.class);
    public static final String X_ACCESS_TOKEN = "X-Access-Token";

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        System.out.println("\u5168\u5c40\u767b\u9646\u8fc7\u6ee4\u5668\u5f00\u59cb");
        String url = exchange.getRequest().getURI().getPath();
        log.info("  access url :  " + url);
        ServerWebExchangeUtils.addOriginalRequestUrl((ServerWebExchange)exchange, (URI)exchange.getRequest().getURI());
        String rawPath = exchange.getRequest().getURI().getRawPath();
        String newPath = "/" + Arrays.stream(StringUtils.tokenizeToStringArray((String)rawPath, (String)"/")).skip(1L).collect(Collectors.joining("/"));
        ServerHttpRequest newRequest = exchange.getRequest().mutate().path(newPath).build();
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, newRequest.getURI());
        ServerHttpRequest mutableReq = exchange.getRequest().mutate().header("Authorization-UserName", "").build();
        ServerWebExchange mutableExchange = exchange.mutate().request(mutableReq).build();
        System.out.println("\u5168\u5c40\u767b\u9646\u8fc7\u6ee4\u5668\u7ed3\u675f");
        return chain.filter(mutableExchange);
    }

    public int getOrder() {
        return 0;
    }
}

