package com.zzsn.modules.kgj.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import com.zzsn.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 网站信息源
 * @Author: zzsn-boot
 * @Date:   2020-10-21
 * @Version: V1.0
 */
@Data
@TableName("ces_sys_web")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="ces_sys_web对象", description="网站信息源")
public class CesSysWeb implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ID_WORKER_STR)
    @ApiModelProperty(value = "主键")
    private String id;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private Date updateTime;
	/**网站*/
	@Excel(name = "网站", width = 15)
    @ApiModelProperty(value = "网站")
    private String url;
	/**网站名*/
	@Excel(name = "网站名", width = 15)
    @ApiModelProperty(value = "网站名")
    private String name;
	/**地点*/
	@Excel(name = "地点", width = 15)
    @ApiModelProperty(value = "地点")
    private String local;

    /**网址类型:1:科工局子机构网址，2：文章关联政府机构网址*/
    @Excel(name = "网站类型", width = 15)
    @ApiModelProperty(value = "网址类型")
    private Long urlType;
    /**开始时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "开始时间")
    private Date startTime;
    /**结束时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "结束时间")
    private Date endTime;

    /** 经纬度，逗号相连 **/
    @Excel(name = "经纬度", width = 15)
    @ApiModelProperty(value = "经纬度")
    private String longitudeLatitude;

    @ApiModelProperty(value = "是否为总公司：1-是，非1-否")
    private Integer isHeadOffice;

    @ApiModelProperty(value = "备注")
    private String remark;
}
