package com.zzsn.modules.system.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import com.zzsn.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 租户界面配置表
 * @Author: zzsn-boot
 * @Date:   2020-08-13
 * @Version: V1.0
 */
@Data
@TableName("sys_tenant_theme")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="sys_tenant_theme对象", description="租户界面配置表")
public class SysTenantTheme implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ID_WORKER_STR)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
	/**①页面通用：标题图标*/
	@Excel(name = "①页面通用：标题图标", width = 15)
    @ApiModelProperty(value = "①页面通用：标题图标")
    private java.lang.String commonFavicon;
	/**②页面通用：系统标题*/
	@Excel(name = "②页面通用：系统标题", width = 15)
    @ApiModelProperty(value = "②页面通用：系统标题")
    private java.lang.String commonTitle;
	/**③登陆界面：系统名称设置*/
	@Excel(name = "③登陆界面：系统名称设置", width = 15)
    @ApiModelProperty(value = "③登陆界面：系统名称设置")
    private java.lang.String loginName;
	/**④登陆界面：系统背景图*/
	@Excel(name = "④登陆界面：系统背景图", width = 15)
    @ApiModelProperty(value = "④登陆界面：系统背景图")
    private java.lang.String loginBg;
	/**⑤登陆界面：底部标识*/
	@Excel(name = "⑤登陆界面：底部标识", width = 15)
    @ApiModelProperty(value = "⑤登陆界面：底部标识")
    private java.lang.String loginFooter;
	/**⑥主界面：系统logo*/
	@Excel(name = "⑥主界面：系统logo", width = 15)
    @ApiModelProperty(value = "⑥主界面：系统logo")
    private java.lang.String mainLogo;
	/**⑦主界面：底部标识*/
	@Excel(name = "⑦主界面：底部标识", width = 15)
    @ApiModelProperty(value = "⑦主界面：底部标识")
    private java.lang.String mainFooter;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;

	@Excel(name = "租户id",width = 36)
    @ApiModelProperty(value = "租户id")
	private String tenantId;
}
