package com.zzsn.modules.kgj.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.modules.kgj.entity.CesSysWeb;
import com.zzsn.modules.kgj.entity.DTO.CesSysWebDto;
import com.zzsn.modules.kgj.entity.SiteTypeMid;
import com.zzsn.modules.kgj.entity.VO.CesSysWebVo;
import com.zzsn.modules.kgj.mapper.CesSysWebMapper;
import com.zzsn.modules.kgj.mapper.SiteTypeMidMapper;
import com.zzsn.modules.kgj.service.ICesSysWebService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.List;

/**
 * @Description: 网站信息源
 * @Author: zzsn-boot
 * @Date:   2020-10-21
 * @Version: V1.0
 */
@Service
public class CesSysWebServiceImpl extends ServiceImpl<CesSysWebMapper, CesSysWeb> implements ICesSysWebService {

    private Logger logger = LoggerFactory.getLogger(CesSysWebServiceImpl.class);

    @Autowired
    private CesSysWebMapper webMapper;

    @Autowired
    private SiteTypeMidMapper typeMidMapper;

    @Override
    public boolean isExist(CesSysWeb cesSysWeb) {
        QueryWrapper<CesSysWeb> wrapper = new QueryWrapper<>();
        wrapper.eq("URL",cesSysWeb.getUrl());
        if (cesSysWeb.getId() != null) {
            wrapper.ne("id", cesSysWeb.getId());
        }
//        wrapper.ne("url_type",2);
        int count = count(wrapper);
        return count(wrapper) > 0;
    }

    /**
     * 新增网站
     * @param cesSysWebDto
     */
    @Override
    @Transactional
    public String add(CesSysWebDto cesSysWebDto) {
        logger.info("新增网站！");
        CesSysWeb cesSysWeb = new CesSysWeb();
        BeanUtils.copyProperties(cesSysWebDto,cesSysWeb);
        if(StringUtils.isNotBlank(cesSysWeb.getUrl())){
            //去除网址后边最后一个斜杠'/'
            if(cesSysWeb.getUrl().endsWith("/")){
                cesSysWeb.setUrl(cesSysWeb.getUrl().substring(0,cesSysWeb.getUrl().length()-1));
            }
        }
        if(isExist(cesSysWeb)){
            return "网址已经存在";
        }
//        cesSysWeb.setUrlType(1L);
        //1.先插入网站表
        int i = webMapper.insert(cesSysWeb);
        if(i!=1){
            logger.info("插入网站表失败");
            throw new RuntimeException("新增网站失败！");
        }
        //2.插入网站和类型关联表
        SiteTypeMid siteTypeMid = new SiteTypeMid();
        siteTypeMid.setSiteId(cesSysWeb.getId());
        siteTypeMid.setTypeId(cesSysWebDto.getSiteTypeId());
        int insert = typeMidMapper.insert(siteTypeMid);
        if(insert !=1){
            logger.info("插入网站类型关联表失败");
            throw new RuntimeException("新增网站失败！");
        }
        return "添加成功！";
    }

    /**
     * 编辑保存
     * @param cesSysWebDto
     * @return
     */
    @Override
    @Transactional
    public String edit(CesSysWebDto cesSysWebDto) {
        logger.info("网站信息编辑保存,参数是：{}",cesSysWebDto);
        CesSysWeb cesSysWeb = new CesSysWeb();
        BeanUtils.copyProperties(cesSysWebDto,cesSysWeb);
        if(StringUtils.isNotBlank(cesSysWeb.getUrl())){
            //去除网址后边最后一个斜杠'/'
            if(cesSysWeb.getUrl().endsWith("/")){
                cesSysWeb.setUrl(cesSysWeb.getUrl().substring(0,cesSysWeb.getUrl().length()-1));
            }
        }
        if(isExist(cesSysWeb)){
            return "网址已经存在";
        }
        //1.更新网站信息
        int i = webMapper.updateById(cesSysWeb);
        if(i!=1){
            logger.info("更新网站信息表失败！");
            throw new RuntimeException("更新网站信息失败！");
        }
        QueryWrapper<SiteTypeMid> midQueryWrapper = new QueryWrapper<>();
        midQueryWrapper.eq("SITEID",cesSysWeb.getId());
        //2.删除关联表中网站和类型的记录
        typeMidMapper.delete(midQueryWrapper);
        //3.新插入网站和类别关联表
        SiteTypeMid siteTypeMid = new SiteTypeMid();
        siteTypeMid.setSiteId(cesSysWeb.getId());
        siteTypeMid.setTypeId(cesSysWebDto.getSiteTypeId());
        int insert = typeMidMapper.insert(siteTypeMid);
        if(insert !=1){
            logger.info("插入网站类型关联表失败");
            throw new RuntimeException("更新网站失败！");
        }
        return "更新成功！";
    }

    /**
     * 根据ID是删除网站信息
     * @param id
     * @return
     */
    @Override
    @Transactional
    public String delete(String id) {
        logger.info("根据ID删除网站记录,id是：{}",id);
        //1.先删除网站表记录
        int i = webMapper.deleteById(id);
//        if(i!=1){
//            logger.info("删除失败，{}",id);
//            throw new RuntimeException("删除失败！");
//        }
        //2.删除网站和类型关联表
        QueryWrapper<SiteTypeMid> midQueryWrapper = new QueryWrapper<>();
        midQueryWrapper.eq("SITEID",id);
        typeMidMapper.delete(midQueryWrapper);
        return "删除成功！";
    }

    /**
     * 根据ID批量删除
     * @param ids
     * @return
     */
    @Override
    public String deleteByIds(String ids) {
        logger.info("批量删除网站信息！ids是：{}",ids);
        List<String> stringList = Arrays.asList(ids.split(","));
        //1.删除网站信息表
        int i = webMapper.deleteBatchIds(stringList);
//        if(i<1){
//            logger.info("批量删除网站信息失败！");
//            throw new RuntimeException("批量删除网站信息失败");
//        }
        //2.删除网站和类型关联表
        QueryWrapper<SiteTypeMid> midQueryWrapper = new QueryWrapper<>();
        midQueryWrapper.in("SITEID",stringList);
        typeMidMapper.delete(midQueryWrapper);
        return "批量删除成功！";
    }

    /**
     * 带分页的列表
     * @param page
     * @param cesSysWebDto
     * @return
     */
    @Override
    public IPage<CesSysWebDto> selectByPage(Page<CesSysWebDto> page, CesSysWebDto cesSysWebDto) {
        IPage<CesSysWebDto> list = webMapper.selectByPage(page, cesSysWebDto);
        return list;
    }

    @Override
    public List<CesSysWebVo> getWebSites(Long typeId) {
        return webMapper.getWebSites(typeId);
    }

    @Override
    public Long getWebSiteCount(Long typeId, Long pTypeId) {
        return webMapper.getWebSiteCount(typeId,pTypeId);
    }
}
