package com.zzsn.modules.kgj.mapper;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.modules.kgj.entity.BaseDataVO;
import com.zzsn.modules.kgj.entity.Basedata;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author 刘凯歌
 * @description:
 * @date 2020/9/27 16:27
 */
//@DS("master")
public interface BaseDataMapper extends BaseMapper<Basedata> {
//    @DS("multi-datasource1")
    Long pagerCount(@Param("basedata") Basedata basedata);
//    @DS("multi-datasource1")
    List<Basedata> pagerData(@Param("offset")long offset,@Param("pageSize")long pageSize,@Param("basedata")Basedata basedata);
//    @DS("multi-datasource1")
    void save(Basedata basedata);
//    @DS("multi-datasource1")
    void updateByExample(Basedata basedata);
//    @DS("multi-datasource1")
    void getserialno(Map<String,String> map);
//    @DS("multi-datasource1")
    Long getDataCountOld(@Param("tid") Long tid,@Param("publishStartTime") String startTime,@Param("publishEndTime") String endTime,@Param("delflag") Long type);
    Long getDataCount(@Param("tid") Long tid,@Param("publishStartTime") String startTime,@Param("publishEndTime") String endTime,@Param("delflag") Long type, @Param("list") List<Long> typeList,@Param("siteId") Long siteId);
//    @DS("multi-datasource1")
    List<BaseDataVO> getDataCountGroupByMonthOld(@Param("tid") Long tid, @Param("publishStartTime") String startTime, @Param("publishEndTime") String endTime, @Param("delflag") Long type);
    List<BaseDataVO> getDataCountGroupByMonth(@Param("tid") Long tid, @Param("publishStartTime") String startTime, @Param("publishEndTime") String endTime, @Param("delflag") Long type, @Param("list") List<Long> typeList);
//    @DS("multi-datasource1")
    List<String> getOriginsOld(@Param("tid") Long tid);
    List<String> getOrigins(@Param("tid") Long tid,@Param("list") List<Long> typeList);
//    @DS("multi-datasource1")
    Long getDatasbyOrigin(@Param("tid") long tid,@Param("delflag") Long type,@Param("origin") String origin);
//    @DS("multi-datasource1")
    List<Basedata> getBaseDataByType(@Param("tid") long tid,@Param("delflag") Long type);
//    @DS("multi-datasource1")
    List<Basedata> analysisKeyWords(@Param("tid") Long tid);
//    @DS("master")
//    @DS("multi-datasource1")
    Basedata queryById(@Param("id") Long id);

    /**
     * 批量通过ID查询
     * @param list
     * @return
     */
    List<Basedata> queryByIds(@Param("list") List<Long> list);

    /**
     * 预警信息
     * @param pageIndex
     * @param pageSize
     * @param tid
     * @param type
     * @return
     */
    List<Map<String, Object>> getWarningDataOld(@Param("offsetFrom") int pageIndex, @Param("offsetEnd") int pageSize, @Param("tid") Long tid, @Param("delflag") Long type);
    /**
     * 获取预警信息
     * @param pageIndex 当前页码
     * @param pageSize 每页条数
     * @param tid 科工局
     * @param type 类型
     * @param secretLevel 风险等级
     * @return
     */
    List<Map<String, Object>> getWarningData(@Param("offsetFrom") int pageIndex, @Param("offsetEnd") int pageSize, @Param("tid") Long tid, @Param("delflag") Long type, @Param("secretLevel") Long secretLevel,@Param("list") List<Long> typeList,@Param("siteId")Long siteId);

    /**
     * 地图信息
     * @param kgjTid
     * @param type
     * @return
     */
    List<Map<String, String>> getMapDataOld(@Param("tid") Long kgjTid,@Param("delflag") Long type);
    List<Map<String, String>> getMapData(@Param("tid") Long kgjTid,@Param("delflag") Long type,@Param("level")Long level,@Param("list") List<Long> typeList);

    /**
     * 获取词云的信息
     * @param kgjTid
     * @return
     */
    List<Map<String, Object>> getWordCloudOld(@Param("tid") Long kgjTid);
    List<Map<String, Object>> getWordCloud(@Param("tid") Long kgjTid,@Param("list") List<Long> typeList);

    List<Map<String, Object>> getKeyWordCloud(@Param("pTypeId")Long pTypeId,@Param("beginTime") String beginTime
                                            ,@Param("endTime")String endTime);

    /**
     * 获取地区数据
     * @param tid
     * @param type
     * @param typeList
     * @return
     */
    List<BaseDataVO> getSuspectDataNew(@Param("tid") Long tid, @Param("delflag") Long  type,@Param("list") List<Long> typeList);

    List<Basedata> selectIds();

    List<BaseDataVO> getAllCorpDataList(@Param("tid")Long tid,@Param("delflag2")Long delflag2, @Param("delflag3") Long delflag3, @Param("list") List<Long> typeList);

    List<BaseDataVO> getSuspectDataBytypeid(@Param("tid") Long tid, @Param("delflag") Long  type,@Param("list") List<Long> typeList);

    List<BaseDataVO> getAllContentDataList(@Param("tid")Long tid,@Param("delflag2")Long delflag2,
                                           @Param("delflag3") Long delflag3,
                                           @Param("pTypeId") Long pTypeId,
                                           @Param("beginTime") String beginTime,@Param("endTime") String endTime);

    List<String> getProvinceList();
}
