package com.zzsn.modules.kgj.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.io.Serializable;

/**
 * @Description: 用户关注网址分类中间表
 * @Author: zzsn-boot
 * @Date:   2021-01-05
 * @Version: V1.0
 */
@Data
@TableName("cis_user_site_type_mid")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="cis_user_site_type_mid对象", description="网址分类中间表")
@KeySequence("seq_cis_user_site_type_mid")
public class UserSiteTypeMid implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(value = "ID",type = IdType.INPUT)
    @ApiModelProperty(value = "主键")
    private Long id;
	/**用户ID*/
    @ApiModelProperty(value = "网址ID")
    @TableField("USER_ID")
    private String userId;
	/**网址类别ID*/
	@Excel(name = "网址类别ID", width = 15)
    @ApiModelProperty(value = "网址类别ID")
    @TableField("SITE_TYPE_ID")
    private Long siteTypeId;
}
