package com.zzsn.modules.kgj.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import com.zzsn.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: MG_SYS_SECRET
 * @Author: zzsn-boot
 * @Date:   2021-03-15
 * @Version: V1.0
 */
@Data
@TableName("mg_sys_secret")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="mg_sys_secret对象", description="MG_SYS_SECRET")
public class MgSysSecret implements Serializable {
    private static final long serialVersionUID = 1L;

    /**主键*/
    @TableId(type = IdType.ID_WORKER_STR)
    @ApiModelProperty(value = "主键")
    private String id;
    /**创建人*/
    @ApiModelProperty(value = "创建人")
    private String createBy;
    /**创建日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;
    /**更新人*/
    @ApiModelProperty(value = "更新人")
    private String updateBy;
    /**更新日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private Date updateTime;
    /**内容*/
    @Excel(name = "内容", width = 15)
    @ApiModelProperty(value = "内容")
    private String content;
    /**密点类型*/
    @Excel(name = "密点类型", width = 15)
    @ApiModelProperty(value = "密点类型")
    private Integer type;
    /**密点分类ID*/
    @Excel(name = "密点分类", width = 15)
    @ApiModelProperty(value = "密点分类ID")
    private String typeId;
    /**密点等级*/
    @Excel(name="密点等级",width = 15)
    @ApiModelProperty(value = "密点等级")
    private Long secretLevel;
    /**密点分类名称*/
    @TableField(exist = false)
    private String typeName;
}
