package com.zzsn.modules.kgj.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.io.Serializable;

/**
 * @Description: 文章网站中间表
 * @Author: zzsn-boot
 * @Date:   2021-01-05
 * @Version: V1.0
 */
@Data
@TableName("cis_basedata_web_mid")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="CIS_BASEDATA_WEB_MID对象", description="文章网站中间表")
@KeySequence("seq_cis_basedata_web_mid")
public class BaseDataWebMid implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(value = "ID",type = IdType.INPUT)
    @ApiModelProperty(value = "主键")
    private Long id;

    /**文章ID*/
    @ApiModelProperty(value = "文章ID")
    @TableField("BID")
    private Long bId;

    /**网站ID*/
    @ApiModelProperty(value = "网站ID")
    @TableField("WEB_ID")
    private String webId;

    /**密点等级*/
    @TableField("SECRET_LEVEL")
    private Long secretLevel;
}
