package com.zzsn.modules.kgj.controller;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.zzsn.common.api.vo.Result;
import com.zzsn.modules.kgj.common.Contant;
import com.zzsn.modules.kgj.entity.SiteType;
import com.zzsn.modules.kgj.entity.SiteTypeMid;
import com.zzsn.modules.kgj.entity.VO.SiteVo;
import com.zzsn.modules.kgj.mapper.BaseDataImageMapper;
import com.zzsn.modules.kgj.service.ISiteTypeMidService;
import com.zzsn.modules.kgj.service.ISiteTypeService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import com.zzsn.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import com.zzsn.common.aspect.annotation.AutoLog;

 /**
 * @Description: 网址分类表
 * @Author: zzsn-boot
 * @Date:   2021-01-05
 * @Version: V1.0
 */
@Api(tags="网址分类表")
@RestController
@RequestMapping("/kgj/siteType")
@Slf4j
public class SiteTypeController extends JeecgController<SiteType, ISiteTypeService> {
	@Autowired
	private ISiteTypeService siteTypeService;

	@Autowired
	private ISiteTypeMidService siteTypeMidService;
	 @Autowired
	 private BaseDataImageMapper imageMapper;
	/**
	 * 分页列表查询
	 *
	 * @param siteType
	 * @param pageNo
	 * @param pageSize
	 * @return
	 */
	@AutoLog(value = "网址分类表-分页查询")
	@ApiOperation(value = "网址分类表-分页查询", notes="网址分类表-根据参数传入的sysUser对象和分页控制参数，对数据进行数据库查询后，封装成page分页对象并返回")
	@GetMapping(value = "")
	public Result<?> queryPageList(SiteType siteType,
								   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
								   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize) {
//		QueryWrapper<SiteType> queryWrapper = QueryGenerator.initQueryWrapper(siteType, req.getParameterMap());
		QueryWrapper<SiteType> queryWrapper = new QueryWrapper<>();
		if(siteType!=null){
			if(StringUtils.isNotBlank(siteType.getChName())){
				queryWrapper.like("CHNAME",siteType.getChName());
			}
		}
		queryWrapper.orderByDesc("CREATE_TIME");
		Page<SiteType> page = new Page<SiteType>(pageNo, pageSize);
		IPage<SiteType> pageList = siteTypeService.page(page, queryWrapper);
		return Result.ok(pageList);
	}
	 /**
	  * 所有分类
	  * @return
	  */
	 @AutoLog(value = "网址分类表-全部分类无分页")
	 @ApiOperation(value = "网址分类表-全部分类无分页", notes="网址分类表-全部数据不带分页")
	 @GetMapping(value = "/all")
	 public Result<?> allList() {
		 QueryWrapper<SiteType> queryWrapper = new QueryWrapper<>();
		 //按照创建时间降序
		 queryWrapper.orderByDesc("CREATE_TIME");
		 List<SiteType> list = siteTypeService.list(queryWrapper);
		 return Result.ok(list);
	 }

	 /**
	  * 十大军工分类
	  * @return
	  */
	 @AutoLog(value = "网址分类表-十大军工分类无分页")
	 @ApiOperation(value = "网址分类表-十大军工分类无分页", notes="网址分类表-十大军工分类不带分页")
	 @GetMapping(value = "/warinds")
	 public Result<?> warinds() {
		 QueryWrapper<SiteType> queryWrapper = new QueryWrapper<>();
		 //按照创建时间降序
		 queryWrapper.orderByDesc("CREATE_TIME");
		 List<SiteType> list = siteTypeService.list(queryWrapper);
		 return Result.ok(list);
	 }

	 /**
	  * 所有分类包含每个分类下边的网站
	  * @return
	  */
	 @AutoLog(value = "网址分类表-全部分类包含每个分类网站")
	 @ApiOperation(value = "网址分类表-全部分类包含每个分类网站", notes="网址分类表-全部分类包含每个分类网站")
	 @GetMapping(value = "/all/site")
	 public Result<?> allSiteList() {
		 List<SiteVo> list = siteTypeService.allSiteList();
		 return Result.ok(list);
	 }
	/**
	 *   添加
	 *
	 * @param siteType
	 * @return
	 */
	@AutoLog(value = "网址分类表-添加")
	@ApiOperation(value="网址分类表-添加", notes="网址分类表-通过参数传入json格式sysUser对象，在数据库中生成一条新的数据")
	@PostMapping(value = "")
	public Result<?> add(@RequestBody SiteType siteType) {
		siteTypeService.save(siteType);
		return Result.ok("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param siteType
	 * @return
	 */
	@AutoLog(value = "网址分类表-编辑")
	@ApiOperation(value="网址分类表-编辑", notes="网址分类表-编辑")
	@PutMapping(value = "")
	public Result<?> edit(@RequestBody SiteType siteType) {
		Validate.notNull(siteType.getId(),"主键ID不能为空");
		if(siteType.getId() == 1){
			//如果是政府网站这个分类，不允许编辑
			return Result.error("政府网站分类不允许编辑");
		}

		//删除图片
		SiteType type = siteTypeService.getById(siteType.getId());
		if (type.getImageId() != null && !StringUtils.equals(type.getImageId(),siteType.getImageId())){
			imageMapper.deleteById(type.getImageId());
		}

		siteTypeService.updateById(siteType);
		return Result.ok("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "网址分类表-通过id删除")
	@ApiOperation(value="网址分类表-通过id删除", notes="网址分类表-通过id删除")
	@DeleteMapping(value = "/{id}")
	public Result<?> delete(@PathVariable("id") Long id) {
		Validate.notNull(id,"主键ID不能为空");
		if(id == 1){
			//如果是政府网站这个分类，不允许删除
			return Result.error("政府网站分类不允许删除");
		}
		//1.查询该分类下边是否有网址
		QueryWrapper<SiteTypeMid> midQueryWrapper = new QueryWrapper<>();
		midQueryWrapper.eq("TYPEID",id);
		int count = siteTypeMidService.count(midQueryWrapper);
		if(count>0){
			return Result.error("该分类下边有网站，不能删除！");
		}
		//删除图片
		SiteType type = siteTypeService.getById(id);
		if (type.getId() != null){
			siteTypeService.removeById(id);
			System.out.println(12);
			System.out.println(234);
			//imageMapper.deleteById(type.getImageId());
		}
		return Result.ok("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "网址分类表-批量删除")
	@ApiOperation(value="网址分类表-批量删除", notes="网址分类表-批量删除")
	@DeleteMapping(value = "")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		if(StringUtils.isBlank(ids)){
			//ids为空
			return Result.error("需要删除的ID不能为空！");
		}
		List<String> strings = Arrays.asList(ids.split(","));
		List<Long> collect = strings.stream().map(s -> {
			if (StringUtils.isNotBlank(s)) {
				return new Long(s);
			}
			return 0L;
		}).collect(Collectors.toList());
		if(collect.contains(1L)){
			//如果是政府网站这个分类，不允许删除
			return Result.error("政府网站分类不允许删除！");
		}
		List<SiteTypeMid> siteTypeMidList = siteTypeMidService.listByIds(collect);
		if(CollectionUtils.isNotEmpty(siteTypeMidList)){
			return Result.error("需要删除的分类下包含网站，不能删除！");
		}
		this.siteTypeService.removeByIds(collect);
		//删除图片
		for (Long id : collect) {
			SiteType type = siteTypeService.getById(id);
			if (type.getImageId() != null){
				imageMapper.deleteById(type.getImageId());
			}
		}
		return Result.ok("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "网址分类表-通过id查询")
	@ApiOperation(value="网址分类表-通过id查询", notes="网址分类表-通过id查询")
	@GetMapping(value = "/{id}")
	public Result<?> queryById(@PathVariable("id")   Long id) {
		SiteType siteType = siteTypeService.getById(id);
		if(siteType==null) {
			return Result.error("未找到对应数据");
		}
		return Result.ok(siteType);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param siteType
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, SiteType siteType) {
        return super.exportXls(request, siteType, SiteType.class, "网址分类表");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, SiteType.class);
    }

}
