package com.zzsn.modules.kgj.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.zzsn.common.api.vo.Result;
import com.zzsn.common.system.query.QueryGenerator;
import com.zzsn.common.util.oConvertUtils;
import com.zzsn.modules.kgj.entity.CesSysSecretType;
import com.zzsn.modules.kgj.service.ICesSysSecretTypeService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.apache.commons.lang.Validate;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import com.zzsn.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import com.zzsn.common.aspect.annotation.AutoLog;

 /**
 * @Description: 密点分类
 * @Author: zzsn-boot
 * @Date:   2020-12-16
 * @Version: V1.0
 */
@Api(tags="密点分类")
@RestController
@RequestMapping("/kgj/cesSysSecretType")
@Slf4j
public class CesSysSecretTypeController extends JeecgController<CesSysSecretType, ICesSysSecretTypeService> {
	@Autowired
	private ICesSysSecretTypeService cesSysSecretTypeService;
	
	/**
	 * 分页列表查询
	 *
	 * @param cesSysSecretType
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "密点分类-分页查询")
	@ApiOperation(value = "密点分类-分页查询", notes="密点分类-根据参数传入的sysUser对象和分页控制参数，对数据进行数据库查询后，封装成page分页对象并返回")
	@GetMapping(value = "")
	public Result<?> queryPageList(CesSysSecretType cesSysSecretType,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<CesSysSecretType> queryWrapper = QueryGenerator.initQueryWrapper(cesSysSecretType, req.getParameterMap());
		Page<CesSysSecretType> page = new Page<CesSysSecretType>(pageNo, pageSize);
		IPage<CesSysSecretType> pageList = cesSysSecretTypeService.page(page, queryWrapper);
		return Result.ok(pageList);
	}

	 /**
	  * 不带分页的所有密点分类信息
	  * @return
	  */
	 @AutoLog(value = "密点分类-全部不带分页查询")
	 @ApiOperation(value = "密点分类-全部不带分页查询", notes="密点分类-全部对象返回")
	 @GetMapping(value = "/all")
	 public Result<?> queryAllList() {
		 List<CesSysSecretType> list = cesSysSecretTypeService.list();
		 return Result.ok(list);
	 }
	/**
	 *   添加
	 *
	 * @param cesSysSecretType
	 * @return
	 */
	@AutoLog(value = "密点分类-添加")
	@ApiOperation(value="密点分类-添加", notes="密点分类-通过参数传入json格式sysUser对象，在数据库中生成一条新的数据")
	@PostMapping(value = "")
	public Result<?> add(@RequestBody CesSysSecretType cesSysSecretType) {
		cesSysSecretTypeService.save(cesSysSecretType);
		return Result.ok("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param cesSysSecretType
	 * @return
	 */
	@AutoLog(value = "密点分类-编辑")
	@ApiOperation(value="密点分类-编辑", notes="密点分类-编辑")
	@PutMapping(value = "")
	public Result<?> edit(@RequestBody CesSysSecretType cesSysSecretType) {
		cesSysSecretTypeService.updateById(cesSysSecretType);
		return Result.ok("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "密点分类-通过id删除")
	@ApiOperation(value="密点分类-通过id删除", notes="密点分类-通过id删除")
	@DeleteMapping(value = "/{id}")
	public Result<?> delete(@PathVariable("id") String id) {
		Validate.notNull(id,"ID不能为空！");
		cesSysSecretTypeService.deleteById(id);
		return Result.ok("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "密点分类-批量删除")
	@ApiOperation(value="密点分类-批量删除", notes="密点分类-批量删除")
	@DeleteMapping(value = "")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.cesSysSecretTypeService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.ok("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "密点分类-通过id查询")
	@ApiOperation(value="密点分类-通过id查询", notes="密点分类-通过id查询")
	@GetMapping(value = "/{id}")
	public Result<?> queryById(@PathVariable("id")   String id) {
		CesSysSecretType cesSysSecretType = cesSysSecretTypeService.getById(id);
		if(cesSysSecretType==null) {
			return Result.error("未找到对应数据");
		}
		return Result.ok(cesSysSecretType);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param cesSysSecretType
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, CesSysSecretType cesSysSecretType) {
        return super.exportXls(request, cesSysSecretType, CesSysSecretType.class, "密点分类");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, CesSysSecretType.class);
    }

}
