package com.zzsn.modules.kgj.common;

import lombok.Data;

import java.io.Serializable;

/**
 * http请求响应体
 */
@Data
public class ResultModel<T> implements Serializable {


    private boolean result;

    /**
     * 返回码
     */
    private int code;

    /**
     * 返回结果描述
     */
    private String msg;

    /**
     * 返回内容
     */
    private T data;

    public ResultModel() {

    }

    public T getData() {
        return  data;
    }


    private ResultModel(boolean result, int code, String msg) {
        this.result = result;
        this.code = code;
        this.msg = msg;

    }

    private ResultModel(boolean result, int code, String msg, T data) {
        this.result = result;
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public static ResultModel<Object> OK(Object data) {
        return new ResultModel<>(true, 200, "成功", data);
    }

    public static ResultModel OK() {
        return new ResultModel(true, 200, "成功");
    }

    public static ResultModel FAIL(String msg) {
        return new ResultModel(false, -200, msg);
    }

    public static ResultModel<Object> OKStr(String data) {
        return new ResultModel<>(true, 200, "成功", data);
    }
}
