package com.zzsn.modules.system.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.zzsn.common.api.vo.Result;
import com.zzsn.common.system.query.QueryGenerator;
import com.zzsn.common.util.oConvertUtils;
import com.zzsn.modules.system.entity.SysTenant;
import com.zzsn.modules.system.service.ISysTenantService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import com.zzsn.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import com.zzsn.common.aspect.annotation.AutoLog;

/**
 * @Description: 租户表
 * @Author: zzsn-boot
 * @Date:   2020-08-10
 * @Version: V1.0
 */
@Api(tags="租户表")
@RestController
@RequestMapping("/sys/sysTenant")
@Slf4j
public class SysTenantController extends JeecgController<SysTenant, ISysTenantService> {
    @Autowired
    private ISysTenantService sysTenantService;

    /**
     * 分页列表查询
     *
     * @param sysTenant
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "租户表-分页查询")
    @ApiOperation(value = "租户表-分页查询", notes="租户表-根据参数传入的sysUser对象和分页控制参数，对数据进行数据库查询后，封装成page分页对象并返回")
    @GetMapping(value = "")
    public Result<?> queryPageList(SysTenant sysTenant,
                                   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
                                   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
                                   HttpServletRequest req) {
        QueryWrapper<SysTenant> queryWrapper = QueryGenerator.initQueryWrapper(sysTenant, req.getParameterMap());
        Page<SysTenant> page = new Page<SysTenant>(pageNo, pageSize);
        IPage<SysTenant> pageList = sysTenantService.page(page, queryWrapper);
        return Result.ok(pageList);
    }

    /**
     *   添加
     *
     * @param sysTenant
     * @return
     */
    @AutoLog(value = "租户表-添加")
    @ApiOperation(value="租户表-添加", notes="租户表-通过参数传入json格式sysUser对象，在数据库中生成一条新的数据")
    @PostMapping(value = "")
    public Result<?> add(@RequestBody SysTenant sysTenant) {
        sysTenantService.save(sysTenant);
        return Result.ok("添加成功！");
    }

    /**
     *  编辑
     *
     * @param sysTenant
     * @return
     */
    @AutoLog(value = "租户表-编辑")
    @ApiOperation(value="租户表-编辑", notes="租户表-编辑")
    @PutMapping(value = "")
    public Result<?> edit(@RequestBody SysTenant sysTenant) {
        sysTenantService.updateById(sysTenant);
        return Result.ok("编辑成功!");
    }

    /**
     *   通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "租户表-通过id删除")
    @ApiOperation(value="租户表-通过id删除", notes="租户表-通过id删除")
    @DeleteMapping(value = "/{id}")
    public Result<?> delete(@PathVariable("id") String id) {
        sysTenantService.removeById(id);
        return Result.ok("删除成功!");
    }

    /**
     *  批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "租户表-批量删除")
    @ApiOperation(value="租户表-批量删除", notes="租户表-批量删除")
    @DeleteMapping(value = "")
    public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
        this.sysTenantService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.ok("批量删除成功!");
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    @AutoLog(value = "租户表-通过id查询")
    @ApiOperation(value="租户表-通过id查询", notes="租户表-通过id查询")
    @GetMapping(value = "/{id}")
    public Result<?> queryById(@PathVariable("id")   String id) {
        SysTenant sysTenant = sysTenantService.getById(id);
        if(sysTenant==null) {
            return Result.error("未找到对应数据");
        }
        return Result.ok(sysTenant);
    }

    /**
     * 导出excel
     *
     * @param request
     * @param sysTenant
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, SysTenant sysTenant) {
        return super.exportXls(request, sysTenant, SysTenant.class, "租户表");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, SysTenant.class);
    }

}
