package com.zzsn.modules.kgj.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.zzsn.modules.kgj.entity.CesSysSecret;
import com.zzsn.modules.kgj.entity.CesSysSecretType;
import com.zzsn.modules.kgj.mapper.CesSysSecretMapper;
import com.zzsn.modules.kgj.mapper.CesSysSecretTypeMapper;
import com.zzsn.modules.kgj.service.ICesSysSecretTypeService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @Description: 密点分类
 * @Author: zzsn-boot
 * @Date:   2020-12-16
 * @Version: V1.0
 */
@Service
public class CesSysSecretTypeServiceImpl extends ServiceImpl<CesSysSecretTypeMapper, CesSysSecretType> implements ICesSysSecretTypeService {
    private Logger logger = LoggerFactory.getLogger(CesSysSecretTypeServiceImpl.class);

    @Autowired
    private CesSysSecretMapper secretMapper;

    @Autowired
    private CesSysSecretTypeMapper secretTypeMapper;

    /**
     * 根据分类ID分类删除
     * @param id
     */
    @Override
    @Transactional
    public void deleteById(String id) {
        logger.info("根据ID删除密点分类：{}",id);
        if(StringUtils.isNotBlank(id)){
            QueryWrapper<CesSysSecret> wrapper = new QueryWrapper<>();
            wrapper.eq("type_id",id);
            List<CesSysSecret> cesSysSecretList = secretMapper.selectList(wrapper);
            if(CollectionUtils.isNotEmpty(cesSysSecretList)){
                //如果分类下有密点则不删除
                throw new RuntimeException("该分类下存在密点数据，删除失败！");
            }
            int i = secretTypeMapper.deleteById(id);
            if (i!= 1){
                //删除失败
                throw new RuntimeException("该分类下存在密点数据，删除失败！");
            }
        }
    }
}
