package com.zzsn.modules.kgj.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.zzsn.common.api.vo.Result;
import com.zzsn.common.system.query.QueryGenerator;
import com.zzsn.common.system.vo.LoginUser;
import com.zzsn.common.util.oConvertUtils;
import com.zzsn.modules.kgj.common.ResultModel;
import com.zzsn.modules.kgj.entity.CesSysSecret;
import com.zzsn.modules.kgj.entity.CesSysWeb;
import com.zzsn.modules.kgj.entity.DTO.CesSysWebDto;
import com.zzsn.modules.kgj.entity.SiteTypeMid;
import com.zzsn.modules.kgj.entity.VO.CesSysSecretVo;
import com.zzsn.modules.kgj.service.ICesSysWebService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.modules.kgj.service.ISiteTypeMidService;
import lombok.extern.slf4j.Slf4j;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import com.zzsn.common.system.base.controller.JeecgController;
import org.apache.shiro.SecurityUtils;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import com.zzsn.common.aspect.annotation.AutoLog;

 /**
 * @Description: 网站信息源
 * @Author: zzsn-boot
 * @Date:   2020-10-21
 * @Version: V1.0
 */
@Api(tags="网站信息源")
@RestController
@RequestMapping("/kgj/cesSysWeb")
@Slf4j
public class CesSysWebController extends JeecgController<CesSysWeb, ICesSysWebService> {
	@Autowired
	private ICesSysWebService cesSysWebService;

	@Autowired
	private ISiteTypeMidService siteTypeMidService;
	/**
	 * 分页列表查询
	 *
	 * @param cesSysWebDto
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "网站信息源-分页查询")
	@ApiOperation(value = "网站信息源-分页查询", notes="网站信息源-根据参数传入的sysUser对象和分页控制参数，对数据进行数据库查询后，封装成page分页对象并返回")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(CesSysWebDto cesSysWebDto,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
//		QueryWrapper<CesSysWeb> queryWrapper = QueryGenerator.initQueryWrapper(cesSysWeb, req.getParameterMap());
//		QueryWrapper<CesSysWeb> queryWrapper = new QueryWrapper<>();
//		if(cesSysWebDto != null){
//			if(!StringUtils.isBlank(cesSysWeb.getName())){
//				queryWrapper.like("name",cesSysWeb.getName());
//			}
//			if(!StringUtils.isBlank(cesSysWeb.getLocal())){
//				queryWrapper.like("local",cesSysWeb.getLocal());
//			}
//		}
//		//网址类型为空或者1为科工局的下属子机构
//		queryWrapper.isNull("url_type").or().eq("url_type",1);
//		queryWrapper.orderByDesc("CREATE_TIME");
//		Page<CesSysWeb> page = new Page<CesSysWeb>(pageNo, pageSize);
//		IPage<CesSysWeb> pageList = cesSysWebService.page(page, queryWrapper);

		Page<CesSysWebDto> page = new Page<CesSysWebDto>(pageNo, pageSize);
		IPage<CesSysWebDto> pageList = cesSysWebService.selectByPage(page,cesSysWebDto);
		return Result.ok(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param cesSysWebDto
	 * @return
	 */
	@AutoLog(value = "网站信息源-添加")
	@ApiOperation(value="网站信息源-添加", notes="网站信息源-通过参数传入json格式sysUser对象，在数据库中生成一条新的数据")
	@PostMapping(value = "/add")
	public ResultModel<?> add(@RequestBody CesSysWebDto cesSysWebDto) {
		return ResultModel.OK(cesSysWebService.add(cesSysWebDto));
	}
	
	/**
	 *  编辑
	 *
	 * @param cesSysWebDto
	 * @return
	 */
	@AutoLog(value = "网站信息源-编辑")
	@ApiOperation(value="网站信息源-编辑", notes="网站信息源-编辑")
	@PutMapping(value = "/update")
	public ResultModel<?> edit(@RequestBody CesSysWebDto cesSysWebDto) {
		Validate.notNull(cesSysWebDto.getId(),"主键ID不能为空");
		return ResultModel.OK(cesSysWebService.edit(cesSysWebDto));
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "网站信息源-通过id删除")
	@ApiOperation(value="网站信息源-通过id删除", notes="网站信息源-通过id删除")
	@DeleteMapping(value = "delete/{id}")
	public Result<?> delete(@PathVariable("id") String id) {
		Validate.notNull(id,"主键ID不能为空");
		return Result.ok(cesSysWebService.delete(id));
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "网站信息源-批量删除")
	@ApiOperation(value="网站信息源-批量删除", notes="网站信息源-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		if(StringUtils.isBlank(ids)){
			//ids为空
			return Result.error("批量删除ID不能为空！");
		}
		return Result.ok(cesSysWebService.deleteByIds(ids));
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "网站信息源-通过id查询")
	@ApiOperation(value="网站信息源-通过id查询", notes="网站信息源-通过id查询")
	@GetMapping(value = "/get/{id}")
	public Result<?> queryById(@PathVariable("id")   String id) {
		Validate.notNull(id,"主键ID");
		CesSysWeb cesSysWeb = cesSysWebService.getById(id);
		if(cesSysWeb==null) {
			return Result.error("未找到对应数据");
		}
		return Result.ok(cesSysWeb);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param cesSysWeb
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, CesSysWeb cesSysWeb) {
//        return super.exportXls(request, cesSysWeb, CesSysWeb.class, "网站信息源");
		// Step.1 组装查询条件
		QueryWrapper<CesSysWeb> queryWrapper = QueryGenerator.initQueryWrapper(cesSysWeb, request.getParameterMap());
		//LoginUser sysUser = JwtUtil.getLoginUser();
		LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
		// Step.2 获取导出数据
		List<CesSysWeb> pageList = cesSysWebService.list(queryWrapper);
		for (int i = 0; i < pageList.size(); i++) {
			CesSysWeb cs=pageList.get(i);
			String id=cs.getId();
			//SiteTypeMid sm=new SiteTypeMid();
			//sm.setSiteId(id);
			QueryWrapper<SiteTypeMid> midQueryWrapper = new QueryWrapper<>();
			midQueryWrapper.eq("SITEID",id);
			SiteTypeMid sm=siteTypeMidService.getOne(midQueryWrapper);
			if(sm!=null){

				cs.setUrlType(sm.getTypeId());
			}
		}

		List<CesSysWeb> exportList = null;

		// 过滤选中数据
		String selections = request.getParameter("selections");
		if (oConvertUtils.isNotEmpty(selections)) {
			List<String> selectionList = Arrays.asList(selections.split(","));
			exportList = pageList.stream().filter(item -> selectionList.contains(getId(item))).collect(Collectors.toList());
		} else {
			exportList = pageList;
		}

		// Step.3 AutoPoi 导出Excel
		ModelAndView mv = new ModelAndView(new JeecgEntityExcelView());
		mv.addObject(NormalExcelConstants.FILE_NAME, "网站信息源"); //此处设置的filename无效 ,前端会重更新设置一下
		mv.addObject(NormalExcelConstants.CLASS, CesSysWeb.class);
		mv.addObject(NormalExcelConstants.PARAMS, new ExportParams("网站信息源" + "报表", "导出人:" + "", "网站信息源"));
		mv.addObject(NormalExcelConstants.DATA_LIST, exportList);
		return mv;
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel1", method = RequestMethod.POST)
    public Result<?> importExcel1(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, CesSysWeb.class);
    }

	 @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
	 public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
		 MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		 Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		 for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			 MultipartFile file = entity.getValue();// 获取上传文件对象
			 ImportParams params = new ImportParams();
			 params.setTitleRows(2);
			 params.setHeadRows(1);
			 params.setNeedSave(true);
			 try {
				 List<CesSysWeb> importList = ExcelImportUtil.importExcel(file.getInputStream(), CesSysWeb.class, params);
				 if(CollectionUtils.isEmpty(importList)){
					 return Result.error("文件内容不能为空");
				 }
				 //update-begin-author:taoyan date:20190528 for:批量插入数据
				 //查询数据库中存在的所有网站
				 List<CesSysWeb> dataList = cesSysWebService.list();
				 if(CollectionUtils.isEmpty(dataList)){
					 //如果数据库中的密点内容为空，则不用比对，直接导入
					 boolean b = cesSysWebService.saveBatch(importList);
					 if(!b){
						 log.info("导入密点库失败");
						 return Result.error("文件导入失败!");
					 }
					 return Result.ok("文件导入成功！数据行数：" + importList.size());
				 }
				 Map<String, CesSysWeb> map = dataList.stream().collect(Collectors.toMap(cesSysWeb -> {
					 String content = cesSysWeb.getUrl();
					 if(org.apache.commons.lang.StringUtils.isNotBlank(content)){
						 return content.trim();
					 }
					 return content;
				 }, cesSysWeb -> cesSysWeb,(k1,k2)->k2));
				 //数据库中的密点不为空，则进行比较
				 List<CesSysWeb> insertList = new ArrayList<>();
				 //重复的数据
				 List<String> repeatList = new ArrayList<>();
				 for (CesSysWeb cesSysWeb : importList) {
					 String url = cesSysWeb.getUrl();
					 if(org.apache.commons.lang.StringUtils.isNotBlank(url)){
						 //去除前后空格
						 String trim = url.trim();
						 if(map.get(trim) ==null){
							 //等于空，说明数据库里边不存在
							 insertList.add(cesSysWeb);
						 }else{
							 //不等于空，说明存在
							 repeatList.add(trim);
						 }
					 }

				 }
				 long start = System.currentTimeMillis();
				 if(!(insertList.size()>0)){
					 //插入的数据为空，说明都是重复的，直接返回
					 return Result.ok("文件导入成功！数据行数：" + insertList.size()+" 重复的内容行数："+repeatList.size());
				 }


				 boolean b=true;
				 for (CesSysWeb cesSysWeb : insertList) {
					 String url = cesSysWeb.getUrl();
					 CesSysWebDto cesSysWebDto=new CesSysWebDto();
					 cesSysWebDto.setUrl(url);
					 cesSysWebDto.setName(cesSysWeb.getName());
					 cesSysWebDto.setSiteTypeId(cesSysWeb.getUrlType());
					 cesSysWebDto.setLocal(cesSysWeb.getLocal());
					 cesSysWebDto.setLongitudeLatitude(cesSysWeb.getLongitudeLatitude());
					 cesSysWebService.add(cesSysWebDto);

				 }
				 //boolean b = cesSysWebService.saveBatch(insertList);
				 if(!b){
					 log.info("导入密点库失败");
					 return Result.error("文件导入失败!");
				 }
				 //400条 saveBatch消耗时间1592毫秒  循环插入消耗时间1947毫秒
				 //1200条  saveBatch消耗时间3687毫秒 循环插入消耗时间5212毫秒
				 log.info("消耗时间" + (System.currentTimeMillis() - start) + "毫秒");
				 //update-end-author:taoyan date:20190528 for:批量插入数据
				 return Result.ok("文件导入成功！数据行数：" + insertList.size()+" 重复的密点内容行数："+repeatList.size());
			 } catch (Exception e) {
				 log.error(e.getMessage(), e);
				 return Result.error("文件导入失败:" + e.getMessage());
			 } finally {
				 try {
					 file.getInputStream().close();
				 } catch (IOException e) {
					 e.printStackTrace();
				 }
			 }
		 }
		 return Result.error("文件导入失败！");
//        return super.importExcel(request, response, CesSysSecret.class);
	 }


	 /**
	  * 获取对象ID
	  *
	  * @return
	  */
	 private String getId(CesSysWeb item) {
		 try {
			 return PropertyUtils.getProperty(item, "id").toString();
		 } catch (Exception e) {
			 e.printStackTrace();
			 return null;
		 }
	 }
}
