package com.zzsn.common.poi;


import org.apache.commons.lang.StringUtils;
import org.apache.poi.xwpf.usermodel.*;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.*;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class DownLoadSupport {


	/**
	 * 项目信息列表-表头
	 * @param
	 * @return
	 */
	public static List<Metadata> getProjectColumn(){
		List<Metadata> list = new ArrayList<Metadata>();

		list.add(new Metadata("String","rank","序号", "120", "center"));
		list.add(new Metadata("String","id","id", "120", "center"));
		list.add(new Metadata("String","title","标题", "200", "center"));
		list.add(new Metadata("String","originAmount","金额(万元)", "200", "center"));
		list.add(new Metadata("String","industryName","行业", "150", "center"));
		list.add(new Metadata("String","proStatus","状态", "150", "center"));
		list.add(new Metadata("String","countryName","国家", "150", "center"));
		list.add(new Metadata("String","createTime","日期", "150", "center"));

		return list;
	}
	/**
	 * 项目信息列表-表头
	 * @param
	 * @return
	 */
	public static List<Metadata> getProjectEnColumn(){
		List<Metadata> list = new ArrayList<Metadata>();

		list.add(new Metadata("String","rank","rank", "120", "center"));
		list.add(new Metadata("String","id","id", "200", "center"));
		list.add(new Metadata("String","title","title", "200", "center"));
		list.add(new Metadata("String","originAmount","originAmount(million)", "200", "center"));
		list.add(new Metadata("String","industryName","industry", "150", "center"));
		list.add(new Metadata("String","proStatus","status", "150", "center"));
		list.add(new Metadata("String","countryName","country", "150", "center"));
		list.add(new Metadata("String","createTime","createTime", "150", "center"));

		return list;
	}
	/**
	 * 信息源绑定列表-表头
	 * @param
	 * @return
	 */
	public static List<Metadata> getSiteBindColumn(){
		List<Metadata> list = new ArrayList<Metadata>();

		list.add(new Metadata("String","rank","序号", "120", "center"));
		list.add(new Metadata("String","id","id", "120", "center"));
		list.add(new Metadata("String","name","名称", "200", "center"));
		list.add(new Metadata("String","url","地址", "200", "center"));
		list.add(new Metadata("String","isValid","是否启用", "150", "center"));
		list.add(new Metadata("String","qualityLevel","名单类型", "150", "center"));

		return list;
	}
	/**
	 * 项目信息列表-表头(所有字段)
	 * @param
	 * @return
	 */
	public static List<Metadata> getProjectAllColumn(){
		List<Metadata> list = new ArrayList<Metadata>();
		list.add(new Metadata("String","id","序号", "120", "center"));
		list.add(new Metadata("String","title","标题", "200", "center"));
		list.add(new Metadata("String","conBuildUnitId","承建单位编号", "200", "center"));
		list.add(new Metadata("String","conBuildUnit","承建单位", "150", "center"));
		return list;
	}


	/**
	 * 风险信息列表-表头
	 * @param
	 * @return
	 * 标题 title
	 * 国家 countryname
	 * 详细地址 addrss
	 * 风险类型 categorys
	 * 来源  source
	 * 简介  synopsis
	 * 发布时间  pub_time
	 */
	public static List<Metadata> getRiskColumn(){
		List<Metadata> list = new ArrayList<Metadata>();

		list.add(new Metadata("String","rank","序号", "120", "center"));
		list.add(new Metadata("String","title","标题", "200", "center"));
		list.add(new Metadata("String","countryname","国家", "200", "center"));
//		list.add(new Metadata("String","addrss","详细地址", "150", "center"));
		list.add(new Metadata("String","categorys","类型", "150", "center"));
//		list.add(new Metadata("String","source","来源", "150", "center"));
		list.add(new Metadata("String","summary","简介", "150", "center"));
		list.add(new Metadata("String","time","更新时间", "150", "center"));

		return list;
	}
	/**
	 * 风险信息列表-表头
	 * @param
	 * @return
	 * 标题 title
	 * 国家 countryname
	 * 详细地址 addrss
	 * 风险类型 categorys
	 * 来源  source
	 * 简介  synopsis
	 * 发布时间  pub_time
	 */
	public static List<Metadata> getRiskEnColumn(){
		List<Metadata> list = new ArrayList<Metadata>();

		list.add(new Metadata("String","rank","rank", "120", "center"));
		list.add(new Metadata("String","title","title", "200", "center"));
		list.add(new Metadata("String","countryname","country", "200", "center"));
//		list.add(new Metadata("String","addrss","详细地址", "150", "center"));
		list.add(new Metadata("String","categorys","categorys", "150", "center"));
//		list.add(new Metadata("String","source","来源", "150", "center"));
		list.add(new Metadata("String","summary","synopsis", "150", "center"));
		list.add(new Metadata("String","time","Release time", "150", "center"));

		return list;
	}
	/**
	 * 风险信息列表-表头
	 * @param
	 * @return
	 * 标题 title
	 * 国家 countryname
	 * 详细地址 addrss
	 * 风险类型 categorys
	 * 来源  source
	 * 简介  synopsis
	 * 发布时间  pub_time
	 */
	public static List<Metadata> getBusinessColumn(){
		List<Metadata> list = new ArrayList<Metadata>();

		list.add(new Metadata("String","rank","序号", "60", "center"));
		list.add(new Metadata("String","title","标题", "200", "center"));
		list.add(new Metadata("String","labels","标签", "80", "center"));
		list.add(new Metadata("String","countryName","国家名称", "100", "center"));
		list.add(new Metadata("String","categorys","类别", "100", "center"));
		list.add(new Metadata("String","industry","行业", "100", "center"));
		list.add(new Metadata("String","cycle","周期", "100", "center"));
		list.add(new Metadata("String","source","数据来源", "100", "center"));
		list.add(new Metadata("String","background","背景", "150", "center"));
		list.add(new Metadata("String","represent","描述", "250", "center"));
		list.add(new Metadata("String","content","内容", "250", "center"));
		list.add(new Metadata("String","createTime","创建时间", "120", "center"));

		return list;
	}

	/**
	 * 资讯信息列表-表头
	 * @param
	 * @return
	 */
	public static List<Metadata> getArticleColumn(){
		List<Metadata> list = new ArrayList<Metadata>();
		list.add(new Metadata("String","rank","序号", "80", "center"));
		list.add(new Metadata("String","title","标题", "150", "center"));
		list.add(new Metadata("String","summary","摘要", "300", "center"));
		list.add(new Metadata("String","status","审核状态", "120", "center"));
		list.add(new Metadata("String","time","时间", "120", "center"));
		list.add(new Metadata("String","source","来源", "120", "center"));
		list.add(new Metadata("String","articleType","资讯类型", "120", "center"));
		list.add(new Metadata("String","sourceAddress","原文链接", "260", "center"));
		list.add(new Metadata("String","content","正文", "400", "center"));
		return list;
	}
	/**
	 * 资讯信息列表-表头
	 * @param
	 * @return
	 */
	public static List<Metadata> getArticleBackColumn(){
		List<Metadata> list = new ArrayList<Metadata>();
		list.add(new Metadata("String","rank","序号", "80", "center"));
		list.add(new Metadata("String","title","标题", "150", "center"));
		list.add(new Metadata("String","summary","摘要", "300", "center"));
//		list.add(new Metadata("String","labels","类别", "120", "center"));
		list.add(new Metadata("String","time","时间", "120", "center"));
		list.add(new Metadata("String","source","来源", "120", "center"));
		list.add(new Metadata("String","sourceAddress","原文链接", "260", "center"));
//		list.add(new Metadata("String","content","正文", "400", "center"));
		return list;
	}
	/**
	 * 资讯信息列表-表头
	 * @param
	 * @return
	 */
	public static List<Metadata> getArticleEnColumn(){
		List<Metadata> list = new ArrayList<Metadata>();
		list.add(new Metadata("String","rank","rank", "80", "center"));
		list.add(new Metadata("String","title","title", "150", "center"));
		list.add(new Metadata("String","summary","summary", "200", "center"));
		list.add(new Metadata("String","time","time", "120", "center"));
		list.add(new Metadata("String","source","source", "200", "center"));
		list.add(new Metadata("String","sourceAddress","sourceAddress", "260", "center"));
//		list.add(new Metadata("String","keyWords","keyWords", "120", "center"));
//		list.add(new Metadata("String","labels","labels", "120", "center"));
		return list;
	}

	/**
	 * artcleMap.put("id", articleInfo.getId());
	 artcleMap.put("code", articleInfo.getCode());
	 artcleMap.put("logo", articleInfo.getLogo());
	 artcleMap.put("name", articleInfo.getName());
	 artcleMap.put("aliasName", articleInfo.getAliasName());
	 artcleMap.put("nameEn", articleInfo.getNameEn());
	 artcleMap.put("connectPhone", articleInfo.getConnectPhone());
	 artcleMap.put("address", articleInfo.getAddress());
	 artcleMap.put("addressEn", articleInfo.getAddressEn());
	 * @return
	 */
	public static List<Metadata>  getEnterpriseColumn(){
		List<Metadata> list = new ArrayList<Metadata>();
		list.add(new Metadata("String","rank","序号", "80", "center"));
		list.add(new Metadata("String","id","id编号", "120", "center"));
		list.add(new Metadata("String","code","统一信用编号", "150", "center"));
		list.add(new Metadata("String","logo","图标所在地址", "220", "center"));
		list.add(new Metadata("String","name","企业名字", "120", "center"));
		list.add(new Metadata("String","aliasName","企业别名", "120", "center"));
		list.add(new Metadata("String","nameEn","英文名字", "120", "center"));
		list.add(new Metadata("String","connectPhone","联系电话", "120", "center"));
		list.add(new Metadata("String","address","企业地址", "120", "center"));
		list.add(new Metadata("String","addressEn","企业地址英文", "120", "center"));
		return list;
	}

	/*
	 * 项目企业关联表
	 */
	public static List<Metadata>  getProjectEnterpriseColumn(){
		List<Metadata> list = new ArrayList<Metadata>();
		list.add(new Metadata("String","projectId","资讯编号", "120", "center"));
		list.add(new Metadata("String","enterpriseId","企业编号", "150", "center"));
		list.add(new Metadata("String","enterpriseName","企业名称", "220", "center"));
		list.add(new Metadata("String","enterpriseNameEn","企业英文名称", "220", "center"));
		return list;
	}

	// word跨列合并单元格
	public static void mergeCellsHorizontal(XWPFTable table, int row, int fromCell, int toCell) {
		for (int cellIndex = fromCell; cellIndex <= toCell; cellIndex++) {
			XWPFTableCell cell = table.getRow(row).getCell(cellIndex);
			if ( cellIndex == fromCell ) {
				// The first merged cell is set with RESTART merge value
				cell.getCTTc().addNewTcPr().addNewHMerge().setVal(STMerge.RESTART);
			} else {
				// Cells which join (merge) the first one, are set with CONTINUE
				cell.getCTTc().addNewTcPr().addNewHMerge().setVal(STMerge.CONTINUE);
			}
		}
	}
	// word跨行并单元格
	public static void mergeCellsVertically(XWPFTable table, int col, int fromRow, int toRow) {
		for (int rowIndex = fromRow; rowIndex <= toRow; rowIndex++) {
			XWPFTableCell cell = table.getRow(rowIndex).getCell(col);
			if ( rowIndex == fromRow ) {
				// The first merged cell is set with RESTART merge value
				cell.getCTTc().addNewTcPr().addNewVMerge().setVal(STMerge.RESTART);
			} else {
				// Cells which join (merge) the first one, are set with CONTINUE
				cell.getCTTc().addNewTcPr().addNewVMerge().setVal(STMerge.CONTINUE);
			}
		}
	}

	/**
	 * 单元格段落属性设置
	 * @param cell
	 * @param cellText
	 * @param font
	 * @param fontSize
	 * @param isbold
	 */
	public static void getCellParagraph(XWPFTableCell cell,String cellText,String font,int fontSize,Boolean isbold){
		CTP ctp = CTP.Factory.newInstance();
		cell.setVerticalAlignment(XWPFTableCell.XWPFVertAlign.CENTER);
		XWPFParagraph p = new XWPFParagraph(ctp, cell);
		p.setAlignment(ParagraphAlignment.CENTER);
		XWPFRun run = p.createRun();
		run.setFontSize(fontSize);
		run.setBold(isbold);
		run.setText(cellText);

		CTRPr rpr = run.getCTR().isSetRPr() ? run.getCTR().getRPr() : run.getCTR().addNewRPr();
		CTFonts fonts = rpr.isSetRFonts() ? rpr.getRFonts() : rpr.addNewRFonts();
		fonts.setAscii(font);
		fonts.setEastAsia(font);
		fonts.setHAnsi(font);

		cell.setParagraph(p);
	}


	/**
	 * 单元格段落属性设置
	 * @param p
	 * @param cellText
	 * @param font
	 * @param fontSize
	 * @param isbold
	 */
	public static void getParagraph(XWPFParagraph p,String cellText,ParagraphAlignment align,String font,int fontSize,Boolean isbold){
		p.setAlignment(align);
		XWPFRun run = p.createRun();
		run.setFontSize(fontSize);
		run.setBold(isbold);
		run.setText(cellText);
		CTRPr rpr = run.getCTR().isSetRPr() ? run.getCTR().getRPr() : run.getCTR().addNewRPr();
		CTFonts fonts = rpr.isSetRFonts() ? rpr.getRFonts() : rpr.addNewRFonts();
		fonts.setAscii(font);
		fonts.setEastAsia(font);
		fonts.setHAnsi(font);


	}
	/**
	 * 表格宽高
	 * @param table
	 * @param width
	 * @param height
	 */
	public static void setTableWidthAndHeight(XWPFTable table,int width,int  height){
		CTTblPr tblPr = table.getCTTbl().getTblPr();
		tblPr.getTblW().setType(STTblWidth.DXA);
		tblPr.getTblW().setW(BigInteger.valueOf(width));
		List<XWPFTableRow> rows = table.getRows();
		for (XWPFTableRow row : rows) {
			CTTrPr trPr = row.getCtRow().addNewTrPr();
			CTHeight ht = trPr.addNewTrHeight();
			ht.setVal(BigInteger.valueOf(height));
		}
	}
}
