package com.zzsn.config;

import com.baomidou.mybatisplus.extension.incrementer.OracleKeyGenerator;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

/**
 * @author
 * @description: mybatis-plus配置
 * @date
 */
@EnableTransactionManagement
@Configuration
//@MapperScan("com.zzsn.mapper")
public class MybatisPlusConfig {

    /**
     * mybatis-plus分页配置
     */
    @Bean
    public PaginationInterceptor paginationInterceptor() {
        return new PaginationInterceptor();
    }

    /**
     * Sequence主键自增
     *
     * @return 返回oracle自增类
     * @author zhenggc
     */
    @Bean
    public OracleKeyGenerator oracleKeyGenerator(){
        return new OracleKeyGenerator();
    }

}
