package com.zzsn.entity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.zzsn.utils.BlobTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;


/**
 * 人工干预Model
 * @author 刘小鹏
 * @date 2015-5-13 14:13
 * @company 郑州数能软件科技有限公司
 */
//@MappedJdbcTypes(includeNullJdbcType = false, value = JdbcType.BLOB)
//@TableName(value = "CIS_ANS_BASEDATA", autoResultMap = true)
@TableName(value = "CIS_ANS_BASEDATA")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class Basedata implements Serializable {


	//columns START
	/**
	 * id       db_column: ID
	 */
	private String id;
	/**
	 * tid       db_column: TID
	 */
	private Long tid;

	private Long sid;
	/**
	 * viewTid
	 */
	private String viewTid;
	/**
	 * viewType
	 */
	private String viewType;
	/**
	 * title       db_column: TITLE
	 */
	private String title;
	/**
	 * summary       db_column: SUMMARY
	 */
	private String summary;
	/**
	 * keywords       db_column: KEYWORDS
	 */
	private String keywords;
	/**
	 * autor       db_column: AUTOR
	 */
	private String author;
	/**
	 * sourcesite       db_column: SOURCESITE
	 */
	private String sourcesite;
	/**
	 * sourceaddress       db_column: SOURCEADDRESS
	 */
	private String sourceaddress;
	/**
	 * type       db_column: TYPE
	 */
	private String type;
	/**
	 * withtagfile       db_column: WITHTAGFILE
	 */
	private String withtagfile;
	/**
	 * publishDate       db_column: PUBLISH_DATE
	 */
	private String publishDate;
	/**
	 * publishStartTime
	 */
	private String publishStartTime;
	/**
	 * publishEndTime
	 */
	private String publishEndTime;
	/**
	 * createBy       db_column: CREATE_BY
	 */
	private String createBy;
	/**
	 * createDate       db_column: CREATE_DATE
	 */
	private String createDate;
	/**
	 * createStartTime
	 */
	private String createStartTime;
	/**
	 * createEndTime
	 */
	private String createEndTime;
	/**
	 * content       db_column: CONTENT
	 */
//	@TableField(typeHandler= BlobTypeHandler.class)
	private String content;
	/**
	 * content       db_column: CONTENT
	 */
//	@TableField(typeHandler= BlobTypeHandler.class)
	private String contentNoTag;
	/**
	 * content       db_column: CONTENT
	 */
//	@TableField(typeHandler= BlobTypeHandler.class)
	private String featurewords;
	/**
	 * sort
	 */
	private String sort;
	/**
	 * dicPid
	 */
	private Long dicPid;
	/**
	 * orientation
	 */
	private String orientation;
	private String lang;

	private Long orgId;

	private Integer isdelete;
//	@TableField(typeHandler= BlobTypeHandler.class)
	private String words;

	private String fileDownLoadPath;
	//舆情热度值
	private Long hotValue;
	//RELATE_PLACES 相关国家城市地点信息
	private String relatePlaces;
	//LOCALE 信息所属国别（国别，不是城市）
	private String locale;
	//columns END
	private String readid;
	private String readstatus;
	private Long baseid[];
	private String basebids;
	private Long cloudid;
	private String sName;
	private Long snIndex;
	private Long hits;
	private String tids;
	private String origin;
	private Long treecodes[];
	private Long btId;     //情报分类主键ID
	private Long brTids[];
	private List<Long> typeIds;
	private Long readCount;
	private Long commentCount;
	private Long appCount;
	private Long adviceCount;
	private String dayFlag;
	private String weekFlag;
	private String monthFlag;
	private Long delflag;
	private String viewStatus;
	private Long repeat;
	private String checkDate;
	private String fromWhere;
	private String briefMark;//是否加入简报
	private String isAllNeg;//是否看全部负面
//	@Transient
	@JsonIgnore
	private String total;   //统计字段
//	@Transient
	@JsonIgnore
	private String descriptionch; //企业名称
//	@Transient
	@JsonIgnore
	private String rennum;//舆情统计添加冗余字段
	private String isYq;
	//资讯得分
	private Double infoScore;
	/**
	 * reliability       db_column: RELIABILITY
	 */
	private String reliability;
	/**
	 * influence       db_column: INFLUENCE
	 */
//	@TableField(typeHandler= BlobTypeHandler.class)
	private String influence;

	//用于情报简报查询
	private  Long   datatype;
	private  String tname;//分类名称
	//情报所属地域，有可能属于多个区域
	private String viewRegion;
//	@TableField(typeHandler= BlobTypeHandler.class)
	private String contentImgCvtTag;

	private String reprintCount;  //重复数量
	private String repeatFilter;  //重复数量

	private String isBrief;//是否为简报。0为否，大于0就是简报，并且值是简报ID。
	//信息源分类
	private String originType;
	//标题是否匹配中. 0:未匹配中；1：匹配中
	private String titleMatchFlag;
	//关键词匹配到的次数
	private Integer wordsCount;

	//国资研究相关的关键词词频
	private Integer qyCount;


	public String getRepeatFilter() {
		return repeatFilter;
	}
	public void setRepeatFilter(String repeatFilter) {
		this.repeatFilter = repeatFilter;
	}
	public Long getDatatype() {
		return datatype;
	}
	public void setDatatype(Long datatype) {
		this.datatype = datatype;
	}
	//竞争对手ID，用于查询竞争对手下所有高管的新闻
	private Long cid;
	/**
	 * viewSid
	 */
	private String viewSid;

	private String viewRegionTreecode;
	/**
	 * 包含关键词
	 */
	private String[] includeKeywords;
	/**
	 * 排除词
	 */
	private String[] excludeKeywords;
	/**
	 * 页
	 */
	private Long page;
	/**
	 * 每页数量
	 */
	private Long pageSize;
	/**
	 * sourceType       db_column: SOURCE_TYPE
	 */
	private String sourceType;

	//add lihuawei 重要度标识
	private Integer ordervalue;


	private Boolean hasImage;
	private List<String> imgPath;
	private Long logid;
	private Boolean hasPushed;
	private String dieNum;
	private String hurtNum;
	//add lihuawei 相似数量
	private Integer likecount;

	private Boolean sortReverse;

	private Map<String,String> otherParams;

	//IS_FIRST_PUBLISH   是否是首发信息；  0：不是首发信息；1：是首发信息
	private Long isFirstPublish;
	//FIRST_PUBLISH_BID  首发信息ID； 当当前信息是首发信息时，该字段为空；当当前信息不是首发时，此信息为当前信息的首发信息ID
	private Long firstPublishBid;

	private Long sameEventCount;

	public Integer getLikecount() {
		return likecount;
	}
	public void setLikecount(Integer likecount) {
		this.likecount = likecount;
	}
	public Integer getOrdervalue() {
		return ordervalue;
	}
	public void setOrdervalue(Integer ordervalue) {
		this.ordervalue = ordervalue;
	}
	public String getsName() {
		return sName;
	}
	public void setsName(String sName) {
		this.sName = sName;
	}
	/**
	 *
	 */
//	@Transient
	@JsonIgnore
	private Site site = new Site();
	private String outId;  //中铁建蓝信项目

	/**
	 * 附件信息虚拟字段
	 */
	private String attachmentInfos;

	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public Long getTid() {
		return tid;
	}
	public void setTid(Long tid) {
		this.tid = tid;
	}
	public String getViewTid() {
		return viewTid;
	}
	public void setViewTid(String viewTid) {
		this.viewTid = viewTid;
	}
	public String getViewType() {
		return viewType;
	}
	public void setViewType(String viewType) {
		this.viewType = viewType;
	}
	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public String getSummary() {
		return summary;
	}
	public void setSummary(String summary) {
		this.summary = summary;
	}
	public String getKeywords() {
		return keywords;
	}
	public void setKeywords(String keywords) {
		this.keywords = keywords;
	}

	public String getAuthor() {
		return author;
	}
	public void setAuthor(String author) {
		this.author = author;
	}
	public String getSourcesite() {
		return sourcesite;
	}
	public void setSourcesite(String sourcesite) {
		this.sourcesite = sourcesite;
	}
	public String getSourceaddress() {
		return sourceaddress;
	}
	public void setSourceaddress(String sourceaddress) {
		this.sourceaddress = sourceaddress;
	}
	public String getType() {
		return type;
	}
	public void setType(String type) {
		this.type = type;
	}
	public String getWithtagfile() {
		return withtagfile;
	}
	public void setWithtagfile(String withtagfile) {
		this.withtagfile = withtagfile;
	}
	public String getPublishDate() {
		return publishDate;
	}
	public void setPublishDate(String publishDate) {
		this.publishDate = publishDate;
	}
	public String getPublishStartTime() {
		return publishStartTime;
	}
	public void setPublishStartTime(String publishStartTime) {
		this.publishStartTime = publishStartTime;
	}
	public String getPublishEndTime() {
		return publishEndTime;
	}
	public void setPublishEndTime(String publishEndTime) {
		this.publishEndTime = publishEndTime;
	}
	public String getCreateBy() {
		return createBy;
	}
	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}
	public String getCreateDate() {
		return createDate;
	}
	public void setCreateDate(String createDate) {
		this.createDate = createDate;
	}
	public String getCreateStartTime() {
		return createStartTime;
	}
	public void setCreateStartTime(String createStartTime) {
		this.createStartTime = createStartTime;
	}
	public String getCreateEndTime() {
		return createEndTime;
	}
	public void setCreateEndTime(String createEndTime) {
		this.createEndTime = createEndTime;
	}
	public String getContent() {
		return content;
	}
	public void setContent(String content) {
		this.content = content;
	}
	public String getSort() {
		return sort;
	}
	public void setSort(String sort) {
		this.sort = sort;
	}
	public Long getDicPid() {
		return dicPid;
	}
	public void setDicPid(Long dicPid) {
		this.dicPid = dicPid;
	}


	public Site getSite() {
		return site;
	}
	public void setSite(Site site) {
		this.site = site;
	}
	public String getLang() {
		return lang;
	}
	public void setLang(String lang) {
		this.lang = lang;
	}
	public Long getSid() {
		return sid;
	}
	public void setSid(Long sid) {
		this.sid = sid;
	}
	public Long getOrgId() {
		return orgId;
	}
	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}
	public String getReadid() {
		return readid;
	}
	public void setReadid(String readid) {
		this.readid = readid;
	}
	public String getReadstatus() {
		return readstatus;
	}
	public void setReadstatus(String readstatus) {
		this.readstatus = readstatus;
	}
	public Long[] getBaseid() {
		return baseid;
	}
	public void setBaseid(Long[] baseid) {
		this.baseid = baseid;
	}

	public String getBasebids() {
		return basebids;
	}
	public void setBasebids(String basebids) {
		this.basebids = basebids;
	}
	public Integer getIsdelete() {
		return isdelete;
	}
	public void setIsdelete(Integer isdelete) {
		this.isdelete = isdelete;
	}
	public Long getCloudid() {
		return cloudid;
	}
	public void setCloudid(Long cloudid) {
		this.cloudid = cloudid;
	}
	public String getOutId() {
		return outId;
	}
	public void setOutId(String outId) {
		this.outId = outId;
	}
	public Long getCid() {
		return cid;
	}
	public void setCid(Long cid) {
		this.cid = cid;
	}
	public Long getHits() {
		return hits;
	}
	public void setHits(Long hits) {
		this.hits = hits;
	}
	public String getTids() {
		return tids;
	}
	public void setTids(String tids) {
		this.tids = tids;
	}
	public String getOrigin() {
		return origin;
	}
	public void setOrigin(String origin) {
		this.origin = origin;
	}
	public String getViewSid() {
		return viewSid;
	}
	public void setViewSid(String viewSid) {
		this.viewSid = viewSid;
	}
	public String getTname() {
		return tname;
	}
	public void setTname(String tname) {
		this.tname = tname;
	}
	public String getContentNoTag() {
		return contentNoTag;
	}
	public void setContentNoTag(String contentNoTag) {
		this.contentNoTag = contentNoTag;
	}

	public String getFeaturewords() {
		return featurewords;
	}
	public void setFeaturewords(String featurewords) {
		this.featurewords = featurewords;
	}
	public String getViewRegionTreecode() {
		return viewRegionTreecode;
	}
	public void setViewRegionTreecode(String viewRegionTreecode) {
		this.viewRegionTreecode = viewRegionTreecode;
	}
	public String getViewRegion() {
		return viewRegion;
	}
	public void setViewRegion(String viewRegion) {
		this.viewRegion = viewRegion;
	}
	public String getReliability() {
		return reliability;
	}
	public void setReliability(String reliability) {
		this.reliability = reliability;
	}
	public String getInfluence() {
		return influence;
	}
	public void setInfluence(String influence) {
		this.influence = influence;
	}
	public String getWords() {
		return words;
	}
	public void setWords(String words) {
		this.words = words;
	}


	public String getOrientation() {
		return orientation;
	}
	public void setOrientation(String orientation) {
		this.orientation = orientation;
	}
	public String[] getIncludeKeywords() {
		return includeKeywords;
	}
	public void setIncludeKeywords(String[] includeKeywords) {
		this.includeKeywords = includeKeywords;
	}
	public Long[] getTreecodes() {
		return treecodes;
	}
	public void setTreecodes(Long[] treecodes) {
		this.treecodes = treecodes;
	}
	public String[] getExcludeKeywords() {
		return excludeKeywords;
	}
	public void setExcludeKeywords(String[] excludeKeywords) {
		this.excludeKeywords = excludeKeywords;
	}
	public String getFileDownLoadPath() {
		return fileDownLoadPath;
	}
	public void setFileDownLoadPath(String fileDownLoadPath) {
		this.fileDownLoadPath = fileDownLoadPath;
	}

	public Long getPage() {
		return page;
	}
	public void setPage(Long page) {
		this.page = page;
	}
	public Long getPageSize() {
		return pageSize;
	}
	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}
	public String getSourceType() {
		return sourceType;
	}
	public void setSourceType(String sourceType) {
		this.sourceType = sourceType;
	}
	public String getContentImgCvtTag() {
		return contentImgCvtTag;
	}
	public void setContentImgCvtTag(String contentImgCvtTag) {
		this.contentImgCvtTag = contentImgCvtTag;
	}
	public String getReprintCount() {
		return reprintCount;
	}
	public void setReprintCount(String reprintCount) {
		this.reprintCount = reprintCount;
	}
	public Long getBtId() {
		return btId;
	}
	public void setBtId(Long btId) {
		this.btId = btId;
	}
	public List<Long> getTypeIds() {
		return typeIds;
	}
	public void setTypeIds(List<Long> typeIds) {
		this.typeIds = typeIds;
	}

	public Long getReadCount() {
		return readCount;
	}
	public void setReadCount(Long readCount) {
		this.readCount = readCount;
	}
	public Long getCommentCount() {
		return commentCount;
	}
	public void setCommentCount(Long commentCount) {
		this.commentCount = commentCount;
	}
	public Long getAppCount() {
		return appCount;
	}
	public void setAppCount(Long appCount) {
		this.appCount = appCount;
	}
	public String getDayFlag() {
		return dayFlag;
	}
	public void setDayFlag(String dayFlag) {
		this.dayFlag = dayFlag;
	}
	public String getWeekFlag() {
		return weekFlag;
	}
	public void setWeekFlag(String weekFlag) {
		this.weekFlag = weekFlag;
	}
	public String getMonthFlag() {
		return monthFlag;
	}
	public void setMonthFlag(String monthFlag) {
		this.monthFlag = monthFlag;
	}
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		return result;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Basedata other = (Basedata) obj;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		return true;
	}
	public Long[] getBrTids() {
		return brTids;
	}
	public void setBrTids(Long brTids[]) {
		this.brTids = brTids;
	}
	public Long getSnIndex() {
		return snIndex;
	}
	public void setSnIndex(Long snIndex) {
		this.snIndex = snIndex;
	}
	public Long getAdviceCount() {
		return adviceCount;
	}
	public void setAdviceCount(Long adviceCount) {
		this.adviceCount = adviceCount;
	}
	public Long getDelflag() {
		return delflag;
	}
	public void setDelflag(Long delflag) {
		this.delflag = delflag;
	}
	public String getViewStatus() {
		return viewStatus;
	}
	public void setViewStatus(String viewStatus) {
		this.viewStatus = viewStatus;
	}
	public Long getRepeat() {
		return repeat;
	}
	public void setRepeat(Long repeat) {
		this.repeat = repeat;
	}
	public String getCheckDate() {
		return checkDate;
	}
	public void setCheckDate(String checkDate) {
		this.checkDate = checkDate;
	}
	public String getFromWhere() {
		return fromWhere;
	}
	public void setFromWhere(String fromWhere) {
		this.fromWhere = fromWhere;
	}
	public String getAttachmentInfos() {
		return attachmentInfos;
	}
	public void setAttachmentInfos(String attachmentInfos) {
		this.attachmentInfos = attachmentInfos;
	}
	public String getBriefMark() {
		return briefMark;
	}
	public void setBriefMark(String briefMark) {
		this.briefMark = briefMark;
	}
	public String getIsBrief() {
		return isBrief;
	}
	public void setIsBrief(String isBrief) {
		this.isBrief = isBrief;
	}
	public String getIsAllNeg() {
		return isAllNeg;
	}
	public void setIsAllNeg(String isAllNeg) {
		this.isAllNeg = isAllNeg;
	}
	public String getTotal() {
		return total;
	}
	public void setTotal(String total) {
		this.total = total;
	}
	public String getDescriptionch() {
		return descriptionch;
	}
	public void setDescriptionch(String descriptionch) {
		this.descriptionch = descriptionch;
	}
	public String getRennum() {
		return rennum;
	}
	public void setRennum(String rennum) {
		this.rennum = rennum;
	}
	public String getIsYq() {
		return isYq;
	}
	public void setIsYq(String isYq) {
		this.isYq = isYq;
	}
	public Long getHotValue() {
		return hotValue;
	}
	public void setHotValue(Long hotValue) {
		this.hotValue = hotValue;
	}
	public Boolean getHasImage() {
		return hasImage;
	}
	public void setHasImage(Boolean hasImage) {
		this.hasImage = hasImage;
	}
	public List<String> getImgPath() {
		return imgPath;
	}
	public void setImgPath(List<String> imgPath) {
		this.imgPath = imgPath;
	}
	public Map<String, String> getOtherParams() {
		return otherParams;
	}
	public void setOtherParams(Map<String, String> otherParams) {
		this.otherParams = otherParams;
	}
	public Boolean getSortReverse() {
		return sortReverse;
	}
	public void setSortReverse(Boolean sortReverse) {
		this.sortReverse = sortReverse;
	}
	public Long getIsFirstPublish() {
		return isFirstPublish;
	}
	public void setIsFirstPublish(Long isFirstPublish) {
		this.isFirstPublish = isFirstPublish;
	}
	public Long getFirstPublishBid() {
		return firstPublishBid;
	}
	public void setFirstPublishBid(Long firstPublishBid) {
		this.firstPublishBid = firstPublishBid;
	}
	public Long getSameEventCount() {
		return sameEventCount;
	}
	public void setSameEventCount(Long sameEventCount) {
		this.sameEventCount = sameEventCount;
	}
	public String getRelatePlaces() {
		return relatePlaces;
	}
	public void setRelatePlaces(String relatePlaces) {
		this.relatePlaces = relatePlaces;
	}
	public Long getLogid() {
		return logid;
	}
	public void setLogid(Long logid) {
		this.logid = logid;
	}
	public Boolean getHasPushed() {
		return hasPushed;
	}
	public void setHasPushed(Boolean hasPushed) {
		this.hasPushed = hasPushed;
	}
	public String getDieNum() {
		return dieNum;
	}
	public void setDieNum(String dieNum) {
		this.dieNum = dieNum;
	}
	public String getHurtNum() {
		return hurtNum;
	}
	public void setHurtNum(String hurtNum) {
		this.hurtNum = hurtNum;
	}
	public String getLocale() {
		return locale;
	}
	public void setLocale(String locale) {
		this.locale = locale;
	}
	/**
	 * @return the originType
	 */
	public String getOriginType() {
		return originType;
	}
	/**
	 * @param originType the originType to set
	 */
	public void setOriginType(String originType) {
		this.originType = originType;
	}
	/**
	 * @return the infoScore
	 */
	public Double getInfoScore() {
		return infoScore;
	}
	/**
	 * @param infoScore the infoScore to set
	 */
	public void setInfoScore(Double infoScore) {
		this.infoScore = infoScore;
	}
	/**
	 * @return the titleMatchFlag
	 */
	public String getTitleMatchFlag() {
		return titleMatchFlag;
	}
	/**
	 * @param titleMatchFlag the titleMatchFlag to set
	 */
	public void setTitleMatchFlag(String titleMatchFlag) {
		this.titleMatchFlag = titleMatchFlag;
	}
	/**
	 * @return the wordsCount
	 */
	public Integer getWordsCount() {
		return wordsCount;
	}
	/**
	 * @param wordsCount the wordsCount to set
	 */
	public void setWordsCount(Integer wordsCount) {
		this.wordsCount = wordsCount;
	}
	/**
	 * @return the qyCount
	 */
	public Integer getQyCount() {
		return qyCount;
	}
	/**
	 * @param qyCount the qyCount to set
	 */
	public void setQyCount(Integer qyCount) {
		this.qyCount = qyCount;
	}

	@Override
	public String toString() {
		return "Basedata{" +
				"id='" + id + '\'' +
				", tid=" + tid +
				", sid=" + sid +
				", viewTid='" + viewTid + '\'' +
				", viewType='" + viewType + '\'' +
				", title='" + title + '\'' +
				", summary='" + summary + '\'' +
				", keywords='" + keywords + '\'' +
				", author='" + author + '\'' +
				", sourcesite='" + sourcesite + '\'' +
				", sourceaddress='" + sourceaddress + '\'' +
				", type='" + type + '\'' +
				", withtagfile='" + withtagfile + '\'' +
				", publishDate='" + publishDate + '\'' +
				", publishStartTime='" + publishStartTime + '\'' +
				", publishEndTime='" + publishEndTime + '\'' +
				", createBy='" + createBy + '\'' +
				", createDate='" + createDate + '\'' +
				", createStartTime='" + createStartTime + '\'' +
				", createEndTime='" + createEndTime + '\'' +
				", content='" + content + '\'' +
				", contentNoTag='" + contentNoTag + '\'' +
				", featurewords='" + featurewords + '\'' +
				", sort='" + sort + '\'' +
				", dicPid=" + dicPid +
				", orientation='" + orientation + '\'' +
				", lang='" + lang + '\'' +
				", orgId=" + orgId +
				", isdelete=" + isdelete +
				", words='" + words + '\'' +
				", fileDownLoadPath='" + fileDownLoadPath + '\'' +
				", hotValue=" + hotValue +
				", relatePlaces='" + relatePlaces + '\'' +
				", locale='" + locale + '\'' +
				", readid='" + readid + '\'' +
				", readstatus='" + readstatus + '\'' +
				", baseid=" + Arrays.toString(baseid) +
				", basebids='" + basebids + '\'' +
				", cloudid=" + cloudid +
				", sName='" + sName + '\'' +
				", snIndex=" + snIndex +
				", hits=" + hits +
				", tids='" + tids + '\'' +
				", origin='" + origin + '\'' +
				", treecodes=" + Arrays.toString(treecodes) +
				", btId=" + btId +
				", brTids=" + Arrays.toString(brTids) +
				", typeIds=" + typeIds +
				", readCount=" + readCount +
				", commentCount=" + commentCount +
				", appCount=" + appCount +
				", adviceCount=" + adviceCount +
				", dayFlag='" + dayFlag + '\'' +
				", weekFlag='" + weekFlag + '\'' +
				", monthFlag='" + monthFlag + '\'' +
				", delflag=" + delflag +
				", viewStatus='" + viewStatus + '\'' +
				", repeat=" + repeat +
				", checkDate='" + checkDate + '\'' +
				", fromWhere='" + fromWhere + '\'' +
				", briefMark='" + briefMark + '\'' +
				", isAllNeg='" + isAllNeg + '\'' +
				", total='" + total + '\'' +
				", descriptionch='" + descriptionch + '\'' +
				", rennum='" + rennum + '\'' +
				", isYq='" + isYq + '\'' +
				", infoScore=" + infoScore +
				", reliability='" + reliability + '\'' +
				", influence='" + influence + '\'' +
				", datatype=" + datatype +
				", tname='" + tname + '\'' +
				", viewRegion='" + viewRegion + '\'' +
				", contentImgCvtTag='" + contentImgCvtTag + '\'' +
				", reprintCount='" + reprintCount + '\'' +
				", repeatFilter='" + repeatFilter + '\'' +
				", isBrief='" + isBrief + '\'' +
				", originType='" + originType + '\'' +
				", titleMatchFlag='" + titleMatchFlag + '\'' +
				", wordsCount=" + wordsCount +
				", qyCount=" + qyCount +
				", cid=" + cid +
				", viewSid='" + viewSid + '\'' +
				", viewRegionTreecode='" + viewRegionTreecode + '\'' +
				", includeKeywords=" + Arrays.toString(includeKeywords) +
				", excludeKeywords=" + Arrays.toString(excludeKeywords) +
				", page=" + page +
				", pageSize=" + pageSize +
				", sourceType='" + sourceType + '\'' +
				", ordervalue=" + ordervalue +
				", hasImage=" + hasImage +
				", imgPath=" + imgPath +
				", logid=" + logid +
				", hasPushed=" + hasPushed +
				", dieNum='" + dieNum + '\'' +
				", hurtNum='" + hurtNum + '\'' +
				", likecount=" + likecount +
				", sortReverse=" + sortReverse +
				", otherParams=" + otherParams +
				", isFirstPublish=" + isFirstPublish +
				", firstPublishBid=" + firstPublishBid +
				", sameEventCount=" + sameEventCount +
				", site=" + site +
				", outId='" + outId + '\'' +
				", attachmentInfos='" + attachmentInfos + '\'' +
				'}';
	}
}
