/*
**  壁纸
*/
EBOS.wallpaper = (function(){
	return {
		/*
		**	获得壁纸
		**	通过ajax到后端获取壁纸信息，同时设置壁纸
		*/
		get : function(callback){
			EBOS.CONFIG.wallpaper = '../plugins/ebos/img/wallpaper/wallpaper1.jpg';
			EBOS.CONFIG.wallpaperType = 'shiying';
			EBOS.CONFIG.wallpaperWidth = '';
			EBOS.CONFIG.wallpaperHeight = '';
			callback && callback();
			return;
			$.ajax({
				type : 'POST',
				url : ajaxUrl,
				data : 'ac=getWallpaper',
				success : function(msg){
					var w = msg.split('<{|}>');
					EBOS.CONFIG.wallpaperState = w[0];
					switch(w[0]){
						case '1':
						case '2':
							EBOS.CONFIG.wallpaper = w[1];
							EBOS.CONFIG.wallpaperType = w[2];
							EBOS.CONFIG.wallpaperWidth = w[3];
							EBOS.CONFIG.wallpaperHeight = w[4];
							break;
						case '3':
							EBOS.CONFIG.wallpaper = w[1];
							break;
					}
					callback && callback();
				}
			});
		},
		/*
		**	设置壁纸
		**	平铺和居中可直接用css样式background解决
		**	而填充、适应和拉伸则需要进行模拟
		*/
		set : function(isreload){
			/*
			**  判断壁纸是否需要重新载入
			**  比如当浏览器尺寸改变时，只需更新壁纸，而无需重新载入
			*/
			var isreload = typeof(isreload) == 'undefined' ? true : isreload;
			if(isreload){
				$('#zoomWallpaperGrid').remove();
			}
			var w = $(window).width(), h = $(window).height();
			var state = EBOS.CONFIG.wallpaperState;
			switch(state){
				case 1:
				case 2:
					switch(EBOS.CONFIG.wallpaperType){
						//平铺
						case 'pingpu':
							if(isreload){
								$('body').append('<div id="zoomWallpaperGrid" style="position:absolute;z-index:-10;top:0;left:0;height:100%;width:100%;background:url(' + EBOS.CONFIG.wallpaper + ') repeat"></div>');
							}
							break;
						//居中
						case 'juzhong':
							if(isreload){
								$('body').append('<div id="zoomWallpaperGrid" style="position:absolute;z-index:-10;top:0;left:0;height:100%;width:100%;background:url(' + EBOS.CONFIG.wallpaper + ') no-repeat 50% 50%"></div>');
							}
							break;
						//填充
						case 'tianchong':
							var t = (h - EBOS.CONFIG.wallpaperHeight) / 2, l = (w - EBOS.CONFIG.wallpaperWidth) / 2;
							if(isreload){
								$('body').append('<div id="zoomWallpaperGrid" style="position:absolute;z-index:-10;left:0;top:0;overflow:hidden;height:' + h + 'px;width:' + w + 'px"><img id="zoomWallpaper" style="position:absolute;height:' + EBOS.CONFIG.wallpaperHeight + 'px;width:' + EBOS.CONFIG.wallpaperWidth + 'px;top:' + t + 'px;left:' + l + 'px"><div style="position:absolute;height:' + h + 'px;width:' + w + 'px;background:#fff;opacity:0;filter:alpha(opacity=0)"></div></div>');
								$('#zoomWallpaper').attr('src', EBOS.CONFIG.wallpaper).on('load', function(){
									$(this).show();
								});
							}else{
								$('#zoomWallpaperGrid, #zoomWallpaperGrid div').css({
									height : h + 'px',
									width : w + 'px'
								});
								$('#zoomWallpaper').css({
									top : t + 'px',
									left : l + 'px'
								});
							}
							break;
						//适应
						case 'shiying':
							var imgH, imgW, t, l;
							if(EBOS.CONFIG.wallpaperHeight / EBOS.CONFIG.wallpaperWidth > h / w){
								imgH = h;
								imgW = EBOS.CONFIG.wallpaperWidth * (h / EBOS.CONFIG.wallpaperHeight);
								t = 0;
								l = (w - imgW) / 2;
							}else if(EBOS.CONFIG.wallpaperHeight / EBOS.CONFIG.wallpaperWidth < h / w){
								imgW = w;
								imgH = EBOS.CONFIG.wallpaperHeight * (w / EBOS.CONFIG.wallpaperWidth);
								l = 0;
								t = (h - imgH) / 2;
							}else{
								imgH = EBOS.CONFIG.wallpaperHeight;
								imgW = EBOS.CONFIG.wallpaperWidth;
								t = l = 0;
							}
							if(isreload){
								$('body').append('<div id="zoomWallpaperGrid" style="position:absolute;z-index:-10;left:0;top:0;overflow:hidden;height:' + h + 'px;width:' + w + 'px"><img id="zoomWallpaper" style="position:absolute;height:' + imgH + 'px;width:' + imgW + 'px;top:' + t + 'px;left:' + l + 'px"><div style="position:absolute;height:' + h + 'px;width:' + w + 'px;background:#fff;opacity:0;filter:alpha(opacity=0)"></div></div>');
								$('#zoomWallpaper').attr('src', EBOS.CONFIG.wallpaper).on('load', function(){
									$(this).show();
								});
							}else{
								$('#zoomWallpaperGrid, #zoomWallpaperGrid div').css({
									height : h + 'px',
									width : w + 'px'
								});
								$('#zoomWallpaper').css({
									height : imgH + 'px',
									width : imgW + 'px',
									top : t + 'px',
									left : l + 'px'
								});
							}
							break;
						//拉伸
						case 'lashen':
							if(isreload){
								$('body').append('<div id="zoomWallpaperGrid" style="position:absolute;z-index:-10;left:0;top:0;overflow:hidden;height:' + h + 'px;width:' + w + 'px"><img id="zoomWallpaper" style="position:absolute;height:' + h + 'px;width:' + w + 'px;top:0;left:0"><div style="position:absolute;height:' + h + 'px;width:' + w + 'px;background:#fff;opacity:0;filter:alpha(opacity=0)"></div></div>');
								$('#zoomWallpaper').attr('src', EBOS.CONFIG.wallpaper).on('load', function(){
									$(this).show();
								});
							}else{
								$('#zoomWallpaperGrid').css({
									height : h + 'px',
									width : w + 'px'
								}).children('#zoomWallpaper, div').css({
									height : h + 'px',
									width : w + 'px'
								});
							}
							break;
					}
					break;
				case 3:
					if(isreload){
						$('body').append('<div id="zoomWallpaperGrid" style="position:absolute;z-index:-10;top:0;left:0;height:100%;width:100%;overflow:hidden"><div></div><iframe id="iframeWallpaper" frameborder="no" border="0" class="iframeWallpaper" style="position:absolute;left:0;top:0;overflow:hidden;width:100%;height:100%" src="' + EBOS.CONFIG.wallpaper + '"></iframe></div>');
					}
					break;
			}
		},
		/*
		**	更新壁纸
		**	通过ajax到后端进行更新，同时获得壁纸
		*/
		update : function(wallpaperstate, wallpapertype, wallpaper){
			$.ajax({
				type : 'POST',
				url : ajaxUrl,
				data : 'ac=setWallpaper&wpstate=' + wallpaperstate + '&wptype=' + wallpapertype + '&wp=' + wallpaper,
				success : function(){
					EBOS.wallpaper.get(function(){
						EBOS.wallpaper.set();
					});
				}
			});
		}
	}
})();