var ebD3 = {};
ebD3.userBehavior = function(options) {
    var defaults = {
        width: 1000,
        height: 350,
        textHeight: 25,
        margin: 0,
        margin_left: 100,
        range: 250
    };
    var options = $.extend(true, defaults, options);
    var cluster = d3.layout.cluster().size([options.height, options.width - 160]);
    var diagonal = d3.svg.diagonal().projection(function(d) {
        return [d.y, d.x];
    });

    
    function separation(a, b) {
        return a.parent == b.parent ? 1 : 2;
    }

    function setNodeX(node, height) {
        if (node.children && node.children.length > 0) {
            var heightCum = 0;
            for (var i = 0; i < node.children.length; i++) {
                height = setNodeX(node.children[i], height);
                heightCum += height;
            }
            node['x'] = heightCum / node.children.length;

        } else {
            if (height == 0) {
                node['x'] = node["r"] + options.textHeight + options.margin;
                height = node["r"] + node['x'];
            } else {
                node['x'] = node["r"] + options.textHeight + options.margin + height;
                height = node["r"] + node['x'];
            }
        }
        return height;
    }
	$(options.container).unbind().html('');
    options.success = function(root){
    	var svg = d3.select(options.container)
		.append("svg").attr('class', 'buddle').attr("width", options.width).attr("height", options.height)
		.append("g").attr("transform", "translate(40,0)");

        var nodes = cluster.nodes(root.data.treeNode);
        for (var i = nodes.length - 1; i >= 0; i--) {
            nodes[i]["value"] = +nodes[i]["value"];
        };

        var scale = d3.scale.sqrt()
        				.domain([d3.min(nodes, function(d) { return d['value'] }), d3.max(nodes, function(d) {return d['value']})])
        				.range([15, 30]);
        var color = d3.scale.category10();

        for (var i = nodes.length - 1; i >= 0; i--) {
            nodes[i]["y"] = options.margin_left + nodes[i]["depth"] * options.range;
            nodes[i]["r"] = scale(nodes[i]["value"]);
        };

        setNodeX(nodes[0], 0);

        var links = cluster.links(nodes);
        var link = svg.selectAll(".link").data(links).enter()
        			.append("path").attr("class", "link").attr("d", diagonal);
        var node = svg.selectAll(".node").data(nodes).enter()
        			.append("g").style("fill", function(d) { return d.bgColor; })
        			.attr("class", "node")
        			.attr("transform", function(d) { return "translate(" + d.y + "," + d.x + ")";});

        node.append("circle").attr("r", function(d) { return d.r;});

        node.append("svg:image")
        	.attr("class", "circle")//fade
        	.attr("width",function(d) {return d.r * 1.3;})
        	.attr("height",function(d) {return d.r * 1.3;})
        	.attr("opacity","0.5")
        	.attr("xlink:href",function(d) {
            //根据类型来使用图片
        		return d.bgImg;
        	}).attr("x",function(d) {return - d.r / 1.5;})
        	.attr("y",function(d) {return - d.r / 1.5;})
        	.on('mouseover',function(d) {
        		if( d.describe ){
        			var offset = $('svg.buddle').parent().offset();
    	            var left = d.y + offset.left;
    	            var top = d.x + offset.top + d.r;
    	
    	            var html = '<h3 class="title">' + d.label + '</h3>';
	            	html += '<p class="content">' + d.label + '：' + d.value + '人</p>';//<a href="user" target="_blank">查看用户群特征</a>
	            	if( d.describe ){
	            		html += '<p class="content">'+d.describe+'</p>';
	            	}
	            	d3.select('div.tooltip-mini').remove();
	            	d3.select('body').append('div')
	            		.attr('class', 'tooltip-mini')
	            		.style("left", left + "px")
	            		.style("top", top + "px")
	            		.html(function() {return html});
        		}		
        });
        
        // 气泡上方的文字提示
        node.append("text")
        	.attr("dx", function(d) { return - (d['label']+d.value).length * 5-5;})
        	.attr("dy", function(d) { return - 4 - d.r;})
        	.style("text-anchor", function(d) { "start"})
        	.text(function(d) {return d.label + '  ' + d.value + '人';}) //
        	.attr("class", "tip");
        
        // 气泡上的人数
        /*
        node.append("text")
        	.attr("dx", function(d) { return - d.r*0.6;})
        	.attr("dy", function(d) { return 5;})
        	.style("text-anchor", function(d) { "start"})
        	.text(function(d) {return d.value + '人';}) 
        	.attr("class", "title");
         */
        
        d3.select('svg.buddle').on('click',function(d) {
            d3.select('div.tooltip-mini').remove();
        });
    }
    
    $.ebAjax(options);
    d3.select(self.frameElement).style("height", options.height + "px");

}