/**
Requires jQuery
*/
/**表单项提示语句初始化
*	初始化时，在表单项中添加提示语句，用户focus时去除，如果没有修改返回初始化状态
*/
function formInputInit(data){
	var $t = data.$t;
	var val = data.val;
	var initClass = data.initClass;
	
	$t.data('isInit',true).bind('focus',function(){//.addClass(initClass)
		if( $(this).data('isInit') ){
			$(this).data('initVal',$(this).val()).val(val).data('isInit',false);//.removeClass(initClass)
		}
	}).bind('blur',function(){
		if( $(this).val() == '' ){
			$(this).val($(this).data('initVal')).data('isInit',true);//.addClass(initClass)
		}
	});
}

function checkboxOption(data){
//	对多选框进行全选、全不选、反选操作
	var $t = data.$t;	//	操作对象
	var opera = data.operator;	//	操作的方式，false全不选；true全选；toggle反选
	var name = data.name;	//	指定的多选框的name属性
	var checkbox = 'input[type=checkbox]';
	
	if( name != undefined )	checkbox+='[name=' + name + ']';
	
	if ( opera == 'toggle' ){
		$(checkbox,$t).each(function(i, n){
			$(this).attr('checked',!$(this).attr('checked'));
		});
	} else {
		$(checkbox,$t).each(function(i, n){
			if( opera=='true' )	$(this).attr('checked',true);
			if( opera=='false' )	$(this).attr('checked',false);
		});
	}
}

function getCheckedValue(name){
//	获取多选框的值
	var name = name;	//	多选框的name属性
	var value ='';
	var sep ='';
	$('input[type=checkbox][name='+name+']:checked').each(function(){
		value += sep + this.value;
		sep=',';
	});
	return value;
}

function makeFormViewlistUint(data){
//	拼接查看表单的html。这里的value是list
	var label = data.label;	//	表单的名称
	var value = data.value;	//	表单的值
	var html = '';
	
	$(value).each(function(i,n){
		html += '<span style="display:inline-block;">'+n.value
		if( value.length-1 !=i )	html += ',';
		html += '</span>&nbsp;';
	});
	return makeFormViewUint({label:label,value:html});
}

function makeFormViewUint(data){
//	拼接查看表单的html
	var label = data.label;	//	表单的名称
	var value = data.value;	//	表单的值
	var html = '';
	
	html = '<div style="line-height:17px;margin-bottom:4px;">'+
		'<label><b>'+label+'：</b></label>'+
		'&nbsp;&nbsp;&nbsp;'+value+
		'</div>';
	return html;
}