package com.zzsn.job;

import com.zzsn.common.SpringUtil;
import com.zzsn.common.cache.MemcachedUtils;
import com.zzsn.entity.Site;
import com.zzsn.service.PaserErroreMsgService;
import com.zzsn.service.SiteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.PropertySource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import com.zzsn.common.cache.IGatRedisKey;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * DCS定时任务
 *
 * @ClassName: DCSTask
 * @Description:
 */
@Component
@EnableScheduling
@Slf4j
@Async
@PropertySource("classpath:/application.properties")
public class BoilerJob implements IGatRedisKey {
//	@Autowired
//	public StringRedisTemplate stringRedisTemplate;
	@Autowired
	public RestTemplate restTemplate;
	PaserErroreMsgService paserErroreMsgService= SpringUtil.getBean(PaserErroreMsgService.class) ;

	SiteService siteService= SpringUtil.getBean(SiteService.class) ;
	/**
	 *
	 *
	 * @Title: keepaliveTask
	 * @Description:
	 */
	@Scheduled(cron = "${boiler.job.dcsTask}")
	public void keepaliveTask() {
		log.info("定时任务");
		try {
			Object cacheObj= MemcachedUtils.get("tempSite");
			List<Site> addressList = new ArrayList<Site>();
			if (cacheObj != null && !"null".equals(cacheObj)) {
				addressList = (List<Site>) cacheObj;
				saveErrorSite(addressList);
				MemcachedUtils.set("tempSite",null,3600);
			}
		}catch (Exception e){

		}
	}
	public  void saveErrorSite(List<Site> tempSites){
		try {

			List<Site> siteList = siteService.list();
			List<Site> sites = siteList.stream().filter(item -> !tempSites.contains(item.getDomainUri())).collect(Collectors.toList());
			if (sites.size() >0) {
				for (Site site :sites) {
					siteService.save(site);
				}

			}
		}catch (Exception e){
			System.out.println("保存失败");
		}
	}
}
