/*
**  分页导航
*/
EBOS.navbar = (function(){
	return {
		/*
		**  初始化
		*/
		init : function(){
			$('#nav-bar').css({
				'left' : $(document).width() / 2 - 105,
				'top' : 80
			}).show();
			EBOS.navbar.getAvatar();
			EBOS.navbar.move();
			EBOS.navbar.dragOver();
		},
		dragOver : function(){
			//hover 事件触发
			$('#nav-bar .nav-container a.indicator').on('mouseenter',function(e){
			
				if($(document).data('move')){
					EBOS.navbar.switchDesk($(this).attr('index'));
				}
//				if($.browser.msie){
//					if( e.button == 1){//判断鼠标按键是否被按下， ie读取不到鼠标点击事件
//						EBOS.navbar.switchDesk($(this).attr('index'));
//					}
//				}else{
//					if(e.buttons == 1){//判断鼠标按键是否被按下，
//						EBOS.navbar.switchDesk($(this).attr('index'));
//					}
//				}
			});
		},
		/*
		**  获取头像
		*/
		getAvatar : function(){
			$('#nav-bar .indicator-header-img').attr('src', '../plugins/ebos/img/ui/loading_24.gif');
			$.ajax({
				type : 'POST',
				url : ajaxUrl,
				data : 'ac=getAvatar'
			}).done(function(msg){
				$('#nav-bar .indicator-header-img').attr('src', '../plugins/ebos/img/ui/avatar_24.jpg');
			});
		},
		/*
		**  设置头像
		*/
		setAvatar : function(){
			EBOS.window.createTemp({
				appid : 'txsz',
				title : '头像设置',
				url : '/mrbis/account/user!input.action?id=1',
				width : 550,
				height : 550
			});
		},
		/*
		**  拖动
		*/
		move : function(){
			$('#nav-bar, #navbarHeaderImg, #nav-bar .nav-container a.indicator').on('mousedown', function(e){
				$('.popup-menu').hide();
				$('.quick_view_container').remove();
				e.preventDefault();//阻止a 的href触发。
				if (e && e.stopPropagation){
			         e.stopPropagation();
				} else{
			         window.event.cancelBubble=true;//IE 特殊处理
				}
				if(e.button == 0 || e.button == 1){
					var x, y, cx, cy, dx, dy, lay, obj = $('#nav-bar'), thisobj = $(this);
					dx = cx = obj.offset().left;
					dy = cy = obj.offset().top;
					x = e.clientX - dx;
					y = e.clientY - dy;
					//绑定鼠标移动事件
					$(document).on('mousemove', function(e){
						lay = EBOS.maskBox.desk();
						lay.show();
						cx = e.clientX - x <= 0 ? 0 : e.clientX - x > $(document).width() - 210 ? $(document).width() - 210 : e.clientX - x;
						cy = e.clientY - y <= 10 ? 10 : e.clientY - y > $(document).height() - 50 ? $(document).height() - 50 : e.clientY - y;
						obj.css({
							left : cx,
							top : cy
						});
					}).on('mouseup', function(){
						if(dx == cx && dy == cy){
							if(typeof(thisobj.attr('index')) !== 'undefined'){
								EBOS.navbar.switchDesk(thisobj.attr('index'));
							}else if(thisobj.hasClass('indicator-manage')){
								//初始化全局视图
								EBOS.appmanage.init();
							}else if(thisobj.hasClass('indicator-header')){
								EBOS.navbar.setAvatar();
							}
						}
						if(typeof(lay) !== 'undefined'){
							lay.hide();
						}
						$(this).off('mousemove').off('mouseup');
					});
				}
			});
		},
		/*
		**  切换桌面
		*/
		switchDesk : function(deskNumber){
			//验证传入的桌面号是否为1-5的正整数
			var r = /^\+?[1-5]*$/;
			deskNumber = r.test(deskNumber) ? deskNumber : 1;
			var nav = $('#navContainer'), currindex = EBOS.CONFIG.desk, switchindex = deskNumber,
			currleft = $('#desk-' + currindex).offset().left, switchleft = $('#desk-' + switchindex).offset().left;
			if(currindex != switchindex){
				if(!$('#desk-' + switchindex).hasClass('animated') && !$('#desk-' + currindex).hasClass('animated')){
					$('#desk-' + currindex).addClass('animated').animate({
						left : switchleft
					}, 500, 'easeInOutCirc', function(){
						$(this).removeClass('animated');
					});
					$('#desk-'+switchindex).addClass('animated').animate({
						left : currleft
					}, 500, 'easeInOutCirc', function(){
						$(this).removeClass('animated');
						nav.removeClass('nav-current-' + currindex).addClass('nav-current-' + switchindex);
						EBOS.CONFIG.desk = switchindex;
					});
				}
			}
		}
	}
})();