/*
**  图标布局格子
**  这篇文章里有简单说明格子的作用
**  http://www.cnblogs.com/hooray/archive/2012/03/23/2414410.html
*/
EBOS.grid = (function(){
	return {
		getAppGrid : function(){
			var width, height;
			width = $('#desk-' + EBOS.CONFIG.desk).width() ;
			height = $('#desk-' + EBOS.CONFIG.desk).height() ;
			var appGrid = [], _top = EBOS.CONFIG.appButtonTop, _left = EBOS.CONFIG.appButtonLeft;
			for(var i = 0; i < 10000; i++){
				appGrid.push({
					startY : _top,
					endY : _top + 100,
					startX : _left,
					endX : _left + 120
				});
				if(EBOS.CONFIG.appXY == 'x'){
					_left += 120;
					if(_left + 100 > width){
						_top += 100;
						_left = EBOS.CONFIG.appButtonLeft;
					}
				}else{
					_top += 100;
					if(_top + 70 > height){
						_top = EBOS.CONFIG.appButtonTop;
						_left += 120;
					}
				}
			}
			return appGrid;
		},
		searchAppGrid : function(x, y){
			var grid = EBOS.grid.getAppGrid(), j = grid.length;
			var flags = 0, appLength = $('#desk-' + EBOS.CONFIG.desk + ' li:not(.add)').length - 1;
			for(var i = 0; i < j; i++){
				if(x >= grid[i].startX && x <= grid[i].endX){
					flags += 1;
				}
				if(y >= grid[i].startY && y <= grid[i].endY){
					flags += 1;
				}
				if(flags === 2){
					return i > appLength ? appLength : i;
				}else{
					flags = 0;
				}
			}
			return null;
		},
		getDockAppGrid : function(){
			//var height = $('#dock-bar .dock-applist').height();
			/**
			 * @20130518 zjl
			 * 左侧导航现在换成高度自适应
			 */
			var height = (window.innerHeight || (window.document.documentElement.clientHeight || window.document.body.clientHeight))-150;
			var dockAppGrid = [], _left = 0, _top = 0;
			for(var i = 0; i < 15; i++){
				dockAppGrid.push({
					startY : _top,
					endY : _top + 50,
					startX : _left,
					endX : _left + 62
				});
				_top += 50;
			}
			return dockAppGrid;
		},
		searchDockAppGrid : function(x, y){
			var grid = EBOS.grid.getDockAppGrid(), j = grid.length, flags = 0,
				appLength = $('#dock-bar .dock-applist li').length - 1;
			for(var i = 0; i < j; i++){
				if(x >= grid[i].startX && x <= grid[i].endX){
					flags += 1;
				}
				if(y >= grid[i].startY && y <= grid[i].endY){
					flags += 1;
				}
				if(flags === 2){
					return i > appLength ? appLength : i;
				}else{
					flags = 0;
				}
			}
			return null;
		},
		getFolderGrid : function(){
			var folderGrid = [];
			$('.folder-window:visible').each(function(){
				folderGrid.push({
					zIndex : $(this).css('z-index'),
					id : $(this).attr('appid'),
					startY : $(this).offset().top,
					endY : $(this).offset().top + $(this).height(),
					startX :  $(this).offset().left,
					endX :  $(this).offset().left +  $(this).width()
				});
			});
			folderGrid.sort(function(x, y){
				return y['zIndex'] - x['zIndex'];
			});
			return folderGrid;
		},
		searchFolderGrid : function(x, y){
			var folderGrid = EBOS.grid.getFolderGrid(), j = folderGrid.length, flags = 0;
			for(var i = 0; i < j; i++){
				if(x >= folderGrid[i].startX && x <= folderGrid[i].endX){
					flags += 1;
				}
				if(y >= folderGrid[i].startY && y <= folderGrid[i].endY){
					flags += 1;
				}
				if(flags === 2){
					return folderGrid[i]['id'];
				}else{
					flags = 0;
				}
			}
			return null;
		},
		getManageDockAppGrid : function(){
			var manageDockAppGrid = [], _left = 20;
			for(var i = 0; i < 10000; i++){
				manageDockAppGrid.push({
					startX : _left,
					endX : _left + 72
				});
				_left += 72;
			}
			return manageDockAppGrid;
		},
		getManageDockAppGridOnMove : function(){
			var manageDockAppGrid = [], _left = 20;
			for(var i = 0; i < 10000; i++){
				manageDockAppGrid.push({
					startX : _left,
					endX : _left + (i == 0 ? 29 : 72)
				});
				_left += (i == 0 ? 29 : 72);
			}
			//调试代码
			//for(var i = 0; i < 100; i++){$('body').append('<div style="position:absolute;width:1px;height:80px;border-left:1px solid #000;top:0;left:'+manageDockAppGrid[i].startX+'px"></div>');}
			return manageDockAppGrid;
		},
		searchManageDockAppGrid : function(x){
			var grid = EBOS.grid.getManageDockAppGridOnMove(), flags = 0;
			var returnInfo = 0;
			for(var i = 0; i < grid.length; i++){
				if(x >= grid[i].startX && x <= grid[i].endX){
					flags += 1;
				}
				if(flags === 1){
					returnInfo = i;
					break;
				}else{
					flags = 0;
				}
			}
			return returnInfo;
		},
		getManageAppGrid : function(){
			var manageAppGrid = [], _top = 0;
			for(var i = 0; i < 10000; i++){
				manageAppGrid.push({
					startY : _top,
					endY : _top + 40
				});
				_top += 40;
			}
			return manageAppGrid;
		},
		getManageAppGridOnMove : function(){
			var manageAppGrid = [], _top = 0;
			for(var i = 0; i < 10000; i++){
				manageAppGrid.push({
					startY : _top,
					endY : _top + (i == 0 ? 20 : 40)
				});
				_top += (i == 0 ? 20 : 40);
			}
			return manageAppGrid;
		},
		searchManageAppGrid : function(y){
			var grid = EBOS.grid.getManageAppGridOnMove(), flags = 0;
			var returnInfo = 0;
			for(var i = 0; i < grid.length; i++){
				if(y >= grid[i].startY && y <= grid[i].endY){
					flags += 1;
				}
				if(flags === 1){
					returnInfo = i;
					break;
				}else{
					flags = 0;
				}
			}
			return returnInfo;
		},
		getWidgetGrid : function (){
			var widgetGrid = [], _top = EBOS.CONFIG.widgetButtonTop, _left = EBOS.CONFIG.widgetButtonLeft;
			var width, height;
			width = $('#desk-' + EBOS.CONFIG.desk).width() ;
			height = $('#desk-' + EBOS.CONFIG.desk).height() - EBOS.CONFIG.widgetButtonTop;
			while(_left <= width ){
				widgetGrid.push({
					_top : _top,
					_bottom : _top+100,
					_left : _left,
					_right : _left+120
				});
				_top += 100;
				if(_top > height){
					_left += 120;
					_top = EBOS.CONFIG.widgetButtonTop;
				}
			}
			return(widgetGrid);
		},
		searcheWidgetGrid : function(){
			
		}
	}
})();