/*
**  图标
*/
EBOS.app = (function(){
	return {
		/*
		**  获得图标排列方式，x横向排列，y纵向排列
		*/
		getXY : function(callback){
			callback && callback();
		},
		/*
		**  更新图标排列方式
		*/
		updateXY : function(i, callback){
			$.ajax({
				type : 'POST',
				url : ajaxUrl,
				data : 'ac=setAppXY&appxy=' + i
			}).done(function(){
				EBOS.CONFIG.appXY = i;
				callback && callback();
			});
		},
		/*
		**  获取图标
		*/
		get : function(){
			//绘制图标表格
			var grid = EBOS.grid.getAppGrid(), dockGrid = EBOS.grid.getDockAppGrid();
			//获取json数组并循环输出每个图标
			$.getJSON(ajaxUrl + 'widget!ajaxUserWidgets.action', function(sc){
//				$.getJSON(ajaxUrl + 'widget!ajaxWidgets.action', function(sc){
				//加载应用码头图标
//				sc = {'dock':[],'desk1':{'left':[],'middle':[],'right':[]}};
				// 左侧菜单
//				sc['desk1']['left'] = [
//			       {'id':'1','name':'手机阅读经营分析日报','clazz':'mobile-read','url':'#','appid':'1'},
//			       {'id':'2','name':'运营日报','clazz':'mobile-read','url':'#','appid':'2'},
//			       {id:'3',name:'智能推荐',clazz:'recommend', url : '#', appid:'3'}
//				];
				if(sc['dock'] != ''){
					var dock_append = '<ul>';
					$(sc['dock']).each(function(i){
						dock_append += naviTemp({
							'top' : dockGrid[i]['startY'],
							'left' : dockGrid[i]['startX'],
							'name' : this.name,
							'type' : this.type,
							'id' : 'd_' + this.appid,
							'appid' : this.appid,
							'clazz' : this.clazz,
							'url' : this.url
						});
					});
					dock_append += '</ul>';
					$('#dock-bar .dock-applist').html(dock_append);
				}
				//加载桌面快捷方式
				for(var j = 1; j <= 5; j++){//debug
					var desk_append = '<ul>';
					if(sc['desk' + j] != undefined){
						if($(sc['desk' + j]['left'])){
							$(sc['desk' + j]['left']).each(function(i,n){
								desk_append += linkTemple({
									'top' : grid[i]['startY'] + 7,
									'left' : grid[i]['startX'] + 16,
									'name' : this.name,
									'type' : this.type,
									'id' : 'd_' + this.appid,
									'appid' : this.appid,
									'clazz' : this.clazz,
									'url' : this.url
								});
							});
						}
						desk_append += addbtnTemp({
							'top' : grid[sc['desk' + j]['left'].length]['startY'] + 7,
							'left' : grid[sc['desk' + j]['left'].length]['startX'] + 16
						});
						desk_append += '</ul>';
						$('#desk-' + j).html(desk_append);
						if(sc['desk'+j]['right']){
							sc['desk'+j]['right'].desk = j;
							//加载右侧
							EBOS.widget.init(sc['desk'+j]['right']);
						};
						if(sc['desk'+j]['middle']){
							sc['desk'+j]['middle'].desk = j;
							//加载中间
							EBOS.widget.init(sc['desk'+j]['middle']);
						}
					}else{
						desk_append += addbtnTemp({
							'top' : grid[0]['startY'] + 7,
							'left' : grid[0]['startX'] + 16
						});
						desk_append += '</ul>';
						$('#desk-' + j).html(desk_append);
					};
				};
				
				//绑定'应用市场'图标点击事件
				$('#desk').off('click').on('click', 'a.add-icon', function(){
					var myDate = new Date();
					var appid = 'ebos_yysc';
					
					EBOS.window.createTemp({
						appid : appid,
						title : '选择要添加到主页显示的组件',
						url : ctx+'/portal/add-app.action?appid=' + appid,
						width : 704,
						height : 454,
						isflash : false
					});
				});
				//绑定图标拖动事件
				EBOS.app.move();
				//绑定应用码头拖动事件
//				EBOS.dock.move();
				//加载滚动条
				EBOS.app.getScrollbar();
				//绑定滚动条拖动事件
				EBOS.app.moveScrollbar();
				//绑定图标右击事件
				$('#desk').on('contextmenu', '.appbtn:not(.add)', function(e){
					$('.popup-menu').hide();
					$('.quick_view_container').remove();
					switch($(this).attr('type')){
						case 'app':
						case 'widget':
							var popupmenu = EBOS.popupMenu.app($(this));
							break;
						case 'papp':
						case 'pwidget':
							var popupmenu = EBOS.popupMenu.papp($(this));
							break;
						case 'folder':
							var popupmenu = EBOS.popupMenu.folder($(this));
							break;
					}
					var l = ($(document).width() - e.clientX) < popupmenu.width() ? (e.clientX - popupmenu.width()) : e.clientX;
					var t = ($(document).height() - e.clientY) < popupmenu.height() ? (e.clientY - popupmenu.height()) : e.clientY;
					popupmenu.css({
						left : l,
						top : t
					}).show();
					return false;
				});
			});
		},
		/*
		**  添加应用
		*/
		add : function(id,type, callback){
			var desk = EBOS.widget.getDesk(type);
			$.ajax({
				type : 'POST',
				url : ctx+'/portal/app!addApp.action',
				data : {appId : id,desk:desk},
				success : function(){
					callback && callback(id,'true');
					EBOS.app.get();
				}
			}); 
		},
		/*
		**  删除应用
		*/
		remove : function(id, callback){
			$.ajax({
				type : 'POST',
				url : ctx+'/portal/widget!deleteWidget.action',
				data : {widgetId : id},
				success : function(){
					callback && callback();
					// 调用iframe内部的js函数刷新列表
					var iframeId = "w_ebos_yysc_iframe";
					if ($("#w_ebos_yysc_iframe")[0] != null) {
						$("#w_ebos_yysc_iframe")[0].contentWindow.refreshAppList();
					}
				}
			}); 
		},
		/*
		**  图标拖动、打开
		**  这块代码略多，主要处理了9种情况下的拖动，分别是：
		**  桌面拖动到应用码头、桌面拖动到文件夹内、当前桌面上拖动(排序)
		**  应用码头拖动到桌面、应用码头拖动到文件夹内、应用码头上拖动(排序)
		**  文件夹内拖动到桌面、文件夹内拖动到应用码头、不同文件夹之间拖动
		*/
		move : function(){
			//桌面图标拖动
			$('#desk .desktop-container').off('mousedown', 'li:not(.add)').on('mousedown', 'li:not(.add)', function(e){
				e.preventDefault();//阻止关联动作执行
				e.stopPropagation();//阻止事件到其他节点
				if(e.button == 0 || e.button == 1){
					var oldobj = $(this), x, y, cx, cy, dx, dy, lay, obj = $('<li id="shortcut_shadow" ">' + oldobj.html() + '</li>').children('a');
					$(document).data('move',true);
					obj.css({'z-index' : '90000'});//设为z-index 最大
					dx = cx = e.clientX;
					dy = cy = e.clientY;
					x = dx - oldobj.children('a').offset().left;
					y = dy - oldobj.children('a').offset().top;
					var _w = oldobj.children('a').width(), _h =  oldobj.children('a').height();
					//绑定鼠标移动事件
					$(document).on('mousemove', function(e){
						$('body').append(obj);
						lay = EBOS.maskBox.desk();
						cx = e.clientX - x <= 100 ? 100 : e.clientX - x > $(document).width() - _w-100 ? $(document).width() - _w-100 : e.clientX - x;
						cy = e.clientY - y <= 50 ? 50 : e.clientY - y > $(document).height() - _h ? $(document).height() - _h : e.clientY - y;
						var $navBar = $('#nav-bar'),
							_left = parseInt($navBar.css('left')),
							_top= parseInt($navBar.css('top'));
						if((e.clientX>=_left && e.clientX<=(_left+$navBar.width())) && (e.clientY>=_top&& e.clientY<=(_top+$navBar.height()))){
							obj.css('z-index',$navBar.css('z-index')-1);
							lay.hide();
						}else{
							lay.show();
						};
						obj.css({
							left : cx,
							top : cy
						});
					}).on('mouseup', function(){
						$(document).off('mousemove').off('mouseup');
						obj.remove();
						$(document).data('move',false);
						if(typeof(lay) !== 'undefined'){
							lay.hide();
						}
						//判断是否移动图标，如果没有则判断为click事件
						if(dx == cx && dy == cy){
							return false;
						}
						var folderId = EBOS.grid.searchFolderGrid(cx, cy);
						//拖动进文件夹
						if(folderId != null){
							if(oldobj.attr('type') != 'folder'){
								$.ajax({
									type : 'POST',
									url : ajaxUrl,
									data : 'ac=updateMyApp&movetype=desk-folder&id=' + oldobj.attr('appid') + '&from=' + (oldobj.index() - 2) + '&to=' + folderId + '&desk=' + EBOS.CONFIG.desk,
									success : function(){
										oldobj.remove();
										EBOS.deskTop.appresize();
										//如果文件夹预览面板为显示状态，则进行更新
										if($('#qv_' + folderId).length != 0){
											EBOS.folderView.init($('#d_' + folderId));
										}
										//如果文件夹窗口为显示状态，则进行更新
										if($('#w_' + folderId).length != 0){
											EBOS.window.updateFolder(folderId);
										}
									}
								});
							}
						}else{
							//拖动到dock
							var icon, icon2;
							var iconIndex = $('#desk-' + EBOS.CONFIG.desk + ' li.appbtn:not(.add)').length == 0 ? -1 : $('#desk-' + EBOS.CONFIG.desk + ' li').index(oldobj);
							var iconIndex2 = $('#dock-bar .dock-applist').html() == '' ? -1 : $('#dock-bar .dock-applist li').index(oldobj);
							
							var dock_w2 = EBOS.CONFIG.dockPos == 'left' ? 0 : EBOS.CONFIG.dockPos == 'top' ? ($(window).width() - $('#dock-bar .dock-applist').width() - 20) / 2 : $(window).width() - $('#dock-bar .dock-applist').width();
							var dock_h2 = EBOS.CONFIG.dockPos == 'top' ? 0 : ($(window).height() - $('#dock-bar .dock-applist').height() - 20) / 2;
							icon2 = EBOS.grid.searchDockAppGrid(cx - dock_w2, cy - dock_h2);
							if(icon2 != null){
								$.ajax({
									type : 'POST',
									url : ajaxUrl,
									data : 'ac=updateMyApp&movetype=desk-dock&id=' + oldobj.attr('appid') + '&from=' + (oldobj.index() - 2) + '&to=' + (icon2 + 1) + '&desk=' + EBOS.CONFIG.desk,
									success : function(){
										if(icon2 < iconIndex2){
											$('#dock-bar .dock-applist li:eq(' + icon2 + ')').before(oldobj);
										}else if(icon2 > iconIndex2){
											$('#dock-bar .dock-applist li:eq(' + icon2 + ')').after(oldobj);
										}else{
											if(iconIndex2 == -1){
												$('#dock-bar .dock-applist').append(oldobj);
											}
										}
										if($('#dock-bar .dock-applist li').length > 7){
											$('#desk-' + EBOS.CONFIG.desk + ' li.add').before($('#dock-bar .dock-applist li').last());
										}
										EBOS.deskTop.appresize();
									}
								});
							}else{
								var dock_w = EBOS.CONFIG.dockPos == 'left' ? 73 : 0;
								var dock_h = EBOS.CONFIG.dockPos == 'top' ? 73 : 0;
								var iconIndex = $('#desk-' + EBOS.CONFIG.desk + ' li:not(.add)').length == 0 ? -1 : $('#desk-' + EBOS.CONFIG.desk + ' li').index(oldobj);
								var icon = EBOS.grid.searchAppGrid(cx - dock_w, cy - dock_h);
								if(icon != null ){//&& icon != (oldobj.index() - 2)
									if(icon < iconIndex){
										$('#desk-' + EBOS.CONFIG.desk + ' li:not(.add):eq(' + icon + ')').before(oldobj);
									}else if(icon > iconIndex){
										$('#desk-' + EBOS.CONFIG.desk + ' li:not(.add):eq(' + icon + ')').after(oldobj);
									}else{
										if(iconIndex == -1){
											$('#desk-' + EBOS.CONFIG.desk + ' li.add').before(oldobj);
										}
									}
									EBOS.deskTop.appresize();
									//注释部分为后台存储此拖动结果数据使用
//									$.ajax({
//										type : 'POST',
//										url : ajaxUrl,
//										data : 'ac=updateMyApp&movetype=desk-desk&id=' + oldobj.attr('appid') + '&from=' + (oldobj.index() - 2) + '&to=' + icon + '&desk=' + EBOS.CONFIG.desk,
//										success : function(){
//											if(icon < iconIndex){
//												$('#desk-' + EBOS.CONFIG.desk + ' li:not(.add):eq(' + icon + ')').before(oldobj);
//											}else if(icon > iconIndex){
//												$('#desk-' + EBOS.CONFIG.desk + ' li:not(.add):eq(' + icon + ')').after(oldobj);
//											}else{
//												if(iconIndex == -1){
//													$('#desk-' + EBOS.CONFIG.desk + ' li.add').before(oldobj);
//												}
//											}
//											EBOS.deskTop.appresize();
//										}
//									});
								}
							}
						}
					});
				}
			});
			//应用码头图标拖动
			$('#dock-bar .dock-applist').off('mousedown', 'li').on('mousedown', 'li', function(e){
				e.preventDefault();
				e.stopPropagation();
				if(e.button == 0 || e.button == 1){
					var oldobj = $(this), x, y, cx, cy, dx, dy, lay, obj = $('<li id="shortcut_shadow">' + oldobj.html() + '</li>');
					dx = cx = e.clientX;
					dy = cy = e.clientY;
					x = dx - oldobj.offset().left;
					y = dy - oldobj.offset().top;
					//绑定鼠标移动事件
					$(document).on('mousemove', function(e){
						$('body').append(obj);
						lay = EBOS.maskBox.desk();
						lay.show();
						cx = e.clientX <= 0 ? 0 : e.clientX >= $(document).width() ? $(document).width() : e.clientX;
						cy = e.clientY <= 0 ? 0 : e.clientY >= $(document).height() ? $(document).height() : e.clientY;
						_l = cx - x;
						_t = cy - y;
						if(dx != cx || dy != cy){
							obj.css({
								left : _l,
								top : _t
							}).show();
						}
					}).on('mouseup', function(){
						$(document).off('mousemove').off('mouseup');
						obj.remove();
						if(typeof(lay) !== 'undefined'){
							lay.hide();
						}
						//判断是否移动图标，如果没有则判断为click事件
						if(dx == cx && dy == cy){
							switch(oldobj.attr('type')){
								case 'app':
								case 'papp':
									EBOS.window.create(oldobj.attr('appid'));
									break;
								case 'widget':
								case 'pwidget':
									EBOS.widget.create(oldobj.attr('appid'));
									break;
								case 'folder':
									EBOS.folderView.init(oldobj);
									break;
							}
							return false;
						}
						var folderId = EBOS.grid.searchFolderGrid(cx, cy);
						if(folderId != null){
							if(oldobj.hasClass('folder') == false){
								$.ajax({
									type : 'POST',
									url : ajaxUrl,
									data : 'ac=updateMyApp&movetype=dock-folder&id=' + oldobj.attr('appid') + '&to=' + folderId,
									success : function(){
										oldobj.remove();
										EBOS.deskTop.appresize();
										//如果文件夹预览面板为显示状态，则进行更新
										if($('#qv_' + folderId).length != 0){
											EBOS.folderView.init($('#d_' + folderId));
										}
										//如果文件夹窗口为显示状态，则进行更新
										if($('#w_' + folderId).length != 0){
											EBOS.window.updateFolder(folderId);
										}
									}
								});
							}
						}else{
							var icon, icon2;
							var iconIndex = $('#desk-' + EBOS.CONFIG.desk + ' li.appbtn:not(.add)').length == 0 ? -1 : $('#desk-' + EBOS.CONFIG.desk + ' li').index(oldobj);
							var iconIndex2 = $('#dock-bar .dock-applist').html() == '' ? -1 : $('#dock-bar .dock-applist li').index(oldobj);
							
							var dock_w2 = EBOS.CONFIG.dockPos == 'left' ? 0 : EBOS.CONFIG.dockPos == 'top' ? ($(window).width() - $('#dock-bar .dock-applist').width() - 20) / 2 : $(window).width() - $('#dock-bar .dock-applist').width();
							var dock_h2 = EBOS.CONFIG.dockPos == 'top' ? 0 : ($(window).height() - $('#dock-bar .dock-applist').height() - 20) / 2;
							icon2 = EBOS.grid.searchDockAppGrid(cx - dock_w2, cy - dock_h2);
							if(icon2 != null && icon2 != oldobj.index()){
								$.ajax({
									type : 'POST',
									url : ajaxUrl,
									data : 'ac=updateMyApp&movetype=dock-dock&id=' + oldobj.attr('appid') + '&from=' + oldobj.index() + '&to=' + icon2,
									success : function(){
										if(icon2 < iconIndex2){
											$('#dock-bar .dock-applist li:eq(' + icon2 + ')').before(oldobj);
										}else if(icon2 > iconIndex2){
											$('#dock-bar .dock-applist li:eq(' + icon2 + ')').after(oldobj);
										}
										EBOS.deskTop.appresize();
									}
								});
							}else{
								var dock_w = EBOS.CONFIG.dockPos == 'left' ? 73 : 0;
								var dock_h = EBOS.CONFIG.dockPos == 'top' ? 73 : 0;
								icon = EBOS.grid.searchAppGrid(cx - dock_w, cy - dock_h);
								if(icon != null){
									$.ajax({
										type : 'POST',
										url : ajaxUrl,
										data : 'ac=updateMyApp&movetype=dock-desk&id=' + oldobj.attr('appid') + '&from=' + oldobj.index() + '&to=' + (icon + 1) + '&desk=' + EBOS.CONFIG.desk,
										success : function(){
											if(icon < iconIndex){
												$('#desk-' + EBOS.CONFIG.desk + ' li:not(.add):eq(' + icon + ')').before(oldobj);
											}else if(icon > iconIndex){
												$('#desk-' + EBOS.CONFIG.desk + ' li:not(.add):eq(' + icon + ')').after(oldobj);
											}else{
												if(iconIndex == -1){
													$('#desk-' + EBOS.CONFIG.desk + ' li.add').before(oldobj);
												}
											}
											EBOS.deskTop.appresize();
										}
									});
								}
							}
						}
					});
				}
				return false;
			});
			//文件夹内图标拖动
			$('.folder_body, .quick_view_container').off('mousedown', 'li').on('mousedown', 'li', function(e){
				e.preventDefault();
				e.stopPropagation();
				if(e.button == 0 || e.button == 1){
					var oldobj = $(this), x, y, cx, cy, dx, dy, lay, obj = $('<li id="shortcut_shadow">' + oldobj.html() + '</li>');
					dx = cx = e.clientX;
					dy = cy = e.clientY;
					x = dx - oldobj.offset().left;
					y = dy - oldobj.offset().top;
					//绑定鼠标移动事件
					$(document).on('mousemove', function(e){
						$('body').append(obj);
						lay = EBOS.maskBox.desk();
						lay.show();
						cx = e.clientX <= 0 ? 0 : e.clientX >= $(document).width() ? $(document).width() : e.clientX;
						cy = e.clientY <= 0 ? 0 : e.clientY >= $(document).height() ? $(document).height() : e.clientY;
						_l = cx - x;
						_t = cy - y;
						if(dx != cx || dy != cy){
							obj.css({
								left : _l,
								top : _t
							}).show();
						}
					}).on('mouseup', function(){
						$(document).off('mousemove').off('mouseup');
						obj.remove();
						if(typeof(lay) !== 'undefined'){
							lay.hide();
						}
						//判断是否移动图标，如果没有则判断为click事件
						if(dx == cx && dy == cy){
							switch(oldobj.attr('type')){
								case 'app':
								case 'papp':
									EBOS.window.create(oldobj.attr('appid'));
									break;
								case 'widget':
								case 'pwidget':
									EBOS.widget.create(oldobj.attr('appid'));
									break;
							}
							return false;
						}
						var folderId = EBOS.grid.searchFolderGrid(cx, cy);
						if(folderId != null){
							if(oldobj.parents('.folder-window').attr('appid') != folderId){
								$.ajax({
									type : 'POST',
									url : ajaxUrl,
									data : 'ac=updateMyApp&movetype=folder-folder&id=' + oldobj.attr('appid') + '&to=' + folderId,
									success : function(){
										oldobj.remove();
										EBOS.deskTop.appresize();
										//如果文件夹预览面板为显示状态，则进行更新
										if($('#qv_' + folderId).length != 0){
											EBOS.folderView.init($('#d_' + folderId));
										}
										//如果文件夹窗口为显示状态，则进行更新
										if($('#w_' + folderId).length != 0){
											EBOS.window.updateFolder(folderId);
										}
									}
								});
							}
						}else{
							var icon, icon2;
							var iconIndex = $('#desk-' + EBOS.CONFIG.desk + ' li.appbtn:not(.add)').length == 0 ? -1 : $('#desk-' + EBOS.CONFIG.desk + ' li').index(oldobj);
							var iconIndex2 = $('#dock-bar .dock-applist').html() == '' ? -1 : $('#dock-bar .dock-applist li').index(oldobj);
							
							var dock_w2 = EBOS.CONFIG.dockPos == 'left' ? 0 : EBOS.CONFIG.dockPos == 'top' ? ($(window).width() - $('#dock-bar .dock-applist').width() - 20) / 2 : $(window).width() - $('#dock-bar .dock-applist').width();
							var dock_h2 = EBOS.CONFIG.dockPos == 'top' ? 0 : ($(window).height() - $('#dock-bar .dock-applist').height() - 20) / 2;
							icon2 = EBOS.grid.searchDockAppGrid(cx - dock_w2, cy - dock_h2);
							if(icon2 != null){
								$.ajax({
									type : 'POST',
									url : ajaxUrl,
									data : 'ac=updateMyApp&movetype=folder-dock&id=' + oldobj.attr('appid') + '&to=' + (icon2 + 1) + '&desk=' + EBOS.CONFIG.desk,
									success : function(){
										var folderId = oldobj.parents('.folder-window').attr('appid');
										if(icon2 < iconIndex2){
											$('#dock-bar .dock-applist li.appbtn:not(.add):eq(' + icon2 + ')').before(oldobj);
										}else if(icon2 > iconIndex2){
											$('#dock-bar .dock-applist li.appbtn:not(.add):eq(' + icon2 + ')').after(oldobj);
										}else{
											if(iconIndex2 == -1){
												$('#dock-bar .dock-applist').append(oldobj);
											}
										}
										if($('#dock-bar .dock-applist li').length > 7){
											$('#desk-' + EBOS.CONFIG.desk + ' li.add').before($('#dock-bar .dock-applist li').last());
										}
										EBOS.deskTop.appresize();
										//如果文件夹预览面板为显示状态，则进行更新
										if($('#qv_' + folderId).length != 0){
											EBOS.folderView.init($('#d_' + folderId));
										}
										//如果文件夹窗口为显示状态，则进行更新
										if($('#w_' + folderId).length != 0){
											EBOS.window.updateFolder(folderId);
										}
									}
								});
							}else{
								var dock_w = EBOS.CONFIG.dockPos == 'left' ? 73 : 0;
								var dock_h = EBOS.CONFIG.dockPos == 'top' ? 73 : 0;
								icon = EBOS.grid.searchAppGrid(cx - dock_w, cy - dock_h);
								if(icon != null){
									$.ajax({
										type : 'POST',
										url : ajaxUrl,
										data : 'ac=updateMyApp&movetype=folder-desk&id=' + oldobj.attr('appid') + '&to=' + (icon + 1) + '&desk=' + EBOS.CONFIG.desk,
										success : function(){
											var folderId = oldobj.parents('.folder-window').attr('appid');
											if(icon < iconIndex){
												$('#desk-' + EBOS.CONFIG.desk + ' li.appbtn:not(.add):eq(' + icon + ')').before(oldobj);
											}else if(icon > iconIndex){
												$('#desk-' + EBOS.CONFIG.desk + ' li.appbtn:not(.add):eq(' + icon + ')').after(oldobj);
											}else{
												if(iconIndex == -1){
													$('#desk-' + EBOS.CONFIG.desk + ' li.add').before(oldobj);
												}
											}
											EBOS.deskTop.appresize();
											//如果文件夹预览面板为显示状态，则进行更新
											if($('#qv_' + folderId).length != 0){
												EBOS.folderView.init($('#d_' + folderId));
											}
											//如果文件夹窗口为显示状态，则进行更新
											if($('#w_' + folderId).length != 0){
												EBOS.window.updateFolder(folderId);
											}
										}
									});
								}
							}
						}
					});
				}
			});
		},
		/*
		**  加载滚动条
		*/
		getScrollbar : function(){
			setTimeout(function(){
				$('#desk .desktop-container').each(function(){
					var desk = $(this), scrollbar = desk.children('.scrollbar');
					//先清空所有附加样式
					scrollbar.hide();
					desk.scrollLeft(0).scrollTop(0);
					/*
					**  判断图标排列方式
					**  横向排列超出屏幕则出现纵向滚动条，纵向排列超出屏幕则出现横向滚动条
					*/
					if(EBOS.CONFIG.appXY == 'x'){
						/*
						**  获得桌面图标定位好后的实际高度
						**  因为显示的高度是固定的，而实际的高度是根据图标个数会变化
						*/
						var deskH = parseInt(desk.children('.add').css('top')) + 108;
						/*
						**  计算滚动条高度
						**  高度公式（图标纵向排列计算滚动条宽度以此类推）：
						**  滚动条实际高度 = 桌面显示高度 / 桌面实际高度 * 滚动条总高度(桌面显示高度)
						**  如果“桌面显示高度 / 桌面实际高度 >= 1”说明图标个数未能超出桌面，则不需要出现滚动条
						*/
						if(desk.height() / deskH < 1){
							desk.children('.scrollbar-y').height(desk.height() / deskH * desk.height()).css('top',0).show();
						}
					}else{
						var deskW = parseInt(desk.children('.add').css('left')) + 106;
						if(desk.width() / deskW < 1){
							desk.children('.scrollbar-x').width(desk.width() / deskW * desk.width()).css('left',0).show();
						}
					}
				});
			},500);
		},
		/*
		**  移动滚动条
		*/
		moveScrollbar : function(){
			/*
			**  手动拖动
			*/
			$('.scrollbar').on('mousedown', function(e){
				var x, y, cx, cy, deskrealw, deskrealh, movew, moveh;
				var scrollbar = $(this), desk = scrollbar.parent('.desktop-container');
				deskrealw = parseInt(desk.children('.add').css('left')) + 106;
				deskrealh = parseInt(desk.children('.add').css('top')) + 108;
				movew = desk.width() - scrollbar.width();
				moveh = desk.height() - scrollbar.height();
				if(scrollbar.hasClass('scrollbar-x')){
					x = e.clientX - scrollbar.offset().left;
				}else{
					y = e.clientY - scrollbar.offset().top;
				}
				$(document).on('mousemove', function(e){
					if(scrollbar.hasClass('scrollbar-x')){
						if(EBOS.CONFIG.dockPos == 'left'){
							cx = e.clientX - x - 73 < 0 ? 0 : e.clientX - x - 73 > movew ? movew : e.clientX - x - 73;
						}else{
							cx = e.clientX - x < 0 ? 0 : e.clientX - x > movew ? movew : e.clientX - x;
						}
						scrollbar.css('left', cx / desk.width() * deskrealw + cx);
						desk.scrollLeft(cx / desk.width() * deskrealw);
					}else{
						if(EBOS.CONFIG.dockPos == 'top'){
							cy = e.clientY - y - 73 < 0 ? 0 : e.clientY - y - 73 > moveh ? moveh : e.clientY - y - 73;
						}else{
							cy = e.clientY - y < 0 ? 0 : e.clientY - y > moveh ? moveh : e.clientY - y;
						}
						scrollbar.css('top', cy / desk.height() * deskrealh + cy);
						desk.scrollTop(cy / desk.height() * deskrealh);
					}
				}).on('mouseup', function(){
					$(this).off('mousemove').off('mouseup');
				});
			});
			/*
			**  鼠标滚轮
			**  只支持纵向滚动条
			*/
			$('#desk .desktop-container').each(function(i){
				$('#desk-' + (i + 1)).on('mousewheel', function(event, delta){
					var desk = $(this), deskrealh = parseInt(desk.children('.add').css('top')) + 108, scrollupdown;
					/*
					**  delta == -1   往下
					**  delta == 1    往上
					**  chrome下鼠标滚轮每滚动一格，页面滑动距离是200px，所以下面也用这个值来模拟每次滑动的距离
					*/
					if(delta < 0){
						scrollupdown = desk.scrollTop() + 200 > deskrealh - desk.height() ? deskrealh - desk.height() : desk.scrollTop() + 200;
					}else{
						scrollupdown = desk.scrollTop() - 200 < 0 ? 0 : desk.scrollTop() - 200;
					}
					desk.stop(false, true).animate({scrollTop:scrollupdown},300);
					desk.children('.scrollbar-y').stop(false, true).animate({
						top : scrollupdown / deskrealh * desk.height() + scrollupdown
					}, 300);
				});
			});
		}
	}
})();