/**
Requires jQuery
*/
function checkNumberLoop(data){//数字检查,多个
	/********************************
	*功能：数字校验,多个
	*参数：
	*	type：	是否必填，unneed只检查是否有非数字字符；all和need同时需要非空
	*	value：	校验的值
	*	split:	数字之间分隔的字符(存在全角、半角问题)
	*	isChange：	是否整理值并保存至表单
	*	target：	目标input(需要带上#或者.这些)
	*返回值：
	*	0:正确		1:未填写		2:非数字
	********************************/

    var _isOk = 0;//ok
	data.value = $.trim( data.value );
	if(data.value === ""){
		if( data.type == 'need' || data.type == 'all' ){//need means if it's '' ,then error
			_isOk = 1;//''
		}
	} else {
		var _test = /^[0-9]\d*$/;
		var _pIds = data.value.split(data.split);
		var _value = '';
		var _sep = '';
		$(_pIds).each(function(i,n){
			//alert(_value+'-'+n);
			if( $.trim(n) !== ''){
				if( !_test.test( $.trim(n) )){
			    	_isOk = 2;//error
			    }
		    	_value += _sep + $.trim(n);
		    	_sep = data.split;
			}
		   // alert(_value+'-'+n);
		});
		if( data.isChange){
			$(data.target).val(_value);
		}
		//alert('-'+_value+'-' +data.type);
		if( data.type == 'need' || data.type == 'all' && _value === ''){
			_isOk = 1;
		}
	}
	
	//alert(_isOk);
	return _isOk;
}

function checkNumberOnce(data){//数字检查，单个
	/********************************
	*功能：数字校验，单个
	*参数：
	*	value：	校验的值
	*	isChange：	是否整理值并保存至表单
	*	target：	目标input(需要带上#或者.这些)
	*返回值：
	*	true:正确		false:非数字
	********************************/
	//console.log(($.trim(data.value) =='') +'--'+$.trim(data.value)+'--');
    var _isOk = false;
	//alert(data.value+'-'+typeof(data.value));
	var _test = /^[0-9]\d*$/;
	if( $.trim(data.value) ==''){
		_isOk = true ;
	}else if( _test.test( $.trim(data.value) )){
		_isOk = true ;
		
		if( data.isChange ){
			$(data.target).val( $.trim( data.value ) );
		}
	}
	
	return _isOk;
}

function checkNumberRange(data){//数字检查，单个
	/********************************
	*功能：百分比数字校验，单个 percentField
	*参数：
	*	value：	校验的值
	*	isChange：	是否整理值并保存至表单
	*	target：	目标input(需要带上#或者.这些)
	*	max:	最大值
	*	min:	最小值
	*返回值：
	*	0:正确		1:非数字		2:超出范围
	********************************/
    var _isOk = 1;
//	alert(data.value+'-'+typeof(data.value));
	var _test = /^[0-9]\d*$/;
	
	if( $.trim(data.value) ==''){
		_isOk = 0 ;
	} else if( _test.test( $.trim(data.value) )){
		if(  Number(data.max) < Number(data.value) || Number(data.value) < Number(data.min) ){
			_isOk = 2 ;
		} else {
			_isOk = 0 ;
		}
		if( data.isChange ){
			$(data.target).val( $.trim( data.value ) );
		}
	}
	//console.log(_isOk +'--'+$.trim(data.value)+'--');
	return _isOk;
}

function isBlank(data){
	/********************************
	*功能：校验是否空白，忽略空格
	*参数：
	*	value：	校验的值
	*返回值：
	*	true:空白		false:有非空值
	********************************/

	var value = $.trim(data.value);
	var r = false;
	if( value === ''){
		r= true;
	}
	
	return r;
}

function convertToHump(valueToChange){
	/********************************
	*将字符串转化为驼峰标识
	*输入：任意字符串
	*输出：驼峰标识的字符串
	********************************/
	if( !valueToChange) return '';
	var values = valueToChange.split('_');
	var value = '';
	$(values).each(function(i,n){
		if(i===0){ value = n;
		} else if( $.trim(n) !== ''){
			if( n.length === 1 ) value += n.toUpperCase();
			else value += n.substring(0,1).toUpperCase()+n.substring(1);
		}
	});
	return value;
}

function trimArrayInString(data){
	/**********************************
	* 将字符串按分隔符转化为数组，再去除前后空格，以字符串形式返回
	* 输入： 
	*	value ：需要去除空格的字符串
	*	tId： 如$('#'+tId)存在，则赋值
	* 返回：
	*	去除空格后，以;为分隔符的字符串
	***********************************/
	if( undefined == data.value || 'undefined' === data.value || isBlank(data))	return '';
	var v = data.value.replace(/；/g,';').replace(/,/g,';').replace(/，/g,';');
	var result = '';
	var sep = '';
	var array = v.split(';');
	
	$(array).each(function(i,n){
		if( $.trim(n) !== '' ){
			result = result + sep + $.trim(n);
			sep= ';';
		}
	});
	
	var $t = $('#'+data.tId);
	if( $t ){
		$t.attr('value',result);
	}
	return result;
}
function setTrBgColor(data){
	//设置隔行背景色
	$t = $('.'+data.target);
	$t.children(':even').css('background-color',data.even)
		.end().children(':odd').css('background-color',data.odd)
		.end().children().each(function(){
			$(this).data('bgcolor',$(this).css('background-color'));
		});
	
	//设置焦点悬浮背景色
	$t.children().hover(function(){
		$(this).css('background-color',data.hover);
	},function(){
		$(this).css('background-color',$(this).data('bgcolor'));
	});
}

function loadBegin(msg,delay,dialog){
	/**********************************
	* 数据加载时提示
	* 使用需要加载BlockUI插件
	* 输入： 
	*	msg：		提示信息
	*	delay：		字段关闭的时间
	*	dialog:		需要重新打开的对话框
	***********************************/
	//	先去除之前的提示
	//alert(msg);
	loadClose();
	var msg = '<span style="margin-left:10px;font-size:14px;color:black;font-family:Microsoft Yahei;">'+msg+'</span>';
	var img = '<img src="/mrbis/styles/images/ajax-loading.gif" style="width:23px;height:23px;margin-left:-120px;"/>';
	if( delay!=undefined && delay!='undefined' && '0'!=delay )	img = '';
	jQuery.blockUI({
	 message: '<h6> '+img+msg+' </h6>',
	 css: { 
           border: 'none', 
           padding: '15px', 
           backgroundColor: 'rgb(197, 194, 194)', 
           '-webkit-border-radius': '10px', 
           '-moz-border-radius': '10px', 
           opacity: '.5', 
           color: '#fff'
       },
       overlayCSS: {
       	 backgroundColor: '#E6E6E6' 
        }  
    });
    
	if( dialog!=undefined && dialog!='undefined'  ){
		$('#'+dialog).dialog({closed: true});
	}
    if( delay!=undefined && delay!='undefined' && '0'!=delay ){
    	setTimeout(function(){
    		loadClose();
    		if( dialog!=undefined && dialog!='undefined'  ){
    			$('#'+dialog).dialog({closed: false});
    		}
    	},delay);
    }
}

function loadClose(){
//	加载结束时的动画
//	使用需要加载BlockUI插件
	jQuery.unblockUI();
}

function getDateDiff(data){
//	获取日期差
	//	把时间按"_"切成数组
    var sd=data.startDate.split("-");//	开始日期
    var ed=data.endDate.split("-");//	结束时间
    var diff = '';	//	日期差
	//	转为毫秒数
	var bDate=new Date(sd[0],sd[1]-1,sd[2]);
    var eDate=new Date(ed[0],ed[1]-1,ed[2]);
    //	计算相差天数
    diff = (eDate.getTime()-bDate.getTime())/(1000*24*60*60);

    return Math.abs(diff);
}

function confirmDialog(msg){
/*	
*	使用对话框询问用户，进行确认
*/
	var dId = 'eb-confirm';
	var html = '<div id="'+dId+'"></div>';
	
	if( !$('#'+dId).attr('id') )	 $('body').append(html);
	$('#'+dId).dialog({
		height:130,
		width:360,
		shadow: false,
		modal:true,
		closed:false,
		resizable: false,
		title:'系统确认'
	});
	$('#'+dId).html(msg);
	
	$('.cancel','#'+dId).click(closeConfirmDialog).focus();
	
}

function closeConfirmDialog(){
//		关闭对话框
	$('#eb-confirm').dialog({closed:true});
};