package com.zzsn.util;


import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * 元数据
 * 
 * @author zjl
 */
public class Metadata {

	/** 字段变量类型 */
	private String type;
	/** 字段名称  */
	private String name;
	/** 字段中文描述  */
	private String describe;
	/** 字段具体描述信息  */
	private String comments;
	/** 字段类型：dim维度,measure度量,path下钻路径 */
	private String columnType;
	
	private String dataFormat;
	/** 排序位置 */
	private int position; 
	/**  父节点名称 用于表头合并 */
	private String parentName; 
	/**  格式化类型 详见http://www.trirand.com/jqgridwiki/doku.php?id=wiki:predefined_formatter */
	private String formatter;
	/**  格式化参数  详见http://www.trirand.com/jqgridwiki/doku.php?id=wiki:predefined_formatter */
	private String formatOptions;
	/** 指标详细解释 */
	private String title;
	//-----以下属性用于jqGrid表格

	/** 宽度 */
	private String width;
	/** 是否可以排序 */
	private boolean sortable;
	/** 排序类型 */
	private String sortType;
	/** 对其方式 */
	private String align;
	/** 是否隐藏 */
	private boolean hidden;
	/** 是否默认选中  默认不选中*/
	private boolean selected = false;
	/** 背景色 */
	private String backgroundColor;
	/** 是否判断正负(趋势) */
	private boolean trend;

	/** 具体的值 */
	private Object data;
	
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescribe() {
		return describe;
	}

	public void setDescribe(String describe) {
		this.describe = describe;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}
	
	public String getDataFormat() {
		return dataFormat;
	}

	public void setDataFormat(String dataFormat) {
		this.dataFormat = dataFormat;
	}
	
	public String getWidth() {
		return width;
	}

	public void setWidth(String width) {
		this.width = width;
	}

	public boolean isSortable() {
		return sortable;
	}

	public void setSortable(boolean sortable) {
		this.sortable = sortable;
	}

	public String getSortType() {
		return sortType;
	}

	public void setSortType(String sortType) {
		this.sortType = sortType;
	}

	public String getAlign() {
		return align;
	}

	public void setAlign(String align) {
		this.align = align;
	}

	public boolean isHidden() {
		return hidden;
	}

	public void setHidden(boolean hidden) {
		this.hidden = hidden;
	}

	public boolean isSelected() {
		return selected;
	}

	public void setSelected(boolean selected) {
		this.selected = selected;
	}

	public String getBackgroundColor() {
		return backgroundColor;
	}

	public void setBackgroundColor(String backgroundColor) {
		this.backgroundColor = backgroundColor;
	}

	public String getColumnType() {
		return columnType;
	}

	public void setColumnType(String columnType) {
		this.columnType = columnType;
	}
	
	public boolean isTrend() {
		return trend;
	}

	public void setTrend(boolean trend) {
		this.trend = trend;
	}
	
	public String getParentName() {
		return parentName;
	}

	public void setParentName(String parentName) {
		this.parentName = parentName;
	}

	public String getFormatter() {
		return formatter;
	}

	public void setFormatter(String formatter) {
		this.formatter = formatter;
	}

	public String getFormatOptions() {
		return formatOptions;
	}

	public void setFormatOptions(String formatOptions) {
		this.formatOptions = formatOptions;
	}

	public int getPosition() {
		return position;
	}

	public void setPosition(int position) {
		this.position = position;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}
	
	public Object getData() {
		return data;
	}

	public void setData(Object data) {
		this.data = data;
	}
	
	@Override
	public String toString() {
		return ReflectionToStringBuilder.toString(this);
	}
	
	/**
	 * 页面使用jqGrid展现数据时
	 * @param type	字段变量类型：String/long/double/int
	 * @param name	字段名称
	 * @param describe	字段中文名
	 * @param comments	字段中文具体描述
	 * @param width		表格中的宽度
	 * @param sortable	是否可以排序
	 * @param sortType	排序类型
	 * @param align		对其类型：left/right/center
	 * @param hidden	是否隐藏
	 * @param backgroundColor		背景颜色
	 * @param trend		是否判断正负（通过字体颜色）
	 */
	public Metadata(String type, String name, String describe, String dataFormat,String comments,
			String width,boolean sortable,String sortType,String align,boolean hidden,
			String backgroundColor,boolean trend) {
		this.type = type;
		this.name = name;
		this.describe = describe;
		this.comments = comments;
		this.dataFormat = dataFormat;
		this.sortable = sortable;
		this.sortType = sortType;
		this.align = align;
		this.hidden = hidden;
		this.backgroundColor = backgroundColor;
		this.trend = trend;
	}
//	/**
//	 * 页面使用jqGrid展现数据时
//	 * @param type	字段变量类型：String/long/double/int
//	 * @param name	字段名称
//	 * @param describe	字段中文名
//	 * @param comments	字段中文具体描述
//	 * @param width		表格中的宽度
//	 * @param sortable	是否可以排序
//	 * @param sortType	排序类型
//	 * @param align		对其类型：left/right/center
//	 */
//	public Metadata(String type, String name, String describe, String comments,
//			String width,boolean sortable,String sortType,String align) {
//		this.type = type;
//		this.name = name;
//		this.describe = describe;
//		this.comments = comments;
//		this.width = width;
//		this.sortable = sortable;
//		this.sortType = sortType;
//		this.align = align;
//	}
	
	/**
	 * 页面使用jqGrid展现数据时
	 * @param type	字段变量类型：String/long/double/int
	 * @param name	字段名称
	 * @param describe	字段中文名
	 * @param width		表格中的宽度
	 * @param sortable	是否可以排序
	 * @param sortType	排序类型
	 * @param align		对其类型：left/right/center
	 * @param backgroundColor	单元格背景色
	 */
	public Metadata(String type, String name, String describe, String dataFormat,
			String width,boolean sortable,String sortType,String align,String backgroundColor) {
		this.type = type;
		this.name = name;
		this.describe = describe;
		this.dataFormat = dataFormat;
		this.width = width;
		this.sortable = sortable;
		this.sortType = sortType;
		this.align = align;
		this.backgroundColor = backgroundColor;
	}
	
	/**
	 * 页面使用jqGrid展现数据时
	 * @param type	字段变量类型：String/long/double/int
	 * @param name	字段名称
	 * @param describe	字段中文名
	 * @param width		表格中的宽度
	 * @param sortable	是否可以排序
	 * @param sortType	排序类型
	 * @param align		对其类型：left/right/center
	 */
	public Metadata(String type, String name, String describe, 
			String width,boolean sortable,String sortType,String align) {
		this.type = type;
		this.name = name;
		this.describe = describe;
		this.width = width;
		this.sortable = sortable;
		this.sortType = sortType;
		this.align = align;
	}
	
	/**
	 * 页面使用jqGrid展现数据时
	 * @param type	字段变量类型：String/long/double/int
	 * @param name	字段名称
	 * @param describe	字段中文名
	 * @param width		表格中的宽度
	 * @param sortable	是否可以排序
	 * @param sortType	排序类型
	 * @param align		对其类型：left/right/center
	 */
	public Metadata(String type, String name, String describe,String dataFormat,
			String width,boolean sortable,String sortType,String align) {
		this.type = type;
		this.name = name;
		this.describe = describe;
		this.dataFormat = dataFormat;
		this.width = width;
		this.sortable = sortable;
		this.sortType = sortType;
		this.align = align;
	}
	
	/**
	 * 页面使用jqGrid展现数据时
	 * @param type	字段变量类型：String/long/double/int
	 * @param name	字段名称
	 * @param describe	字段中文名
	 * @param comments	字段中文具体描述
	 * @param width		表格中的宽度
	 * @param sortable	是否可以排序
	 * @param sortType	排序类型
	 * @param align		对其类型：left/right/center
	 * @param isSelected	是否默认选中
	 */
	public Metadata(String type, String name, String describe, String comments,
			String width,boolean sortable,String sortType,String align,boolean selected) {
		this.type = type;
		this.name = name;
		this.describe = describe;
		this.comments = comments;
		this.width = width;
		this.sortable = sortable;
		this.sortType = sortType;
		this.align = align;
		this.selected = selected;
	}
	/**
	 * 页面使用jqGrid展现数据时
	 * @param type	字段变量类型：String/long/double/int
	 * @param name	字段名称
	 * @param describe	字段中文名
	 * @param comments	字段中文具体描述
	 * @param width		表格中的宽度
	 * @param sortable	是否可以排序
	 * @param sortType	排序类型
	 * @param align		对其类型：left/right/center
	 * @param isSelected	是否默认选中
	 * @param parentName 父节点名称
	 *  * @param hidden	是否隐藏
	 */
	public Metadata(String type, String name, String describe, String comments,
			String width,boolean sortable,String sortType,String align,boolean selected,String parentName,Boolean hidden) {
		this.type = type;
		this.name = name;
		this.describe = describe;
		this.comments = comments;
		this.width = width;
		this.sortable = sortable;
		this.sortType = sortType;
		this.align = align;
		this.selected = selected;
		this.parentName = parentName;
		this.hidden = hidden;
	}
	
	/**
	 * 构造方法
	 * @param columnType 字段类型 path,dim或者measure
	 * @param name 字段名称 英文code
	 * @param describe 字段名中文描述
	 * @param position 字段位置
	 * @param width  字段宽度
	 * @param align  字段位置 left，right，center
	 * @param hidden 是否隐藏
	 * @param formatter 格式化参数
	 * @param formatOptions 格式化参数 
	 * @param parentName 父节点name
	 */
	public Metadata(String columnType,String name,String describe,int position,String width,String align,boolean hidden,String formatter,String formatOptions,String parentName){
		this.columnType = columnType;
		this.name = name;
		this.describe = describe;
		this.position = position;
		this.width = width;
		this.align = align;
		this.hidden = hidden;
		this.formatter = formatter;
		this.formatOptions = formatOptions;
		this.parentName = parentName;
	}
	/**
	 * 构造方法
	 * @param columnType 字段类型 path,dim或者measure
	 * @param name 字段名称 英文code
	 * @param describe 字段名中文描述
	 * @param position 字段位置
	 * @param width  字段宽度
	 * @param align  字段位置 left，right，center
	 * @param hidden 是否隐藏
	 * @param formatter 格式化参数
	 * @param formatOptions 格式化参数 
	 * @param parentName 父节点name
	 * @param title 指标详细解释
	 */
	public Metadata(String columnType,String name,String describe,int position,String width,String align,boolean hidden,String formatter,String formatOptions,String parentName,String title){
		this.columnType = columnType;
		this.name = name;
		this.describe = describe;
		this.position = position;
		this.width = width;
		this.align = align;
		this.hidden = hidden;
		this.formatter = formatter;
		this.formatOptions = formatOptions;
		this.parentName = parentName;
		this.title = title;
	}

	/**
	 * 页面使用jqGrid展现数据时
	 * @param type	字段变量类型：String/long/double/int
	 * @param name	字段名称
	 * @param describe	字段中文名
	 * @param width		表格中的宽度
	 * @param sortable	是否可以排序
	 * @param sortType	排序类型
	 * @param align		对其类型：left/right/center
	 * @param isSelected	是否默认选中
	 */
	public Metadata(String type, String name, String describe, 
			String width,boolean sortable,String sortType,String align,boolean selected) {
		this.type = type;
		this.name = name;
		this.describe = describe;
		this.width = width;
		this.sortable = sortable;
		this.sortType = sortType;
		this.align = align;
		this.selected = selected;
	}
	
	public Metadata(String type, String name, String describe, String comments) {
		this(type, name, describe);
		this.comments = comments;
	}

	public Metadata(String type, String name, String describe) {
		this(type, name);
		this.describe = describe;
	}

	public Metadata(String type, String name, String describe, String width, String align) {
		this(type, name, describe);
		this.width = width;
		this.align = align;
	}
	
	public Metadata(String type, String name, String describe, String width, String align, String formatter) {
		this(type, name, describe, width, align);
		this.formatter = formatter;
	}
	
	public Metadata(String type, String name, String describe, String width, String align, boolean hidden){
		this(type, name, describe,width,align);
		this.hidden = hidden;
	}
	
	public Metadata(String type, String name) {
		this.type = type;
		this.name = name;
	}
	
	public Metadata(String type, Object data) {
		this.type = type;
		this.data = data;
	}
	
	/**
	 * type 字段类型
	 * name 字段名
	 * describe 中文标识
	 * hidden 是否隐藏
	 * @param type
	 * @param name
	 * @param describe
	 * @param hidden
	 */
	public Metadata(String type, String name, String describe, boolean hidden) {
		this(type, name, describe);
		this.hidden = hidden;
	}
}
