package com.zzsn.generation;

import com.zzsn.generation.segment.SegmentUtil;
import com.zzsn.generation.test.KeyExtractor;
import com.zzsn.generation.test.MyUtility;
import com.hankcs.hanlp.HanLP;
import org.apache.commons.collections.CollectionUtils;

import java.util.*;

/**
 * 自动摘要
 * 创建人：李东亮   
 * 创建时间：2015-6-17 下午5:40:46   
 * 公司 ：郑州数能软件科技有限公司
 * @version  1.0  
 *
 */
public class GenSummaryUtil {

	public static String autoSummary(String content,Set<String> keywordArray){
       StringBuffer result = new StringBuffer("");
       String resultlast = "";
		
		//获取所有句子
     	//List<String> sentences = Arrays.asList(content.split("\\,|，|。|\\.|\\?|？|!|！|：|:"));
		List<String> sentences = Arrays.asList(content.split("。"));
		
		//遍历所有句子，统计关键词频
		List<SortMap> frequencies = new ArrayList<SortMap>();
		SortMap sm;
		int count ;
		String s;
		for(int i =0;i<sentences.size();i++){
			count = 0;
			s = sentences.get(i);
		    s = s.replaceAll("<br />", "");
		    s = s.replaceAll("<br/>", "");
	        s = s.replaceAll("&nbsp;", "");
	        s = s.replaceAll("[\\s|　]+", "");
			sm = new SortMap();
			for(String keyword : keywordArray){
				count+=matchTime(s,keyword);
			}
			if(i==0){
				count+=2;
			}
			sm.setKey(i);
			sm.setValue(count);
			frequencies.add(sm);
		}
		Collections.sort(frequencies);
		//获取最
		List<Integer> validIndexs = new ArrayList<Integer>();
		int maxLength = 0 ;
		String part;
		for(SortMap f : frequencies){
			if(maxLength>=350){
				break;
			}
			if(f.getValue().equals(0)&&maxLength>=350){
				break;
			}
			part = sentences.get(f.getKey());
			maxLength+=part.length();
			validIndexs.add(f.getKey());
		
		}
		
		Collections.sort(validIndexs);
		
		for(Integer index : validIndexs){
			result.append(sentences.get(index).trim());
			result.append("。");
			if(result.length()>350){
				result = new StringBuffer(result.substring(0, 350));
				int indexj=result.lastIndexOf("。");
				if (indexj>0) {
					resultlast = result.substring(0, indexj+1);
				}
				break;
			}
		}
		if (null!=resultlast && resultlast.trim().length()>0) {
			
		} else {
			resultlast = result.toString();
		}
		//如果摘要小于100字
		
//		String resultStr = result.toString();
//		if(resultStr.endsWith(",")){
//			resultStr = resultStr.substring(0,resultStr.length()-1);
//		}
		return resultlast;
		
	}
	/**
	 * 自动摘要
	 * 创建人:  李东亮  
	 * 创建时间:  2015-6-17 下午5:42:07 
	 * @version 1.0
	 * @param content
	 * @return
	 */
	public static String autoSummary(String content,String keywords){
		if(keywords==null){
			return null;
		}
		//获取关键词
		String[] keywordArray = 	keywords.split("\n");
		Set<String> set = new HashSet<String>();
		CollectionUtils.addAll(set, keywordArray);
		return autoSummary(content,set);
	}
	
	
	/**
	 * 自动摘要
	 * 创建人:  刘小鹏 
	 * 创建时间:  2020-9-11 下午5:42:07 
	 * @version 1.0
	 * @param content
	 * @return
	 */
	public static String autoSummaryByContent(String content){
		if(content==null){
			return null;
		}
		HashMap<String, List<String>> cleanWordMap = SegmentUtil.segmentCleanHanlp(content);
		List<String> wordList = cleanWordMap.get(SegmentUtil.SEGMENT_WORD);
		wordList = SegmentUtil.cleanResult(wordList);
		KeyExtractor k = new KeyExtractor();
		LinkedHashMap<String,Double>  featureMap  =  k.keyExtract(wordList, "cn", 200);
        Integer wholeSize = featureMap.keySet().size();
        String[] wholeKeywordArray = new String[wholeSize];
        featureMap.keySet().toArray(wholeKeywordArray);
	     Integer  wantSize =10;
	     String[]  keywordArray = null;
	     if(wholeKeywordArray.length>0){
	         if(wantSize>wholeSize){
	             wantSize = wholeSize;
	         }
	         keywordArray = new String[wantSize];
	         for(int i= 0 ; i <wantSize;i++){
	             keywordArray[i] = wholeKeywordArray[i];
	         }
	     }
	    String keyword = MyUtility.connectArray(keywordArray);
		String summ = GenSummaryUtil.autoSummary(content, keyword);
		String result = getSummary(summ,content);
		return result;
	}
	
	/**
	 * 计算匹配次数
	 * 创建人:  李东亮  
	 * 创建时间:  2015-6-17 下午6:17:24 
	 * @version 1.0
	 * @param source
	 * @param keyword
	 * @return
	 */
	private static Integer matchTime(String source,String keyword){
		int count = 0;
		keyword = keyword.trim();
		if(keyword.length()==0){
		    return count;
		}
		while(source.indexOf(keyword)!=-1){
			count++;
			source = source.replace(keyword, "");
		}
		return count;
	}
	
	
    /**
     * 摘要处理
     * 创建人:  刘小鹏
     * 创建时间:  2020-4-22 下午4:46:47 
     * @version 1.0
     * @param sourceAddress
     * @return
     */
	public static String getSummary(String summary,String content){
		String summaryResult = "";
		if (null==summary && null!=content) {
			List<String> phraseList = HanLP.extractSummary(content, 3);
			for (String arr : phraseList) {
				summary +=arr+"。";
			}

		} 
        if (summary.length()>300 || "...".equals(summary.substring(summary.length()-3)) || !summary.endsWith("。")) {
			if (summary.length()>300) {
				summary = summary.substring(0,300);
			}
			if ("...".equals(summary.substring(summary.length()-3))) {
				summary = summary.substring(0,summary.length()-3);
			}
			int indexj=summary.lastIndexOf("。");
			Integer[] numbers = { indexj};
			int max = (int) Collections.max(Arrays.asList(numbers));
			if (max>0) {
				summaryResult = summary.substring(0, max+1);
			} 
			
			
		} else {
			summaryResult = summary;
		}
		
        if (summaryResult.trim().length()==0) {
        	summaryResult = summary;
        }
		return summaryResult;
		
	}

	public static void main(String[] args) {
		String s = "<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 安然知道还是要带她来这里的，还是要回到这";
	    s = s.replaceAll("<br />", "");
        s = s.replaceAll("&nbsp;", "");
		s = s.replaceAll("[\\s|　]+", "");
		System.out.println(s);
	}
}

class SortMap implements Comparable<SortMap> {
	private Integer key;
	private Integer value;
	@Override
	public int compareTo(SortMap o) {
		// TODO Auto-generated method stub
		if(this.value>o.value){
			return -1;
		}else if(this.value<o.value)
		{
			return 1;
		}else
		{
			return 0;
		}
	}
	public Integer getKey() {
		return key;
	}
	public void setKey(Integer key) {
		this.key = key;
	}
	public Integer getValue() {
		return value;
	}
	public void setValue(Integer value) {
		this.value = value;
	}
	
	
	
}
